//====================================================================
//  eNX`NX
//====================================================================

#ifndef __DGTEXTURE_H__
#define __DGTEXTURE_H__

#include "DGDXInclude.h"
#include "Str.h"

#include "LogFile.h"
#include "Utils.h"
#include "DArray.h"

#include "DeviceInfo.h"

#define DGCONTROL_TEXTURE_NORMAL		(0)

class CDGTexture : public CUtils{
	// -----< \z >-----
	//
	public:
		CDGTexture();									// RXgN^
		CDGTexture( CDGTexture& rTexture );				// Rs[RXgN^
		virtual ~CDGTexture();							// fXgN^

	private:
		void SetDefault();								// RXgN^xł̏lݒ
		BOOL CopyMembers( CDGTexture& rTexture );		// IuWFNg̓e𕡐
		BOOL DuplicateTexture( CDGTexture& rTexture );	// IuWFNg̃eNX`𕡐

	// -----< f[^o >-----
	//
	private:
		CGStr				m_strIDName;		// ʖ
		long				m_lTextureType;		// eNX`̎ށiDGCONTROL_TEXTURE_*j
		BOOL				m_bPreLoad;			// 摜PreLoadō쐬ۂ

		int					m_iGHandle;			// OtBbNnh
		int					m_width;			// 摜̕
		int					m_height;			// 摜̍

		char*				m_pFileName;		// eNX`̃t@C
		DWORD				m_dwColorKey;		// J[L[
		SDeviceInfo*		m_pDeviceInfo;		// foCXւ̃|C^

		CDArray< long >		m_objSpriteIndex;	// XvCg̃CfbNXz
		CDArray< long >		m_objGraphicIndex;	// OtBbÑCfbNXz

	// -----< \bh >-----
	//
	public:
		void	Release();						// łɂ̂
		BOOL	PrepareReset();					// Reset
		BOOL	Reset();						// Reset

		BOOL		SetIDName( const char* pName );			// Oݒ
		const char*	GetIDName();							// O擾

	// <<< eNX`\z >>>
	//
	public:
		BOOL	Load(							// t@C摜ǂݍ
					  SDeviceInfo* pDevice
					, const char* pFileName
					, D3DCOLOR dwColorKey
					, BOOL bPreLoad
					);
		long	AddSpriteIndex( long lIndex );	// XvCg̒ʂCfbNXǉ
		long	AddGraphicIndex( long lIndex );	// OtBbN̒ʂCfbNXǉ

	// <<< ⏕֐ >>>
	private:
		BOOL	LoadTextureFile(				// t@C摜ǂݍ
					  SDeviceInfo* pDevice
					, const char* pFileName
					, D3DCOLOR dwColorKey
					);

	// <<< 擾 >>>
	//
	public:
		int	GetGHandle();		// OtBbNnh𓾂
		long	GetSpriteIndex( long lIndex );	// XvCg̒ʂCfbNX擾
		long	GetSpriteCount();				// ֘AXvCg̐Ԃ

		long	GetGraphicIndex( long lIndex );	// OtBbN̒ʂCfbNX擾
		long	GetGraphicCount();				// ֘AOtBbN̐Ԃ

		const char*	GetFilename();				// t@C擾
		UINT		Width();					// 擾
		UINT		Height();					// 擾

		BOOL	RemoveSPIndex( long lSpriteIndex );		// XvCg̓o^폜
		BOOL	RemoveGRPIndex( long lGraphicIndex );	// zOtBbN̓o^폜


	// -----< Zq >-----
	//
	public:
		CDGTexture& operator=( CDGTexture& rTexture );	// Zq
};

#endif
