//====================================================================
//  eNX`NX
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "DeviceInfo.h"
#include "DGTexture.h"

#include "DArrayMacro.h"

//--------------------------------------------------------------------
//	[  ]
//		CDGTexture()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CDGTexture::CDGTexture()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CDGTexture( CDGTexture& rTexture )
//
//	[  ]
//		CDGTexture& rTexture
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CDGTexture::CDGTexture( CDGTexture& rTexture )
{
	SetDefault();
	CopyMembers( rTexture );
}


//--------------------------------------------------------------------
//	[  ]
//		~CDGTexture()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDGTexture::~CDGTexture()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^xł̏lݒ
//--------------------------------------------------------------------
void CDGTexture::SetDefault()
{
	m_strIDName			= "";
	m_lTextureType		= DGCONTROL_TEXTURE_NORMAL;
	m_bPreLoad			= FALSE;
	m_iGHandle			= DGDX_EMPTY;
	m_pFileName			= NULL;
	m_dwColorKey		= 0x00000000;
	m_pDeviceInfo		= NULL;
	m_objSpriteIndex.Release();
	m_objGraphicIndex.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CDGTexture& rTexture )
//
//	[  ]
//		CDGTexture& rTexture			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̕܂B
//--------------------------------------------------------------------
BOOL CDGTexture::CopyMembers( CDGTexture& rTexture )
{
	BOOL bRes;

	// -----< ܂͉ >-----
	//
	Release();

	// -----< ԕϐݒ >-----
	//
	m_strIDName			= rTexture.m_strIDName;

	// J[L[
	m_dwColorKey		= rTexture.m_dwColorKey;

	// _O^[Qbgۂ
	m_lTextureType	= rTexture.m_lTextureType;

	// PreLoadō쐬ꂽۂ
	m_bPreLoad		= FALSE;

	// t@C
	if( rTexture.m_pFileName!=NULL ){
		long lLength;
		lLength = strlen( rTexture.m_pFileName );
		m_pFileName = (char*)malloc( lLength+1 );
		if( m_pFileName==NULL ){
			ErrorLog( "CDGTexture::CopyMembers : t@Cp̃obt@mۂł܂łB\n" );
			return FALSE;
		}
		strcpy( m_pFileName , rTexture.m_pFileName );
	}

	// foCX
	m_pDeviceInfo = rTexture.m_pDeviceInfo;

	// XvCg̃CfbNX𕡐
	m_objSpriteIndex	= rTexture.m_objSpriteIndex;

	// OtBbÑCfbNX𕡐
	m_objGraphicIndex	= rTexture.m_objGraphicIndex;

	// -----< eNX`̓e𕡐 >-----
	//
	m_iGHandle = 0;
	bRes	= DuplicateTexture( rTexture );
	if( bRes==FALSE ){
		ErrorLog( "CDGTexture::CopyMembers : eNX`̓e𕡐ł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DuplicateTexture( CDGTexture& rTexture )
//
//	[  ]
//		CDGTexture& rTexture		ƃeNX`ւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̃eNX`̓e𕡐܂B
//		{IɁACopyMembers()Ăяo܂B
//--------------------------------------------------------------------
BOOL CDGTexture::DuplicateTexture( CDGTexture& rTexture )
{
	BOOL bRes;

	// -----< mF >-----
	//
	// <<< 葤̃eNX`݂Ȃꍇ́A-1ɂďI >>>
	if( rTexture.m_iGHandle==DGDX_EMPTY ){
		m_iGHandle = DGDX_EMPTY;
		return TRUE;
	}

	// -----< ^Cvɂď؂ւ >-----
	//
	switch( rTexture.m_lTextureType ){
		// <<< ʏ̃eNX`̏ꍇ >>>
		case DGCONTROL_TEXTURE_NORMAL:
			{
				// <<< t@Cǂݍރ^Cv̏ꍇ >>>
				bRes = LoadTextureFile( m_pDeviceInfo , rTexture.m_pFileName , rTexture.m_dwColorKey );
				if( bRes==FALSE )return FALSE;
			}
			break;

		// <<< sȃ^Cv >>>
		default:
			ErrorLog( "CDGTexture::DuplicateTexture : sȃ^Cvi%djw肳܂B\n" , rTexture.m_lTextureType );
			return FALSE;
			break;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejďԂɖ߂܂B
//--------------------------------------------------------------------
void CDGTexture::Release()
{
	// ԕϐ
	m_strIDName			= "";
	m_lTextureType		= DGCONTROL_TEXTURE_NORMAL;
	m_bPreLoad			= FALSE;

	// eNX`C^[tFCX̉
	if( m_iGHandle!=DGDX_EMPTY ){
		DeleteGraph(m_iGHandle);
	}
	m_iGHandle = DGDX_EMPTY;

	// 摜񏉊
	m_width = 0;
	m_height = 0;

	// foCX֘A
	m_pDeviceInfo = NULL;

	// t@C̉
	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}
	m_pFileName = NULL;

	// J[L[
	m_dwColorKey	= 0x00000000;

	// XvCgCfbNX̉
	m_objSpriteIndex.Release();

	// OtBbÑCfbNX
	m_objGraphicIndex.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrepareReset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		foCXXg̃Zbg̏i\[Xjs܂B
//--------------------------------------------------------------------
BOOL CDGTexture::PrepareReset()
{
	// 
	if( m_iGHandle!=DGDX_EMPTY){
		// Ô߂ɉĂяoAɉς̔ŃG[ɂȂ锤
		DeleteGraph(m_iGHandle);
	}
	m_iGHandle = DGDX_EMPTY;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Reset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		foCXXg̃Zbgsi\[Xč\zj܂B
//--------------------------------------------------------------------
BOOL CDGTexture::Reset()
{
	BOOL bRes;

	// -----< ^Cvɂď؂蕪 >-----
	//
	switch( m_lTextureType ){
		// <<< ʏ̃eNX`̏ꍇ >>>
		case DGCONTROL_TEXTURE_NORMAL:
			{
				// <<< t@Cǂݍރ^Cv̏ꍇ >>>
				bRes = LoadTextureFile( m_pDeviceInfo , m_pFileName , m_dwColorKey );
				if( bRes==FALSE )return FALSE;
			}
			break;

		// <<< sȃ^Cv >>>
		default:
			ErrorLog( "CDGTexture::Reset : sȃ^Cvi%djw肳܂B\n" , m_lTextureType );
			return FALSE;
			break;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetIDName( const char* pName )
//
//	[  ]
//		const char* pName			ݒ肷閼
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ʖ̂ݒ肵܂
//--------------------------------------------------------------------
BOOL CDGTexture::SetIDName( const char* pName )
{
	m_strIDName	= pName;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetIDName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ʖ
//
//	[  ]
//		ʖ̂Ԃ܂
//--------------------------------------------------------------------
const char* CDGTexture::GetIDName()
{
	return m_strIDName.GetString();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Load( SDeviceInfo* pDeviceInfo , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCXւ̃|C^
//		const char*  pFileName		t@Cւ̃|C^
//		D3DCOLOR     dwColorKey		J[L[wi@\܂j
//		BOOL         bPreLoad		PreLoadsۂ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C摜ǂݍ݂܂B
//--------------------------------------------------------------------
BOOL CDGTexture::Load( SDeviceInfo* pDeviceInfo , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
{
	BOOL bRes;

	// ܂Aɂ̂
	Release();

	// ԕϐݒ
	m_lTextureType	= DGCONTROL_TEXTURE_NORMAL;
	m_bPreLoad		= bPreLoad;

	// foCXւ̃|C^ۑ
	m_pDeviceInfo	= pDeviceInfo;

	// t@C荞
	int iLength;
	iLength = strlen( pFileName );

	m_pFileName = (char*)malloc( iLength+1 );
	if( m_pFileName==NULL ){
		ErrorLog( "CDGTexture::Load : t@Cp̃obt@mۂł܂łB\n" );
		return FALSE;
	}
	strcpy( m_pFileName , pFileName );

	// 摜ǂݍ
	bRes = LoadTextureFile( pDeviceInfo , pFileName , dwColorKey );
	if( bRes==FALSE ){
		ErrorLog( "CDGTexture::Load : eNX`̓ǂݍ݂Ɏs܂B[%s]\n", pFileName );
		return FALSE;
	}

	// J[L[
	m_dwColorKey	= dwColorKey;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddSpriteIndex( long lIndex )
//
//	[  ]
//		long lIndex					XvCg̒ʂԍ
//
//	[ ߂l ]
//		eNX`Ɋ֘AÂꂽXvCgƂẴCfbNXԍ
//
//	[  ]
//		XvCg̒ʂԍw肷ƁAʂԍLA
//		eNX`IuWFNgɐݒ肳ꂽXvCg̃CfbNX
//		Ԃ܂B
//--------------------------------------------------------------------
long CDGTexture::AddSpriteIndex( long lIndex )
{
	long i;
	long lNullIndex = -1;

	// -----< zumۂ >-----
	//
	// <<< 󂫂 >>>
	for( i=0;i<m_objSpriteIndex.Length();i++ ){
		if( m_objSpriteIndex[i]==-1 ){
			lNullIndex = i;
			break;
		}
	}

	// <<< 󂫂ȂΒǉ >>>
	if( lNullIndex==-1 ){
		lNullIndex = m_objSpriteIndex.Add( -1 );
	}
	if( lNullIndex==-1 ){
		ErrorLog( "CDGTexture::AddSpriteIndex : zɗvfǉł܂łB\n" );
		return -1;
	}

	// -----< zuďI >-----
	//
	m_objSpriteIndex[ lNullIndex ] = lIndex;
	return lNullIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddGraphicIndex( long lIndex )
//
//	[  ]
//		long lIndex					OtBbN̒ʂԍ
//
//	[ ߂l ]
//		eNX`Ɋ֘AÂꂽOtBbNʂƂẴCfbNXԍ
//
//	[  ]
//		OtBbNʂ̒ʂԍw肷ƁAʂԍLA
//		eNX`IuWFNgɐݒ肳ꂽOtBbNʂ̃CfbNX
//		Ԃ܂B
//--------------------------------------------------------------------
long CDGTexture::AddGraphicIndex( long lIndex )
{
	long i;
	long lNullIndex = -1;

	// -----< zumۂ >-----
	//
	// <<< 󂫂 >>>
	for( i=0;i<m_objGraphicIndex.Length();i++ ){
		if( m_objGraphicIndex[i]==-1 ){
			lNullIndex = i;
			break;
		}
	}

	// <<< 󂫂ȂΒǉ >>>
	if( lNullIndex==-1 ){
		lNullIndex = m_objGraphicIndex.Add( -1 );
	}
	if( lNullIndex==-1 ){
		ErrorLog( "CDGTexture::AddGraphicIndex : zɗvfǉł܂łB\n" );
		return -1;
	}

	// -----< zuďI >-----
	//
	m_objGraphicIndex[ lNullIndex ] = lIndex;
	return lNullIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL LoadTextureFile( SDeviceInfo* pDeviceInfo , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCXւ̃|C^
//		const char*  pFileName		t@Cւ̃|C^
//		D3DCOLOR     dwColorKey		J[L[wi@\܂j
//		BOOL         bPreLoad		PreLoadsۂ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C摜ǂݍ݂܂B
//--------------------------------------------------------------------
BOOL CDGTexture::LoadTextureFile( SDeviceInfo* pDeviceInfo , const char* pFileName , D3DCOLOR dwColorKey)
{
	int iRes;

	// -----< eNX`쐬 >-----
	//
	iRes = LoadGraph(pFileName);
	if (iRes == -1) {
		ErrorLog( "CDGTexture::LoadTextureFile : t@C̓ǂݍ݂Ɏs܂B[%s]\n", pFileName );
		return FALSE;
	}
	m_iGHandle = iRes;

	// -----< TCY擾 >-----
	//
	iRes = GetGraphSize(m_iGHandle, &m_width, &m_height);
	if (iRes != 0) {
		ErrorLog("CDGTexture::LoadTextureFile : OtBbÑTCY擾ł܂łB\n");
		m_iGHandle = DGDX_EMPTY;
		m_width = 0;
		m_height = 0;
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		int GetGHandle()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		OtBbNnh
//
//	[  ]
//		DXCũOtBbNnhԂ܂
//--------------------------------------------------------------------
int CDGTexture::GetGHandle()
{
	return m_iGHandle;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSpriteIndex( long lIndex )
//
//	[  ]
//		long lIndex					eNX`ɓo^ꂽXvCg̃CfbNXԍ
//
//	[ ߂l ]
//		XvCg̒ʂCfbNXԍ
//
//	[  ]
//		eNX`ɓo^ꂽXvCg̃CfbNXԍw
//		ƁAʂ̃CfbNXԍԂ܂B
//--------------------------------------------------------------------
long CDGTexture::GetSpriteIndex( long lIndex )
{
	if( lIndex<0 ){
		ErrorLog( "CDGTexture::GetSpriteIndex : CfbNXɕ̒lw肳܂B\n" );
		return -1;
	}

	if( lIndex >= m_objSpriteIndex.Length() ){
		ErrorLog( "CDGTexture::GetSpriteIndex : CfbNXԍ傫܂B\n" );
		return -1;
	}

	return m_objSpriteIndex[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSpriteCount()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		֘AXvCg̐
//
//	[  ]
//		AddSpriteIndex() œo^ꂽ֘AXvCg̐Ԃ܂B
//--------------------------------------------------------------------
long CDGTexture::GetSpriteCount()
{
	return m_objSpriteIndex.Length();
}


//--------------------------------------------------------------------
//	[  ]
//		long GetGraphicIndex( long lIndex )
//
//	[  ]
//		long lIndex					eNX`ɓo^ꂽOtBbÑCfbNXԍ
//
//	[ ߂l ]
//		OtBbN̒ʂCfbNXԍ
//
//	[  ]
//		eNX`ɓo^ꂽOtBbÑCfbNXԍw
//		ƁAʂ̃CfbNXԍԂ܂B
//--------------------------------------------------------------------
long CDGTexture::GetGraphicIndex( long lIndex )
{
	if( lIndex<0 ){
		ErrorLog( "CDGTexture::GetGraphicIndex : CfbNXɕ̒lw肳܂B\n" );
		return -1;
	}

	if( lIndex >= m_objGraphicIndex.Length() ){
		ErrorLog( "CDGTexture::GetGraphicIndex : CfbNXԍ傫܂B\n" );
		return -1;
	}

	return m_objGraphicIndex[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GetGraphicCount()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		֘AOtBbN̐
//
//	[  ]
//		AddGraphicIndex() œo^ꂽ֘AXvCg̐Ԃ܂B
//--------------------------------------------------------------------
long CDGTexture::GetGraphicCount()
{
	return m_objGraphicIndex.Length();
}


//--------------------------------------------------------------------
//	[  ]
//		const char* pFilename()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		t@C
//
//	[  ]
//		ǂݍ񂾃eNX`̃t@CԂ܂B
//		ǂݍݑȌꍇ NULL Ԃ܂B
//--------------------------------------------------------------------
const char* CDGTexture::GetFilename()
{
	return m_pFileName;
}


//--------------------------------------------------------------------
//	[  ]
//		UINT Width()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		eNX`̕
//
//	[  ]
//		eNX`摜̕Ԃ܂B
//--------------------------------------------------------------------
UINT CDGTexture::Width()
{
	return m_width;
}


//--------------------------------------------------------------------
//	[  ]
//		UINT Height()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		eNX`摜̍
//
//	[  ]
//		eNX`摜̍Ԃ܂B
//--------------------------------------------------------------------
UINT CDGTexture::Height()
{
	return m_height;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveSPIndex( long lSpriteIndex )
//
//	[  ]
//		long lSpriteIndex			XvCg̒ʂCfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCg̓o^폜܂B
//		lSpriteIndex ɂ́AʂCfbNXԍw肵܂B
//--------------------------------------------------------------------
BOOL CDGTexture::RemoveSPIndex( long lSpriteIndex )
{
	long lIndex = -1;
	long i;

	// CfbNX
	for( i=0;i<m_objSpriteIndex.Length();i++ ){
		if( m_objSpriteIndex[i]==lSpriteIndex ){
			lIndex = i;
			break;
		}
	}
	if( lIndex==-1 ){
		ErrorLog( "CDGTexture::RemoveSPIndex : w肳ꂽXvCg͓o^Ă܂B\n" );
		return FALSE;
	}

	// o^폜ďI
	m_objSpriteIndex[ lIndex ] = -1;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveGRPIndex( long lGraphicIndex )
//
//	[  ]
//		long lGraphicIndex			zOtBbNʂ̒ʂCfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbN̓o^폜܂B
//		lGraphicIndex ɂ́AʂCfbNXԍw肵܂B
//--------------------------------------------------------------------
BOOL CDGTexture::RemoveGRPIndex( long lGraphicIndex )
{
	long lIndex = -1;
	long i;

	// CfbNX
	for( i=0;i<m_objGraphicIndex.Length();i++ ){
		if( m_objGraphicIndex[i]==lGraphicIndex ){
			lIndex = i;
			break;
		}
	}
	if( lIndex==-1 ){
		ErrorLog( "CDGTexture::RemoveGRPIndex : w肳ꂽzOtBbNʂ͓o^Ă܂B\n" );
		return FALSE;
	}

	// o^폜ďI
	m_objGraphicIndex[ lIndex ] = -1;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CDGTexture& operator=( CDGTexture& rTexture )
//
//	[  ]
//		CDGTexture& rTexture			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CDGTexture& CDGTexture::operator=( CDGTexture& rTexture )
{
	CopyMembers( rTexture );
	return *this;
}
