//====================================================================
//  `NX
//====================================================================
#ifndef __DGRENDERTARGET_H__
#define __DGRENDERTARGET_H__

#include "system.h"
#include "Utils.h"

#include "DGDXInclude.h"
#include "DeviceInfo.h"
#include "DGTexture.h"
#include "2DObject.h"

class CDGRenderTarget : public CUtils{
	// -----< \z >-----
	//
	public:
		CDGRenderTarget();									// RXgN^
		CDGRenderTarget( CDGRenderTarget& rRenderTarget );	// Rs[RXgN^
		virtual ~CDGRenderTarget();							// fXgN^

	private:
		BOOL SetDefault();									// lݒ
		BOOL CopyMembers( CDGRenderTarget& rRenderTarget );	// IuWFNg̓e𕡐

	// -----<  >-----
	//
	private:
		// <<<  >>>
		CGStr		m_strIDName;							// 

		// r[|[g
		DWORD		m_dwViewPortX;							// r[|[gw
		DWORD		m_dwViewPortY;							// r[|[gx
		DWORD		m_dwViewPortWidth;						// r[|[g
		DWORD		m_dwViewPortHeight;						// r[|[g
		long		m_lSurfaceWidth;						// T[tFX
		long		m_lSurfaceHeight;						// T[tFX

		// <<< \[X >>>
		SDeviceInfo*		m_pDevice;						// foCX

		// T[tFX
		int					m_iGHandle;						// `T[tFX

	// -----< \bh >-----
	//
	public:
		// <<<  >>>
		BOOL Release();										// 
		BOOL PrepareReset();								// Zbg
		BOOL Reset();										// Zbg

		// <<< 쐬 >>>
		BOOL CreateBySurface( long lWidth , long lHeight );

		// <<< ANZT >>>
		BOOL		SetIDName( const char* pName );			// Oݒ
		const char*	GetIDName();							// O擾
		int			GetGHandle();							// OtBbNnh擾

		// <<<  >>>
		BOOL ReSize( SDeviceInfo* pDeviceInfo , long lWidth , long lHeight );
		BOOL SetAsRenderTarget( SDeviceInfo* pDeviceInfo );	// RenderTarget ƂĐݒ肷
		//BOOL DrawRenderPolygon( SDeviceInfo& sDeviceInfo , long lWidth , long lHeight , int iAlpha );

	// -----<  >-----
	//
	private:
		BOOL GetRenderTargetSize( SIZE* pSize );			// RenderTarget̃TCY擾
};

#endif
