//====================================================================
//  `NX
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ScreenMode.h"
#include "DeviceInfo.h"
#include "DGRenderTarget.h"
#include "DGTexture.h"
#include "2DObject.h"


//--------------------------------------------------------------------
//	[  ]
//		CDGRenderTarget()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CDGRenderTarget::CDGRenderTarget()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CDGRenderTarget( CDGRenderTarget& rRenderTarget )
//
//	[  ]
//		CDGRenderTarget& rRenderTarget	`
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CDGRenderTarget::CDGRenderTarget( CDGRenderTarget& rRenderTarget )
{
	BOOL bRes;
	bRes = CopyMembers( rRenderTarget );
}


//--------------------------------------------------------------------
//	[  ] virtual
//		~CDGRenderTarget()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDGRenderTarget::~CDGRenderTarget()
{
	BOOL bRes;
	bRes = Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɑ΂ďlݒ肵܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::SetDefault()
{
	// 
	m_strIDName			= "";
	m_dwViewPortX		= 0;
	m_dwViewPortY		= 0;
	m_dwViewPortWidth	= 0;
	m_dwViewPortHeight	= 0;
	m_lSurfaceWidth		= 0;
	m_lSurfaceHeight	= 0;

	// \[X
	m_pDevice		= NULL;
	m_iGHandle		= DGDX_EMPTY;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CDGRenderTarget& rRenderTarget )
//
//	[  ]
//		CDGRenderTarget& rRenderTarget	ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::CopyMembers( CDGRenderTarget& rRenderTarget )
{
	BOOL bRes;

	// -----< ܂ >-----
	//
	bRes = Release();
	if( bRes==FALSE ){
		ErrorLog( "CDGRenderTarget::CopyMembers : IuWFNg̓e̔jɎs܂B\n" );
		return FALSE;
	}

	// -----<  >-----
	//
	m_strIDName	= rRenderTarget.m_strIDName;

	// <<< ItXN[T[tFX̏ꍇ >>>
	{
		long lSizeX , lSizeY;
		lSizeX	= rRenderTarget.m_dwViewPortX + rRenderTarget.m_dwViewPortWidth;
		lSizeY	= rRenderTarget.m_dwViewPortY + rRenderTarget.m_dwViewPortHeight;
		bRes = CreateBySurface(  lSizeX , lSizeY );
		if( bRes==FALSE ){
			ErrorLog( "CDGRenderTarget::CopyMembers : T[tFX̍č\zɎs܂B\n" );
			return FALSE;
		}
	}

	// <<< foCX̕ >>>
	m_pDevice	= rRenderTarget.m_pDevice;

	// -----< 𕡐 >-----
	//
	m_dwViewPortX		= rRenderTarget.m_dwViewPortX;
	m_dwViewPortY		= rRenderTarget.m_dwViewPortY;
	m_dwViewPortWidth	= rRenderTarget.m_dwViewPortWidth;
	m_dwViewPortHeight	= rRenderTarget.m_dwViewPortHeight;
	m_lSurfaceWidth		= rRenderTarget.m_lSurfaceWidth;
	m_lSurfaceHeight	= rRenderTarget.m_lSurfaceHeight;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::Release()
{
	m_strIDName	= "";

	// <<< `p|SJ >>>
	if (m_iGHandle != DGDX_EMPTY) {
		DeleteGraph(m_iGHandle);
	}
	m_iGHandle = DGDX_EMPTY;

	// <<< foCX >>>
	m_pDevice = NULL;

	// <<< ԕϐ >>>
	m_dwViewPortX		= 0;
	m_dwViewPortY		= 0;
	m_dwViewPortWidth	= 0;
	m_dwViewPortHeight	= 0;
	m_lSurfaceWidth		= 0;
	m_lSurfaceHeight	= 0;

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrepareReset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		foCXXg̃Zbg̏i\[Xjs܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::PrepareReset()
{
	if (m_iGHandle != DGDX_EMPTY) {
		// ꉞ邪Aɉς̔ŃG[ɂȂ锤
		DeleteGraph(m_iGHandle);
	}
	m_iGHandle = DGDX_EMPTY;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Reset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		\[X̍č\zs܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::Reset()
{
	BOOL bRes;
	bRes = CreateBySurface(m_lSurfaceWidth, m_lSurfaceHeight);
	if (bRes == FALSE) {
		ErrorLog("CDGRenderTarget::Reset : RenderTarget̃ZbgɎs܂B\n");
		return FALSE;
	}
	
	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CreateBySurface( SDeviceInfo* pDeviceInfo , long lWidth , long lHeight )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCX
//		long lWidth					TCYij
//		long lHeight				TCYij
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RenderTarget쐬܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::CreateBySurface( long lWidth , long lHeight )
{
	int iRes;

	// <<< \[XJ >>>
	if( m_iGHandle!=DGDX_EMPTY ){
		DeleteGraph(m_iGHandle);
	}
	m_iGHandle = DGDX_EMPTY;

	// <<< 쐬 >>>
	iRes = MakeScreen(lWidth, lHeight, TRUE);
	if (iRes == -1) {
		ErrorLog( "CDGRenderTarget::CreateBySurface : RenderTarget쐬ł܂łB\n" );
		return FALSE;
	}
	m_iGHandle = iRes;

	// <<< ̏ݒ >>>
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	m_dwViewPortX		= 0;
	m_dwViewPortY		= 0;
	m_dwViewPortWidth	= lWidth;
	m_dwViewPortHeight	= lHeight;
	m_lSurfaceWidth		= lWidth;
	m_lSurfaceHeight	= lHeight;

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetIDName( const char* pName )
//
//	[  ]
//		const char* pName			ݒ肷閼
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ʖ̂ݒ肵܂
//--------------------------------------------------------------------
BOOL CDGRenderTarget::SetIDName( const char* pName )
{
	m_strIDName	= pName;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetIDName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ʖ
//
//	[  ]
//		ʖ̂Ԃ܂
//--------------------------------------------------------------------
const char* CDGRenderTarget::GetIDName()
{
	return m_strIDName.GetString();
}


//--------------------------------------------------------------------
//	[  ]
//		int GetGHandle()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		`eNX`̃IuWFNgւ̃|C^
//
//	[  ]
//		`ƂďꂽeNX`IuWFNgւ
//		|C^Ԃ܂B
//		G[̏ꍇɂ NULL Ԃ܂B
//--------------------------------------------------------------------
int CDGRenderTarget::GetGHandle()
{
	return m_iGHandle;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReSize( SDeviceInfo* pDeviceInfo , long lWidth , long lHeight )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCX
//		long lWidth					TCYij
//		long lHeight				TCYij
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RenderTarget ̃TCYύX܂B
//		ۂɂ́A݊mۂĂ RenderTarget 
//		Vɍ쐬Ȃ܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::ReSize( SDeviceInfo* pDeviceInfo , long lWidth , long lHeight )
{
	BOOL bRes;

	// -----< mF >-----
	//
	if( pDeviceInfo==NULL ){
		ErrorLog( "CDGRenderTarget::ReSize : w肳ꂽ DeviceInfo  NULL łB\n" );
		return FALSE;
	}

	// -----< TCYύX >-----
	//
	// ̏ꍇ͈xč蒼
	bRes = CreateBySurface( lWidth , lHeight );
	if( bRes==FALSE ){
		ErrorLog( "CDGRenderTarget::ReSize : RenderTarget̍č쐬Ɏs܂B\n" );
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetAsRenderTarget( SDeviceInfo* pDeviceInfo )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCX
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`ƂĐݒ肵܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::SetAsRenderTarget( SDeviceInfo* pDeviceInfo )
{
	int iRes;
	BOOL bRes;

	// <<< mF >>>
	if( pDeviceInfo==NULL ){
		ErrorLog( "CDGRenderTarget::SetAsRenderTarget : w肳ꂽ DeviceInfo  NULL łB\n" );
		return FALSE;
	}
	if (m_iGHandle == DGDX_EMPTY) {
		ErrorLog("CDGRenderTarget::SetAsRenderTarget : GHandleݒ肳Ă܂B\n");
		return FALSE;
	}

	// <<< ݒ >>>
	iRes = SetDrawScreen(m_iGHandle);
	if( iRes!=0 ){
		ErrorLog( "CDGRenderTarget::SetAsRenderTarget : SetRenderTarget() Ɏs܂B\n" );
		return FALSE;
	}

	// <<< `GA̕ƍ擾 >>>
	SIZE sRenderTargetSize;
	bRes	= GetRenderTargetSize( &sRenderTargetSize );
	if( bRes==FALSE ){
		ErrorLog( "CDGRenderTarget::SetAsRenderTarget : `̃TCY擾Ɏs܂B\n" );
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GetRenderTargetSize( SIZE* pSize )
//
//	[  ]
//		SIZE* pSize					ʊi[ւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`̈̃TCYApSize ɐݒ肵ĕԂ܂B
//--------------------------------------------------------------------
BOOL CDGRenderTarget::GetRenderTargetSize( SIZE* pSize )
{
	// -----< mF >-----
	//
	if( pSize==NULL ){
		ErrorLog( "CDGRenderTarget::GetRenderTargetSize : pSizeNULLw肳܂B\n" );
		return FALSE;
	}

	// -----< 擾 >-----
	//
	pSize->cx	= m_lSurfaceWidth;
	pSize->cy	= m_lSurfaceHeight;
	return TRUE;
}
