//====================================================================
//  DirectGraphics Control body unit.
//====================================================================

#ifndef __DGCONTROLBODY_H__
#define __DGCONTROLBODY_H__

#include "DGDXInclude.h"

#include "LogFile.h"
#include "Utils.h"
#include "Hash.h"

#include "DeviceInfo.h"
#include "DGControl.h"
#include "DGTexture.h"
#include "Sprite.h"
#include "Graphic.h"
#include "DGRenderTarget.h"

#include "DArrayMacro.h"				// e}N`


class CDGControlBody : public CDGControl{
	// -----< \z >-----
	//
	public:
		CDGControlBody();								// RXgN^
		virtual ~CDGControlBody();						// fXgN^

	private:
		void SetDefault();								// RXgN^xł̃ftHgݒ

	// -----< f[^o >-----
	//
	private:
		// <<< Windows >>>
		//
		BOOL	m_bConsiderReSize;			// EBhETCY邱Ƃl邩ۂ

		// <<< Direct3D >>>
		//
		SDeviceInfo					m_sDeviceInfo;				// foCX

		// <<< `Ώ >>>
		CDArray< CDGTexture*     >	m_objTexture;				// eNX`IuWFNg
		CDArray< CSprite*        >	m_objSprite;				// XvCgIuWFNg
		CDArray< CGraphic*       >	m_objGraphic;				// OtBbNʃIuWFNg
		CDArray< CDGRenderTarget* >	m_objRenderTarget;			// `IuWFNg
		long					m_lCurrentRenderTargetIndex;	// ݂RenderTarget̃CfbNX

		// <<< CfbNX O >>>
		CGHash< long >				m_hashTextureIndex;			// eNX`IuWFNg
		CGHash< long >				m_hashSpriteIndex;			// XvCgIuWFNg
		CGHash< long >				m_hashGraphicIndex;			// OtBbNʃIuWFNg
		CGHash< long >				m_hashRenderTargetIndex;	// RenderTargetIuWFNg

	// -----< \bh >-----
	//
	// <<< \z^^j >>>
	public:
		BOOL Initialize(								// 
				  BOOL bFullScreen
				, int iWidth , int iHeight, int iFreq
				);
		BOOL InitializeForAttach(
				  int iWidth , int iHeight, int iFreq
				);

		virtual const SDeviceInfo* GetDeviceInfo();	// foCXԂ
		long GetBackBufferWidth();					// obNobt@̃TCYԂ
		long GetBackBufferHeight();					// obNobt@̃TCYԂ

		void ReleaseItems();							// foCXȊO
		void ReleaseRenderTarget();						// RenderTarget Sĉ
		void Release();									// IuWFNg̓ej
		BOOL Reset();									// foCXXg畜A

	private:
		BOOL InitializeCore(
				  BOOL bFullScreen
				, int iWidth , int iHeight, int iFreq
				);

	// <<< CfbNX擾 >>>
	public:
		long GetTextureIndex(      const char* pName );			// eNX`IuWFNg
		long GetSpriteIndex(       const char* pName );			// XvCgIuWFNg
		long GetGraphicIndex(      const char* pName );			// OtBbNʃIuWFNg
		long GetRenderTargetIndex( const char* pName );			// `IuWFNg

	// <<< RenderTarget֘A >>>
	public:
		virtual long	AddRenderTargetTexture( const char* pName , long lWidth , long lHeight );	// `Textureǉ
		virtual BOOL	SetRenderTarget( long lIndex );			// `ݒ肷
		virtual BOOL	SetRenderTargetAsBackBuffer();			// `obNobt@ɐݒ肵܂B
		virtual BOOL	RemoveRenderTarget( long lIndex );		// `폜
		virtual long	GetCurrentRenderTarget();				// ݑI𒆂RenderTarget̃CfbNX擾

	// <<< eNX`֘A >>>
	public:
		long		AddTexture( const char* pName			// eNX`ǉiʁj
						, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad );

		long		AddTextureForSprite( const char* pName	// eNX`ǉiXvCgpj
						, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad );

		long		AddTextureForGraphic( const char* pName	// eNX`ǉiOtBbNpj
						, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad );

		BOOL		RemoveTexture( long lIndex );		// eNX`폜
		long		GetTextureCount();					// o^ĂeNX`̐Ԃ
		long		GetTextureWidth( long lIndex );		// eNX`̕擾
		long		GetTextureHeight( long lIndex );	// eNX`̍擾

	private:
		CDGTexture*	GetTexture( long lIndex );							// eNX`擾
		long		SearchTexture( const char* pFilename );				// wt@C̃eNX`̃CfbNXԂ

	// <<< XvCg >>>
	public:
		long		AddSprite(							// XvCgǉ
						  const char* pName
						, long  lTextureIndex
						, long* lIndexOnTexture=NULL );
		BOOL		RemoveSprite( long lSpriteIndex );
		BOOL		RemoveSprite( long lTextureIndex , long lSpriteIndex );
		BOOL		SetSpriteRect(						// XvCgƂĎgp`w肷
						long lIndex , RECT& rRect );
		BOOL		SetSpriteRect(
						long lIndex , long lLeft,long lTop,long lRight,long lBottom );
		BOOL		SetSpriteCenter(					// XvCg̒S_ݒ肷
						long lIndex , long lX , long lY );
		long		GetSpriteCount( long lTextureIndex=-1 );	// o^ĂXvCg̐Ԃ
		CDObjArray< CGStr > GetSpriteNameList();				// o^ĂXvCg̖̈ꗗԂ
		CGStr		GetSpriteName( long lIndex );				// XvCĝ̖Ԃ

	private:
		CSprite*	GetSprite( long lIndex );			// XvCg擾
		CSprite*	GetSprite( long lTextureIndex , long lSpriteIndex );

	// <<< OtBbN >>>
	public:
		long		AddGraphic(							// OtBbNʂǉ
						  const char* pName
						, long  lTextureIndex
						, long* lIndexOnTexture=NULL );
		BOOL		RemoveGraphic( long lGraphicIndex );
		BOOL		RemoveGraphic( long lTextureIndex , long lGraphicIndex );
		BOOL		SetGraphicView(						// OtBbÑr[EBhEw
						long lIndex , RECT& rRect );
																// OtBbŇJԂ`惂[hݒ
		BOOL		SetGraphicLoopMode( long lIndex , BOOL bLoopX , BOOL bLoopY );
		long		GetGraphicCount( long lTextureIndex=-1 );	// o^ĂOtBbN̐Ԃ

	private:
		CGraphic*	GetGraphic( long lIndex );			// OtBbN擾
		CGraphic*	GetGraphic( long lTextureIndex , long lGraphicIndex );

	// <<< `揈 >>>
	public:
		BOOL	DrawSprite(								// XvCg`
							  long lIndex
							, long lX , long lY
							, BOOL bRevX, BOOL bRevY
							, DWORD dwDiffuse
							, float fZ
							);
		BOOL	DrawSprite(								// XvCg`iCfbNXoneNX`gp)
							  long lTextureIndex , long lSpriteIndex
							, long lX , long lY
							, BOOL bRevX, BOOL bRevY
							, DWORD dwDiffuse
							, float fZ
							);

		BOOL	DrawGraphic(							// OtBbN`
					  long lIndex
					, long lViewX , long lViewY
					, DWORD dwDiffuse
					, float fZ
					);
		BOOL	DrawGraphic(							// OtBbN`iCfbNXoneNX`gpj
					  long lTextureIndex , long lGraphicIndex
					, long lViewX , long lViewY
					, DWORD dwDiffuse
					, float fZ
					);

		BOOL	DrawScaledGraphic(						// XP[OꂽOtBbN`
					  long lIndex
					, long lViewX , long lViewY
					, FLOAT fScalingX , FLOAT fScalingY
					, DWORD dwDiffuse
					, float fZ
					);

		BOOL	DrawRenderTargetTexture( long lIndex , long lTgtX, long lTgtY, long lDrawWidth , long lDrawHeight );

		BOOL	Clear();								// obNobt@NA
		BOOL	Flip();									// _uobt@؂ւ
};

#endif
