//====================================================================
//  DirectGraphics Control body unit.
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "LogFile.h"
#include "Utils.h"
#include "DArray.h"
#include "DObjArray.h"
#include "Str.h"

#include "DeviceInfo.h"
#include "ScreenMode.h"
#include "DGControlBody.h"
#include "DGRenderTarget.h"

//--------------------------------------------------------------------
//	[  ]
//		CDGControlBody()
//
//	[  ]
//		RXgN^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CDGControlBody::CDGControlBody()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		~CDGControlBody()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDGControlBody::~CDGControlBody()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^xł̏lݒ
//--------------------------------------------------------------------
void CDGControlBody::SetDefault()
{
	m_bConsiderReSize		= FALSE;						// TCY邱ƂlȂ
	memset( &m_sDeviceInfo , 0 , sizeof( SDeviceInfo ) );

	m_objTexture.Release();			// eNX`IuWFNg
	m_objSprite.Release();			// XvCgIuWFNg
	m_objGraphic.Release();			// OtBbNʃIuWFNg
	m_objRenderTarget.Release();
	m_lCurrentRenderTargetIndex = -1;	// ݂̕`

	m_hashTextureIndex.Initialize();		// eNX`IuWFNg
	m_hashSpriteIndex.Initialize();			// XvCgIuWFNg
	m_hashGraphicIndex.Initialize();		// OtBbNʃIuWFNg
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize(
//				  BOOL bFullScreen
//				, int iWidth , int iHeight, int iFreq
//				)
//
//	[  ]
//		BOOL	bFullScreen			tXN[ɂ邩ۂ
//		int		iWidth				obNobt@̕itXN[̂ݗLj
//		int		iHeight				obNobt@̍itXN[̂ݗLj
//		int		iFreq				ʂ̎g
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgAi{Iɂ́jQ[pɏ܂B
//		̃[hŏꍇɂ́A摜̃v[e[V
//		obNobt@̓e͕ێ܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::Initialize(
			  BOOL bFullScreen
			, int iWidth , int iHeight, int iFreq
){
	BOOL bRes;

	// Q[pBTCYlKvȂ
	m_bConsiderReSize	= FALSE;

	// Jn
	bRes = InitializeCore(
					  bFullScreen
					, iWidth ,iHeight, iFreq
	);
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL InitializeForAttach(
//				  int iWidth , int iHeight, int iFreq
//				);
//
//	[  ]
//		HWND	hWnd				EBhEnh
//		int		iWidth				obNobt@̕itXN[̂ݗLj
//		int		iHeight				obNobt@̍itXN[̂ݗLj
//		int		iFreq				ʂ̎g
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgAi{Iɂ́jWindowsAvP[Vp
//		܂B
//		̃[hŏsƁAʂ̃v[e[V
//		obNobt@̓eێ邱Ƃۏ؂ł܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::InitializeForAttach(
		  int iWidth , int iHeight, int iFreq
){
	BOOL bRes;

	// AvP[VpBTCYlKv
	m_bConsiderReSize	= TRUE;

	bRes = InitializeCore(
					  FALSE					// tXN[ł͂Ȃ
					, iWidth ,iHeight, iFreq
					);
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL InitializeCore(
//				  BOOL bFullScreen
//				, int iWidth , int iHeight, int iFreq
//				);
//
//	[  ]
//		BOOL	bFullScreen			tXN[ɂ邩ۂ
//		int		iWidth				obNobt@̕itXN[̂ݗLj
//		int		iHeight				obNobt@̍itXN[̂ݗLj
//		int		iFreq				ʂ̎g
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::InitializeCore(
			  BOOL bFullScreen
			, int iWidth , int iHeight
			, int iFreq
){
	DebugLog( "CDGControlBody::InitializeCore : IuWFNg̏Jn܂B\n" );

	int iRes;

	// -----< OS Versionݒ >-----
	//
	m_sDeviceInfo.m_sOSInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );

	// -----< foCX쐬 >-----
	//
	// TCYݒ
	iRes = SetGraphMode(iWidth, iHeight, 32, iFreq);
	if (iRes != 0) {
		ErrorLog("CDGControlBody::InitializeCore : ʃTCY̐ݒɎs܂B\n");
		return FALSE;
	}

	// fBXvC[h̍\z
	if( bFullScreen==FALSE ){
		// EBhE[h
		iRes = ChangeWindowMode(TRUE);
		if(iRes!= DX_CHANGESCREEN_OK) {
			ErrorLog( "CDGControlBody::InitializeCore : fBXvC[h̎擾Ɏs܂B\n" );
			return FALSE;
		}
	} else {
		// tXN[
		iRes = ChangeWindowMode(FALSE);
		if (iRes != DX_CHANGESCREEN_OK) {
			ErrorLog( "CDGControlBody::InitializeCore : gp\ȃfBXvC[h܂łBEBhE[hŎs܂B\n" );
			return FALSE;
		}
	}

	// -----< ̑ >-----
	//
	m_lCurrentRenderTargetIndex	= -1;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTextureIndex(      const char* pName )
//		long GetSpriteIndex(       const char* pName )
//		long GetGraphicIndex(      const char* pName )
//		long GetTextWindowIndex(   const char* pName )
//		long GetLightIndex(        const char* pName )
//		long GetRenderTargetIndex( const char* pName )
//
//	[  ]
//		const char* pName			o^
//
//	[ ߂l ]
//		o^ꍇAIuWFNg̃CfbNXԍ
//		Ȃꍇ -1
//
//	[  ]
//		o^̂ŁAIuWFNg̃CfbNXԍԂ܂B
//--------------------------------------------------------------------
long CDGControlBody::GetTextureIndex(      const char* pName )
{
	BOOL bRes;

	// <<< L[݂̑mF >>>
	bRes =	m_hashTextureIndex.KeyExists( pName );
	if( bRes==FALSE ){ return -1; }	// ݂

	// <<< CfbNX擾ĕԂ >>>
	long lIndex;
	lIndex = m_hashTextureIndex.GetObject( pName );
	return lIndex;
}

long CDGControlBody::GetSpriteIndex(       const char* pName )
{
	BOOL bRes;

	// <<< L[݂̑mF >>>
	bRes =	m_hashSpriteIndex.KeyExists( pName );
	if( bRes==FALSE ){ return -1; }	// ݂

	// <<< CfbNX擾ĕԂ >>>
	long lIndex;
	lIndex = m_hashSpriteIndex.GetObject( pName );
	return lIndex;
}

long CDGControlBody::GetGraphicIndex(      const char* pName )
{
	BOOL bRes;

	// <<< L[݂̑mF >>>
	bRes =	m_hashGraphicIndex.KeyExists( pName );
	if( bRes==FALSE ){ return -1; }	// ݂

	// <<< CfbNX擾ĕԂ >>>
	long lIndex;
	lIndex = m_hashGraphicIndex.GetObject( pName );
	return lIndex;
}

long CDGControlBody::GetRenderTargetIndex( const char* pName )
{
	BOOL bRes;

	// <<< L[݂̑mF >>>
	bRes =	m_hashRenderTargetIndex.KeyExists( pName );
	if( bRes==FALSE ){ return -1; }	// ݂

	// <<< CfbNX擾ĕԂ >>>
	long lIndex;
	lIndex = m_hashRenderTargetIndex.GetObject( pName );
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddRenderTargetTexture( const char* pName , long lWidth , long lHeight )
//
//	[  ]
//		const char* pName			o^
//		long lWidth					TCYij
//		long lHeight				TCYij
//
//	[ ߂l ]
//		F쐬ꂽRenderTarget̃CfbNXԍ
//		sF-1
//
//	[  ]
//		VRenderTargetTexture쐬܂B
//		ƁA쐬RenderTargetʂ
//		CfbNXԍԂ܂B
//
//		o^svȏꍇ́ApName  NULL wł܂B
//--------------------------------------------------------------------
long CDGControlBody::AddRenderTargetTexture( const char* pName , long lWidth , long lHeight )
{
	long lIndex;
	BOOL bRes;

	// -----< 쐬 >-----
	//
	// <<< IuWFNg쐬 >>>
	CDGRenderTarget* pRenderTarget = new CDGRenderTarget();
	if( pRenderTarget==NULL ){
		ErrorLog( "CDGControlBody::AddRenderTargetTexture : RenderTargetIuWFNg̍쐬Ɏs܂B\n" );
		return -1;
	}

	// <<< \z >>>
	bRes = pRenderTarget->CreateBySurface(lWidth, lHeight);
	if( bRes==FALSE ){
		ErrorLog( "CDGCotnrolBody::AddRenderTargetTexture : RenderTarget̏Ɏs܂B\n" );
		delete pRenderTarget;
		return -1;
	}

	// -----< zumۂ >-----
	//
	// <<< 󂫂 >>>
	DARRAY_SEARCHINDEX( m_objRenderTarget , lIndex );
	if( lIndex==-1 ){
		ErrorLog( "CDGControlBody::AeddRenderTargetTexture : vf̒ǉɎs܂B\n" );
		delete pRenderTarget;
		return -1;
	}

	// -----< o^ >-----
	//
	// IuWFNgo^
	m_objRenderTarget[ lIndex ] = pRenderTarget;

	// IuWFNgo^
	bRes = pRenderTarget->SetIDName( pName );
	if( bRes==FALSE ){ return -1; }
	if( pName!=NULL ){
		m_hashRenderTargetIndex.AddObject( pName , lIndex );
	}

	// -----< I >-----
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetRenderTarget( long lIndex )
//
//	[  ]
//		long lIndex					RenderTarget ̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		舵 RenderTarget w肵܂B
//		RenderTarget obNobt@ɖ߂ɂ́ASetRenderTargetAsBackBuffer()
//		gp܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetRenderTarget( long lIndex )
{
	BOOL bRes;

	// <<< mF >>>
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::SetRenderTarget : ̃CfbNXw肳܂B\n" );
		return FALSE;
	}
	if( lIndex>=m_objRenderTarget.Length() ){
		ErrorLog( "CDGControlBody::SetRenderTarget : w肳ꂽCfbNX傫܂B\n" );
		return FALSE;
	}

	// <<< 擾 >>>
	CDGRenderTarget* pRenderTarget;
	pRenderTarget = m_objRenderTarget[ lIndex ];
	if( pRenderTarget==NULL ){
		ErrorLog( "CDGControlBody::SetRenderTarget : w肳ꂽRenderTarget͍폜Ă܂B\n" );
		return FALSE;
	}

	// <<< ݒ >>>
	bRes = pRenderTarget->SetAsRenderTarget( &m_sDeviceInfo );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::SetRenderTarget : RenderTargetݒɎs܂B\n" );
		return FALSE;
	}

	// <<< I >>>
	m_lCurrentRenderTargetIndex	= lIndex;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetRenderTargetAsBackBuffer()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RenderTarget ݂̃obNobt@ɐݒ肵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetRenderTargetAsBackBuffer()
{
	int iRes;

	// -----< T[tFX؂ւ >-----
	//
	// <<< ݒ >>>
	iRes = SetDrawScreen(DX_SCREEN_BACK);
	if (iRes != 0) {
		ErrorLog( "CDGControlBody::SetRenderTargetAsBackBuffer : RenderTarget̐ݒɎs܂B\n" );
		return FALSE;
	}

	// -----< `̈ݒ >-----
	//
	CGScreenMode* pScreenMode	= CGScreenMode::GetInstance();
	RECT*         pViewRect		= pScreenMode->GetViewRect();

	// -----< I >-----
	//
	m_lCurrentRenderTargetIndex = -1;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveRenderTarget( long lIndex )
//
//	[  ]
//		long lIndex					폜RenderTarget̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex Ŏw肳 RenderTarget 폜܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::RemoveRenderTarget( long lIndex )
{
	BOOL bRes;

	// <<< mF >>>
	if( lIndex>=m_objRenderTarget.Length() ){
		ErrorLog( "CDGControlBody::RemoveRenderTarget : w肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveRenderTarget : ̃CfbNXw肳܂B\n" );
		return FALSE;
	}

	// <<< 폜ς݂Ȃ琬ŕԂ >>>
	if( m_objRenderTarget[lIndex]==NULL ){
		return TRUE;
	}

	// <<< ݑIĂ̂ł΁AftHgɖ߂ >>>
	bRes = SetRenderTargetAsBackBuffer();
	if( bRes==FALSE )return FALSE;

	// <<< 폜 >>>
	// ̉폜
	CDGRenderTarget* pRenderTarget;
	pRenderTarget = m_objRenderTarget[lIndex];

	bRes = m_hashRenderTargetIndex.DeleteIfExist( pRenderTarget->GetIDName() );
	if( bRes==FALSE )return FALSE;

	// IuWFNg폜
	bRes = m_objRenderTarget[lIndex]->Release();
	if( bRes==FALSE )return FALSE;
	m_objRenderTarget[lIndex] = NULL;

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetCurrentRenderTarget()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݑI𒆂 RenderTarget ̃CfbNXԍ
//		obNobt@̂Ƃɂ -1
//
//	[  ]
//		ݑI𒆂RenderTarget̃CfbNXԍԂ܂B
//		obNobt@w肳ĂƂɂ́A-1 Ԃ܂B
//		 -1 łB
//--------------------------------------------------------------------
long CDGControlBody::GetCurrentRenderTarget()
{
	return m_lCurrentRenderTargetIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		const SDeviceInfo* GetDeviceInfo()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		SDeviceInfo \̂ւ̃|C^
//
//	[  ]
//		ݒ肳ĂfoCXԂ܂B
//		̊֐́AĂяoO Initialize() s
//		ȂƈӖ܂B
//--------------------------------------------------------------------
const SDeviceInfo* CDGControlBody::GetDeviceInfo()
{
	return &m_sDeviceInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetBackBufferWidth()
//		long GetBackBufferHeight()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		obNobt@̃TCY
//
//	[  ]
//		obNobt@̃TCYԂ܂B
//		̊֐sOɁADGControlĂ
//		Kv܂B
//--------------------------------------------------------------------
long CDGControlBody::GetBackBufferWidth()
{
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	return pScreenMode->GetSurfaceWidth();
}

long CDGControlBody::GetBackBufferHeight()
{
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	return pScreenMode->GetSurfaceHeight();
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseItems()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		DirectX ̃C^[tFCXo܂B
//--------------------------------------------------------------------
void CDGControlBody::ReleaseItems()
{
	int i;

	// -----< XvCg̉ >-----
	//
	for( i=0;i<m_objSprite.Length();i++ ){
		if( m_objSprite[i]!=NULL ){
			delete m_objSprite[i];
		}
		m_objSprite[i] = NULL;
	}
	m_objSprite.Release();

	// -----< OtBbN̉ >-----
	//
	for( i=0;i<m_objGraphic.Length();i++ ){
		if( m_objGraphic[i]!=NULL ){
			delete m_objGraphic[i];
		}
		m_objGraphic[i] = NULL;
	}
	m_objGraphic.Release();

	// -----< eNX`̉ >-----
	//
	for (i = 0; i < m_objTexture.Length(); i++) {
		if (m_objTexture[i] != NULL) {
			delete m_objTexture[i];
		}
		m_objTexture[i] = NULL;
	}
	m_objTexture.Release();

	// -----< O >-----
	//
	m_hashTextureIndex.Initialize();		// eNX`IuWFNg
	m_hashSpriteIndex.Initialize();			// XvCgIuWFNg
	m_hashGraphicIndex.Initialize();		// OtBbNʃIuWFNg
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseRenderTarget()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`Sĉ܂B
//		RenderTarget ̓obNobt@ɐݒ肳܂B
//--------------------------------------------------------------------
void CDGControlBody::ReleaseRenderTarget()
{
	long i;

	// -----< obNobt@I >-----
	//
	SetRenderTargetAsBackBuffer();

	// -----< `̉ >-----
	//
	for( i=0;i<m_objRenderTarget.Length();i++ ){
		if( m_objRenderTarget[i]!=NULL ){
			delete m_objRenderTarget[i];
		}
		m_objRenderTarget[i]	= NULL;
	}
	m_objRenderTarget.Release();
	m_lCurrentRenderTargetIndex = -1;

	// -----< O >-----
	//
	m_hashRenderTargetIndex.Initialize();	// `IuWFNg

	// -----< I >-----
	//
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ej
//--------------------------------------------------------------------
void CDGControlBody::Release()
{
	// -----< ỏ >-----
	//
	ReleaseItems();

	// -----< ̑ >-----
	//
	m_bConsiderReSize	= FALSE;
	m_lCurrentRenderTargetIndex	= -1;

	// -----< Utils ̉ >-----
	//
	CUtils::Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Reset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		foCXXg̏Ԃ畜A܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::Reset()
{
	int i;
	BOOL bRes;

	// -----< \[X >-----
	//
	// DGTexture
	for( i=0;i<m_objTexture.Length();i++ ){
		CDGTexture* pTexture	= m_objTexture[ i ];
		if( pTexture==NULL ){ continue; }
		bRes	= pTexture->PrepareReset();
		if( bRes==FALSE ){
			ErrorLog( "CDGControlBody::Reset : DGTexture[%d]PrepareReset()Ɏs܂B\n" , i );
			return FALSE;
		}
	}

	// DGRenderTarget
	for( i=0;i<m_objRenderTarget.Length();i++ ){
		CDGRenderTarget* pRenderTarget	= m_objRenderTarget[ i ];
		if( pRenderTarget==NULL ){ continue; }
		bRes	= pRenderTarget->PrepareReset();
		if( bRes==FALSE ){
			ErrorLog( "CDGControlBody::Reset : DGRenderTarget[%d]PrepareReset()Ɏs܂B\n" , i );
			return FALSE;
		}
	}

	// -----< \[XĊmۂ >-----
	//
	// DGRenderTarget
	for( i=0;i<m_objRenderTarget.Length();i++ ){
		CDGRenderTarget* pRenderTarget	= m_objRenderTarget[ i ];
		if( pRenderTarget==NULL ){ continue; }
		bRes	= pRenderTarget->Reset();
		if( bRes==FALSE ){
			ErrorLog( "CDGControlBody::Reset : DGRenderTarget[%d]Reset()Ɏs܂B\n" , i );
			return FALSE;
		}
	}

	// DGTexture
	for( i=0;i<m_objTexture.Length();i++ ){
		CDGTexture* pTexture	= m_objTexture[ i ];
		if( pTexture==NULL ){ continue; }
		bRes	= pTexture->Reset();
		if( bRes==FALSE ){
			ErrorLog( "CDGControlBody::Reset : DGTexture[%d]Reset()Ɏs܂B\n" , i );
			return FALSE;
		}
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddTexture( const char* pName , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
//
//	[  ]
//		const char* pName			o^
//		const char* pFileName		t@Cւ̃|C^
//		D3DCOLOR	dwColorKey		J[L[wi@\܂j
//		BOOL bPreLoad				PreLoadsۂ
//
//	[ ߂l ]
//		ǉꂽeNX`̃CfbNXԍ
//		G[̏ꍇ -1
//
//	[  ]
//		eNX`ǉ܂B
//		{IɁA|Sɓ\teNX`płB
//		̊֐œǂݍ񂾏ꍇAdwColorKey ͋@\܂B
//--------------------------------------------------------------------
long CDGControlBody::AddTexture( const char* pName , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
{
	// eNX`쐬
	//
	CDGTexture* pTexture;
	pTexture = new CDGTexture();
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::AddTexture : eNX`IuWFNg쐬܂łB\n" );
		return -1;
	}

	// 摜ǂݍ
	//
	BOOL bRes;
	bRes = pTexture->Load( &m_sDeviceInfo , pFileName , dwColorKey , bPreLoad );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::AddTexture : 摜ǂݍ߂܂łB\n" );
		delete pTexture;
		return -1;
	}

	// zɒǉ
	//
	long lRes;
	DARRAY_SEARCHINDEX( m_objTexture , lRes );
	if( lRes==-1 ){
		ErrorLog( "CDGControlBody::AddTexture : eNX`zɒǉł܂łB\n" );
		delete pTexture;
		return -1;
	}
	m_objTexture[lRes] = pTexture;

	// Oݒ
	bRes = pTexture->SetIDName( pName );
	if( bRes==FALSE ){ return FALSE; }
	if( pName!=NULL ){
		m_hashTextureIndex.AddObject( pName , lRes );
	}

	// I
	//
	return lRes;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddTextureForSprite( const cahr* pName , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
//
//	[  ]
//		const char* pName			o^
//		const char* pFileName		t@Cւ̃|C^
//		D3DCOLOR	dwColorKey		J[L[w
//		BOOL bPreLoad				PreLoads邩ۂ
//
//	[ ߂l ]
//		ǉꂽeNX`̃CfbNXԍ
//		G[̏ꍇ -1
//
//	[  ]
//		eNX`ǉ܂B
//		XvCgɎgp邽߂ɃJX^}CYꂽ֐łB
//--------------------------------------------------------------------
long CDGControlBody::AddTextureForSprite( const char* pName , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
{
	// eNX`쐬
	//
	CDGTexture* pTexture;
	pTexture = new CDGTexture();
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::AddTextureForSprite : eNX`IuWFNg쐬܂łB\n" );
		return -1;
	}

	// 摜ǂݍ
	//
	BOOL bRes;
	bRes = pTexture->Load( &m_sDeviceInfo , pFileName , dwColorKey , bPreLoad );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::AddTextureForSprite : 摜ǂݍ߂܂łB\n" );
		delete pTexture;
		return -1;
	}

	// zɒǉ
	//
	long lRes;
	DARRAY_SEARCHINDEX( m_objTexture , lRes );
	if( lRes==-1 ){
		ErrorLog( "CDGControlBody::AddTextureForSprite : eNX`zɒǉł܂łB\n" );
		delete pTexture;
		return -1;
	}
	m_objTexture[ lRes ] = pTexture;

	// Oݒ
	bRes = pTexture->SetIDName( pName );
	if( bRes==FALSE ){ return FALSE; }
	if( pName!=NULL ){
		m_hashTextureIndex.AddObject( pName , lRes );
	}

	// I
	//
	return lRes;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddTextureForGraphic(
//				const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
//
//	[  ]
//		const char*	pFileName		ǂݍމ摜̃t@C
//		D3DCOLOR	dwColorKey		J[L[
//		BOOL		bPreLoad		PreLoadsۂ
//
//	[ ߂l ]
//		eNX`̃CfbNXԍ
//
//	[  ]
//		OtBbNʗp̃eNX`ǉ܂B
//		OtBbNʂɎgp邽߂ɃJX^}CYĂ܂B
//--------------------------------------------------------------------
long CDGControlBody::AddTextureForGraphic(
				const char* pName , const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )
{
	long lIndex;

	// XvCgpƉςȂB
	//
	lIndex = AddTextureForSprite( pName , pFileName , dwColorKey , bPreLoad );
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveTexture( long lIndex )
//
//	[  ]
//		long lIndex					eNX`̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		o^ĂeNX`J܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::RemoveTexture( long lIndex )
{
	// <<< mF >>>
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveTexture : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lIndex>=m_objTexture.Length() ){
		ErrorLog( "CDGControlBody::RemoveTexture : w肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( m_objTexture[ lIndex ]==NULL ){
		// 폜ς݂Ȃ̂ŁAŕԂ
		return TRUE;
	}

	// <<< O폜 >>>
	const char* pName = m_objTexture[ lIndex ]->GetIDName();
	m_hashTextureIndex.DeleteIfExist( pName );

	// <<< 폜 >>>
	m_objTexture[ lIndex ]->Release();
	delete m_objTexture[ lIndex ];
	m_objTexture[ lIndex ] = NULL;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTextureCount()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		o^ĂeNX`̐
//
//	[  ]
//		o^ĂeNX`̑Ԃ܂B
//--------------------------------------------------------------------
long CDGControlBody::GetTextureCount()
{
	long lCount;
	lCount	= m_objTexture.Length();
	return lCount;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTextureWidth( long lIndex )
//		long GetTextureHeight( long lIndex )
//
//	[  ]
//		long lIndex				eNX`̃CfbNXԍ
//
//	[ ߂l ]
//		eNX`̃TCY
//
//	[  ]
//		o^ĂeNX`̕⍂Ԃ܂B
//		LoadTextureForSP  LoadTextureForGRP œǂݍ񂾂̂łȂ
//		ɓ삵܂B
//--------------------------------------------------------------------
long CDGControlBody::GetTextureWidth( long lIndex )
{
	CDGTexture* pTexture;
	pTexture	= GetTexture( lIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::GetTextureWidth : eNX`IuWFNg擾ł܂łB\n" );
		return FALSE;
	}
	
	long lWidth;
	lWidth	= pTexture->Width();
	return lWidth;
}

long CDGControlBody::GetTextureHeight( long lIndex )
{
	CDGTexture* pTexture;
	pTexture	= GetTexture( lIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::GetTextureHeight : eNX`IuWFNg擾ł܂łB\n" );
		return FALSE;
	}
	
	long lHeight;
	lHeight	= pTexture->Height();
	return lHeight;
}


//--------------------------------------------------------------------
//	[  ]
//		CDGTexture* GetTexture( long lIndex );
//
//	[  ]
//		long lIndex					eNX`̃CfbNXԍ
//
//	[ ߂l ]
//		eNX`IuWFNgւ̃|C^
//
//	[  ]
//		eNX`IuWFNg擾܂B
//--------------------------------------------------------------------
CDGTexture* CDGControlBody::GetTexture( long lIndex )
{
	// -----< `FbN >-----
	//
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::GetTexture : ̃CfbNXw肳܂B\n" );
		return NULL;
	}

	if( lIndex >= m_objTexture.Length() ){
		ErrorLog( "CDGControlBody::GetTexture : wCfbNX傫܂B\n" );
		return NULL;
	}

	// -----<  >-----
	//
	CDGTexture* pTexture;
	pTexture = m_objTexture[ lIndex ];
	return pTexture;
}


//--------------------------------------------------------------------
//	[  ]
//		long SearchTexture( const char* pFilename )
//
//	[  ]
//		const char* pFilename	eNX`̃t@CA邢͓o^L[
//
//	[ ߂l ]
//		eNX`IuWFNg̃CfbNXԍ
//
//	[  ]
//		w肳ꂽt@C̉摜ǂݍ񂾃eNX`IuWFNg
//		āACfbNXԍԂ܂B
//		Ȃꍇɂ́A-1 Ԃ܂B
//
//		pFilename ͕ō\܂B
//		t@C̍Ō pFilename eNX`IuWFNg
//		CfbNXԍԂ܂B
//		o^ĂeNX`ɁAỸt@CȂꍇ
//		pFilename ɈvL[œo^ĂeNX`I܂B
//--------------------------------------------------------------------
long CDGControlBody::SearchTexture( const char* pFilename )
{
	// ⓚpŕԂ̂́AɕԂĂ܂
	if( pFilename==NULL )return -1;
	if( strlen( pFilename )==0 )return -1;

	long i;
	int  iFNLength		= strlen( pFilename );
	long lTextureIndex	= -1;

	// -----< 摜 >-----
	//
	for( i=0;i<GetTextureCount();i++ ){
		// <<< 擾 >>>
		//
		CDGTexture* pTexture;				// eNX`IuWFNg
		const char* pTextureFilename;		// eNX`IuWFNgɐݒ肳Ăt@C
		pTexture	= GetTexture( i );
		if( pTexture==NULL )continue;
		pTextureFilename	= pTexture->GetFilename();
		if( pTextureFilename==NULL )continue;

		// <<< ΉeNX`H >>>
		const char* pWork;
		const char* pPosition;
		pWork		= pTextureFilename;
		pPosition	= NULL;
		while( 1 ){
			// T
			pPosition	= strstr( pWork , pFilename );
			if( pPosition==NULL )break;					// ݂Ȃ

			// ŌォH
			if( pPosition[ iFNLength ]==0x00 )break;	// ݂B

			// Ōł͂Ȃ̂ŁAʒu߂āAx
			pWork	= pPosition+1;
		}
		if( pPosition==NULL )continue;				// w肳ꂽeNX`ł͂Ȃ

		// <<< ΉeNX` >>>
		lTextureIndex	= i;
		break;
	}

	// -----< t@CŌȂꍇAL[Ō >-----
	//
	if( lTextureIndex==-1 ){
		BOOL bExists;
		bExists	= m_hashTextureIndex.KeyExists( pFilename );
		if( bExists==TRUE ){
			lTextureIndex	= m_hashTextureIndex.GetObject( pFilename );
		}
	}

	return lTextureIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddSprite( const char* pName , long lTextureIndex , long* pIndexOnTexture )
//
//	[  ]
//		const char*		pName			o^
//		long			lTextureIndex	eNX`̃CfbNXԍ
//		long*			pIndexOnTexture	eNX`ł̃XvCg̃CfbNXԍ󂯎邽߂̃|C^
//
//	[ ߂l ]
//		ǉꂽXvCg̃CfbNXԍ
//
//	[  ]
//		XvCgǉ܂B
//		eNX`ł̃CfbNXKvȏꍇ́ApIndexOnTexture 
//		w肷Ύ擾ł܂B
//		pIndexOnTexture  NULL ̏ꍇ͖܂B
//--------------------------------------------------------------------
long CDGControlBody::AddSprite( const char* pName , long lTextureIndex , long* pIndexOnTexture )
{
	// IuWFNg̍쐬
	//
	CSprite* pSprite;
	pSprite = new CSprite();
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::AddSprite : XvCgIuWFNg쐬ł܂łB\n" );
		return -1;
	}

	// eNX`擾
	//
	CDGTexture* pTexture;
	pTexture = GetTexture( lTextureIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::AddSprite : eNX`擾ł܂łB\n" );
		delete pSprite;
		return -1;
	}

	// XvCg\z
	//
	BOOL bRes;
	bRes = pSprite->Create( &m_sDeviceInfo , pTexture );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::AddSprite : XvCg\zł܂łB\n" );
		delete pSprite;
		return -1;
	}

	// XvCgǉ
	//
	long lIndex;
	DARRAY_SEARCHINDEX( m_objSprite , lIndex );
	if( lIndex==-1 ){
		ErrorLog( "CDGControlBody::AddSprite : XvCgǉł܂łB\n" );
		delete pSprite;
		return -1;
	}
	m_objSprite[ lIndex ] = pSprite;

	// eNX`ɑ΂āAXvCgǉʒm
	//
	long lSPIndex;
	lSPIndex = pTexture->AddSpriteIndex( lIndex );
	if( lSPIndex==-1 ){
		ErrorLog( "CDGControlBody::AddSprite : eNX`IuWFNgɃXvCg̃CfbNXo^ł܂łB\n" );
		m_objSprite.Remove( lIndex );		// ǉXvCgLZ
		delete pSprite;
		return -1;
	}

	// eNX`ł̃XvCg̃CfbNXԍԂ
	//
	if( pIndexOnTexture!=NULL ){
		*pIndexOnTexture = lSPIndex;
	}

	// Oݒ
	bRes = pSprite->SetIDName( pName );
	if( bRes==FALSE ){ return -1; }
	if( pName!=NULL ){
		m_hashSpriteIndex.AddObject( pName , lIndex );
	}

	// I
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveSprite( long lSpriteIndex )
//		BOOL RemoveSprite( long lTextureIndex , long lSpriteIndex )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lSpriteIndex			XvCg̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽXvCg폜܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::RemoveSprite( long lSpriteIndex )
{
	// -----< mF >-----
	//
	if( lSpriteIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveSprite : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lSpriteIndex>=m_objSprite.Length() ){
		ErrorLog( "CDGControlBody::RemoveSprite : w肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( m_objSprite[ lSpriteIndex ]==NULL ){
		// 폜ς݂Ȃ̂ŁAŕԂ
		return TRUE;
	}

	// -----< eNX`ł̏폜 >-----
	//
	// <<< eNX`擾 >>>
	CSprite* pSprite;
	CDGTexture* pTexture;

	pSprite = m_objSprite[ lSpriteIndex ];
	pTexture = pSprite->GetTexture();
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::RemoveSprite : XvCgIuWFNgɃeNX`ݒ肳Ă܂B\n" );
		return FALSE;
	}

	// <<< eNX`ł̓o^폜 >>>
	pTexture->RemoveSPIndex( lSpriteIndex );

	// <<< O폜 >>>
	const char* pName = m_objSprite[ lSpriteIndex ]->GetIDName();
	m_hashSpriteIndex.DeleteIfExist( pName );

	// -----< XvCg폜 >-----
	//
	m_objSprite[ lSpriteIndex ]->Release();
	delete m_objSprite[ lSpriteIndex ];
	m_objSprite[ lSpriteIndex ] = NULL;
	return TRUE;
}


BOOL CDGControlBody::RemoveSprite( long lTextureIndex , long lSpriteIndex )
{
	BOOL bRes;

	// -----< mF >-----
	//
	if( lTextureIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveSprite : lTextureIndexɕ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lTextureIndex>=m_objTexture.Length() ){
		ErrorLog( "CDGControlBody::RemoveSprite : lTextureIndexɎw肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( m_objTexture[ lTextureIndex ]==NULL ){
		ErrorLog( "CDGControlBody::RemoveSprite : eNX`폜ς݂łB\n" );
		return FALSE;
	}

	// -----< ʂCfbNX擾 >-----
	//
	CDGTexture* pTexture;
	pTexture = m_objTexture[ lTextureIndex ];

	long lSerialSPIndex;
	lSerialSPIndex = pTexture->GetSpriteIndex( lSpriteIndex );
	if( lSerialSPIndex==-1 ){
		ErrorLog( "CDGControlBody::RemoveSprite : w肳ꂽXvCg܂łB\n" );
		return FALSE;
	}

	// -----< IuWFNg폜 >-----
	//
	bRes = RemoveSprite( lSerialSPIndex );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::RemoveSprite : XvCg̍폜Ɏs܂B\n" );
		return FALSE;
	}
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetSpriteRect( long lIndex , RECT& rRect )
//
//	[  ]
//		long  lIndex				XvCg̃CfbNXԍ
//		RECT& rRect					gp`̈
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCgɋ`̈蓖Ă܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetSpriteRect( long lIndex , RECT& rRect )
{
	// -----< XvCgIuWFNg擾 >-----
	//
	CSprite* pSprite;
	pSprite = GetSprite( lIndex );
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::SetSpriteRect : XvCg擾ł܂łB\n" );
		return FALSE;
	}

	// -----< XvCgɋ`ݒ >-----
	//
	BOOL bRes;
	bRes = pSprite->SetRect( rRect.left , rRect.top , rRect.right , rRect.bottom );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::SetSpriteRect : XvCgɋ`ݒł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetSpriteRect( long lIndex , long lLeft,long lTop.long lRight,long lBottom )
//
//	[  ]
//		long  lIndex				XvCg̃CfbNXԍ
//		long  lLeft					gp`̈ [
//		long  lTop					gp`̈ [
//		long  lRight				gp`̈ E[
//		long  lBottom				gp`̈ [
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCgɋ`̈蓖Ă܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetSpriteRect( long lIndex , long lLeft , long lTop , long lRight , long lBottom )
{
	RECT sRect;
	sRect.left		= lLeft;
	sRect.top		= lTop;
	sRect.right		= lRight;
	sRect.bottom	= lBottom;

	BOOL bRes;
	bRes	= SetSpriteRect( lIndex , sRect );
	if( bRes==FALSE )return FALSE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetSpriteCenter( long lIndex , long lX , long lY )
//
//	[  ]
//		long lIndex					XvCg̃CfbNXԍ
//		long lX						S_̂wW
//		long lY						S_̂xW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCgɒS_ݒ肵܂B
//		S_ɂ́AXvCg̋`̈̍ォ̃ItZbgw肵܂B
//		`掞ɂ́Aw肵S_A`֐Ɏw肵Wɂ悤
//		`悳܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetSpriteCenter( long lIndex , long lX , long lY )
{
	// -----< XvCg擾 >-----
	//
	CSprite* pSprite;
	pSprite = GetSprite( lIndex );
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::SetSpriteCenter : XvCg擾ł܂łB\n" );
		return FALSE;
	}

	// -----< S_ݒ >-----
	//
	BOOL bRes;
	bRes = pSprite->SetCenter( lX , lY );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::SetSpriteCenter : XvCg̒S_̐ݒɎs܂B\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSpriteCount( long lTextureIndex=-1 )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//
//	[ ߂l ]
//		o^ĂXvCg̐
//
//	[  ]
//		w肳ꂽeNX`ɑ΂ēo^ꂽXvCg̐
//		Ԃ܂B
//		lTextureIndex  -1 w肵ꍇ́AeNX`Ɋ֌WȂ
//		o^ꂽXvCg̑Ԃ܂B
//--------------------------------------------------------------------
long CDGControlBody::GetSpriteCount( long lTextureIndex )
{
	// eNX`̃CfbNXw肳ꂽꍇ
	if( lTextureIndex!=-1 ){
		CDGTexture* pTexture;
		pTexture	= GetTexture( lTextureIndex );
		if( pTexture==NULL ){
			ErrorLog( "CDGControlBody::GetSpriteCount : eNX`IuWFNg擾ł܂łB\n" );
			return -1;
		}

		return pTexture->GetSpriteCount();
	}

	// eNX`̃CfbNXw肳Ȃꍇ
	long lCount;
	lCount	= m_objSprite.Length();
	return lCount;
}


//--------------------------------------------------------------------
//	[  ]
//		CDObjArray< CGStr > GetSpriteNameList()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̓o^̂̈ꗗi[z
//
//	[  ]
//		o^ĂXvCĝ̖zɊi[ĕԂ܂B
//--------------------------------------------------------------------
CDObjArray< CGStr > CDGControlBody::GetSpriteNameList()
{
	long i;
	CDObjArray< CGStr >	arySpriteNameList;

	// -----< ʂ̔z쐬 >-----
	//
	for( i=0;i<m_objSprite.Length();i++ ){
		CSprite* pSprite;
		pSprite	= m_objSprite[ i ];

		// NULL ͖
		if( pSprite==NULL ){ continue; }

		// ʂɒǉ
		CGStr strName;
		strName	= pSprite->GetIDName();
		arySpriteNameList.Add( strName );
	}

	// -----< ʂԂ >-----
	//
	return arySpriteNameList;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr GetSpriteName( long lIndex )
//
//	[  ]
//		long lIndex				o^CfbNX
//
//	[ ߂l ]
//		XvCg̓o^
//
//	[  ]
//		o^ĂXvCĝ̖Ԃ܂B
//--------------------------------------------------------------------
CGStr CDGControlBody::GetSpriteName( long lIndex )
{
	CGStr strName = "";

	// XvCg擾
	CSprite* pSprite;
	pSprite = GetSprite( lIndex );
	if( pSprite==NULL ){
		return strName;
	}

	// OԂ
	strName = pSprite->GetIDName();
	return strName;
}


//--------------------------------------------------------------------
//	[  ]
//		CSprite* GetSprite( long lIndex )
//
//	[  ]
//		long lIndex					XvCg̃CfbNXԍ
//
//	[ ߂l ]
//		XvCgIuWFNgւ̃|C^
//		G[̏ꍇ NULL
//
//	[  ]
//		CfbNXԍ lIndex ̃XvCg擾܂B
//--------------------------------------------------------------------
CSprite* CDGControlBody::GetSprite( long lIndex )
{
	// -----< `FbN >-----
	//
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::GetSprite : ̃CfbNXw肳܂B\n" );
		return NULL;
	}

	if( lIndex >= m_objSprite.Length() ){
		ErrorLog( "CDGControlBody::GetSprite : w肳ꂽCfbNXԍ傫܂B\n" );
		return NULL;
	}

	// -----< Ԃ >-----
	//
	return m_objSprite[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		CSprite* GetSprite( long lTextureIndex , long lSpriteIndex )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lSpriteIndex			eNX`̃XvCg̃CfbNXԍ
//
//	[ ߂l ]
//		XvCgIuWFNgւ̃|C^
//		G[̏ꍇ NULL
//
//	[  ]
//		eNX`ɓo^ꂽXvCg̃CfbNXԍp
//		XvCgIuWFNg擾܂B
//--------------------------------------------------------------------
CSprite* CDGControlBody::GetSprite( long lTextureIndex , long lSpriteIndex )
{
	// eNX`擾
	//
	CDGTexture* pTexture;
	pTexture = GetTexture( lTextureIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::GetSprite : eNX`擾ł܂łB\n" );
		return NULL;
	}

	// XvCg̃CfbNX擾
	//
	long lSPIndex;
	lSPIndex = pTexture->GetSpriteIndex( lSpriteIndex );
	if( lSPIndex==-1 ){
		ErrorLog( "CDGControlBody::GetSprite : XvCg̃CfbNXԍ擾ł܂łB\n" );
		return NULL;
	}

	// XvCg擾
	//
	CSprite* pSprite;
	pSprite = GetSprite( lSPIndex );
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::GetSprite : XvCg擾ł܂łB\n" );
		return NULL;
	}

	// Ԃ
	//
	return pSprite;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddGraphic(
//				  const char* pName
//				, long  lTextureIndex
//				, long* pIndexOnTexture=NULL )
//
//	[  ]
//		const char* pName			o^
//		long  lTextureIndex			eNX`̃CfbNXԍ
//		long* pIndexOnTexture		eNX`ł̃CfbNXԍ󂯎邽߂̃|C^
//
//	[ ߂l ]
//		OtBbNʂ̃CfbNXԍ
//
//	[  ]
//		OtBbNʂǉAOtBbNʂ
//		CfbNXԍԂ܂B
//--------------------------------------------------------------------
long CDGControlBody::AddGraphic(
			const char* pName , long lTextureIndex , long* pIndexOnTexture )
{
	// IuWFNg̍쐬
	//
	CGraphic* pGraphic;
	pGraphic = new CGraphic();
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::AddGraphic : OtBbNIuWFNg쐬ł܂łB\n" );
		return -1;
	}

	// eNX`擾
	//
	CDGTexture* pTexture;
	pTexture = GetTexture( lTextureIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::AddGraphic : eNX`擾ł܂łB\n" );
		delete pGraphic;
		return -1;
	}

	// OtBbN\z
	//
	BOOL bRes;
	bRes = pGraphic->Create( &m_sDeviceInfo , pTexture );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::AddGraphic : OtBbN\zł܂łB\n" );
		delete pGraphic;
		return -1;
	}

	// OtBbNǉ
	//
	long lIndex;
	DARRAY_SEARCHINDEX( m_objGraphic , lIndex );
	if( lIndex==-1 ){
		ErrorLog( "CDGControlBody::AddGraphic : OtBbNǉł܂łB\n" );
		delete pGraphic;
		return -1;
	}
	m_objGraphic[lIndex] = pGraphic;

	// eNX`ɑ΂āAOtBbNǉʒm
	//
	long lGRPIndex;
	lGRPIndex = pTexture->AddGraphicIndex( lIndex );
	if( lGRPIndex==-1 ){
		ErrorLog( "CDGControlBody::AddGraphic : eNX`IuWFNgɃOtBbÑCfbNXo^ł܂łB\n" );
		m_objGraphic.Remove( lIndex );		// ǉOtBbNLZ
		delete pGraphic;
		return -1;
	}

	// eNX`ł̃XvCg̃CfbNXԍԂ
	//
	if( pIndexOnTexture!=NULL ){
		*pIndexOnTexture = lGRPIndex;
	}

	// Oݒ
	bRes = pGraphic->SetIDName( pName );
	if( bRes==FALSE ){ return FALSE; }
	if( pName!=NULL ){
		m_hashGraphicIndex.AddObject( pName , lIndex );
	}

	// I
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveGraphic( long lGraphicIndex )
//		BOOL RemoveGraphic( long lTextureIndex , long lGraphicIndex )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lGraphicIndex			zOtBbÑCfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽzOtBbN폜܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::RemoveGraphic( long lGraphicIndex )
{
	// -----< mF >-----
	//
	if( lGraphicIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveGraphic : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lGraphicIndex>=m_objGraphic.Length() ){
		ErrorLog( "CDGControlBody::RemoveGraphic : w肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( m_objGraphic[ lGraphicIndex ]==NULL ){
		// 폜ς݂Ȃ̂ŁAŕԂ
		return TRUE;
	}

	// -----< eNX`ł̏폜 >-----
	//
	// <<< eNX`擾 >>>
	CGraphic* pGraphic;
	CDGTexture* pTexture;

	pGraphic = m_objGraphic[ lGraphicIndex ];
	pTexture = pGraphic->GetTexture();
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::RemoveGraphic : zOtBbNʃIuWFNgɃeNX`ݒ肳Ă܂B\n" );
		return FALSE;
	}

	// <<< eNX`ł̓o^폜 >>>
	pTexture->RemoveGRPIndex( lGraphicIndex );

	// O폜
	const char* pName = pGraphic->GetIDName();
	m_hashGraphicIndex.DeleteIfExist( pName );

	// -----< OtBbN폜 >-----
	//
	m_objGraphic[ lGraphicIndex ]->Release();
	delete m_objGraphic[ lGraphicIndex ];
	m_objGraphic[ lGraphicIndex ] = NULL;
	return TRUE;
}


BOOL CDGControlBody::RemoveGraphic( long lTextureIndex , long lGraphicIndex )
{
	BOOL bRes;

	// -----< mF >-----
	//
	if( lTextureIndex<0 ){
		ErrorLog( "CDGControlBody::RemoveGraphic : lTextureIndexɕ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lTextureIndex>=m_objTexture.Length() ){
		ErrorLog( "CDGControlBody::RemoveGraphic : lTextureIndexɎw肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( m_objTexture[ lTextureIndex ]==NULL ){
		ErrorLog( "CDGControlBody::RemoveGraphic : eNX`폜ς݂łB\n" );
		return FALSE;
	}

	// -----< ʂCfbNX擾 >-----
	//
	CDGTexture* pTexture;
	pTexture = m_objTexture[ lTextureIndex ];

	long lSerialGRPIndex;
	lSerialGRPIndex = pTexture->GetGraphicIndex( lGraphicIndex );
	if( lSerialGRPIndex==-1 ){
		ErrorLog( "CDGControlBody::RemoveGraphic : w肳ꂽXvCg܂łB\n" );
		return FALSE;
	}

	// -----< IuWFNg폜 >-----
	//
	bRes = RemoveGraphic( lSerialGRPIndex );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::RemoveGraphic : XvCg̍폜Ɏs܂B\n" );
		return FALSE;
	}
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetGraphicView( long lIndex , RECT& rRect );
//
//	[  ]
//		long  lIndex				OtBbNʂ̃CfbNXԍ
//		RECT& rRect					OtBbNʂ̃EBhE`
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbNʂ̃EBhE`ݒ肵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetGraphicView( long lIndex , RECT& rRect )
{
	// -----< OtBbNIuWFNg擾 >-----
	//
	CGraphic* pGraphic;
	pGraphic = GetGraphic( lIndex );
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::SetGraphicVie : OtBbN擾ł܂łB\n" );
		return FALSE;
	}

	// -----< OtBbNɋ`ݒ >-----
	//
	BOOL bRes;
	bRes = pGraphic->SetRect( rRect.left , rRect.top , rRect.right , rRect.bottom );
	if( bRes==FALSE ){
		ErrorLog( "CDGControlBody::SetGraphicRect : OtBbNɋ`ݒł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetGraphicLoopMode( long lIndex , BOOL bLoopX , BOOL bLoopY )
//
//	[  ]
//		long lIndex					OtBbÑCfbNXԍ
//		BOOL bLoopX					OtBbNw̌JԂ[h
//		BOOL bLoopY					OtBbNx̌JԂ[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbN`掞A摜̒[~WnƂ
//		舵ۂw肵܂B
//		FALSE w肷ƁA摜̒[zɂ͉`悳܂B
//		TRUE w肷ƁA摜̒[ƒ[q`ŖɌJԂ
//		`悳܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::SetGraphicLoopMode( long lIndex , BOOL bLoopX , BOOL bLoopY )
{
	BOOL bRes;

	// OtBbN擾
	CGraphic* pGraphic;
	pGraphic	= GetGraphic( lIndex );
	if( pGraphic==NULL )return FALSE;

	// ݒ
	bRes	= pGraphic->SetLoopMode( bLoopX , bLoopY );
	if( bRes==FALSE )return FALSE;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetGraphicCount( long lTextureIndex=-1 )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//
//	[ ߂l ]
//		o^ĂOtBbNʂ̐
//
//	[  ]
//		w肳ꂽeNX`ɑ΂ēo^ꂽOtBbN̐
//		Ԃ܂B
//		lTextureIndex  -1 w肵ꍇ́AeNX`Ɋ֌WȂ
//		o^ꂽOtBbN̑Ԃ܂B
//--------------------------------------------------------------------
long CDGControlBody::GetGraphicCount( long lTextureIndex )
{
	// eNX`̃CfbNXw肳ꂽꍇ
	if( lTextureIndex!=-1 ){
		CDGTexture* pTexture;
		pTexture	= GetTexture( lTextureIndex );
		if( pTexture==NULL ){
			ErrorLog( "CDGControlBody::GetGraphicCount : eNX`IuWFNg擾ł܂łB\n" );
			return -1;
		}

		return pTexture->GetGraphicCount();
	}

	// eNX`̃CfbNXw肳Ȃꍇ
	long lCount;
	lCount	= m_objGraphic.Length();
	return lCount;
}


//--------------------------------------------------------------------
//	[  ]
//		CGraphic* GetGraphic( long lIndex )
//
//	[  ]
//		long lIndex					OtBbNʂ̒ʂCfbNXԍ
//
//	[ ߂l ]
//		OtBbNʃIuWFNgւ̃|C^
//
//	[  ]
//		OtBbNʃIuWFNgԂ܂B
//--------------------------------------------------------------------
CGraphic* CDGControlBody::GetGraphic( long lIndex )
{
	// -----< `FbN >-----
	//
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::GetGraphic : ̃CfbNXw肳܂B\n" );
		return NULL;
	}

	if( lIndex >= m_objGraphic.Length() ){
		ErrorLog( "CDGControlBody::GetGraphic : w肳ꂽCfbNXԍ傫܂B\n" );
		return NULL;
	}

	// -----< Ԃ >-----
	//
	return m_objGraphic[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		CGraphic* GetGraphic( long lTextureIndex , long lGraphicIndex )
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lGraphicIndex			eNX`̃OtBbNʂ̃CfbNXԍ
//
//	[ ߂l ]
//		OtBbNʃIuWFNgւ̃|C^
//
//	[  ]
//		OtBbNʃIuWFNgԂ܂B
//--------------------------------------------------------------------
CGraphic* CDGControlBody::GetGraphic( long lTextureIndex , long lGraphicIndex )
{
	// eNX`擾
	//
	CDGTexture* pTexture;
	pTexture = GetTexture( lTextureIndex );
	if( pTexture==NULL ){
		ErrorLog( "CDGControlBody::GetGraphic : eNX`擾ł܂łB\n" );
		return NULL;
	}

	// OtBbÑCfbNX擾
	//
	long lGRPIndex;
	lGRPIndex = pTexture->GetGraphicIndex( lGraphicIndex );
	if( lGRPIndex==-1 ){
		ErrorLog( "CDGControlBody::GetGraphic : OtBbNʂ̃CfbNXԍ擾ł܂łB\n" );
		return NULL;
	}

	// OtBbN擾
	//
	CGraphic* pGraphic;
	pGraphic = GetGraphic( lGRPIndex );
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::GetGraphic : OtBbN擾ł܂łB\n" );
		return NULL;
	}

	// Ԃ
	//
	return pGraphic;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawSprite(  long lIndex
//						, long lX , long lY
//						, DWORD dwDiffuse = 0xFFFFFFFF
//						, float fZ = 0.0 )
//
//	[  ]
//		long lIndex					`悷XvCg̃CfbNXԍ
//		long lX						`wW
//		long lY						`xW
//		DWORD dwDiffuse				fBt[YF
//		float fZ					XvCĝyW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCg`悵܂B
//		gC]ݒ肵܂B
//		gC]ݒ肷̂AyȂ܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawSprite( long lIndex , long lX , long lY , BOOL bRevX, BOOL bRevY, DWORD dwDiffuse , float fZ )
{
	// XvCg擾
	//
	CSprite* pSprite;
	pSprite = GetSprite( lIndex );
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::DrawSprite : XvCgIuWFNg擾ł܂łB\n" );
		return FALSE;
	}

	// `
	//
	BOOL bRes;
	bRes = pSprite->DrawRev( &m_sDeviceInfo , lX , lY , bRevX, bRevY, dwDiffuse , fZ );

	// `I
	//
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawSprite(  long lTextureIndex , long lSpriteIndex
//						, long lX , long lY
//						, DWORD dwDiffuse = 0xFFFFFFFF
//						, float fZ=0.0
//						)
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lSpriteIndex			eNX`ɓo^ꂽXvCg̃CfbNXԍ
//		long lX						`wW
//		long lY						`xW
//		DWORD dwDiffuse				fBt[YF̐ݒ
//		float fZ					XvCĝyW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		eNX`ɓo^ĂXvCgCfbNXԍp
//		XvCgIA`悵܂B
//		gC]ݒ肵܂B
//		gC]ݒ肷̂AyȂ܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawSprite( long lTextureIndex , long lSpriteIndex
							, long lX , long lY , BOOL bRevX, BOOL bRevY, DWORD dwDiffuse , float fZ )
{
	// XvCg擾
	//
	CSprite* pSprite;
	pSprite = GetSprite( lTextureIndex , lSpriteIndex );
	if( pSprite==NULL ){
		ErrorLog( "CDGControlBody::DrawSprite : XvCg擾ł܂łB\n" );
		return FALSE;
	}

	// `
	//
	return pSprite->DrawRev( &m_sDeviceInfo , lX , lY , bRevX, bRevY, dwDiffuse , fZ );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawGraphic( long lIndex
//						, long lViewX , long lViewY
//						, float fZ = 0.0f , DWORD dwDiffuse=0xFFFFFFFF
//						)
//
//	[  ]
//		long lIndex					OtBbNʂ̒ʂCfbNXԍ
//		long lViewX					OtBbNʂ̃r[|CgwW
//		long lViewY					OtBbNʂ̃r[|CgxW
//		DWORD dwDiffuse= 0xFFFFFFFF	fBt[YF
//		float fZ = 0.0				OtBbNʂ̂yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbNʂ`悵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawGraphic( long lIndex
								, long lViewX , long lViewY
								, DWORD dwDiffuse
								, float fZ
								)
{
	// OtBbN擾
	//
	CGraphic* pGraphic;
	pGraphic = GetGraphic( lIndex );
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::DrawGraphic : OtBbNIuWFNg擾ł܂łB\n" );
		return FALSE;
	}

	// `
	//
	BOOL bRes;
	bRes = pGraphic->Draw( &m_sDeviceInfo , lViewX , lViewY , dwDiffuse , fZ );

	// `I
	//
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawGraphic( long lTextureIndex , long lGraphicIndex
//						, long lViewX , long lViewY
//						, DWORD dwDiffuse = 0xFFFFFFFF
//						, float fZ = 0.0f
//						)
//
//	[  ]
//		long lTextureIndex			eNX`̃CfbNXԍ
//		long lGraphicIndex			OtBbNʂ̃eNX`̃CfbNXԍ
//		long lViewX					r[|CĝwW
//		long lViewY					r[|CĝxW
//		float fZ = 0.0f				`悷yW
//		DWORD dwDiffuse=0xFFFFFFFF	fBt[YF
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbNʂ`悵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawGraphic( long lTextureIndex , long lGraphicIndex
								, long lViewX , long lViewY
								, DWORD dwDiffuse
								, float fZ
								)
{
	// OtBbN擾
	//
	CGraphic* pGraphic;
	pGraphic = GetGraphic( lTextureIndex , lGraphicIndex );
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::DrawGraphic : OtBbN擾ł܂łB\n" );
		return FALSE;
	}

	// `
	//
	return pGraphic->Draw( &m_sDeviceInfo , lViewX,lViewY , dwDiffuse , fZ );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawScaledGraphic( long lIndex
//						, long lViewX , long lViewY
//						, float fZ = 0.0f , DWORD dwDiffuse=0xFFFFFFFF
//						)
//
//	[  ]
//		long lIndex					OtBbNʂ̒ʂCfbNXԍ
//		long lViewX					OtBbNʂ̃r[|CgwW
//		long lViewY					OtBbNʂ̃r[|CgxW
//		long fScalingX				wXP[O
//		long fScalingY				xXP[O
//		DWORD dwDiffuse= 0xFFFFFFFF	fBt[YF
//		float fZ = 0.0				OtBbNʂ̂yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OtBbNʂ`悵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawScaledGraphic( long lIndex
								, long lViewX , long lViewY
								, FLOAT fScalingX , FLOAT fScalingY
								, DWORD dwDiffuse
								, float fZ
								)
{
	// OtBbN擾
	//
	CGraphic* pGraphic;
	pGraphic = GetGraphic( lIndex );
	if( pGraphic==NULL ){
		ErrorLog( "CDGControlBody::DrawGraphicStretch : OtBbNIuWFNg擾ł܂łB\n" );
		return FALSE;
	}

	// `
	//
	BOOL bRes;
	bRes = pGraphic->ScaledDraw( &m_sDeviceInfo , lViewX , lViewY , fScalingX , fScalingY , dwDiffuse , fZ );

	// `I
	//
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DrawRenderTargetTexture( long lIndex , int iAlpha )
//
//	[  ]
//		long lIndex					`IuWFNg̃CfbNXԍ
//		long lDrawWidth				`敝
//		long lDrawHeight			`捂
//		int iAlpha					`掞̃l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`eNX`̓eAWϊȂŕ`悵܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::DrawRenderTargetTexture( long lIndex , long lTgtX, long lTgtY, long lDrawWidth , long lDrawHeight )
{
	int iRes;

	// <<< mF >>>
	if( lIndex<0 ){
		ErrorLog( "CDGControlBody::DrawRenderTargetTexture : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lIndex >= m_objRenderTarget.Length() ){
		ErrorLog( "CDGControlBody::DrawRenderTargetTexture : w肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}

	// <<< IuWFNg擾 >>>
	CDGRenderTarget* pRenderTarget;
	pRenderTarget = m_objRenderTarget[lIndex];
	if( pRenderTarget==NULL ){
		ErrorLog( "CDGControlBody::DrawRenderTargetTexture : CDGRenderTarget Ƃ NULL Ԃ܂B\n" );
		return FALSE;
	}

	// <<< `w >>>
	iRes = DrawExtendGraph(lTgtX, lTgtY, lTgtX + lDrawWidth,lTgtY + lDrawHeight, pRenderTarget->GetGHandle(), TRUE);
	if (iRes != 0) {
		ErrorLog("CDGControlBody::DrawRenderTargetTexture : `Ɏs܂B\n");
		return FALSE;
	}


	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Clear()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		obNobt@̓eNA܂B
//--------------------------------------------------------------------
BOOL CDGControlBody::Clear()
{
	int iRes;
	// -----< R}hs >-----
	//
	iRes = ClearDrawScreen();
	if (iRes == -1) {
		ErrorLog("CDGControlBody::Clear : NAɎs܂B\n");
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Flip()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		obNobt@tgobt@։摜]
//--------------------------------------------------------------------
BOOL CDGControlBody::Flip()
{
	int iRes;

	// -----< R}hs >-----
	//
	iRes = ScreenFlip();
	if (iRes != 0) {
		DebugLog("CDGControlBody::Flip : tbvɎs܂BCode=%d\n", iRes);
	}

	// tbvAɂȂăNA
	//
	iRes = ClearDrawScreen();
	if (iRes != 0) {
		DebugLog("CDGControlBody::Flip : ʃNAɎs܂BCode=%d\n", iRes);
	}
	return TRUE;
}
