//====================================================================
//  DirectGraphics Control
//====================================================================
#ifndef __DGCONTROL_H__
#define __DGCONTROL_H__

#include "DGDXInclude.h"			// DirectXnCN[h

#include "Utils.h"
#include "DeviceInfo.h"

class CDGControl : public CUtils{
	// -----< f[^o >-----
	//
	private:
		static BOOL			s_bCreated;						// 쐬ꂽۂ
		static CDGControl*	s_pInstance;					// CX^Xւ̃|C^

	// -----< \z >-----
	//
	public:
		CDGControl();
		virtual ~CDGControl();

	public:
		static CDGControl*	GetInstance();					// CX^X쐬
		static void			DeleteInstance();				// CX^X폜

	// -----< \bh >-----
	//
	// <<< \z^^j >>>
	public:
		virtual BOOL Initialize(									// 
				  BOOL bFullScreen
				, int iWidth , int iHeight, int iFreq
		)		= 0;
		virtual BOOL InitializeForAttach(
				  int iWidth , int iHeight, int iFreq
				) = 0;

		virtual const SDeviceInfo* GetDeviceInfo() = 0;	// foCXԂ
		virtual long GetBackBufferWidth()	= 0;		// obNobt@̃TCYԂ
		virtual long GetBackBufferHeight()	= 0;		// obNobt@̃TCYԂ

		virtual void ReleaseItems()						= 0;		// foCXȊO
		virtual void ReleaseRenderTarget()				= 0;		// RenderTarget Sĉ
		virtual void Release()							= 0;		// IuWFNg̓ej
		virtual BOOL Reset()							= 0;		// foCXXg畜A

	// <<< CfbNX擾 >>>
	public:
		virtual long GetTextureIndex(      const char* pName ) = 0;			// eNX`IuWFNg
		virtual long GetSpriteIndex(       const char* pName ) = 0;			// XvCgIuWFNg
		virtual long GetGraphicIndex(      const char* pName ) = 0;			// OtBbNʃIuWFNg
		virtual long GetRenderTargetIndex( const char* pName ) = 0;			// `IuWFNg

	// <<< RenderTarget֘A >>>
	public:
		virtual long	AddRenderTargetTexture( const char* pName , long lWidth , long lHeight ) = 0;	// `T[tFXǉ
		virtual BOOL	SetRenderTarget( long lIndex ) = 0;		// `ݒ肷
		virtual BOOL	SetRenderTargetAsBackBuffer() = 0;		// `obNobt@ɐݒ肵܂B
		virtual BOOL	RemoveRenderTarget( long lIndex ) = 0;	// `폜
		virtual long	GetCurrentRenderTarget() = 0;			// ݑI𒆂RenderTarget̃CfbNXԂ

	// <<< eNX`֘A >>>
	public:
		virtual long	AddTexture( const char* pName					// eNX`ǉiʁj
							, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )=0;

		virtual long	AddTextureForSprite( const char* pName			// eNX`ǉiXvCgpj
							, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )=0;

		virtual long	AddTextureForGraphic( const char* pName			// eNX`ǉiOtBbNpj
							, const char* pFileName , D3DCOLOR dwColorKey , BOOL bPreLoad )=0;

		virtual BOOL	RemoveTexture( long lIndex ) = 0;				// eNX`폜
		virtual long	GetTextureCount() = 0;
		virtual long	GetTextureWidth( long lIndex ) = 0;				// eNX`̕擾
		virtual long	GetTextureHeight( long lIndex ) = 0;			// eNX`̍擾

	// <<< XvCg >>>
	public:
		virtual long	AddSprite(								// XvCgǉ
						  const char* pName
						, long  lTextureIndex
						, long* pIndexOnTexture=NULL ) = 0;
		virtual BOOL	RemoveSprite( long lSpriteIndex ) = 0;
		virtual BOOL	RemoveSprite( long lTextureIndex , long lSpriteIndex ) = 0;
		virtual BOOL	SetSpriteRect(							// XvCgƂĎgp`w肷
							long lIndex , RECT& rRect )	= 0;
		virtual BOOL	SetSpriteRect(
							long lIndex , long lLeft,long lTop,long lRight,long lBottom ) = 0;
		virtual BOOL	SetSpriteCenter(						// XvCg̒S_ݒ肷
							long lIndex , long lX , long lY ) = 0;
		virtual long	GetSpriteCount( long lTextureIndex=-1 ) = 0;	// o^ĂXvCg̐Ԃ
		virtual CDObjArray< CGStr > GetSpriteNameList() = 0;			// o^ĂXvCg̖̈ꗗԂ
		virtual CGStr	GetSpriteName( long lIndex ) = 0;				// XvCĝ̖Ԃ

	// <<< OtBbN >>>
	public:
		virtual long	AddGraphic(								// OtBbNǉ
						  const char* pName
						, long  lTextureIndex
						, long* pIndexOnTexture = NULL ) = 0;
		virtual BOOL	RemoveGraphic( long lGraphicIndex ) = 0;
		virtual BOOL	RemoveGraphic( long lTextureIndex , long lGraphicIndex ) = 0;
		virtual BOOL	SetGraphicView(							// OtBbÑr[EBhEݒ
							long lIndex , RECT& rRect ) = 0;
																// OtBbŇJԂ`惂[hݒ
		virtual BOOL	SetGraphicLoopMode( long lIndex , BOOL bLoopX , BOOL bLoopY ) = 0;
		virtual long	GetGraphicCount( long lTextureIndex=-1 ) = 0;	// o^ĂOtBbN̐Ԃ

	// <<< `揈 >>>
	public:
		virtual BOOL	DrawSprite(									// XvCg`
							  long lIndex
							, long lX , long lY
							, BOOL bRevX, BOOL bRevY
							, DWORD dwDiffuse
							, float fZ
							) = 0;
		virtual BOOL	DrawSprite(									// XvCg`iCfbNXoneNX`gp)
							  long lTextureIndex , long lSpriteIndex
							, long lX , long lY
							, BOOL bRevX, BOOL bRevY
							, DWORD dwDiffuse
							, float fZ
							) = 0;

		virtual BOOL	DrawGraphic(								// OtBbN`
							  long lIndex
							, long lViewX , long lViewY
							, DWORD dwDiffuse
							, float fZ
							) = 0;
		virtual BOOL	DrawGraphic(								// OtBbN`iCfbNXoneNX`gpj
							  long lTextureIndex , long lGraphicIndex
							, long lViewX , long lViewY
							, DWORD dwDiffuse
							, float fZ
							) = 0;

		virtual BOOL	DrawScaledGraphic(							// XP[Oꂽ摜găOtBbN`
							  long lIndex
							, long lViewX , long lViewY
							, FLOAT fScalingX , FLOAT fScalingY
							, DWORD dwDiffuse
							, float fZ
							) = 0;

		virtual BOOL	DrawRenderTargetTexture( long lIndex , long lTgtX, long lTgtY , long lDrawWidth , long lDrawHeight ) = 0;

		virtual BOOL	Clear()							= 0;		// obNobt@NA
		virtual BOOL	Flip()							= 0;		// _uobt@؂ւ
};

#endif
