//====================================================================
//  QcIuWFNgNX 
//====================================================================
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "DGDXInclude.h"
#include "DGControl.h"

#include "DeviceInfo.h"
#include "2DObject.h"


//--------------------------------------------------------------------
//	[  ]
//		C2DObject();
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
C2DObject::C2DObject()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		C2DObject( C2DObject& r2DObject )
//
//	[  ]
//		C2DObject& r2DObject			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
C2DObject::C2DObject( C2DObject& r2DObject )
: CUtils( r2DObject )
{
	SetDefault();
	CopyMembers( r2DObject );
}


//--------------------------------------------------------------------
//	[  ]
//		~C2DObject()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
C2DObject::~C2DObject()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
void C2DObject::SetDefault()
{
	m_pTexture	= NULL;

	memset( &m_sRect   , 0 , sizeof( RECT  ) );
	memset( &m_sCenter , 0 , sizeof( POINT ) );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( C2DObject& r2DObject )
//
//	[  ]
//		C2DObject& r2DObject			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL C2DObject::CopyMembers( C2DObject& r2DObject )
{
	// ܂
	Release();

	// 
	m_pTexture	= r2DObject.m_pTexture;

	m_sRect		= r2DObject.m_sRect;
	m_sCenter	= r2DObject.m_sCenter;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejAԂɖ߂܂B
//--------------------------------------------------------------------
void C2DObject::Release()
{
	m_pTexture	= NULL;

	memset( &m_sRect   , 0 , sizeof( RECT  ) );
	memset( &m_sCenter , 0 , sizeof( POINT ) );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Create( SDeviceInfo* pDevice , CDGTexture* pTexture )
//
//	[  ]
//		SDeviceInfo*		pDevice		foCX\̂ւ̃|C^
//		CDGTexture*			pTexture	eNX`IuWFNgւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		gpfoCXƃeNX`w肵A
//		XvCgC^[tFCX쐬܂B
//--------------------------------------------------------------------
BOOL C2DObject::Create( SDeviceInfo* pDeviceInfo , CDGTexture* pTexture )
{
	// eNX`ۑ
	//
	m_pTexture	= pTexture;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetRect( long lLeft , long lTop , long lRight , long lBottom )
//
//	[  ]
//		long lLeft					[W
//		long lTop					[W
//		long lRight					E[W
//		long lBottom				[W
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		QcIuWFNgƂĒ``̈ݒ肵܂B
//--------------------------------------------------------------------
BOOL C2DObject::SetRect( long lLeft , long lTop , long lRight , long lBottom )
{
	m_sRect.top		= lTop;
	m_sRect.left	= lLeft;
	m_sRect.right	= lRight;
	m_sRect.bottom	= lBottom;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		RECT* GetRect()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		eNX`Ƃĕ\`̈
//
//	[  ]
//		eNX`ƂĎgp`̈Ԃ܂B
//--------------------------------------------------------------------
RECT* C2DObject::GetRect()
{
	return &m_sRect;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetCenter( long lX , long lY )
//
//	[  ]
//		long lX						S_̂wW
//		long lY						S_̂xW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		S_ݒ肵܂B
//--------------------------------------------------------------------
BOOL C2DObject::SetCenter( long lX , long lY )
{
	m_sCenter.x	= lX;
	m_sCenter.y	= lY;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		POINT* GetCenter()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		S_xNgێ POINT \̂ւ̃|C^
//
//	[  ]
//		S_xNg擾܂B
//--------------------------------------------------------------------
POINT* C2DObject::GetCenter()
{
	return &m_sCenter;
}


//--------------------------------------------------------------------
//	[  ]
//		CDGTexture* GetTexture()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		eNX`ւ̃|C^
//
//	[  ]
//		eNX`IuWFNgւ̃|C^
//--------------------------------------------------------------------
CDGTexture* C2DObject::GetTexture()
{
	return m_pTexture;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Draw(
//					  SDeviceInfo* pDeviceInfo
//					, long lX1 , long lY1 , long lX2 , long lY2
//					, long lTgtX , long lTgtY
//					, DWORD dwDiffuse = 0xFFFFFFFF , float fZ = 0.0f )
//
//	[  ]
//		SDeviceInfo*	pDeviceInfo	foCX\̂ւ̃|C^
//		long			lX1  ,lY1	`ƍW
//		long			lX2  ,lY2	`ƉEW
//		long			lTgtX,lTgtY	`捶W
//		BOOL			bRevX, bRevY	]
//		DWORD			dwDiffuse	fBt[YF
//		float			fZ			`掞̂yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		摜`悵܂B
//		gC]̏s܂B
//		gC]̏ŝ葽ɂȂ܂B
//		̊֐ł́Am_sRect p܂Bm_sRect ́Ap
//		NXŎgp܂B
//--------------------------------------------------------------------
BOOL C2DObject::DrawRev(
	SDeviceInfo* pDeviceInfo
	, long lX1, long lY1, long lX2, long lY2
	, long lTgtX, long lTgtY
	, BOOL bRevX, BOOL bRevY
	, DWORD dwDiffuse
	, float fZ
)
{
	int iRes;

	// ؂o͈͂肷
	long x1 = min(lX1, lX2);
	long y1 = min(lY1, lY2);
	long x2 = max(lX1, lX2);
	long y2 = max(lY1, lY2);
	long width = (x2 - x1) + 1;
	long height = (y2 - y1) + 1;

	// `肷iSʒu␳tj
	long pX, pY;
	pX = lTgtX - m_sCenter.x;
	pY = lTgtY - m_sCenter.y;

	// <<< ` >>>
	//
	iRes = DrawRectGraph(pX, pY, x1, y1, width, height, m_pTexture->GetGHandle(), TRUE, bRevX, bRevY);
	if (iRes != 0) {
		ErrorLog("C2DObject::Draw : v~eBu̕`Ɏs܂B\n");
		ErrorLog("C2DObject::Draw : Ή悤Ȃ̂ŁÂ܂܏𑱍s܂B\n");
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		C2DObject& operator=( C2DObject& r2DObject )
//
//	[  ]
//		C2DObject& r2DObject			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
C2DObject& C2DObject::operator=( C2DObject& r2DObject )
{
	BOOL bRes;
	bRes = CopyMembers( r2DObject );
	if( bRes==FALSE ){
		ErrorLog( "C2DObject::operator= : IuWFNg̓eɎs܂B\n" );
	}

	return *this;
}
