//----------------------------------------------------------
//  Array + Hash ̃ev[gNX
//----------------------------------------------------------
#ifndef __DARRAYHASH_H__
#define __DARRAYHASH_H__

#include "Str.h"
#include "DArray.h"
#include "DStringArray.h"
#include "Hash.h"

//----------------------------------------------------------
//  NX`
//----------------------------------------------------------
template <class T> class CDArrayHash
{
	// -----< \z >-----
	//
	public:
		CDArrayHash( long lUnit=DARRAY_DEFAULT_UNIT_SIZE );		// RXgN^
		CDArrayHash( CDArrayHash& rArray );							// Rs[RXgN^
		virtual ~CDArrayHash();									// fXgN^

	private:
		BOOL	SetDefault();						// RXgN^xł̃ftHgݒ
		BOOL	CopyMembers( CDArrayHash& rArray );		// IuWFNg̓e𕡐


	// -----< f[^o >-----
	//
	private:
		CDArray<T>		m_aryData;					// f[^̓e
		CDStringArray	m_aryName;					// CfbNXɑΉ閼
		CGHash< long >	m_hashIndex;				// CfbNXԍ̖OpHash


	// ---< \bh >---
	//
	public:
		// <<<  >>>
		//
		void	Release();							// 
		void	Release( long lRemain );			// iRemaincĉ
		void	Initialize( long lUnit=DARRAY_DEFAULT_UNIT_SIZE );	// 
		void	Clear();							// ͉Ao^eNA

		// <<< ǉ >>>
		//
		long	Add();								// vf̒ǉivf̃Rs[Ȃj
		long	Add( T rElem );						// vfǉiRs[j
		long	Add( const char* pName , T rElem );	// ̂Ēlǉ

		// <<< XV >>>
		//
		BOOL	Set( long lIndex , T& rElem );			// l̍XV
		BOOL	SetByName( const char* pName , T& rElem );	// l̍XV

		// <<< 폜 >>>
		//
		BOOL	Remove( long lIndex );			// vf폜ċl
		BOOL	RemoveByName( const char* pName );	// OwŁAvf폜ċl߂

		// <<< u >>>
		//
		BOOL	Replace( long lIndex1 , long lIndex2 );	// vf̏ւ
		BOOL	ReplaceByName( const char* pName1 , const char* pName2 );	// vf̏ւ

		// <<< Q >>>
		//
		T&		operator[]( long lIndex );			// z̗vfo
		T		GetValue( long lIndex );			// l̃Rs[o
		T		GetValueByName( const char* pName );		// ̂Al̃Rs[o
		long	Length();							// o^̎擾
		long	GetExtendUnit();					// gPʎ擾

		// <<< O̎舵 >>>
		BOOL		SetName( long lIndex , const char* pName );	// Oݒ肷
		const char*	GetName( long lIndex );			// wCfbNX̖̂Ԃ
		long		GetIndex( const char* pName );	// w肳ꂽOɑΉCfbNXԂ
		CDObjArray< CGStr > GetKeys();				// L[ꗗԂ

		// <<< ̑ >>>
		//
		CDArrayHash& operator=( CDArrayHash& rArray );	// Zq

	// -----<  >-----
	//
	private:
		long	AddName( const char* pName );	// Oǉ
};



//----------------------------------------------------------
//  ev[g`
//----------------------------------------------------------
//--------------------------------------------------------------------
//	[  ]
//		CDArrayHash( long lUnit = DARRAY_DEFAULT_UNIT_SIZE );
//
//	[  ]
//		long lUnit					z̊gP
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
template<class T>
CDArrayHash< T >::CDArrayHash( long lUnit )
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CDArrayHash( CDArrayHash& rArray )
//
//	[  ]
//		CDArrayHash& rArray				ւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template<class T>
CDArrayHash< T >::CDArrayHash( CDArrayHash& rArray )
{
	SetDefault();
	CopyMembers( rArray );
}


//--------------------------------------------------------------------
//	[  ]
//		~CDArrayHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template <class T>
CDArrayHash< T >::~CDArrayHash()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void Initialize( long lUnit=DARRAY_DEFAULT_UNIT_SIZE )
//
//	[  ]
//		long lUnit = DARRAY_DEFAULT_UNIT_SIZE
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		f[^AǉPʐύX܂B
//--------------------------------------------------------------------
template <class T>
void CDArrayHash< T >::Initialize( long lUnit )
{
	Release();

	// z̏
	m_aryData.Initialize( lUnit );

	// Ȍ
	m_aryName.Release();
	m_hashIndex.Initialize();
}


//--------------------------------------------------------------------
//	[  ]
//		void Clear()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		z̓o^Oɂ܂B
//		Ao^_IɂOɂ܂B
//		svȃ͉܂񂪁Aɏ܂B
//--------------------------------------------------------------------
template <class T>
void CDArrayHash< T >::Clear()
{
	// ȅNA
	m_aryData.Clear();

	// ̂NA
	m_aryName.Clear();

	// CfbNXԍ Hash ̓eNA
	m_hashIndex.Initialize();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
template <class T>
BOOL CDArrayHash< T >::SetDefault()
{
	// z̏lݒ肷
	m_aryData.Initialize();

	// ̔z̏lݒ肷
	m_aryName.Release();

	// Hash ̏lݒ肷
	m_hashIndex.Initialize();

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CDArrayHash& rArray )
//
//	[  ]
//		CDArrayHash& rArray			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐
//--------------------------------------------------------------------
template <class T>
BOOL CDArrayHash< T >::CopyMembers( CDArrayHash& rArray )
{
	// z̏𕡐
	m_aryData = rArray.m_aryData;

	// ̂𕡐
	m_aryName	= rArray.m_aryName;

	// Hash ̓e𕡐
	m_hashIndex	= rArray.m_hashIndex;

	// ʂԂ
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ej
//--------------------------------------------------------------------
template <class T>
void CDArrayHash< T >::Release()
{
	// f[^̓e
	m_aryData.Release();

	// ̂̓e
	m_aryName.Release();

	// Hash ̓e
	m_hashIndex.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void Release( long lRemain )
//
//	[  ]
//		long lRemain				cvf
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lRemain ̗vfcAȍ~̗̈J܂B
//		̉K؂ɍs܂B
//--------------------------------------------------------------------
template <class T>
void CDArrayHash< T >::Release( long lRemain )
{
	long i;

	// <<< 폜Ώۂ̖̈ꗗ쐬 >>>
	CDStringArray aryNames;
//	aryNames.Initialize();
	for( i=lRemain;i<m_aryName.Length();i++ ){
		aryNames.Add( m_aryName[ i ] );
	}

	// <<< 폜Ώۂ̖Op폜 >>>
	for( i=0;i<aryNames.Length();i++ ){
		m_hashIndex.Remove( aryNames[ i ] );
	}

	// <<< ̂̔zRelease >>>
	m_aryName.Release( lRemain );

	// <<< zRelease >>>
	m_aryData.Release( lRemain );

	// <<< I >>>
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		vfǉ܂B
//		z̗̈ĝ݂Ȃ̂ŁAgꂽ̈ɓĂ
//		l͕slƂȂ܂B
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::Add()
{
	// <<< IuWFNg𐶐 >>>
	T objData;

	// <<< ǉ >>>
	long lIndex;
	lIndex = Add( "" , objData );
	if( lIndex==-1 ){
		return -1;
	}

	// <<< I >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( T rElem )
//
//	[  ]
//		T rElem						ǉvf
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		zɗvfǉ܂B
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::Add( T rElem )
{
	// <<< zɗvfǉ >>>
	long lIndex;
	lIndex = Add( "" , rElem );
	if( lIndex==-1 ){
		return -1;
	}

	// <<< I >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( const char* pName , T rElem )
//
//	[  ]
//		const char* pName			ݒ肷閼
//		T rElem						ǉvf
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		zɗvfǉ܂B
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::Add( const char* pName , T rElem )
{
	// <<< lݒ肷 >>>
	long lIndex;
	lIndex = m_aryData.Add( rElem );
	if( lIndex==-1 ){
		return -1;
	}

	// <<< Op̏ݒ肷 >>>
	long lNameIndex;
	lNameIndex = AddName( pName );
	if( lNameIndex==-1 ){
		// OݒɎs
		m_aryData.Remove( lIndex );
		return -1;
	}

	// <<< I >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Set( long lIndex , T& rElem );
//
//	[  ]
//		long lIndex					CfbNXԍ
//		T&   rElem					l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lXV܂B
//		sȃCfbNXw肳ꂽꍇ̓G[Ԃ
//		ɏI܂B
//--------------------------------------------------------------------
template< class T >
BOOL CDArrayHash< T >::Set( long lIndex , T& rElem )
{
	BOOL bRes;

	// <<< lݒ肷 >>>
	bRes = m_aryData.Set( lIndex , rElem );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetByName( const char* pName , T& rElem );
//
//	[  ]
//		const char* pName			CfbNXɊ֘AÂꂽ
//		T&   rElem					l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lXV܂B
//		sȖ̂w肳ꂽꍇ̓G[Ԃ
//		ɏI܂B
//--------------------------------------------------------------------
template< class T >
BOOL CDArrayHash< T >::SetByName( const char* pName , T& rElem )
{
	BOOL bRes;

	// <<< ̂CfbNXɕϊ >>>
	long lIndex;
	lIndex = GetIndex( pName );
	if( lIndex==-1 ){
		// o^Ȃꍇ́AG[ŕԂ
		return FALSE;
	}

	// <<< ubW >>>
	bRes = Set( lIndex , rElem );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Remove( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z̗vf폜AeOɋl߂܂B
//		vf̐͂P܂B
//		̈̊J͍s܂B𔺂
//		ꍇ́ARelease( long lRemain ) gp܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArrayHash< T >::Remove( long lIndex )
{
	BOOL bRes;

	// <<< mF >>>
	if( lIndex >= m_aryData.Length() ){
		// CfbNX傫
		return FALSE;
	}
	if( lIndex<0 ){
		// CfbNX
		return FALSE;
	}

	// <<< Op̏폜 >>>
	// ̐ݒ肪ꍇAHash폜
	const char* pName = m_aryName[ lIndex ];
	bRes = m_hashIndex.DeleteIfExist( pName );
	if( bRes==FALSE ){
		return FALSE;
	}

	// ̂폜
	bRes = m_aryName.Remove( lIndex );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< z̓e폜 >>>
	bRes = m_aryData.Remove( lIndex );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL RemoveByName( const char* pName )
//
//	[  ]
//		const char* pName			CfbNXɑΉÂꂽ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z̗vf폜AeOɋl߂܂B
//		vf̐͂P܂B
//		̈̊J͍s܂B𔺂
//		ꍇ́ARelease( long lRemain ) gp܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArrayHash< T >::RemoveByName( const char* pName )
{
	BOOL bRes;

	// <<< CfbNX擾 >>>
	long lIndex;
	lIndex = GetIndex( pName );
	if( lIndex==-1 ){
		// o^ꍇ́AG[ŕԂ
		return FALSE;
	}

	// <<< ubW >>>
	bRes = Remove( lIndex );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Replace( long lIndex1 , long lIndex2 )
//
//	[  ]
//		long lIndex1				ւΏۂ̃CfbNXԍ
//		long lIndex2				ւΏۂ̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		wCfbNX̗vfւ܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArrayHash< T >::Replace( long lIndex1 , long lIndex2 )
{
	BOOL bRes;

	// <<< mF >>>
	if( lIndex1 >= m_aryName.Length() ){
		// w肳ꂽCfbNX傫
		return FALSE;
	}
	if( lIndex2 >= m_aryName.Length() ){
		// w肳ꂽCfbNX傫
		return FALSE;
	}

	if( lIndex1<0 ){
		// ̃CfbNXw肳ꂽ
		return FALSE;
	}
	if( lIndex2<0 ){
		// ̃CfbNXw肳ꂽ
		return FALSE;
	}

	// <<< z̓eւ >>>
	bRes = m_aryData.Replace( lIndex1 , lIndex2 );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< Op̏擾 >>>
	const char* pName1 = m_aryName[ lIndex1 ];
	const char* pName2 = m_aryName[ lIndex2 ];

	// <<< ̂̏ւ >>>
	m_aryName.Replace( lIndex1 , lIndex2 );

	// <<< Hash̏ւ >>>
	if( pName1!=NULL ){
		if( strcmp( pName1,"" )!=0 ){
			m_hashIndex[ pName1 ] = lIndex2;
		}
	}

	if( pName2!=NULL ){
		if( strcmp( pName2,"" )!=0 ){
			m_hashIndex[ pName2 ] = lIndex1;
		}
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReplaceByName( const char* pName1 , const char* pName2 )
//
//	[  ]
//		const char* pName1		CfbNXɊ֘AÂꂽ
//		const char* pName2		CfbNXɊ֘AÂꂽ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽ̂œ肳vfւ܂B
//		pName1 , pName2 ̂ꂩ̖̂o^ĂȂꍇ
//		G[Ԃ܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArrayHash< T >::ReplaceByName( const char* pName1 , const char* pName2 )
{
	BOOL bRes;

	long lIndex1;
	long lIndex2;

	// <<< mF >>>
	lIndex1 = GetIndex( pName1 );
	lIndex2 = GetIndex( pName2 );
	if( lIndex1==-1 ){
		return FALSE;
	}
	if( lIndex2==-1 ){
		return FALSE;
	}

	// <<< ubW >>>
	bRes = Replace( lIndex1 , lIndex2 );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator[]( long lIndex )
//
//	[  ]
//		long lIndex					QƂl̃CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		QƉZq
//--------------------------------------------------------------------
template <class T>
T&	CDArrayHash< T >::operator[]( long lIndex )
{
	return m_aryData[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		T GetValue( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		zɊi[ꂽl
//
//	[  ]
//		l̕o܂Bz͈̔̓`FbN͍s܂B
//--------------------------------------------------------------------
template < class T >
T CDArrayHash< T >::GetValue( long lIndex )
{
	return m_aryData.GetValue( lIndex );
}


//--------------------------------------------------------------------
//	[  ]
//		T GetValueByName( const char* pName )
//
//	[  ]
//		const char* pName			CfbNXɊ֘AÂꂽ
//
//	[ ߂l ]
//		zɊi[ꂽl
//
//	[  ]
//		l̕o܂Bz͈̔̓`FbN͍s܂B
//--------------------------------------------------------------------
template < class T >
T CDArrayHash< T >::GetValueByName( const char* pName )
{
	static T objError;

	// <<< mF >>>
	long lIndex;
	lIndex = GetIndex( pName );	
	if( lIndex==-1 ){
		// ̂̓o^ȂꍇAG[p̃IuWFNgԂ
		return objError;
	}

	// <<< lԂ >>
	return m_aryData.GetValue( lIndex );
}


//--------------------------------------------------------------------
//	[  ]
//		long Length()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		z̒
//
//	[  ]
//		݂̔z̒Ԃ܂B
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::Length()
{
	return m_aryData.Length();
}


//--------------------------------------------------------------------
//	[  ]
//		long SetName( long lIndex , const char* pName )
//
//	[  ]
//		long lIndex					Oݒ肷vf̃CfbNXԍ
//		const char* pName			ǉ閼
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Oݒ肵܂B
//		lIndex ̃f[^͊łKv܂B
//
//		pName  NULL w肳ꂽꍇɂ́Aki""jƂ
//		߂܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArrayHash< T >::SetName( long lIndex , const char* pName )
{
	BOOL bRes;

	// -----< mF >-----
	//
	// <<< CfbNXsłȂmF >>>
	if( lIndex>=m_aryData.Length() ){
		return FALSE;
	}
	if( lIndex<0 ){
		return FALSE;
	}

	// <<< NULL  "" Ƃĉ߂ >>>
	if( pName==NULL ){
		pName = "";
	}

	// -----< ̂ύX >-----
	//
	CGStr strOldName;					// ύXO
	strOldName = m_aryName[ lIndex ];
	bRes = m_aryName.Set( lIndex , pName );
	if( bRes==FALSE ){
		// l̕ύXɎs
		return FALSE;
	}

	// -----< OύX >-----
	//
	// <<< ȂA폜 >>>
	m_hashIndex.DeleteIfExist( pName );

	// <<< ǉ >>>
	bRes = m_hashIndex.AddObject( pName , lIndex );
	if( bRes==FALSE ){
		// CfbNXǉɎs
		m_aryName.Set( lIndex , strOldName.GetString() );
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetName( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		ւ̃|C^
//
//	[  ]
//		̂ւ̃|C^Ԃ܂
//--------------------------------------------------------------------
template <class T>
const char* CDArrayHash< T >::GetName( long lIndex )
{
	return m_aryName[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GetIndex( const char* pName )
//
//	[  ]
//		const char* pName			CfbNXɑΉÂꂽ
//
//	[ ߂l ]
//		Fvf̃CfbNXԍ
//		sF-1
//
//	[  ]
//		w肳ꂽOɑΉCfbNXԂ܂B
//		̂̓o^ꍇɂ -1 Ԃ܂B
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::GetIndex( const char* pName )
{
	// <<< ݂mF >>>
	BOOL bExists;
	bExists = m_hashIndex.KeyExists( pName );
	if( bExists==FALSE ){
		return -1;
	}

	// <<< CfbNX擾 >>>
	long lIndex;
	lIndex = m_hashIndex.GetObject( pName );

	// <<< ʂԂ >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		CDObjArray< CGStr > GetKeys();
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		L[̔z
//
//	[  ]
//		o^ĂL[̈ꗗԂ܂B
//--------------------------------------------------------------------
template <class T>
CDObjArray< CGStr > CDArrayHash< T >::GetKeys()
{
	BOOL bRes;
	CDStringArray objArray;
	long i;

	// L[ꗗ擾
	bRes = m_hashIndex.GetKeys( objArray );
	if( bRes==FALSE ){
		CDObjArray< CGStr > objError;
		return objError;
	}

	// ʃIuWFNgɊi[
	CDObjArray< CGStr > objResult;
	objResult.Initialize();
	for( i=0;i<objArray.Length();i++ ){
		CGStr strValue = objArray[ i ];
		objResult.Add( strValue );
	}
	return objResult;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetExtendUnit()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		gP
//
//	[  ]
//		z̃gPʂ擾܂
//--------------------------------------------------------------------
template <class T>
long CDArrayHash< T >::GetExtendUnit()
{
	return m_aryData.GetExtendUnit();
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator=( CDArrayHash& rArray )
//
//	[  ]
//		CDArrayHash& rArray				ւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template < class T >
CDArrayHash< T >& CDArrayHash< T >::operator=( CDArrayHash& rArray )
{
	// e𕡐
	CopyMembers( rArray );

	// ւ̎QƂԂ
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddName( const char* pName )
//
//	[  ]
//		const char* pName			ǉ閼
//
//	[ ߂l ]
//		Fǉꂽf[^̃CfbNXԍ
//		sF-1
//
//	[  ]
//		Oǉ܂B
//		m_aryData.Add() Ƒ΂ɂȂČĂтKv܂B
//		ȊOÃ[`ĂтĂ͂܂B
//
//		pName  NULL w肳ꂽꍇAki""jƂ
//		߂܂B
//--------------------------------------------------------------------
template < class T >
long CDArrayHash< T >::AddName( const char* pName )
{
	BOOL bRes;

	// -----< mF >-----
	//
	if( pName==NULL ){
		// NULL w̏ꍇ́AkƂĉ߂
		pName	= "";
	}

	// -----< Oǉ >-----
	//
	// <<< ̂ǉ >>>
	long lIndex;
	lIndex = m_aryName.Add( pName );
	if( lIndex==-1 ){
		// ǉɎs
		return -1;
	}

	// -----< Oǉ >-----
	//
	bRes = SetName( lIndex , pName );
	if( bRes==FALSE ){
		// O̒ǉɎs
		m_aryName.Remove( lIndex );
		return -1;
	}

	// -----< I >-----
	//
	return lIndex;
}

#endif
