//----------------------------------------------------------
//  TCYgziŁj
//----------------------------------------------------------
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "DStringArray.h"

//--------------------------------------------------------------------
//	[  ]
//		CDStringArray( long lUnit = DARRAY_DEFAULT_UNIT_SIZE );
//
//	[  ]
//		long lUnit					z̊gP
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CDStringArray::CDStringArray( long lUnit )
{
	SetDefault( lUnit );
}


//--------------------------------------------------------------------
//	[  ]
//		CDStringArray( CDStringArray& rArray )
//
//	[  ]
//		CDStringArray& rArray			ւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CDStringArray::CDStringArray( CDStringArray& rArray )
{
	SetDefault( DARRAY_DEFAULT_UNIT_SIZE );
	CopyMembers( rArray );
}


//--------------------------------------------------------------------
//	[  ]
//		~CDStringArray()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDStringArray::~CDStringArray()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault( long lUnit )
//
//	[  ]
//		long lUnit					z̊gPʃTCY
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
BOOL CDStringArray::SetDefault( long lUnit )
{
	m_objArray.Initialize( lUnit );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CDStringArray& rArray )
//
//	[  ]
//		CDStringArray& rArray			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐
//--------------------------------------------------------------------
BOOL CDStringArray::CopyMembers( CDStringArray& rArray )
{
	// -----< ܂ >-----
	//
	Release();

	// -----< o̕ >-----
	//
	long i;
	for( i=0;i<rArray.m_objArray.Length();i++ ){
		char* pString;
		int   iLength;

		pString = NULL;
		iLength = 0;

		// <<< NULLȂIuWFNg𕡐 >>>
		if( rArray.m_objArray[i]!=NULL ){
			iLength = strlen( rArray.m_objArray[i] )+1;
			pString = (char*)malloc( iLength );
			if( pString==NULL ){
				return FALSE;
			}
			strcpy( pString , rArray.m_objArray[i] );
		} else {
			pString = NULL;
			iLength = 0;
		}

		// <<< zɒǉ >>>
		long lRes;
		lRes = m_objArray.Add( pString );
		if( lRes==-1 ){
			return FALSE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ej
//--------------------------------------------------------------------
void CDStringArray::Release()
{
	long i;

	// -----< vf̍폜 >-----
	//
	for( i=0;i<m_objArray.Length();i++ ){
		if( m_objArray[i]!=NULL ){
			free( m_objArray[i] );
		}
		m_objArray[i] = NULL;
	}
	m_objArray.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void Release( long lRemain )
//
//	[  ]
//		long lRemain				cvf
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lRemain ̗vfcAȍ~̗̈J܂B
//		̉K؂ɍs܂B
//--------------------------------------------------------------------
void CDStringArray::Release( long lRemain )
{
	// KvȂꍇ́Â܂ܕԂ
	if( m_objArray.Length()<=0 )return;					// vfȂ炻̂܂ܕԂB
	if( lRemain>=m_objArray.Length() )return;			// wȉꍇ͂̂܂

	// vf̉
	long i;
	for( i=lRemain;i<m_objArray.Length();i++ ){
		if( m_objArray[i]!=NULL ){
			free( m_objArray[i] );
		}
		m_objArray[i] = NULL;
	}

	// z̗̈
	m_objArray.Release( lRemain );
}


//--------------------------------------------------------------------
//	[  ]
//		long Add()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		vfǉ܂B
//		z̗̈ĝ݂Ȃ̂ŁAgꂽ̈ɓĂ
//		l͕slƂȂ܂B
//--------------------------------------------------------------------
long CDStringArray::Add()
{
	long lIndex;
	lIndex = m_objArray.Add( NULL );
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( const char* pString )
//
//	[  ]
//		const char* pString			ǉ镶
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		zɗvfǉ܂B
//--------------------------------------------------------------------
long CDStringArray::Add( const char* pString )
{
	// ---< vf̒ǉ >---
	//
	long lIndex;
	lIndex = Add();										// vf̒ǉ

	// -----< vf쐬 >-----
	//
	char* pStringBuffer;
	int   iLength;
	iLength = strlen( pString )+1;
	pStringBuffer = (char*)malloc( iLength );
	if( pStringBuffer==NULL ){
		Release( m_objArray.Length()-1 );
		return -1;
	}
	strcpy( pStringBuffer , pString );

	// -----< vfǉ >-----
	//
	m_objArray[lIndex] = pStringBuffer;					// vfRs[

	return lIndex;										// CfbNXԂďI
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Set( long lIndex , const char* pString )
//
//	[  ]
//		long lIndex					CfbNXԍ
//		const char* pString			
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lXV܂B
//		sȃCfbNXw肳ꂽꍇ̓G[Ԃ
//		ɏI܂B
//--------------------------------------------------------------------
BOOL CDStringArray::Set( long lIndex , const char* pString )
{
	// -----< `FbN >-----
	//
	if( lIndex <  0                   )return FALSE;
	if( lIndex >= m_objArray.Length() )return FALSE;

	// -----< ̃f[^폜 >-----
	//
	if( m_objArray[lIndex]!=NULL ){
		free( m_objArray[lIndex] );
	}
	m_objArray[lIndex] = NULL;

	// -----< l̑ >-----
	//
	int   iLength;
	char* pStringBuffer;
	iLength = strlen( pString )+1;
	pStringBuffer = (char*)malloc( iLength );
	strcpy( pStringBuffer , pString );

	m_objArray[ lIndex ] = pStringBuffer;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Remove( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z̗vf폜AeOɋl߂܂B
//		vf̐͂P܂B
//		̈̊J͍s܂B𔺂
//		ꍇ́ARelease( long lRemain ) gp܂B
//--------------------------------------------------------------------
BOOL CDStringArray::Remove( long lIndex )
{
	// -----< `FbN >-----
	//
	if( lIndex <  0                   )return FALSE;
	if( lIndex >= m_objArray.Length() )return FALSE;

	// -----< vf폜 >-----
	//
	char* pString;
	pString = m_objArray[lIndex];
	if( pString!=NULL ){
		free( pString );
	}

	// -----< l߂ >-----
	//
	m_objArray.Remove( lIndex );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Replace( long lIndex1 , long lIndex2 )
//
//	[  ]
//		long lIndex1				ւΏۂ̃CfbNXԍ
//		long lIndex2				ւΏۂ̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		wCfbNX̗vfւ܂B
//--------------------------------------------------------------------
BOOL CDStringArray::Replace( long lIndex1 , long lIndex2 )
{
	BOOL bRes;
	bRes = m_objArray.Replace( lIndex1 , lIndex2 );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		char* operator[]( long lIndex )
//
//	[  ]
//		long lIndex					QƂl̃CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		QƉZq
//--------------------------------------------------------------------
char*	CDStringArray::operator[]( long lIndex )
{
	return m_objArray[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		char* GetValue( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		zɊi[ꂽl
//
//	[  ]
//		lo܂Bւ̒ړIȃ|C^Ԃ܂B
//		i͍̕܂Bj
//		z͈̔̓`FbN͍s܂B
//--------------------------------------------------------------------
char* CDStringArray::GetValue( long lIndex )
{
	// -----< |C^擾 >-----
	//
	char* pString;
	pString = m_objArray[ lIndex ];

	// -----< Ԃ >-----
	//
	return pString;
}


//--------------------------------------------------------------------
//	[  ]
//		long Length()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		z̒
//
//	[  ]
//		݂̔z̒Ԃ܂B
//--------------------------------------------------------------------
long CDStringArray::Length()
{
	return m_objArray.Length();
}




//--------------------------------------------------------------------
//	[  ]
//		long GetExtendUnit()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		gP
//
//	[  ]
//		z̃gPʂ擾܂
//--------------------------------------------------------------------
long CDStringArray::GetExtendUnit()
{
	return m_objArray.GetExtendUnit();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Sort()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z\[g܂
//--------------------------------------------------------------------
BOOL CDStringArray::Sort()
{
	long lLength;
	lLength = m_objArray.Length();

	// mF
	if( lLength<=0 ){
		return TRUE;
	}

	// z̐擪擾
	char** pArray	= &( m_objArray[0] );
	if( pArray==NULL ){ return FALSE; }

	// \[g
	qsort( pArray , lLength , sizeof( char* ) , (int (__cdecl *)(const void *,const void *))strcmp );

	// ʂԂ
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CDStringArray& operator=( CDStringArray& rArray )
//
//	[  ]
//		CDStringArray& rArray		ւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CDStringArray& CDStringArray::operator=( CDStringArray& rArray )
{
	CopyMembers( rArray );
	return *this;
}
