//----------------------------------------------------------
//  TCYgz
//----------------------------------------------------------
#ifndef __DARRAY_H__
#define __DARRAY_H__

#define DARRAY_DEFAULT_UNIT_SIZE	10

//----------------------------------------------------------
//  NX`
//----------------------------------------------------------
template <class T> class CDArray
{
	// -----< \z >-----
	//
	public:
		CDArray( long lUnit=DARRAY_DEFAULT_UNIT_SIZE );				// RXgN^
		CDArray( CDArray& rArray );				// Rs[RXgN^
		virtual ~CDArray();						// fXgN^

	private:
		BOOL	SetDefault();					// RXgN^xł̃ftHgݒ
		BOOL	CopyMembers( CDArray& rArray );	// IuWFNg̓e𕡐


	// -----< f[^o >-----
	//
	private:
		T*		m_pArray;						// zւ̃|C^
		long	m_lUnitOfArray;					// z̊gPʃTCY
		long	m_lNumOfArray;					// z̑傫
		long	m_lAllocCount;					// ۂɊmۂĂz̗vf


	// ---< \bh >---
	//
	public:		// <<<  >>>
		//
		void	Release();						// 
		void	Release( long lRemain );		// iRemaincĉ
		void	ReleaseObjectPointerArray();	// |C^zAe܂߉
		void	Initialize( long lUnit=DARRAY_DEFAULT_UNIT_SIZE );	// 
		void	Clear();						// ͉Ao^eNA

		// <<< ǉ >>>
		//
		long	Add();							// vf̒ǉivf̃Rs[Ȃj
		long	Add( T rElem );				// vfǉiRs[j

		// <<< XV >>>
		//
		BOOL	Set( long lIndex , T& rElem );	// l̍XV

		// <<< 폜 >>>
		//
		BOOL	Remove( long lIndex );			// vf폜ċl߂

		// <<< u >>>
		//
		BOOL	Replace( long lIndex1 , long lIndex2 );	// vf̏ւ

		// <<< Q >>>
		//
		T&		operator[]( long lIndex );		// z̗vfo
		T		GetValue( long lIndex );		// l̃Rs[o
		long	Length();						// o^̎擾
		long	GetExtendUnit();				// gPʎ擾

		// <<< ̑ >>>
		//
		CDArray& operator=( CDArray& rArray );	// Zq
};



//----------------------------------------------------------
//  ev[g`
//----------------------------------------------------------
//--------------------------------------------------------------------
//	[  ]
//		CDArray( long lUnit = DARRAY_DEFAULT_UNIT_SIZE );
//
//	[  ]
//		long lUnit					z̊gP
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
template<class T>
CDArray< T >::CDArray( long lUnit )
{
	SetDefault();
	m_lUnitOfArray	= lUnit;
}


//--------------------------------------------------------------------
//	[  ]
//		CDArray( CDArray& rArray )
//
//	[  ]
//		CDArray& rArray				ւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template<class T>
CDArray< T >::CDArray( CDArray& rArray )
{
	SetDefault();
	CopyMembers( rArray );
}


//--------------------------------------------------------------------
//	[  ]
//		~CDArray()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template <class T>
CDArray< T >::~CDArray()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void Initialize( long lUnit=DARRAY_DEFAULT_UNIT_SIZE )
//
//	[  ]
//		long lUnit = DARRAY_DEFAULT_UNIT_SIZE
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		f[^AǉPʐύX܂B
//--------------------------------------------------------------------
template <class T>
void CDArray< T >::Initialize( long lUnit )
{
	Release();
	m_lUnitOfArray = lUnit;
}


//--------------------------------------------------------------------
//	[  ]
//		void Clear()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		z̓o^Oɂ܂B
//		Ao^_IɂOɂ܂B
//		svȃ͉܂񂪁Aɏ܂B
//--------------------------------------------------------------------
template <class T>
void CDArray< T >::Clear()
{
	m_lNumOfArray	= 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
template <class T>
BOOL CDArray< T >::SetDefault()
{
	m_pArray		= NULL;
	m_lUnitOfArray	= 0;
	m_lNumOfArray	= 0;
	m_lAllocCount	= 0;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CDArray& rArray )
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		IuWFNg̓e𕡐
//--------------------------------------------------------------------
template <class T>
BOOL CDArray< T >::CopyMembers( CDArray& rArray )
{
	// ܂͉
	//
	Release();

	// ǉPʂ̕
	//
	m_lUnitOfArray = rArray.m_lUnitOfArray;

	// vfǉĂ
	//
	for( long i=0;i<rArray.m_lNumOfArray;i++ ){			// vf̒ǉ
		long lIndex;
		lIndex = Add( rArray[i] );
		if( lIndex==-1 ){
			return FALSE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ej
//--------------------------------------------------------------------
template <class T>
void CDArray< T >::Release()
{
	if( m_pArray ){								// z񂪂Ȃ
		free( m_pArray );
	}
	m_pArray	= NULL;

	m_lNumOfArray = 0;							// vfO
	m_pArray = NULL;							// ŌɃ|C^ďI
	m_lAllocCount	= 0;						// mۂĂ郁Ȃ
}


//--------------------------------------------------------------------
//	[  ]
//		void Release( long lRemain )
//
//	[  ]
//		long lRemain				cvf
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lRemain ̗vfcAȍ~̗̈J܂B
//		̉K؂ɍs܂B
//--------------------------------------------------------------------
template <class T>
void CDArray< T >::Release( long lRemain )
{
	// KvȂꍇ́Â܂ܕԂ
	if( m_pArray==NULL )return;							// vfȂ炻̂܂ܕԂB
	if( lRemain>=m_lNumOfArray )return;					// wȉꍇ͂̂܂

	// vf̗L͈͂ύX
	m_lNumOfArray	= lRemain;							// 𒲐

	// ̃jbgvZ
	long lUnits;										// jbg
	if( (m_lNumOfArray%m_lUnitOfArray)==0 ){
		lUnits = m_lNumOfArray/m_lUnitOfArray;
	} else {
		lUnits = (m_lNumOfArray/m_lUnitOfArray)+1;
	}

	// ̍Ċm
	m_lAllocCount	= (lUnits*m_lUnitOfArray);			// mۗvf
	m_pArray = (T*)realloc( m_pArray , sizeof( T )*m_lAllocCount );
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseObjectPointerArray()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		z񂪁Adelete \ȃIuWFNg̃|C^̔zł
//		ÔƁAz̓e܂߁Az̓ej܂B
//		delete łȂIuWFNgւ̃|C^o^ꂽԂ
//		̃\bhsĂ͂܂B
//--------------------------------------------------------------------
template <class T>
void CDArray< T >::ReleaseObjectPointerArray()
{
	long i;

	// -----< o^ĂIuWFNg delete  >-----
	//
	for( i=0;i<m_lNumOfArray;i++ ){
		if( m_pArray[i]!=NULL ){
			delete m_pArray[i];
			m_pArray[i] = NULL;
		}
	}

	// -----< z >-----
	//
	Release();

	return;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		vfǉ܂B
//		z̗̈ĝ݂Ȃ̂ŁAgꂽ̈ɓĂ
//		l͕slƂȂ܂B
//--------------------------------------------------------------------
template <class T>
long CDArray< T >::Add()
{
	// -----< XbgȂΒǉ >-----
	//
	if( m_lNumOfArray>=m_lAllocCount ){
		int lAllocCount;
		lAllocCount	= (m_lNumOfArray+m_lUnitOfArray);

		T*	pTempArray;									// ̊g
		pTempArray = (T*)realloc( m_pArray,sizeof( T )*lAllocCount );
		if( pTempArray==NULL )return -1;				// gɎsꍇ -1 Ԃ

		m_lAllocCount	= lAllocCount;					// mېݒ
		m_pArray		= pTempArray;					// g
	}


	// ---< vf̒ǉ >---
	//
	m_lNumOfArray += 1;									// z̑傫ɂP

	return m_lNumOfArray-1;								// CfbNXԂďI
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( T rElem )
//
//	[  ]
//		T rElem						ǉvf
//
//	[ ߂l ]
//		Fo^CfbNXԍ
//		sF-1
//
//	[  ]
//		zɗvfǉ܂B
//--------------------------------------------------------------------
template <class T>
long CDArray< T >::Add( T rElem )
{
	// ---< vf̒ǉ >---
	//
	long lIndex;
	lIndex = Add();										// vf̒ǉ

	m_pArray[lIndex] = rElem;							// vfRs[

	return lIndex;										// CfbNXԂďI
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Set( long lIndex , T& rElem );
//
//	[  ]
//		long lIndex					CfbNXԍ
//		T&   rElem					l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lXV܂B
//		sȃCfbNXw肳ꂽꍇ̓G[Ԃ
//		ɏI܂B
//--------------------------------------------------------------------
template< class T >
BOOL CDArray< T >::Set( long lIndex , T& rElem )
{
	// -----< `FbN >-----
	//
	if( lIndex <  0             )return FALSE;
	if( lIndex >= m_lNumOfArray )return FALSE;

	// -----<  >-----
	//
	m_pArray[ lIndex ] = rElem;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Remove( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z̗vf폜AeOɋl߂܂B
//		vf̐͂P܂B
//		̈̊J͍s܂B𔺂
//		ꍇ́ARelease( long lRemain ) gp܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArray< T >::Remove( long lIndex )
{
	// -----< `FbN >-----
	//
	if( lIndex <  0             )return FALSE;
	if( lIndex >= m_lNumOfArray )return FALSE;

	// -----< l߂ >-----
	//
	int i;
	for( i=lIndex;i<m_lNumOfArray-1;i++ ){
			m_pArray[ i ] = m_pArray[ i+1 ];
	}

	m_lNumOfArray -= 1;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Replace( long lIndex1 , long lIndex2 )
//
//	[  ]
//		long lIndex1				ւΏۂ̃CfbNXԍ
//		long lIndex2				ւΏۂ̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		wCfbNX̗vfւ܂B
//--------------------------------------------------------------------
template < class T >
BOOL CDArray< T >::Replace( long lIndex1 , long lIndex2 )
{
	// -----< `FbN >-----
	//
	if( lIndex1 < 0 )return FALSE;
	if( lIndex2 < 0 )return FALSE;
	if( lIndex1 >= m_lNumOfArray )return FALSE;
	if( lIndex2 >= m_lNumOfArray )return FALSE;

	// -----< ւ >-----
	//
	T objElem;
	objElem = m_pArray[ lIndex1 ];
	m_pArray[ lIndex1 ] = m_pArray[ lIndex2 ];
	m_pArray[ lIndex2 ] = objElem;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator[]( long lIndex )
//
//	[  ]
//		long lIndex					QƂl̃CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		QƉZq
//--------------------------------------------------------------------
template <class T>
T&	CDArray< T >::operator[]( long lIndex )
{
	return m_pArray[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		T GetValue( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		zɊi[ꂽl
//
//	[  ]
//		l̕o܂Bz͈̔̓`FbN͍s܂B
//--------------------------------------------------------------------
template < class T >
T CDArray< T >::GetValue( long lIndex )
{
	return m_pArray[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long Length()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		z̒
//
//	[  ]
//		݂̔z̒Ԃ܂B
//--------------------------------------------------------------------
template <class T>
long CDArray< T >::Length()
{
	return m_lNumOfArray;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetExtendUnit()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		gP
//
//	[  ]
//		z̃gPʂ擾܂
//--------------------------------------------------------------------
template <class T>
long CDArray< T >::GetExtendUnit()
{
	return m_lUnitOfArray;
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator=( CDArray& rArray )
//
//	[  ]
//		CDArray& rArray				ւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template < class T >
CDArray< T >& CDArray< T >::operator=( CDArray& rArray )
{
	CopyMembers( rArray );
	return *this;
}

#endif
