//==============================================================================
//    AVConfig.cpp			Ƃ
//		CVS ID : $Id: AVConfig.cpp,v 1.2 2010/08/07 02:27:53 gtn Exp $
//==============================================================================
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <string.h>

#include "DShowControl.h"
#include "AVConfig.h"

//--------------------------------------------------------------------
//	[  ]
//		CGAVConfig()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGAVConfig::CGAVConfig()
{
	m_hashAudio.Initialize();
	m_hashMovie.Initialize();
	m_hashWav.Initialize();
}


//--------------------------------------------------------------------
//	[  ] virtual
//		~CGAVConfig()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGAVConfig::~CGAVConfig()
{
	m_hashAudio.Release();
	m_hashMovie.Release();
	m_hashWav.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		const CGHash< long >& GetAudioHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		nbVIuWFNg̕
//
//	[  ]
//		f[^ǂݍ݌́Ai[ Hash Ԃ܂B
//--------------------------------------------------------------------
const CGHash< long >& CGAVConfig::GetAudioHash()
{
	return m_hashAudio;
}


//--------------------------------------------------------------------
//	[  ]
//		const CGHash< long >& GetMovieHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		nbVIuWFNg̕
//
//	[  ]
//		f[^ǂݍ݌́Ai[ Hash Ԃ܂B
//--------------------------------------------------------------------
const CGHash< long >& CGAVConfig::GetMovieHash()
{
	return m_hashMovie;
}


//--------------------------------------------------------------------
//	[  ]
//		const CGHash< long >& GetWavHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		nbVIuWFNg̕
//
//	[  ]
//		f[^ǂݍ݌́Ai[ Hash Ԃ܂B
//--------------------------------------------------------------------
const CGHash< long >& CGAVConfig::GetWavHash()
{
	return m_hashWav;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Exec()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XNvgs
//--------------------------------------------------------------------
BOOL CGAVConfig::Exec()
{
	BOOL bRes;
	long lIndex;
	CGStr	strToken;

	// -----< ubN\z >-----
	//
	// <<< gpubN̈ꗗ쐬 >>>
	CDObjArray< CGStr > objBlockList;
	objBlockList.Add( CGStr( "AVResource" ) );

	// <<< ubN擪o >>>
	bRes	= TakeInBlockTop( objBlockList , FALSE );
	if( bRes==FALSE )return FALSE;


	// -----< eubNɂăp[Xs >-----
	//
	// <<< AVResource >>>
	//
	if( m_hashBlockTop.KeyExists( "AVResource" )==TRUE ){
		lIndex	= m_hashBlockTop[ "AVResource" ];
		lIndex	= ExecAVResource( lIndex );
		if( lIndex==-1 ){
			ErrorLog( "CGAVConfig::Exec : AVResource ubN̏ɃG[܂B\n" );
			return FALSE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long ExecAVResource( long lIndex )
//
//	[  ]
//		long lIndex					ubN擪u[XʒũCfbNX
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		AVResource ubN܂
//--------------------------------------------------------------------
long CGAVConfig::ExecAVResource( long lIndex )
{
	long lRes;
	CGStr	strToken;

	// -----< u[XmF >-----
	//
	lRes	= GetToken( lIndex , strToken );
	if( lRes==-1 )return -1;
	if( strToken!="{" ){
		ErrorLog( "CGDIConfig::ExecAVResource : Jnu[X܂B\n" );
		return -1;
	}
	lIndex++;

	// -----<  >-----
	//
	while( 1 ){
		// <<< mF >>>
		if( lIndex==-1 )return -1;

		// <<< g[N擾 >>>
		lRes	= GetToken( lIndex , strToken );
		if( lRes==-1 )return -1;

		// <<< I >>>
		if( strToken=="}" ){
			break;
		}
		if( strToken=="" ){
			ErrorLog( "CGAVConfig::ExecAVResource : sEOFo܂B\n" );
			return -1;
		}

		// <<< R}hŕ >>>
		// Audio
		if( strToken=="Audio" ){
			lIndex	= OnAVResourceAudio( lIndex );
			continue;
		}

		// Movie
		if( strToken=="Movie" ){
			lIndex	= OnAVResourceMovie( lIndex );
			continue;
		}

		// Wav
		if( strToken=="Wav" ){
			lIndex	= OnAVResourceWav( lIndex );
			continue;
		}

		// ܂łG[
		ErrorLog( "CGDIConfig::ExecAVResource : %ds sȃR}h [%s] w肳Ă܂B\n"
					, GetLine( lIndex ) , strToken.GetString() );
		return -1;
	}

	// <<< I >>>
	lIndex++;
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long OnAVResourceMovie( long lIndex )
//
//	[  ]
//		long lIndex					R}h擪̃CfbNXԍ
//
//	[ ߂l ]
//		FR}h̎̃CfbNXԍ
//		sF-1
//
//	[  ]
//		Movie ݒ肵܂
//--------------------------------------------------------------------
long CGAVConfig::OnAVResourceMovie( long lIndex )
{
	long	lSpecIndex		= lIndex;
	CGStr	strName			= CGStr( "" );
	CGStr	strFilename		= CGStr( "" );
	BOOL	bLoop			= FALSE;

	// -----< 擾 >-----
	//
	lIndex	= JudgeToken( lIndex , "Movie"       );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strName       );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "="           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strFilename   );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ","           );	if( lIndex==-1 )return -1;
	lIndex	= GetBool(    lIndex , bLoop         );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;

	// -----< o^ >-----
	//
	// \z
	long lPageIndex;
	CDShowControl* pDShowControl;
	pDShowControl	= CDShowControl::GetInstance();
	lPageIndex	= pDShowControl->AddMovie( strFilename.GetString() , bLoop );
	if( lPageIndex==-1 ){
		ErrorLog( "CGAVConfig::OnAVResourceMovie : [r[̒ǉɎs܂B\n" );
		return -1;
	}

	// hash ɓo^
	m_hashMovie.AddObject( strName , lPageIndex );

	// 
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long OnAVResourceAudio( long lIndex )
//
//	[  ]
//		long lIndex					R}h擪̃CfbNXԍ
//
//	[ ߂l ]
//		FR}h̎̃CfbNXԍ
//		sF-1
//
//	[  ]
//		Audio ݒ肵܂
//--------------------------------------------------------------------
long CGAVConfig::OnAVResourceAudio( long lIndex )
{
	long	lSpecIndex		= lIndex;
	CGStr	strName			= CGStr( "" );
	CGStr	strFilename		= CGStr( "" );
	BOOL	bLoop			= FALSE;

	// -----< 擾 >-----
	//
	lIndex	= JudgeToken( lIndex , "Audio"       );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strName       );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "="           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strFilename   );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ","           );	if( lIndex==-1 )return -1;
	lIndex	= GetBool(    lIndex , bLoop         );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;

	// -----< o^ >-----
	//
	// \z
	long lPageIndex;
	CDShowControl* pDShowControl;
	pDShowControl	= CDShowControl::GetInstance();
	lPageIndex	= pDShowControl->AddAudio( strFilename.GetString() , bLoop );
	if( lPageIndex==-1 ){
		ErrorLog( "CGAVConfig::OnAVResourceAudio : Audio̒ǉɎs܂B\n" );
		return -1;
	}

	// hash ɓo^
	m_hashAudio.AddObject( strName , lPageIndex );

	// 
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long OnAVResourceWav( long lIndex )
//
//	[  ]
//		long lIndex					R}h擪̃CfbNXԍ
//
//	[ ߂l ]
//		FR}h̎̃CfbNXԍ
//		sF-1
//
//	[  ]
//		Wav ݒ肵܂
//--------------------------------------------------------------------
long CGAVConfig::OnAVResourceWav( long lIndex )
{
	long	lSpecIndex		= lIndex;
	CGStr	strName			= CGStr( "" );
	CGStr	strFilename		= CGStr( "" );
	long	lPolyCount		= 1;

	// -----< 擾 >-----
	//
	lIndex	= JudgeToken( lIndex , "Wav"         );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strName       );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "="           );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , "("           );	if( lIndex==-1 )return -1;
	lIndex	= GetToken(   lIndex , strFilename   );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ","           );	if( lIndex==-1 )return -1;
	lIndex	= GetLong(    lIndex , lPolyCount    );	if( lIndex==-1 )return -1;
	lIndex	= JudgeToken( lIndex , ")"           );	if( lIndex==-1 )return -1;

	// -----< o^ >-----
	//
	// \z
	long lPageIndex;
	CGSoundUnit* pSoundUnit;
	pSoundUnit	= CGSoundUnit::GetInstance();
	lPageIndex	= pSoundUnit->AddWave( (char*)(strFilename.GetString()) , (char*)(strName.GetString()) , lPolyCount, 0 );
	if( lPageIndex==-1 ){
		ErrorLog( "CGAVConfig::OnAVResourceWav : WAV̒ǉɎs܂B\n" );
		return -1;
	}

	// hash ɓo^
	m_hashWav.AddObject( strName , lPageIndex );

	// 
	return lIndex;
}
