//====================================================================
//  Str test
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Str.h"
#include "DStringArray.h"

//--------------------------------------------------------------------
//  main
//--------------------------------------------------------------------
int main( int argc , char* argv[] )
{
	CGStr*	pString1;
	CGStr*	pString2;
	BOOL	bRes;

	printf( "[ \z ]\n" );
	pString1	= new CGStr();
	if( pString1==NULL ){
		printf( "\zɎs\n" );
		return __LINE__;
	}

	printf( "[ ݒ ]\n" );
	bRes = pString1->SetString( "P\n" );
	if( bRes==FALSE ){
		delete pString1;
		printf( "ݒɎs\n" );
		return __LINE__;
	}

	printf( "[ 擾mF ]\n" );
	const char* pcRes	= pString1->GetString();
	if( pcRes==NULL ){
		delete pString1;
		printf( "擾ŕs\n" );
		return __LINE__;
	}
	if( strcmp( pcRes,"P\n" )!=0 ){
		delete pString1;
		printf( "𐳂擾ł܂łB\n" );
		return __LINE__;
	}

	printf( "[ ڑ(CGStr&) ]\n" );
	pString2	= new CGStr();
	*pString2	= CGStr( "Q" );
	bRes	= pString1->AppendString( *pString2 );
	if( bRes==FALSE ){
		delete pString1;
		delete pString2;
		printf( "ڑɎs\n" );
		return __LINE__;
	}
	delete pString2;
	printf( "ڑʁF%s\n" , pString1->GetString() );
	if( strcmp( pString1->GetString(),"P\nQ" )!=0 ){
		delete pString1;
		delete pString2;
		printf( "̐ڑs܂łB\n" );
		return __LINE__;
	}

	printf( "[ ڑ(const char*) ]\n" );
	bRes = pString1->AppendString( "\nR\n" );
	if( bRes==FALSE ){
		delete pString1;
		printf( "ڑɎs\n" );
		return __LINE__;
	}
	if( strcmp( pString1->GetString(),"P\nQ\nR\n" )!=0 ){
		delete pString1;
		printf( "̐ڑɍs܂łB\n" );
		return __LINE__;
	}

	printf( "[ RXgN^ ]\n" );
	CGStr	objStringA( "RXgN^eXg\n" );
	if( strcmp( objStringA.GetString(),"RXgN^eXg\n" )!=0 ){
		delete pString1;
		printf( "RXgN^ɋ@\Ă܂B\n" );
		return __LINE__;
	}
	
	printf( "[  ]\n" );
	CGStr	objStringB;
	objStringB	= objStringA;
	if( strcmp( objStringB.GetString(),"RXgN^eXg\n" )!=0 ){
		delete pString1;
		printf( "ɋ@\Ă܂B\n" );
		return __LINE__;
	}

	printf( "[ oCgo ]\n" );
	if( pString1->GetMBLetterSize( "ABCDE" )!=1 ){
		delete pString1;
		printf( "poɎs\n" );
		return __LINE__;
	}
	if( pString1->GetMBLetterSize( "قق" )!=2 ){
		delete pString1;
		printf( "SpoɎs\n" );
		return __LINE__;
	}

	printf( "[  ]\n" );
	bRes = pString1->Initialize();
	if( bRes==FALSE ){
		delete pString1;
		printf( "̏Ɏs\n" );
		return __LINE__;
	}
	if( pString1->Length()!=0 ){
		delete pString1;
		printf( "񏉊AOłȂB\n" );
		return __LINE__;
	}
	if( pString1->GetString()!=NULL ){
		delete pString1;
		printf( "񏉊AƂ NULL ĂȂ\n" );
		return __LINE__;
	}

	printf( "[ } ]\n" );
	bRes	= pString1->InsertString( "}P\n" );
	if( bRes==FALSE ){
		delete pString1;
		printf( "}Ɏs\n" );
		return __LINE__;
	}
	bRes	= pString1->InsertString( "}Q\n" );
	if( bRes==FALSE ){
		delete pString1;
		printf( "}ɎsQ\n" );
		return __LINE__;
	}
	bRes	= pString1->InsertString( CGStr( "}R\n" ) );
	if( bRes==FALSE ){
		delete pString1;
		printf( "}ɎsR\n" );
		return __LINE__;
	}
	if( strcmp( pString1->GetString(),"}R\n}Q\n}P\n" )!=0 ){
		delete pString1;
		printf( "}ɍs܂łB\n" );
		return __LINE__;
	}

	printf( "[ o ]\n" );
	if( pString1->Length()!=(13*3) ){
		delete pString1;
		printf( "񒷌oɎs\n" );
		return __LINE__;
	}

	printf( "[ o ]\n" );
	if( pString1->MBLength()!=(7*3) ){
		delete pString1;
		printf( "񐔌oɎs\n" );
		return __LINE__;
	}

	printf( "[ operator+ ]\n" );
	pString1->Initialize();
	*pString1	= *pString1 + "eXgP";
	*pString1	= *pString1 + CGStr( "eXgQ\n" );
	if( strcmp( pString1->GetString(),"eXgPeXgQ\n" )!=0 ){
		delete pString1;
		printf( "operator+ ɋ@\Ă܂B\n" );
		return __LINE__;
	}
	printf( "operator+ʁF%s\n" , pString1->GetString() );

	printf( "[ operator+= ]\n" );
	pString1->Initialize();
	*pString1	+= "eXgP";
	*pString1	+= CGStr( "eXgQ\n" );
	if( strcmp( pString1->GetString(),"eXgPeXgQ\n" )!=0 ){
		delete pString1;
		printf( "operator+= ɋ@\Ă܂B\n" );
		return __LINE__;
	}
	printf( "operator+=ʁF%s\n" , pString1->GetString() );

	printf( "[ operator= ]\n" );
	CGStr	objDist;
	CGStr	objSrc;
	objSrc	= "eXgp";
	objDist	= objSrc;
	if( strcmp( objSrc.GetString(),"eXgp" )!=0 ){
		delete pString1;
		printf( "(const char*)Ɏs\n" );
		return __LINE__;
	}
	if( strcmp( objDist.GetString(),"eXgp" )!=0 ){
		delete pString1;
		printf( "(CGStr)Ɏs\n" );
		return __LINE__;
	}

	printf( "[ rZq ]\n" );
	CGStr	objCompare1( "v" );
	CGStr	objCompare2( "v" );

	if( objCompare1==objCompare2 ){
		printf( "΃IuWFNgvmF\n" );
	} else {
		printf( "΃IuWFNgrs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1==objCompare1.GetString() ){
		printf( "ΕvmF\n" );
	} else {
		printf( "Εrs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1==*pString1 ){
		printf( "΃IuWFNgrsvs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1=="قق" ){
		printf( "Εrsvs\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ ےrZq ]\n" );
	if( objCompare1!=objCompare2 ){
		printf( "΃IuWFNgےrs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1!=objCompare2.GetString() ){
		printf( "Εےrs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1!=*pString1 ){
		printf( "΃IuWFNgےrmF\n" );
	} else {
		printf( "΃IuWFNgےrs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objCompare1!=pString1->GetString() ){
		printf( "ΕےrmF\n" );
	} else {
		printf( "Εےrs\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ 񕪗 ]\n" );
	CDStringArray	objElements;
	CGStr			objKeys;
	objKeys	= "vfP,vfQ,Ή\P,Ή\Q";

	bRes = objKeys.Explode( "," , objElements );
	if( bRes==FALSE ){
		printf( "̕Ɏs\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "%s\n" , objElements[0] );
	if( CGStr( "vfP" )!=objElements[0] ){
		printf( "񕪗ŕs(00)\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "%s\n" , objElements[1] );
	if( CGStr( "vfQ" )!=objElements[1] ){
		printf( "񕪗ŕs(01)\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "%s\n" , objElements[2] );
	if( CGStr( "Ή\P" )!=objElements[2] ){
		printf( "񕪗ŕs(02)\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "%s\n" , objElements[3] );
	if( CGStr( "Ή\Q" )!=objElements[3] ){
		printf( "񕪗ŕs(03)\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ 񌋍 ]\n" );
	objKeys = "";
	bRes = objKeys.Implode( "," , objElements );
	if( bRes==FALSE ){
		printf( "񌋍Ɏs\n" );
		delete pString1;
		return __LINE__;
	}
	if( objKeys!="vfP,vfQ,Ή\P,Ή\Q" ){
		printf( "񌋍ŕs\n" );
		delete pString1;
		return __LINE__;
	}
	printf( "%s\n" , objKeys.GetString() );

	printf( "[ s폜eXg ]\n" );
	CGStr	objCRStr;
	objCRStr	= "sR[h\\n";
	bRes = objCRStr.DeleteLastCR();
	if( bRes==FALSE ){
		printf( "sR[h폜Ɏs\n" );
		delete pString1;
		return __LINE__;
	}
	if( objCRStr!="sR[h\" ){
		printf( "sR[h폜ŕs\n" );
		delete pString1;
		return __LINE__;
	}

	bRes = objCRStr.DeleteLastCR();
	if( bRes==FALSE ){
		printf( "sR[h폜Ɏs\n" );
		delete pString1;
		return __LINE__;
	}
	if( objCRStr!="sR[h\" ){
		printf( "sR[h폜ŕs\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ XvbgeXg ]\n" );
	CGStr	objSplit;
	CGStr	objLeft,objRight;
	objSplit	= "i\=i}X^[01.dat";
	bRes	= objSplit.Split( "=" , objLeft , objRight );
	if( bRes==FALSE ){
		printf( "񕪊Ɏs܂B\n" );
		delete pString1;
		return __LINE__;
	}

	if( objLeft!="i\" ){
		printf( "񕪊ŕs\n" );
		delete pString1;
		return __LINE__;
	}

	if( objRight!="i}X^[01.dat" ){
		printf( "񕪊ŕs\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ StrLast mF ]\n" );
	CGStr	strLast;
	strLast	= "ققBEND";
	if( strLast.StrLast( "END" )==FALSE ){
		printf( "StrLast ʂԂ܂łB\n" );
		delete pString1;
		return __LINE__;
	}

	if( strLast.StrLast( "BEN" )==TRUE ){
		printf( "StrLast ʂԂ܂łB\n" );
		delete pString1;
		return __LINE__;
	}

	printf( "[ j ]\n" );
	delete pString1;

	printf( "[ I ]\n" );
	return 0;
}
