//====================================================================
//  CPPDoc RA[`
//====================================================================

#include "system.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "LineRead.h"

// -----< 萔` >-----
//
#define MAX_LINEHEAD	2048		/* swb_̍ő咷 */
#define MAX_ONE_LINE	10240		/* Ps̍ő咷 */

// -----< {̕ >-----
//
static char* g_pJapaneseForm		= "";
static char* g_pJapaneseParams		= "";
static char* g_pJapaneseRetValue	= "߂l";
static char* g_pJapaneseRemarks		= "";

// -----< p̕ >-----
//
static char* g_pEnglishForm			= "Synopsis";
static char* g_pEnglishParams		= "Parameters";
static char* g_pEnglishRetValue		= "Return value";
static char* g_pEnglishRemarks		= "Remarks";

// -----< ؂֘A̕ >-----
//
static char* g_pPauseString	= "//\n";
static char* g_pLineString	= "//--------------------------------------------------------------------\n";

// -----< ÓI֐̃vg^Cv錾 >-----
//
static BOOL SearchLine( CLineRead* pLineRead , char* pString );
static BOOL OutputSegment( CLineRead* pLineRead , char* pSubject , char* pHeaderString , FILE* pDest , BOOL bLastSegment=FALSE );
static BOOL ReplaceTab( char* pString );


//--------------------------------------------------------------------
//	[  ]
//		void OutputJapaneseFormat( FILE* pStream )
//
//	[  ]
//		FILE* pStream				o͐t@CXg[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		{ŃtH[}bgo͂܂B
//--------------------------------------------------------------------
void OutputJapaneseFormat( FILE* pStream )
{
	fprintf( pStream , "//--------------------------------------------------------------------\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pJapaneseForm );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pJapaneseParams );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pJapaneseRetValue );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pJapaneseRemarks );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//--------------------------------------------------------------------\n" );
}


//--------------------------------------------------------------------
//	[  ]
//		void OutputEnglishFormat( FILE* pFormat )
//
//	[  ]
//		FILE* pStream				o͐̃t@CXg[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		pŃtH[}bgo͂܂B
//--------------------------------------------------------------------
void OutputEnglishFormat( FILE* pStream )
{
	fprintf( pStream , "//--------------------------------------------------------------------\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pEnglishForm );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pEnglishParams );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pEnglishRetValue );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//\n" );
	fprintf( pStream , "//	[ %s ]\n" , g_pEnglishRemarks );
	fprintf( pStream , "//		\n" );
	fprintf( pStream , "//--------------------------------------------------------------------\n" );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ExecCPPDoc( char* pSourceFile , char* pDestFile )
//
//	[  ]
//		char* pSourceFile			̓t@C
//		char* pDestFile				o̓t@C
//
//	[ ߂l ]
//		const char* pSourceFile		\[Xt@C
//		const char* pDestFile		o̓t@C
//
//	[  ]
//		oƂs܂B
//--------------------------------------------------------------------
BOOL ExecCPPDoc( const char* pSourceFile , const char* pDestFile , BOOL bEnglish
			  , const char* pTitle , const char* pReturnAddress )
{
	BOOL bRes;

	// -----< X^Cw >-----
	//
	char*	pHRStyle	= "color=\"#7600AE\"";			// ̃X^C

	// -----< ȑ >-----
	//
	char	pFormString[ MAX_LINEHEAD ];		// swb_
	char	pParamsString[ MAX_LINEHEAD ];		// p[^swb_
	char	pRetValueString[ MAX_LINEHEAD ];	// ߂lswb_
	char	pRemarksString[ MAX_LINEHEAD ];		// swb_
	char	pPauseString[ MAX_LINEHEAD ];		// ؂s

	memset( pFormString     , 0 , MAX_LINEHEAD );
	memset( pParamsString   , 0 , MAX_LINEHEAD );
	memset( pRetValueString , 0 , MAX_LINEHEAD );
	memset( pRemarksString  , 0 , MAX_LINEHEAD );
	memset( pPauseString    , 0 , MAX_LINEHEAD );

	if( bEnglish ){
		sprintf(     pFormString , "//	[ %s ]" , g_pJapaneseForm     );
		sprintf(   pParamsString , "//	[ %s ]\n" , g_pJapaneseParams   );
		sprintf( pRetValueString , "//	[ %s ]\n" , g_pJapaneseRetValue );
		sprintf(  pRemarksString , "//	[ %s ]\n" , g_pJapaneseRemarks  );
		sprintf(    pPauseString , "//\n" );
	} else {
		sprintf(     pFormString , "//	[ %s ]" , g_pJapaneseForm     );
		sprintf(   pParamsString , "//	[ %s ]\n" , g_pJapaneseParams   );
		sprintf( pRetValueString , "//	[ %s ]\n" , g_pJapaneseRetValue );
		sprintf(  pRemarksString , "//	[ %s ]\n" , g_pJapaneseRemarks  );
		sprintf(    pPauseString , "//\n" );
	}

	// -----< t@CJ >-----
	//
	FILE* pSource	= NULL;
	FILE* pDest		= NULL;

	// ̓t@CJ
	pSource	= fopen( pSourceFile , "rt" );
	if( pSource==NULL ){
		printf( "̓t@CJ܂łB\n" );
		return FALSE;
	}

	// o̓t@CJ
	pDest	= fopen( pDestFile   , "wt" );
	if( pDest==NULL ){
		printf( "o̓t@CJ܂łB\n" );
		fclose( pSource );
		return FALSE;
	}

	// -----< C[h >-----
	//
	CLineRead objLineRead;
	bRes = objLineRead.Attach( pSource );
	if( bRes==FALSE ){
		fclose( pSource );
		fclose( pDest );
		return FALSE;
	}

	// -----< oJn >-----
	//
	BOOL bError = FALSE;

	fprintf( pDest , "<html>\n" );
	fprintf( pDest , "\n" );
	fprintf( pDest , "<head>\n" );
	fprintf( pDest , "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=shift_jis\">\n" );
	fprintf( pDest , "<title>%s</title>\n" , pTitle );
	fprintf( pDest , "</head>\n" );
	fprintf( pDest , "<body>\n" );
	fprintf( pDest , "\n" );

	// ^Cg\
	fprintf( pDest , "<table border=\"0\" width=\"100%%\" bgcolor=\"#E6C8FF\" cellpadding=\"2\">\n" );
	fprintf( pDest , "  <tr>\n" );
	fprintf( pDest , "    <td width=\"100%%\" align=\"center\">\n" );
	fprintf( pDest , "      <font size=\"4\">%s</font>\n" , pTitle );
	fprintf( pDest , "    </td>\n" );
	fprintf( pDest , "  </tr>\n" );
	fprintf( pDest , "</table>\n" );

	// \
	time_t timevalue;
	time( &timevalue );

	struct tm* local_time;
	local_time = localtime( &timevalue );
	fprintf( pDest , "<p align=\"right\">Document generated at %d/%02d/%02d %02d:%02d:%02d</p>\n"
		, local_time->tm_year+1900 , local_time->tm_mon+1 , local_time->tm_mday
		, local_time->tm_hour , local_time->tm_min , local_time->tm_sec );
	fprintf( pDest , "<hr %s>\n" , pHRStyle );


	BOOL bFirstTable = TRUE;
	while( 1 ){
		char* pSubject;

		// <<< s >>>
		//
		bRes = SearchLine( &objLineRead , pFormString );
		if( bRes==FALSE ){
			// sȂ΁AŏI
			bError = FALSE;
			break;
		}

		// ŏ̍słȂ HR 
		if( bFirstTable ){
			bFirstTable = FALSE;
		} else {
			fprintf( pDest , "&nbsp;<br><hr %s width=\"70%%\">&nbsp;<br>\n" , pHRStyle );
		}

		// <<< ֐Jn >>>
		fprintf( pDest
			, "<table border=\"1\" width=\"100%%\" bordercolor=\"#000000\" cellspacing=\"1\" cellpadding=\"5\" bordercolordark=\"#000000\" bordercolorlight=\"#000000\">\n" );

		// <<< o >>>
		//
		if( bEnglish )pSubject = g_pEnglishForm;
		else          pSubject = g_pJapaneseForm;
		bRes = OutputSegment( &objLineRead , pSubject , pParamsString , pDest );
		if( bRes==FALSE ){
			bError = TRUE;
			break;
		}

		// <<< p[^o >>>
		if( bEnglish )pSubject = g_pEnglishParams;
		else          pSubject = g_pJapaneseParams;
		bRes = OutputSegment( &objLineRead , pSubject , pRetValueString , pDest );
		if( bRes==FALSE ){
			bError = TRUE;
			break;
		}

		// <<< ߂lo >>>
		if( bEnglish )pSubject = g_pEnglishRetValue;
		else          pSubject = g_pJapaneseRetValue;
		bRes = OutputSegment( &objLineRead , pSubject , pRemarksString , pDest );
		if( bRes==FALSE ){
			bError = TRUE;
			break;
		}

		// <<< o >>>
		if( bEnglish )pSubject = g_pEnglishRemarks;
		else          pSubject = g_pJapaneseRemarks;
		bRes = OutputSegment( &objLineRead , pSubject , g_pLineString , pDest , TRUE );
		if( bRes==FALSE ){
			bError = TRUE;
			break;
		}

		// <<< ֐I >>>
		fprintf( pDest , "</table>\n" );
	}

	// <<< Ō̐ >>>
	fprintf( pDest , "\n" );
	fprintf( pDest , "<hr %s>\n" , pHRStyle );

	// <<< ߂郊N >>>
	if( strlen( pReturnAddress )!=0 ){
		fprintf( pDest , "<p align=\"right\">\n" );
		fprintf( pDest , "  <a href=\"%s\">BACK</a>\n" , pReturnAddress );
		fprintf( pDest , "</p>\n" , pReturnAddress );
		fprintf( pDest , "\n" );
	}

	// <<< ^OI >>>
	fprintf( pDest , "</body>\n" );
	fprintf( pDest , "</html>\n" );

	// -----< ǂݍݏI >-----
	//
	objLineRead.Detach();
	fclose( pSource );			// \[Xt@C
	fclose( pDest );			// o̓t@C

	// ʂԂ
	if( bError ){
		return FALSE;
	} else {
		return TRUE;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SearchLine( CLineRead* pLineRead , char* pString )
//
//	[  ]
//		CLineRead* pLineRead		sǂ݃IuWFNgւ̃|C^
//		char*      pString			镶
//
//	[ ߂l ]
//		FTRUE
//		FFALSE
//
//	[  ]
//		ZOg̃wb_܂B
//--------------------------------------------------------------------
static BOOL SearchLine( CLineRead* pLineRead , char* pString )
{
	BOOL bRes;

	while( 1 ){
		// Psǂݍ
		bRes = pLineRead->Read( FALSE );
		if( bRes==FALSE ){
			// FALSE ԂǂݍݏI
			return FALSE;
		}

		// sr
		bRes = pLineRead->CheckHead( pString );
		if( bRes==FALSE ){
			continue;
		}

		// ܂ŗ烉C
		return TRUE;
	}

	// ɂ͂Ȃ
	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL OutputSegment( CLineRead* pLineRead , char* pSubject , char* pNextHeader , FILE* pDest );
//
//	[  ]
//		CLineRead* pLineRead		sǂ݃IuWFNgւ̃|C^
//		char*      pSubject			ږ
//		char*      pNextHeader		̃ZOg̎ʎq
//		FILE*      pDest			o̓t@C̃t@CXg[
//		BOOL       bLastSegment		ŏIZOgۂ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ZOg̓eo͂܂B
//--------------------------------------------------------------------
static BOOL OutputSegment( CLineRead* pLineRead , char* pSubject , char* pNextHeader , FILE* pDest , BOOL bLastSegment )
{
	BOOL bRes;

	fprintf( pDest , "  <tr>\n" );

	// -----< ZOg >-----
	//
	fprintf( pDest , "    <td valign=\"top\" align=\"center\" nowrap bgcolor=\"#000000\">\n" );
	fprintf( pDest , "      <font color=\"#FFFFFF\">" );
	fprintf( pDest , "%s" , pSubject );

	// Cq
	for( int i=0;i<pLineRead->GetTokens();i++ ){
		// private
		if( strcmp( pLineRead->GetToken( i ) , "private" )==0 ){
			fprintf( pDest , "<br><font color=\"#FF0000\">[ private ]</font>" );
		}

		// protectec
		if( strcmp( pLineRead->GetToken( i ) , "protected" )==0 ){
			fprintf( pDest , "<br><font color=\"#00FF00\">[ protected ]</font>" );
		}
	}
	fprintf( pDest , "</font>\n" );
	fprintf( pDest , "    </td>\n" );


	// -----< ZOg̓e >-----
	//
	fprintf( pDest , "    <td width=\"89%%\" nowrap>\n" );
	fprintf( pDest , "    <pre>" );

	BOOL bFirst = TRUE;
	while( 1 ){
		BOOL bSpacingLine = FALSE;		// ŝƂTRUE

		// -----< Psǂݍ >-----
		//
		bRes = pLineRead->Read( FALSE );
		if( bRes==FALSE ){
			// FALSE ԂArŐ؂ĂĂƁB
			return FALSE;
		}

		// -----< b{{̃RgłȂ΃G[ >-----
		//
		bRes = pLineRead->CheckHead( "//" );
		if( bRes==FALSE ){
			return FALSE;
		}

		// -----< ŏIZOgŁAȂ炱ŏI >-----
		//
		if( bLastSegment ){
			if( pLineRead->CheckHead( pNextHeader )==TRUE ){
				// ŏIZOgȂAŏI
				break;
			}
		}

		// -----< ŏIZOgłȂāÃZOgɑꍇ͂ŏI >-----
		//
		// ZOg؂sƓŁAɎusvɑꍇ́A
		// ̃ZOgƂ̋؂ÔPsB
		// ́AŏIZOgŋ؂܂łIB
		//
		if( pLineRead->CheckHead( g_pPauseString )==TRUE ){
			bRes = pLineRead->Read( FALSE );
			if( bRes==FALSE ){
				// ؂ꂽG[
				return FALSE;
			}

			// ̃ZOgʎqɑꍇ́A
			bRes = pLineRead->CheckHead( pNextHeader );
			if( bRes==TRUE ){
				break;
			}

			// sȂ̂ŁAsłB
			bSpacingLine = TRUE;
		}

		// -----< ܂ŗAoׂsB >-----
		//
		// <<< ŏ̍słȂ΁AO̕ɉs >>>
		//
		if( bFirst==TRUE ){
			bFirst = FALSE;
		} else {
			fprintf( pDest , "\n" );
		}

		// <<< o >>>
		//
		// sRs[
		char pLine[ MAX_ONE_LINE ];
		strcpy( pLine , pLineRead->AfterHead( "//\t\t" ) );

		// ^uXy[Xɕϊ
		bRes = ReplaceTab( pLine );
		if( bRes==FALSE ){
			return FALSE;
		}

		// Ō̃^[R[hO
		if( (*pLine!='\n')&&(*pLine!=0) ){	// słȂꍇB
			pLine[ strlen( pLine )-1 ] = 0;
		}

		// o
		fprintf( pDest , "%s" , pLine );
	}

	// -----< I >-----
	//
	fprintf( pDest , "</pre>\n" );
	fprintf( pDest , "    </td>\n" );
	fprintf( pDest , "  </tr>\n" );
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReplaceTab( char* pString )
//
//	[  ]
//		char* pString				^uϊ镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		񒆂̃^uXy[XɕύX܂B
//--------------------------------------------------------------------
BOOL ReplaceTab( char* pString )
{
	// -----< G[`FbN >----
	//
	if( *pString==NULL ){
		return FALSE;
	}

	// -----<  >-----
	//
	char* pWrite;						// p|C^
	char* pWork;						// ǂݗp|C^
	char pLine[ MAX_ONE_LINE ];			// Ɨpobt@

	pWrite	= pString;
	pWork	= pLine;
	strcpy( pLine , pString );

	// -----< Ō܂ŌJԂ >-----
	//
	int iColumn = 0;
	while( *pWork!=0 ){
		// <<< SpÂ܂܂QoCgi߂ >>>
		if(    ((*pWork>0x81) && (*pWork<0x9F))
			|| ((*pWork>0xE0) && (*pWork<0xFC))
		){
			*pWrite++ = *pWork++;
			*pWrite++ = *pWork++;
			iColumn += 2;
			continue;
		}

		// <<< ^ułȂΎ >>>
		if( *pWork!='\t' ){
			*pWrite++ = *pWork++;
			iColumn += 1;
			continue;
		}

		// <<< ^uA𒲐 >>>
		//
		int iSpaceCount;
		iSpaceCount = 4 - (iColumn % 4);

		pWork += 1;						// ^uƂ΂
		for( int i=0;i<iSpaceCount;i++ ){	// Xy[X
			iColumn += 1;
			*pWrite++ = ' ';
		}
	}

	// -----< GhR[h >-----
	//
	*pWrite = 0;
	return TRUE;
}
