//====================================================================
//  ֐dlo
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "LineRead.h"
#include "CPPDocCore.h"

#define MAX_TITLE			4096
#define MAX_RETURNADDRESS	4096

// -----< O[oϐ̐錾 >-----
//
// <<< ̓p[^ >>>
//
char*	g_pSourceFile	= NULL;			// ̓t@C
char*	g_pDestFile		= NULL;			// o̓t@C

// <<< ݒ >>>
//
BOOL	g_bEnglish		= FALSE;		// pꃂ[h
BOOL	g_bOutputFormat	= FALSE;		// tH[}bgo̓[h
BOOL	g_bOutputHelp	= FALSE;		// wvo͂

char	g_pTitle[ MAX_TITLE ];					// ^Cg
char	g_pReturnAddress[ MAX_RETURNADDRESS ];	// ߂AhX

// <<< ʊ֘A >>>
//
BOOL	g_bSuccessMessage = FALSE;		// uɏI܂v\邩ۂ


// -----< ֐̃vg^Cv錾 >-----
//
static BOOL AnalyzeCommandLine( int argc , char* argv[] );
static void PrintHelp();
static void ReleaseAll();


//--------------------------------------------------------------------
//	[  ]
//		int main( int argc , char* argv[] )
//
//	[  ]
//		int   argc					̐
//		char* argv[]				̒l
//
//	[ ߂l ]
//		GhR[h
//
//	[  ]
//		main ֐
//--------------------------------------------------------------------
int main( int argc , char* argv[] )
{
	BOOL bRes;

	// -----<  >-----
	//
	g_pSourceFile	= NULL;				// ̓t@C
	g_pDestFile		= NULL;				// o̓t@C
	memset( g_pTitle , 0 , MAX_TITLE );
	memset( g_pReturnAddress , 0 , MAX_RETURNADDRESS );

	// -----< R}hC >-----
	//
	bRes = AnalyzeCommandLine( argc , argv );
	if( bRes==FALSE ){
		printf( "R}hC͂Ɏs܂B\n" );
		ReleaseAll();
		return -1;
	}

	// -----< wvo >-----
	//
	if( g_bOutputHelp ){
		PrintHelp();
		return 0;
	}

	// -----< tH[}bgo͎wȂtH[}bgo >-----
	//
	if( g_bOutputFormat ){
		// tH[}bgo
		if( g_bEnglish ){
			OutputEnglishFormat( stdout );		// pŃtH[}bgo
			ReleaseAll();
			return 0;
		} else {
			OutputJapaneseFormat( stdout );		// {ŃtH[}bgo
			ReleaseAll();
			return 0;
		}
	}

	// -----< s >-----
	//
	bRes = ExecCPPDoc( g_pSourceFile , g_pDestFile , g_bEnglish
				, g_pTitle , g_pReturnAddress );
	if( bRes==FALSE ){
		ReleaseAll();
		return -1;
	}
	g_bSuccessMessage = TRUE;

	// -----< I >-----
	//
	ReleaseAll();
	if( g_bSuccessMessage ){
		printf( "ɏI܂B\n" );
	}
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AnalyzeCommandLine( int argc , char* argv[] )
//
//	[  ]
//		int   argc					̐
//		char* argv[]				̒l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		R}hC͂AeO[oϐɔf܂B
//--------------------------------------------------------------------
static BOOL AnalyzeCommandLine( int argc , char* argv[] )
{
	// -----< R}ĥ݂ȂAwv\ďI >-----
	//
	if( argc==1 ){
		g_bOutputHelp	= TRUE;
		return TRUE;
	}

	// -----< ɌĂ >-----
	//
	long i;
	for( i=1;i<argc;i++ ){
		// <<< 擪 - ȂIvV >>>
		//
		if( *(argv[i])=='-' ){
			// pꃂ[h
			if( *(argv[i]+1)=='e' ){
 				g_bEnglish		= TRUE;
				continue;
			}

			// tH[}bgo͎w
			if( *(argv[i]+1)=='f' ){
				g_bOutputFormat = TRUE;
				continue;
			}

			// wvo͎w
			if( *(argv[i]+1)=='h' ){
				g_bOutputHelp	= TRUE;
				continue;
			}

			// ^Cgw
			if( *(argv[i]+1)=='t' ){
				i += 1;
				if( i>=argc ){
					return FALSE;
				}

				strcpy( g_pTitle , argv[i] );
				continue;
			}

			// ^[AhXw
			if( *(argv[i]+1)=='r' ){
				i += 1;
				if( i>=argc ){
					return FALSE;
				}

				strcpy( g_pReturnAddress , argv[i] );
				continue;
			}

			// ܂ŗG[
			printf( "sȃIvVw肳܂B[%s]\n" , argv[i] );
			return TRUE;
		}

		// <<< 擪 - łȂ΃t@C >>>
		//
		// Rڂ̃t@Cw肳ꂽG[
		if( (g_pSourceFile!=NULL)&&(g_pDestFile!=NULL) ){
			printf( "R}hCɊԈႢ܂B\n" );
			return TRUE;
		}

		// ̓t@Cw
		if( g_pSourceFile==NULL ){
			g_pSourceFile	= argv[i];
			continue;
		}

		// o̓t@Cw
		if( g_pDestFile==NULL ){
			g_pDestFile		= argv[i];
			continue;
		}

		// ܂ŗ킫ȂB
	}

	// -----< ʊmF >-----
	//
	// ̓t@Co̓t@CȂ΃wv\
	if( g_bOutputFormat==FALSE ){
		if( g_pSourceFile==NULL ){
			g_bOutputHelp = TRUE;
			return TRUE;
		}
	}

	// tH[}bgwł͂ȂAo̓t@Cw肪ĂȂꍇ̓p[^s
	if( g_bOutputFormat==FALSE ){
		if( g_pDestFile==NULL ){
			printf( "܂B\n" );
			return TRUE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void PrintHelp()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Wo͂Ƀwvo͂܂B
//--------------------------------------------------------------------
static void PrintHelp()
{
	printf( "<<< CPPDoc >>> Version1.0 Programmed by GTN.                      \n" );

	if( g_bEnglish ){
		// -----< pgp@ >-----
		//
		printf( "[USAGE]                                                           \n" );
		#ifdef __SYSTEM_WINDOWS__
		printf( "    C:\\dir> CPPDoc [SrcFile] [DstFile]                            \n" );
		#else
		printf( "    % CPPDoc [SrcFile] [DstFile]                                  \n" );
		#endif
		printf( "                                                                  \n" );
		printf( "[Parameters]                                                      \n" );
		printf( "    SecFile    Source file name                                   \n" );
		printf( "    DstFile    Output file name                                   \n" );
		printf( "                                                                  \n" );
		printf( "[Option]                                                          \n" );
		printf( "    -e         English mode                                       \n" );
		printf( "    -f         Output function header format.                     \n" );
		printf( "    -t [title] Set title string.                                  \n" );
		printf( "    -r [url]   Set return address.                                \n" );
		printf( "    -h         Output help.                                       \n" );
		printf( "                                                                  \n" );
		printf( "[Remarks]                                                         \n" );
		printf( "    This program makes function specification manual by HTML from \n" );
		printf( "    C++ source file which has function header witten in specific  \n" );
		printf( "    format.                                                       \n" );
		printf( "    Source file must contain function header by specific format.  \n" );
		printf( "    If you needs the function header format , execute this program\n" );
		printf( "    with option '-f'.                                             \n" );
		printf( "                                                                  \n" );
		printf( "    <note> Japanese format will be output by default setting.     \n" );
		printf( "           If you need english format , execute with '-e' option. \n" );
	} else {
		// -----< {gp@ >-----
		//
		printf( "[gp@]                                                          \n" );
		#ifdef __SYSTEM_WINDOWS__
		printf( "    C:\\dir> CPPDoc [SrcFile] [DstFile]                            \n" );
		#else
		printf( "    % CPPDoc [SrcFile] [DstFile]                                  \n" );
		#endif
		printf( "                                                                  \n" );
		printf( "[]                                                            \n" );
		printf( "    SecFile    ̓t@C                                     \n" );
		printf( "    DstFile    o̓t@C                                     \n" );
		printf( "                                                                  \n" );
		printf( "[IvV]                                                      \n" );
		printf( "    -e         English modeipꃂ[hj                         \n" );
		printf( "    -f         ֐wb_̃tH[}bgo͂܂B             \n" );
		printf( "    -t [title] ^Cgݒ肵܂B                             \n" );
		printf( "    -r [url]   ߂tqkݒ肵܂B                         \n" );
		printf( "    -h         wv\܂B                               \n" );
		printf( "                                                                  \n" );
		printf( "[]                                                            \n" );
		printf( "    ̃vÓAC++̃\[XɋLqꂽRg       \n" );
		printf( "    ֐wb_oAɋLqĂ֐dl𒊏o  \n" );
		printf( "    HTMLŏo͂邽߂̂̂łB                                \n" );
		printf( "    ֐dlo͂邽߂ɂ́A\[Xt@C                \n" );
		printf( "    ̃tH[}bgŋLqꂽ֐wb_܂ł          \n" );
		printf( "    Kv܂B                                              \n" );
		printf( "    ֐wb_̃tH[}bgKvȏꍇ́A-f IvV \n" );
		printf( "    ̃vOsĂB                            \n" );
		printf( "                                                                  \n" );
		printf( "    <>                                                          \n" );
		printf( "    ftHg̏Ԃł́A{̃tH[}bgo͂܂B    \n" );
		printf( "    p̃tH[}bgKvȏꍇ́A-e IvVĎs   \n" );
		printf( "    ĂB                                                \n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseAll()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		AvP[V̂߂Ɋmۂ\[XSĉ܂B
//--------------------------------------------------------------------
static void ReleaseAll()
{
	// Nothing to do.
}
