//-------------------------------------------------------------------------
//  DrawUnit TvvO
//-------------------------------------------------------------------------
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>
#include <time.h>
#include <d3d9.h>
#include <d3dx9core.h>

// -----< CũCN[h >-----
//
#include "WaitForSync.h"
#include "LogFile.h"
#include "Utils.h"
#include "SDrawUnit.h"
#include "TRControl.h"

// -----< AvP[V֘ÃCN[h >-----
//
#include "Procedure.h"
#include "Game.h"


// -----< satic , globalϐ̐錾 >-----
//
static BOOL	s_bFullScreen;					// tXN[ɂ邩ۂ

CLogFile	g_objDebugLog;					// fobOO
CLogFile	g_objErrorLog;					// G[O
CSDrawUnit*	g_pDrawUnit		= NULL;			// DrawUnit
CGame*		g_pGame			= NULL;			// Q[IuWFNg
CTRControl*	g_pTRControl	= NULL;			// ^Op֐

HWND hWnd;									// EBhEnh


// -----< ֐̃vg^Cv錾 >-----
//
BOOL		Initialize();					// 
void		ReleaseAll();					// 
BOOL		OnOneFrame();					// Pt[̏

// -----< 萔` >-----
//
long g_lScreenWidth		= 640;
long g_lScreenHeight	= 480;
long g_lRotQDivision	= 4;
long g_lZoomRatio		= 6;

//--------------------------------------------------------------------
//	[  ]
//		int WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
//
//	[  ]
//		HINSTANCE	hInstance			
//		HINSTANCE	hPrevInstance		
//		LPSTR		lpCmdLine			
//		int			nCmdShow			
//
//	[ ߂l ]
//		vZX̏IR[h
//
//	[  ]
//		 WinMain ֐
//--------------------------------------------------------------------
int WINAPI WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
{
	BOOL	bRes;

//	s_bFullScreen = FALSE;
	s_bFullScreen = TRUE;

	//----------< EBhENX̍쐬 >----------
	//
	WNDCLASSEX	wc;													// Window Class \

	wc.cbSize			= sizeof( WNDCLASSEX );						// \̂̃TCY
	wc.style			= CS_HREDRAW | CS_VREDRAW;					// X^C
	wc.lpfnWndProc		= WindowProc;								// vVWւ̃|C^
	wc.cbClsExtra		= 0;										// ExtraȂ
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;								// CX^Xnh
	wc.hIcon			= LoadIcon(hInstance,IDI_APPLICATION);		// ACR
	wc.hCursor			= LoadCursor(NULL,IDC_ARROW);				// J[\
	wc.hbrBackground	= NULL;										// wiuV
	wc.lpszMenuName		= 0;										// j[Ȃ
	wc.lpszClassName	= "EneShots";								// Window class 
	wc.hIconSm			= NULL;										// X[ACR̃nh NULL hIcongpB


	//----------< EBhE̓o^ƍ쐬 >----------
	//
	DWORD	dwStyle;
	if( s_bFullScreen )	dwStyle = WS_OVERLAPPED|WS_POPUP|WS_VISIBLE;
	else				dwStyle = WS_CAPTION|WS_OVERLAPPED|WS_POPUP|WS_SYSMENU|WS_VISIBLE;

	RegisterClassEx( &wc );											// o^
	hWnd = CreateWindowEx(											// 쐬
		0,															// EBhEX^C
		wc.lpszClassName,											// EBhENX
		"DrawUnit test",											// ^Cg
		dwStyle,													// X^C
		0,															// \ʒu
		0,
		100,														// TCY
		100,
		NULL,														// eEBhEȂ
		NULL,														// j[Ȃ
		hInstance,													// CX^X̃nh
		NULL														// ǉȂ
		);
	if( hWnd==NULL ){
		MessageBox( NULL , "EBhE̍쐬Ɏs܂B" , "Error" , MB_OK );
		return( 1 );
	}

	//----------< EBhETCY >----------
	//
	RECT sClientRect;
	GetClientRect( hWnd , &sClientRect );
	MoveWindow( hWnd, 0, 0, 100 + (g_lScreenWidth-sClientRect.right), 100 + (g_lScreenHeight-sClientRect.bottom) , TRUE );

	//----------< EBhE̕\ >----------
	//
	ShowWindow( hWnd,nCmdShow );				// EBhEԂɂ
	UpdateWindow( hWnd );						// EBhE̍XV
	SetFocus( hWnd );							// tH[JX̃EBhEɂ
	if( s_bFullScreen ){
		ShowCursor( FALSE );					// J[\
	} else {
		// Nothing to do.
	}


	// ---------<  >----------
	//
	bRes = Initialize();
	if( bRes==FALSE ){
		ShowWindow( hWnd , SW_HIDE );
		DestroyWindow( hWnd );
		UnregisterClass( wc.lpszClassName , hInstance );
		ShowCursor( TRUE );

		MessageBox( NULL , "AvP[V̏Ɏs܂B" , "Error" , MB_OK );
		return 1;
	}


	//----------< bZ[W[v >----------
	//
	MSG			msg;								// Window bZ[W

	WaitForSync( 1000/60 );							// ̏
	while(1){
		// -----< Pt[̏s >-----
		//
		bRes = OnOneFrame();
		if( bRes==FALSE ){
			g_objDebugLog.ErrorLog( "::main : Pt[̏ŃG[܂B\n" );
			break;
		}

		// -----< WindowsbZ[W̏ >-----
		//
		if( PeekMessage( &msg,hWnd,0,0,PM_NOREMOVE ) ){		// bZ[WDispatch
			if( !GetMessage( &msg,NULL,0,0 ) )break;		// [vĨbZ[WȂI
			TranslateMessage(&msg);							// gX[g
			DispatchMessage(&msg);							// fBXpb`
		}
 	}

	// ----------< AvP[V̏I >----------
	//
	ReleaseAll();									// SĂ

	DestroyWindow( hWnd );
	ShowCursor( TRUE );

	return msg.wParam;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		vȌs܂B
//--------------------------------------------------------------------
BOOL Initialize()
{
	BOOL bRes;

	// -----< fobOOJn >-----
	//
	bRes = g_objDebugLog.SetFileName( "debug.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objDebugLog.SetMode( LOGFILE_DEBUG );

	// -----< G[OJn >-----
	//
	g_objErrorLog.SetFileName( "error.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objErrorLog.SetMode( LOGFILE_DEBUG );

	CUtils::SetDebugLog( &g_objDebugLog );
	CUtils::SetErrorLog( &g_objErrorLog );


	// -----< DrawUnit  >-----
	//
	// <<< \z >>>
	g_pDrawUnit = CSDrawUnit::CreateSDrawUnit();
	if( g_pDrawUnit==NULL ){
		g_objDebugLog.ErrorLog( "::main : CSDrawUnit̍쐬Ɏs܂B\n" );
		return FALSE;
	}

	// <<<  >>>
	SDUDeviceInfo sDeviceInfo;
	sDeviceInfo.m_hWnd = hWnd;
	bRes = g_pDrawUnit->Initialize( &sDeviceInfo , g_lScreenWidth , g_lScreenHeight , s_bFullScreen , 60 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : CSDrawUnitIuWFNg̏Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	g_pDrawUnit->SetLayers( 5 );

	// -----< Op֐\z >-----
	//
	g_pTRControl = new CTRControl( g_lRotQDivision , g_lZoomRatio );
	if( g_pTRControl==NULL ){
		g_objDebugLog.ErrorLog( "::main : ^Op֐\zł܂łB\n" );
		ReleaseAll();
		return FALSE;
	}


	// -----< Q[\z >-----
	//
	g_pGame	= new CGame;
	if( g_pGame==NULL ){
		g_objDebugLog.ErrorLog( "::main : CGameIuWFNg̍쐬Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	bRes = g_pGame->Initialize();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : CGameIuWFNg̏Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

//	// -----< eLXgEBhE >-----
//	//
//	RECT rect;
//	rect.top = 32;
//	rect.left = 32;
//	rect.right = 500;
//	rect.bottom = 150;
//	g_pDGControl->AddTW();
//	g_pDGControl->InitializeTW(
//						  0
//						, rect
//						, 1024 , 8,16
//						, FALSE , FALSE , FALSE , FALSE
//						, "lr SVbN" );

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseAll()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		vOIOɌĂԁB
//--------------------------------------------------------------------
void ReleaseAll()
{
	// TRControl
	if( g_pTRControl!=NULL ){
		delete g_pTRControl;
	}
	g_pTRControl = NULL;

	// Game ̉
	if( g_pGame!=NULL ){
		delete g_pGame;
	}
	g_pGame	= NULL;

	// DirectGraphics control ̉
	if( g_pDrawUnit!=NULL ){
		CSDrawUnit::DeleteSDrawUnit();
	}
	g_pDrawUnit = NULL;


	// I
	return;
}



//--------------------------------------------------------------------
//	[  ]
//		void OnOneFrame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Pt[̏s
//--------------------------------------------------------------------
BOOL OnOneFrame()
{
	BOOL bRes;
	BOOL bDoDraw;
	static long lFrameCount = -1;
	static long lFrameSkipped	= 0;

	// -----< EFCg違tbv >-----
	//
	bDoDraw = WaitForSync();

	// XLbv̂Ƃ́AIɈx`悳B
	if( bDoDraw==FALSE ){
		lFrameSkipped += 1;
		if( lFrameSkipped>=10 ){
			bDoDraw = TRUE;
			lFrameSkipped	= 0;
//			g_pDGControl->AddTWString( 0 , "Force to draw occured." );
		}
	}

	// tbv\ȂƂɂ̓tbv
	if( g_pGame->FlipReady()==TRUE ){		// DrawԂɍĂȂ`\
		g_pGame->Flip();					// `揈
	}


	// -----< t[𐔂 >-----
	//
	lFrameCount	+= 1;

	// -----< s >-----
	//
	if( g_pGame!=NULL ){
		bRes = g_pGame->OnOneFrame( lFrameCount );
	}
	if( bRes==FALSE ){
		return FALSE;
	}

	// -----< `揈 >-----
	//
	if( bDoDraw==TRUE ){
//		g_pDGControl->StartToDraw();

		g_pGame->Draw();
		lFrameSkipped	= 0;

//		// -----< eLXgEBhE`揈 >-----
//		//
//		static int countcheck=0;
//		static DWORD time_start	= 0;
//		static DWORD time_end	= 0;
//		countcheck += 1;
//
//		if( countcheck==60 ){
//			DWORD time_span = 0;
//			DWORD frames = 0;
//
//			countcheck = 0;								// r߂
//			time_end = timeGetTime();					// Ƃ
//			if( time_start!=0 ){						// ŏłȂ΁A
//				time_span = time_end - time_start;		// ^CXpZo
//				frames = (60*1000) / ( time_span );		// t[[gZo
//			}
//			time_start = time_end;						// XV
//
//			g_pDGControl->AddTWString( 0 , "FPS = %d" , frames );
//		}
//		bRes = g_pDGControl->DrawTW( 0 );
//		if( bRes==FALSE ){
//			g_pDGControl->EndToDraw();
//			return FALSE;
//		}

//		g_pDGControl->EndToDraw();
		g_pDrawUnit->DrawLayers();
	}

	return TRUE;
}
