//-------------------------------------------------------------------------
//  DGControl TvvO
//-------------------------------------------------------------------------
#include "system.h"
#include "DGDXInclude.h"
#include <time.h>


// -----< CũCN[h >-----
//
#include "WaitForSync.h"
#include "LogFile.h"
#include "Utils.h"
#include "DGControl.h"


// -----< AvP[V֘ÃCN[h >-----
//
#include "Procedure.h"


// -----< satic , globalϐ̐錾 >-----
//
static BOOL	s_bFullScreen;					// tXN[ɂ邩ۂ

CLogFile	g_objDebugLog;					// fobOO
CLogFile	g_objErrorLog;					// G[O
CDGControl*	g_pDGControl = NULL;			// DGControl

HWND hWnd;									// EBhEnh


// -----< ֐̃vg^Cv錾 >-----
//
BOOL		Initialize();					// 
void		ReleaseAll();					// 
void		OnOneFrame();					// Pt[̏

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480

//--------------------------------------------------------------------
//	[  ]
//		int WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
//
//	[  ]
//		HINSTANCE	hInstance			
//		HINSTANCE	hPrevInstance		
//		LPSTR		lpCmdLine			
//		int			nCmdShow			
//
//	[ ߂l ]
//		vZX̏IR[h
//
//	[  ]
//		 WinMain ֐
//--------------------------------------------------------------------
int WINAPI WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
{
	BOOL	bRes;

	s_bFullScreen = FALSE;

	//----------< EBhENX̍쐬 >----------
	//
	WNDCLASSEX	wc;													// Window Class \

	wc.cbSize			= sizeof( WNDCLASSEX );						// \̂̃TCY
	wc.style			= CS_HREDRAW | CS_VREDRAW;					// X^C
	wc.lpfnWndProc		= WindowProc;								// vVWւ̃|C^
	wc.cbClsExtra		= 0;										// ExtraȂ
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;								// CX^Xnh
	wc.hIcon			= LoadIcon(hInstance,IDI_APPLICATION);		// ACR
	wc.hCursor			= LoadCursor(NULL,IDC_ARROW);				// J[\
	wc.hbrBackground	= NULL;										// wiuV
	wc.lpszMenuName		= 0;										// j[Ȃ
	wc.lpszClassName	= "DGControl Test";							// Window class 
	wc.hIconSm			= NULL;										// X[ACR̃nh NULL hIcongpB


	//----------< EBhE̓o^ƍ쐬 >----------
	//
	DWORD	dwStyle;
	if( s_bFullScreen )	dwStyle = WS_OVERLAPPED|WS_POPUP|WS_VISIBLE;
	else				dwStyle = WS_CAPTION|WS_OVERLAPPED|WS_POPUP|WS_SYSMENU|WS_VISIBLE;

	RegisterClassEx( &wc );											// o^
	hWnd = CreateWindowEx(											// 쐬
		0,															// EBhEX^C
		wc.lpszClassName,											// EBhENX
		"DGControl test",											// ^Cg
		dwStyle,													// X^C
		0,															// \ʒu
		0,
		100,														// TCY
		100,
		NULL,														// eEBhEȂ
		NULL,														// j[Ȃ
		hInstance,													// CX^X̃nh
		NULL														// ǉȂ
		);
	if( hWnd==NULL ){
		MessageBox( NULL , "EBhE̍쐬Ɏs܂B" , "Error" , MB_OK );
		return( 1 );
	}

	//----------< EBhETCY >----------
	//
	RECT sClientRect;
	GetClientRect( hWnd , &sClientRect );
	MoveWindow( hWnd, 0, 0, 100 + (SCREEN_WIDTH-sClientRect.right), 100 + (SCREEN_HEIGHT-sClientRect.bottom) , TRUE );

	//----------< EBhE̕\ >----------
	//
	ShowWindow( hWnd,nCmdShow );				// EBhEԂɂ
	UpdateWindow( hWnd );						// EBhE̍XV
	SetFocus( hWnd );							// tH[JX̃EBhEɂ
	if( s_bFullScreen ){
		ShowCursor( FALSE );					// J[\
	} else {
		// Nothing to do.
	}


	// ---------<  >----------
	//
	bRes = Initialize();
	if( bRes==FALSE ){
		ShowWindow( hWnd , SW_HIDE );
		DestroyWindow( hWnd );
		UnregisterClass( wc.lpszClassName , hInstance );
		ShowCursor( TRUE );

		MessageBox( NULL , "AvP[V̏Ɏs܂B" , "Error" , MB_OK );
		return 1;
	}


	//----------< bZ[W[v >----------
	//
	MSG			msg;								// Window bZ[W

	WaitForSync( 1000/60 );							// ̏
	while(1){
		// -----< Pt[̏s >-----
		//
		OnOneFrame();

		// -----< WindowsbZ[W̏ >-----
		//
		if( PeekMessage( &msg,NULL,0,0,PM_NOREMOVE ) ){		// bZ[WDispatch
			if( !GetMessage( &msg,NULL,0,0 ) )break;		// [vĨbZ[WȂI
			TranslateMessage(&msg);							// gX[g
			DispatchMessage(&msg);							// fBXpb`
		}
 	}

	// ----------< AvP[V̏I >----------
	//
	ReleaseAll();									// SĂ

	DestroyWindow( hWnd );
	ShowCursor( TRUE );

	return msg.wParam;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		vȌs܂B
//--------------------------------------------------------------------
BOOL Initialize()
{
	BOOL bRes;

	// -----< fobOOJn >-----
	//
	bRes = g_objDebugLog.SetFileName( "debug.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objDebugLog.SetMode( LOGFILE_DEBUG );

	// -----< G[OJn >-----
	//
	g_objErrorLog.SetFileName( "error.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objErrorLog.SetMode( LOGFILE_DEBUG );

	CUtils::SetDebugLog( &g_objDebugLog );
	CUtils::SetErrorLog( &g_objErrorLog );

	// -----< DGControl  >-----
	//
	// <<< \z >>>
	g_pDGControl = CDGControl::GetInstance();
	if( g_pDGControl==NULL ){
		g_objDebugLog.ErrorLog( "::main : CDGControl̍쐬Ɏs܂B\n" );
		return FALSE;
	}

	// <<<  >>>
	bRes = g_pDGControl->Initialize( hWnd , s_bFullScreen , SCREEN_WIDTH , SCREEN_HEIGHT , 60 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : CDGControlIuWFNg̏Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// <<< Aʏݒ >>>
	bRes	= g_pDGControl->SetCullMode( FALSE );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : AʏݒɎs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// <<< yobt@gpݒ >>>
	bRes	= g_pDGControl->SetZBufferMode( FALSE );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : yobt@gpݒɎs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// -----< XvCg >-----
	//
	RECT rect;
	rect.left	= 248;
	rect.top	= 410;
	rect.right	= 248+87-1;
	rect.bottom	= 410+25-1;
//248,410 , 87,25
//	g_pDGControl->AddTextureForSprite( "images/mecha3.bmp" , 0xFF00FF00 );
	g_pDGControl->AddTextureForSprite( "images/Frame_lu.dds" , 0xFF00FF00 );
	g_pDGControl->AddSprite( 0 );
	g_pDGControl->SetSpriteRect( 0 , rect );
	g_pDGControl->SetSpriteCenter( 0 , 0,0 );

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseAll()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		vOIOɌĂԁB
//--------------------------------------------------------------------
void ReleaseAll()
{
	// DirectGraphics control ̉
	if( g_pDGControl!=NULL ){
		CDGControl::DeleteInstance();
	}
	g_pDGControl = NULL;


	// I
	return;
}



//--------------------------------------------------------------------
//	[  ]
//		void OnOneFrame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Pt[̏s
//--------------------------------------------------------------------
void OnOneFrame()
{
	BOOL		bRes;
	BOOL		bTimeToDraw	= FALSE;			// `̃^C~Oۂ
	BOOL		bDrawReady	= FALSE;			// t[̕`悪łۂ


	// -----< ҂ĉʂɕ\ >-----
	//
	bTimeToDraw = WaitForSync();				// 
	bDrawReady = TRUE;
	if( bDrawReady ){
		// `iobNobt@tgobt@ցj
		bRes = g_pDGControl->Flip();
	}

	// -----< `Jn >-----
	//
	bRes = g_pDGControl->StartToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `Jnł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}

	// -----< XvCg`揈 >-----
	//
	static float fRotation = 0.0f;
	static long  lX  = 320;
	static long  lY  = 240;
	static long  lVx = 1;
	static long  lVy = 1;

	fRotation	+= 0.01f;
	if( lX>640 )lVx = -1;
	if( lY>480 )lVy = -2;
	if( lX<0   )lVx =  2;
	if( lY<0   )lVy =  1;
	lX			+= lVx;
	lY			+= lVy;
/*
	bRes = g_pDGControl->DrawSprite(
				  0						// SP Index
				, lX					// X Position
				, lY					// Y Position
				, fRotation				// rotation
				, 2.0f					// scaling x
				, 1.0f					// scaling y
				, 0xFFFFFFFF			// Diffuse
				, 0.0f					// Z Axis position
				);
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : XvCg`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}
*/
	static long offset=0;
	static float fz = 0.f;
//	static long xx=38+95,yy=0+167;
	static long xx=0,yy=0;
//	offset +=1;
	bRes = g_pDGControl->DrawSprite(
				  0						// SP Index
				, xx+offset					// X Position
				, yy+offset					// Y Position
				,0,1,1
				, 0xFFFFFFFF			// Diffuse
				, fz					// Z Axis position
				);
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : XvCg`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}

	// -----< `I >-----
	//
	bRes = g_pDGControl->EndToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}
}
