//====================================================================
//  ^}
//====================================================================
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "system.h"
#include "Shot.h"
#include "DGControl.h"

extern long g_lScreenWidth;
extern long g_lScreenHeight;
extern CDGControl* g_pDGControl;

#define ZOOM	6
#define SPEED	3

CShot::CShot()
{
	Release();
}

CShot::~CShot()
{
}

void CShot::Release()
{
	m_bExists	= FALSE;
	m_lX		= 0;
	m_lY		= 0;
	m_lZx		= 0;
	m_lZy		= 0;
	m_lVx		= 0;
	m_lVy		= 0;
	m_lPattern	= 0;
	m_lPatternCount	= 0;
}


BOOL CShot::Appear( long lX , long lY , long lVx , long lVy )
{
	m_lX	= lX;
	m_lY	= lY;
	m_lVx	= lVx;
	m_lVy	= lVy;
	m_lZx	= m_lX << ZOOM;
	m_lZy	= m_lY << ZOOM;
	m_bExists	= TRUE;
	m_lPattern	= rand() % 4;
	m_lPatternCount	= 0;
	return TRUE;
}

BOOL CShot::IsExists()
{
	return m_bExists;
}

BOOL CShot::Move()
{
	m_lZx	+= m_lVx * SPEED;
	m_lZy	+= m_lVy * SPEED;
	m_lX	= m_lZx >> ZOOM;
	m_lY	= m_lZy >> ZOOM;

	if( m_lX > g_lScreenWidth ){
		m_bExists	= FALSE;
	}
	if( m_lY > g_lScreenWidth ){
		m_bExists	= FALSE;
	}

	if( m_lX < 0 ){
		m_bExists	= FALSE;
	}
	if( m_lY < 0 ){
		m_bExists	= FALSE;
	}

	m_lPatternCount += 1;
	if( m_lPatternCount >= 6 ){
		m_lPatternCount	= 0;
		m_lPattern += 1;
		m_lPattern %= 4;
	}

	return TRUE;
}

BOOL CShot::Draw()
{
	g_pDGControl->DrawSprite( m_lPattern , m_lX , m_lY );
	return TRUE;
}
