//-------------------------------------------------------------------------
//  DGControl TvvO
//-------------------------------------------------------------------------
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>
#include <time.h>
#include <d3d9.h>
#include <d3dx9core.h>

// -----< CũCN[h >-----
//
#include "WaitForSync.h"
#include "LogFile.h"
#include "Utils.h"
#include "DGControl.h"

// -----< AvP[V֘ÃCN[h >-----
//
#include "Procedure.h"


// -----< satic , globalϐ̐錾 >-----
//
static BOOL	s_bFullScreen;					// tXN[ɂ邩ۂ

CLogFile	g_objDebugLog;					// fobOO
CLogFile	g_objErrorLog;					// G[O
CDGControl*	g_pDGControl = NULL;			// DGControl

HWND hWnd;									// EBhEnh


// -----< ֐̃vg^Cv錾 >-----
//
BOOL		Initialize();					// 
void		ReleaseAll();					// 
void		OnOneFrame();					// Pt[̏


// ȉARIuWFNg֘ABQcgȂ̂ŏȗ܂B
//// -----< ^錾 >-----
////
//typedef struct _SVertexForm{
//	float	x,y,z;
//	float	rhw;
//	DWORD	color;
//	DWORD	specular;
//	float	tu0,tv0;
//}SVertexForm;
//
//#define D3DFVF_TLVERTEX	( D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_SPECULAR | D3DFVF_TEX1 )

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480

//--------------------------------------------------------------------
//	[  ]
//		int WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
//
//	[  ]
//		HINSTANCE	hInstance			
//		HINSTANCE	hPrevInstance		
//		LPSTR		lpCmdLine			
//		int			nCmdShow			
//
//	[ ߂l ]
//		vZX̏IR[h
//
//	[  ]
//		 WinMain ֐
//--------------------------------------------------------------------
int WINAPI WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
{
	BOOL	bRes;

	s_bFullScreen = TRUE;

	//----------< EBhENX̍쐬 >----------
	//
	WNDCLASSEX	wc;													// Window Class \

	wc.cbSize			= sizeof( WNDCLASSEX );						// \̂̃TCY
	wc.style			= CS_HREDRAW | CS_VREDRAW;					// X^C
	wc.lpfnWndProc		= WindowProc;								// vVWւ̃|C^
	wc.cbClsExtra		= 0;										// ExtraȂ
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;								// CX^Xnh
	wc.hIcon			= LoadIcon(hInstance,IDI_APPLICATION);		// ACR
	wc.hCursor			= LoadCursor(NULL,IDC_ARROW);				// J[\
	wc.hbrBackground	= NULL;										// wiuV
	wc.lpszMenuName		= 0;										// j[Ȃ
	wc.lpszClassName	= "DGControl Test";							// Window class 
	wc.hIconSm			= NULL;										// X[ACR̃nh NULL hIcongpB


	//----------< EBhE̓o^ƍ쐬 >----------
	//
	DWORD	dwStyle;
	if( s_bFullScreen )	dwStyle = WS_OVERLAPPED|WS_POPUP|WS_VISIBLE;
	else				dwStyle = WS_CAPTION|WS_OVERLAPPED|WS_POPUP|WS_SYSMENU|WS_VISIBLE;

	RegisterClassEx( &wc );											// o^
	hWnd = CreateWindowEx(											// 쐬
		0,															// EBhEX^C
		wc.lpszClassName,											// EBhENX
		"DGControl test",											// ^Cg
		dwStyle,													// X^C
		0,															// \ʒu
		0,
		100,														// TCY
		100,
		NULL,														// eEBhEȂ
		NULL,														// j[Ȃ
		hInstance,													// CX^X̃nh
		NULL														// ǉȂ
		);
	if( hWnd==NULL ){
		MessageBox( NULL , "EBhE̍쐬Ɏs܂B" , "Error" , MB_OK );
		return( 1 );
	}

	//----------< EBhETCY >----------
	//
	RECT sClientRect;
	GetClientRect( hWnd , &sClientRect );
	MoveWindow( hWnd, 0, 0, 100 + (SCREEN_WIDTH-sClientRect.right), 100 + (SCREEN_HEIGHT-sClientRect.bottom) , TRUE );

	//----------< EBhE̕\ >----------
	//
	ShowWindow( hWnd,nCmdShow );				// EBhEԂɂ
	UpdateWindow( hWnd );						// EBhE̍XV
	SetFocus( hWnd );							// tH[JX̃EBhEɂ
	if( s_bFullScreen ){
		ShowCursor( FALSE );					// J[\
	} else {
		// Nothing to do.
	}


	// ---------<  >----------
	//
	bRes = Initialize();
	if( bRes==FALSE ){
		ShowWindow( hWnd , SW_HIDE );
		DestroyWindow( hWnd );
		UnregisterClass( wc.lpszClassName , hInstance );
		ShowCursor( TRUE );

		MessageBox( NULL , "AvP[V̏Ɏs܂B" , "Error" , MB_OK );
		return 1;
	}


	//----------< bZ[W[v >----------
	//
	MSG			msg;								// Window bZ[W

	WaitForSync( 1000/60 );							// ̏
	while(1){
		// -----< Pt[̏s >-----
		//
		OnOneFrame();

		// -----< WindowsbZ[W̏ >-----
		//
		if( PeekMessage( &msg,NULL,0,0,PM_NOREMOVE ) ){		// bZ[WDispatch
			if( !GetMessage( &msg,NULL,0,0 ) )break;		// [vĨbZ[WȂI
			TranslateMessage(&msg);							// gX[g
			DispatchMessage(&msg);							// fBXpb`
		}
 	}

	// ----------< AvP[V̏I >----------
	//
	ReleaseAll();									// SĂ

	DestroyWindow( hWnd );
	ShowCursor( TRUE );

	return msg.wParam;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		vȌs܂B
//--------------------------------------------------------------------
BOOL Initialize()
{
	BOOL bRes;

	// -----< fobOOJn >-----
	//
	bRes = g_objDebugLog.SetFileName( "debug.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objDebugLog.SetMode( LOGFILE_DEBUG );

	// -----< G[OJn >-----
	//
	g_objErrorLog.SetFileName( "error.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objErrorLog.SetMode( LOGFILE_DEBUG );

	CUtils::SetDebugLog( &g_objDebugLog );
	CUtils::SetErrorLog( &g_objErrorLog );

	// -----< DGControl  >-----
	//
	// <<< \z >>>
	g_pDGControl = CDGControl::GetInstance();
	if( g_pDGControl==NULL ){
		g_objDebugLog.ErrorLog( "::main : CDGControl̍쐬Ɏs܂B\n" );
		return FALSE;
	}

	// <<<  >>>
	bRes = g_pDGControl->Initialize( hWnd , s_bFullScreen , SCREEN_WIDTH , SCREEN_HEIGHT , 60 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : CDGControlIuWFNg̏Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}


	// -----< XvCg >-----
	//
	RECT rect;
	rect.top	= 0;
	rect.left	= 0;
	rect.right	= 493;
	rect.bottom	= 199;
	g_pDGControl->AddTextureForSprite( "images/texture.bmp" , 0xFF00FF00 );
	g_pDGControl->AddSprite( 0 );
	g_pDGControl->SetSpriteRect( 0 , rect );
	g_pDGControl->SetSpriteCenter( 0 , 247 , 100 );

	// -----< OtBbN >-----
	//
	rect.top	= 0;
	rect.left	= 0;
	rect.right	= 639;
	rect.bottom	= 479;
	g_pDGControl->AddTextureForGraphic( "images/back.bmp" , 0x00000000 );
	g_pDGControl->AddGraphic( 1 );
	g_pDGControl->SetGraphicView( 0 , rect );

	// -----< eLXgEBhE >-----
	//
	rect.top = 32;
	rect.left = 32;
	rect.right = 500;
	rect.bottom = 150;
	g_pDGControl->AddTW();
	g_pDGControl->InitializeTW(
						  0
						, rect
						, 1024 , 8,16
						, FALSE , FALSE , FALSE , FALSE
						, "lr SVbN" );

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseAll()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		vOIOɌĂԁB
//--------------------------------------------------------------------
void ReleaseAll()
{
	// DirectGraphics control ̉
	if( g_pDGControl!=NULL ){
		CDGControl::DeleteInstance();
	}
	g_pDGControl = NULL;


	// I
	return;
}



//--------------------------------------------------------------------
//	[  ]
//		void OnOneFrame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Pt[̏s
//--------------------------------------------------------------------
void OnOneFrame()
{
	BOOL		bRes;
	BOOL		bTimeToDraw	= FALSE;			// `̃^C~Oۂ
	BOOL		bDrawReady	= FALSE;			// t[̕`悪łۂ


	// -----< ҂ĉʂɕ\ >-----
	//
	bTimeToDraw = WaitForSync();				// 
	bDrawReady = TRUE;
	if( bDrawReady ){
		// `iobNobt@tgobt@ցj
		bRes = g_pDGControl->Flip();
	}

	// -----< `Jn >-----
	//
	bRes = g_pDGControl->StartToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `Jnł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}


	// -----< zOtBbNʕ`揈 >-----
	//
	static long	lViewX	= 0;					// OtBbÑr[|Cg
	static long	lViewY	= 0;
	lViewX -= 1;
	lViewY -= 1;
	bRes = g_pDGControl->DrawGraphic( 0 , lViewX , lViewY , 0xFFFFFFFF , 0.8f );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : OtBbN`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}


	// -----< XvCg`揈 >-----
	//
	static float rotation = 0.0f;						// ]px
	rotation += -0.03f;

	static float scaling = 1.0f;						// XP[OW
	static float scaling_diff = 0.003f;
	if( scaling > 2.00 )scaling_diff *= -1;
	if( scaling < 1.00 )scaling_diff *= -1;
	scaling += scaling_diff;

	static DWORD dwDiffuse = 0xFFFFFFFF;				// fBt[YF
	static DWORD dwDiffuse_diff = -0x01000000;
	for( long lTemp=0;lTemp<2;lTemp++ ){
		dwDiffuse += dwDiffuse_diff;
		if( dwDiffuse==0xFFFFFFFF )dwDiffuse_diff *= -1;
		if( dwDiffuse==0x00FFFFFF )dwDiffuse_diff *= -1;
	}

														// XvCg`
	bRes = g_pDGControl->DrawSprite( 0 , SCREEN_WIDTH/2,SCREEN_HEIGHT/2 , rotation,scaling,scaling , dwDiffuse , 0.8f );
//	bRes = g_pDGControl->DrawSprite( 0 , SCREEN_WIDTH/2,SCREEN_HEIGHT/2 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : XvCg`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}



	// -----< eLXgEBhE`揈 >-----
	//
	static int countcheck=0;
	static DWORD time_start	= 0;
	static DWORD time_end	= 0;
	countcheck += 1;

	if( countcheck==60 ){
		DWORD time_span = 0;
		DWORD frames = 0;

		countcheck = 0;								// r߂
		time_end = timeGetTime();					// Ƃ
		if( time_start!=0 ){						// ŏłȂ΁A
			time_span = time_end - time_start;		// ^CXpZo
			frames = (60*1000) / ( time_span );		// t[[gZo
		}
		time_start = time_end;						// XV

		g_pDGControl->AddTWString( 0 , "FPS = %d" , frames );
	}
	bRes = g_pDGControl->DrawTW( 0 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : eLXgEBhE`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}



	// -----< `I >-----
	//
	bRes = g_pDGControl->EndToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}
}
