//-------------------------------------------------------------------------
//  DGControl TvvO
//-------------------------------------------------------------------------
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>
#include <time.h>
#include "DGDXInclude.h"

// -----< CũCN[h >-----
//
#include "WaitForSync.h"
#include "LogFile.h"
#include "Utils.h"
#include "DGControl.h"
#include "Primitive.h"

// -----< AvP[V֘ÃCN[h >-----
//
#include "Procedure.h"


// -----< satic , globalϐ̐錾 >-----
//
static BOOL	s_bFullScreen;					// tXN[ɂ邩ۂ

CLogFile	g_objDebugLog;					// fobOO
CLogFile	g_objErrorLog;					// G[O
CDGControl*	g_pDGControl = NULL;			// DGControl

HWND hWnd;									// EBhEnh


// -----< ֐̃vg^Cv錾 >-----
//
BOOL		Initialize();					// 
void		ReleaseAll();					// 
void		OnOneFrame();					// Pt[̏


// -----< ^錾 >-----
//
/*
// -----
typedef struct _SVertexForm{
	float	x,y,z;
	DWORD	color;
	DWORD	specular;
}SVertexForm;

#define D3DFVF_TLVERTEX	( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_SPECULAR )
#define MAKE_VERTEX( SVERTEX , 	X,Y,Z,COLOR,SPECULAR )		\
		(SVERTEX).x			= (X);							\
		(SVERTEX).y			= (Y);							\
		(SVERTEX).z			= (Z);							\
		(SVERTEX).color		= (COLOR);						\
		(SVERTEX).specular	= (SPECULAR);
*/
// -----
typedef struct _SVertexForm{
	float	x,y,z;
	DWORD	color;
	DWORD	specular;
	float tu0,tv0;
}SVertexForm;

#define D3DFVF_TLVERTEX	(D3DFVF_XYZ | D3DFVF_DIFFUSE |  D3DFVF_SPECULAR | D3DFVF_TEX1)
#define MAKE_VERTEX( SVERTEX , 	X,Y,Z,COLOR,SPECULAR , TU0,TV0 )		\
		(SVERTEX).x			= (X);							\
		(SVERTEX).y			= (Y);							\
		(SVERTEX).z			= (Z);							\
		(SVERTEX).color		= (COLOR);						\
		(SVERTEX).specular	= (SPECULAR);					\
		(SVERTEX).tu0		= (TU0);						\
		(SVERTEX).tv0		= (TV0);
// -----

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480

//--------------------------------------------------------------------
//	[  ]
//		int WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
//
//	[  ]
//		HINSTANCE	hInstance			
//		HINSTANCE	hPrevInstance		
//		LPSTR		lpCmdLine			
//		int			nCmdShow			
//
//	[ ߂l ]
//		vZX̏IR[h
//
//	[  ]
//		 WinMain ֐
//--------------------------------------------------------------------
int WINAPI WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
{
	BOOL	bRes;

	s_bFullScreen = FALSE;

	//----------< EBhENX̍쐬 >----------
	//
	WNDCLASSEX	wc;													// Window Class \

	wc.cbSize			= sizeof( WNDCLASSEX );						// \̂̃TCY
	wc.style			= CS_HREDRAW | CS_VREDRAW;					// X^C
	wc.lpfnWndProc		= WindowProc;								// vVWւ̃|C^
	wc.cbClsExtra		= 0;										// ExtraȂ
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;								// CX^Xnh
	wc.hIcon			= LoadIcon(hInstance,IDI_APPLICATION);		// ACR
	wc.hCursor			= LoadCursor(NULL,IDC_ARROW);				// J[\
	wc.hbrBackground	= NULL;										// wiuV
	wc.lpszMenuName		= 0;										// j[Ȃ
	wc.lpszClassName	= "DGControl Test";							// Window class 
	wc.hIconSm			= NULL;										// X[ACR̃nh NULL hIcongpB


	//----------< EBhE̓o^ƍ쐬 >----------
	//
	DWORD	dwStyle;
	if( s_bFullScreen )	dwStyle = WS_OVERLAPPED|WS_POPUP|WS_VISIBLE;
	else				dwStyle = WS_CAPTION|WS_OVERLAPPED|WS_POPUP|WS_SYSMENU|WS_VISIBLE;

	RegisterClassEx( &wc );											// o^
	hWnd = CreateWindowEx(											// 쐬
		0,															// EBhEX^C
		wc.lpszClassName,											// EBhENX
		"DGControl test",											// ^Cg
		dwStyle,													// X^C
		0,															// \ʒu
		0,
		100,														// TCY
		100,
		NULL,														// eEBhEȂ
		NULL,														// j[Ȃ
		hInstance,													// CX^X̃nh
		NULL														// ǉȂ
		);
	if( hWnd==NULL ){
		MessageBox( NULL , "EBhE̍쐬Ɏs܂B" , "Error" , MB_OK );
		return( 1 );
	}

	//----------< EBhETCY >----------
	//
	RECT sClientRect;
	GetClientRect( hWnd , &sClientRect );
	MoveWindow( hWnd, 0, 0, 100 + (SCREEN_WIDTH-sClientRect.right), 100 + (SCREEN_HEIGHT-sClientRect.bottom) , TRUE );

	//----------< EBhE̕\ >----------
	//
	ShowWindow( hWnd,nCmdShow );				// EBhEԂɂ
	UpdateWindow( hWnd );						// EBhE̍XV
	SetFocus( hWnd );							// tH[JX̃EBhEɂ
	if( s_bFullScreen ){
		ShowCursor( FALSE );					// J[\
	} else {
		// Nothing to do.
	}


	// ---------<  >----------
	//
	bRes = Initialize();
	if( bRes==FALSE ){
		ShowWindow( hWnd , SW_HIDE );
		DestroyWindow( hWnd );
		UnregisterClass( wc.lpszClassName , hInstance );
		ShowCursor( TRUE );

		MessageBox( NULL , "AvP[V̏Ɏs܂B" , "Error" , MB_OK );
		return 1;
	}


	//----------< bZ[W[v >----------
	//
	MSG			msg;								// Window bZ[W

	WaitForSync( 1000/60 );							// ̏
	while(1){
		// -----< Pt[̏s >-----
		//
		OnOneFrame();

		// -----< WindowsbZ[W̏ >-----
		//
		if( PeekMessage( &msg,NULL,0,0,PM_NOREMOVE ) ){		// bZ[WDispatch
			if( !GetMessage( &msg,NULL,0,0 ) )break;		// [vĨbZ[WȂI
			TranslateMessage(&msg);							// gX[g
			DispatchMessage(&msg);							// fBXpb`
		}
 	}

	// ----------< AvP[V̏I >----------
	//
	ReleaseAll();									// SĂ

	DestroyWindow( hWnd );
	ShowCursor( TRUE );

	return msg.wParam;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		vȌs܂B
//--------------------------------------------------------------------
BOOL Initialize()
{
	BOOL bRes;

	// -----< fobOOJn >-----
	//
	bRes = g_objDebugLog.SetFileName( "debug.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objDebugLog.SetMode( LOGFILE_DEBUG );

	// -----< G[OJn >-----
	//
	g_objErrorLog.SetFileName( "error.log" );
	if( bRes==FALSE ){
		return FALSE;
	}
	g_objErrorLog.SetMode( LOGFILE_DEBUG );

	CUtils::SetDebugLog( &g_objDebugLog );
	CUtils::SetErrorLog( &g_objErrorLog );

	// -----< DGControl  >-----
	//
	// <<< \z >>>
	g_pDGControl = CDGControl::GetInstance();
	if( g_pDGControl==NULL ){
		g_objDebugLog.ErrorLog( "::main : CDGControl̍쐬Ɏs܂B\n" );
		return FALSE;
	}

	// <<<  >>>
	bRes = g_pDGControl->Initialize( hWnd , s_bFullScreen , SCREEN_WIDTH , SCREEN_HEIGHT , 60 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : CDGControlIuWFNg̏Ɏs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// <<< Aʏݒ >>>
	bRes	= g_pDGControl->SetCullMode( FALSE );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : AʏݒɎs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// <<< yobt@gpݒ >>>
	bRes	= g_pDGControl->SetZBufferMode( FALSE );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::main : yobt@gpݒɎs܂B\n" );
		ReleaseAll();
		return FALSE;
	}

	// -----< XvCg >-----
	//
	RECT rect;
	rect.top	= 0;
	rect.left	= 0;
	rect.right	= 493;
	rect.bottom	= 199;
	g_pDGControl->AddTextureForSprite( "images/texture.bmp" , 0xFF00FF00 );
	g_pDGControl->AddSprite( 0 );
	g_pDGControl->SetSpriteRect( 0 , rect );
	g_pDGControl->SetSpriteCenter( 0 , 247 , 100 );

	// -----< OtBbN >-----
	//
	rect.top	= 0;
	rect.left	= 0;
	rect.right	= 639;
	rect.bottom	= 479;
	g_pDGControl->AddTextureForGraphic( "images/back.bmp" , 0x00000000 );
	g_pDGControl->AddGraphic( 1 );
	g_pDGControl->SetGraphicView( 0 , rect );

	// -----< RcIuWFNg >-----
	//
	long lTextureIndex;
	lTextureIndex	= g_pDGControl->AddTexture( "images/texture3d.bmp" , 0x00000000 );

	// _
	SVertexForm	sVertex[4];
//	MAKE_VERTEX( sVertex[0] ,   0.0,  50.0,0.0 , 0xFFFF0000 , 0 , 0.0f,0.0f );
//	MAKE_VERTEX( sVertex[1] ,  50.0, -50.0,0.0 , 0xFF00FF00 , 0 , 1.0f,1.0f );
//	MAKE_VERTEX( sVertex[2] , -50.0, -50.0,0.0 , 0xFF0000FF , 0 , 0.0f,1.0f );
//	MAKE_VERTEX( sVertex[3] , 100.0,  0.0,50.0 , 0xFF00FFFF , 0 , 1.0f,0.0f );
	MAKE_VERTEX( sVertex[0] ,   0.0,  50.0,0.0 , 0xFFFFFFFF , 0 , 0.0f,0.0f );
	MAKE_VERTEX( sVertex[1] ,  50.0, -50.0,0.0 , 0xFFFFFFFF , 0 , 1.0f,1.0f );
	MAKE_VERTEX( sVertex[2] , -50.0, -50.0,0.0 , 0xFFFFFFFF , 0 , 0.0f,1.0f );
	MAKE_VERTEX( sVertex[3] , 100.0,  0.0,50.0 , 0xFFFFFFFF , 0 , 1.0f,0.0f );

	// RcIuWFNgǉ
	long l3DIndex;
	long lPrimitiveIndex;
	l3DIndex	= g_pDGControl->Add3DObject();
	if( l3DIndex==-1 ){
		g_objDebugLog.ErrorLog( "::Initialize : RcIuWFNg̒ǉɎs܂B" );
		return FALSE;
	}
	g_objDebugLog.DebugLog( "::Initialize : 쐬ꂽRcIuWFNg̃CfbNX=%d\n" , l3DIndex );

	// Av~eBuǉ
	lPrimitiveIndex	= g_pDGControl->AddAPrimitive( l3DIndex );
	if( lPrimitiveIndex==-1 ){
		g_objDebugLog.ErrorLog( "::Initialize : RcIuWFNg[%d]Ƀv~eBuǉł܂łB" , l3DIndex );
		return FALSE;
	}

	bRes = g_pDGControl->SetPrimitiveType( l3DIndex , lPrimitiveIndex , DG_PT_LINESTRIP );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::Initialize : v~eBũ^CvݒɎs܂B\n" );
		return FALSE;
	}

	// Bv~eBuǉ
	lPrimitiveIndex	= g_pDGControl->AddBPrimitive( l3DIndex , 10 );
	if( lPrimitiveIndex==-1 ){
		g_objDebugLog.ErrorLog( "::Initialize : RcIuWFNg[%d]Ƀv~eBuǉł܂łB" , l3DIndex );
		return FALSE;
	}

	bRes = g_pDGControl->SetPrimitiveType( l3DIndex , lPrimitiveIndex , DG_PT_TRIANGLELIST );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::Initialize : v~eBũ^CvݒɎs܂B\n" );
		return FALSE;
	}

	// Bv~eBu _\ ǉ
	lPrimitiveIndex	= g_pDGControl->AddBPrimitive( l3DIndex , 10 );
	if( lPrimitiveIndex==-1 ){
		g_objDebugLog.ErrorLog( "::Initialize : RcIuWFNg[%d]Ƀv~eBuǉł܂łB" , l3DIndex );
		return FALSE;
	}

	bRes = g_pDGControl->SetPrimitiveType( l3DIndex , lPrimitiveIndex , DG_PT_POINTLIST );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::Initialize : v~eBũ^CvݒɎs܂B\n" );
		return FALSE;
	}

	bRes = g_pDGControl->SetPointSPSize( l3DIndex , lPrimitiveIndex , 32 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::Initialize : |CgXvCg̕`TCYݒɎs܂n" );
		return FALSE;
	}

	// _ǉ
	long lVertexIndex;
	long lIndexIndex;
	SVertexData	sVertexData;
	sVertexData.m_uiSize		= sizeof( SVertexForm );
	sVertexData.m_dwFVFCode		= D3DFVF_TLVERTEX;

	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[0]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,0 , &sVertexData );
	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[1]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,0 , &sVertexData );
	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[2]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,0 , &sVertexData );

	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[0]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,1 , &sVertexData );
	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[3]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,1 , &sVertexData );
	sVertexData.m_pVertexFormat	= (unsigned char*)( &(sVertex[1]) );
	lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,1 , &sVertexData );

	// _\p_ǉ
	int i;
	for( i=0;i<4;i++ ){
		sVertexData.m_pVertexFormat = (unsigned char*)( &(sVertex[i]) );
		lVertexIndex	= g_pDGControl->AddVertex( l3DIndex,2 , &sVertexData );
	}

	// CfbNXǉ
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,0 , 0 );
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,0 , 1 );
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,0 , 2 );
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,0 , 0 );
	g_pDGControl->UnLockPrimitive( l3DIndex,0 );

	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,1 , 0 );
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,1 , 1 );
	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,1 , 2 );
//	lIndexIndex	= g_pDGControl->AddIndex( l3DIndex,1 , 0 );
	g_pDGControl->UnLockPrimitive( l3DIndex,1 );

	// eNX`ݒ
	g_pDGControl->SetTexture( l3DIndex , 0 , lTextureIndex );	// Oڂ̃v~eBuɐݒ
	g_pDGControl->SetTexture( l3DIndex , 1 , lTextureIndex );	// Pڂ̃v~eBuɐݒ
	g_pDGControl->SetTexture( l3DIndex , 2 , lTextureIndex );	// Qڂ̃v~eBuɐݒ


	// -----< eLXgEBhE >-----
	//
	rect.top = 32;
	rect.left = 32;
	rect.right = 500;
	rect.bottom = 150;
	g_pDGControl->AddTW();
	g_pDGControl->InitializeTW(
						  0
						, rect
						, 1024 , 8,16
						, FALSE , FALSE
						, "lr SVbN" );

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseAll()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		vOIOɌĂԁB
//--------------------------------------------------------------------
void ReleaseAll()
{
	// DirectGraphics control ̉
	if( g_pDGControl!=NULL ){
		CDGControl::DeleteInstance();
	}
	g_pDGControl = NULL;


	// I
	return;
}



//--------------------------------------------------------------------
//	[  ]
//		void OnOneFrame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Pt[̏s
//--------------------------------------------------------------------
void OnOneFrame()
{
	BOOL		bRes;
	BOOL		bTimeToDraw	= FALSE;			// `̃^C~Oۂ
	BOOL		bDrawReady	= FALSE;			// t[̕`悪łۂ


	// -----< ҂ĉʂɕ\ >-----
	//
	bTimeToDraw = WaitForSync();				// 
	bDrawReady = TRUE;
	if( bDrawReady ){
		// `iobNobt@tgobt@ցj
		bRes = g_pDGControl->Flip();
	}

	// -----< RcIuWFNgJݒ >-----
	//
	bRes	= g_pDGControl->SetView( 0,0,200 , 0,0,0 , 0,1,0 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : JݒɎs܂B\n" );
		PostQuitMessage( 1 );
		return;
	}

	bRes	= g_pDGControl->SetPers( 45.0 , (float)640.0/(float)480.0 , 100,1000 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : p[XݒɎs܂B\n" );
		PostQuitMessage( 1 );
		return;
	}


	// -----< `Jn >-----
	//
	bRes = g_pDGControl->StartToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `Jnł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}

	// -----< zOtBbNʕ`揈 >-----
	//
	/*
	static long	lViewX	= 0;					// OtBbÑr[|Cg
	static long	lViewY	= 0;
	lViewX -= 1;
	lViewY -= 1;
	bRes = g_pDGControl->DrawGraphic( 0 , lViewX , lViewY , 0xFFFFFFFF , 0.8f );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : OtBbN`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}
	*/
/*
	// ߂
	{
		SDeviceInfo* pDeviceInfo;
		pDeviceInfo = (SDeviceInfo*)( g_pDGControl->GetDeviceInfo() );
		pDeviceInfo->m_pSprite->End();
		pDeviceInfo->m_bOnSPDrawing	= FALSE;
		pDeviceInfo->m_pSprite		= NULL;
	}
*/

	// -----< XvCg`揈 >-----
	//
	static float rotation = 0.0f;						// ]px
	rotation += -0.03f;

	static float scaling = 1.0f;						// XP[OW
	static float scaling_diff = 0.003f;
	if( scaling > 2.00 )scaling_diff *= -1;
	if( scaling < 1.00 )scaling_diff *= -1;
	scaling += scaling_diff;

	static DWORD dwDiffuse = 0xFFFFFFFF;				// fBt[YF
	static DWORD dwDiffuse_diff = -0x01000000;
	for( long lTemp=0;lTemp<2;lTemp++ ){
		dwDiffuse += dwDiffuse_diff;
		if( dwDiffuse==0xFFFFFFFF )dwDiffuse_diff *= -1;
		if( dwDiffuse==0x00FFFFFF )dwDiffuse_diff *= -1;
	}

														// XvCg`
	bRes = g_pDGControl->DrawSprite( 0 , SCREEN_WIDTH/2,SCREEN_HEIGHT/2 , rotation,scaling,scaling , dwDiffuse , 0.8f );
//	bRes = g_pDGControl->DrawSprite( 0 , SCREEN_WIDTH/2,SCREEN_HEIGHT/2 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : XvCg`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}

	// -----< RcIuWFNg`揈 >-----
	//
	static float fX		= 0.0;
	static float fY		= 0.0;
	static float fZ		= 0.0;
	static float fDX	= 0.5;
	static float fDY	= 1.0;
	static float fDZ	= 1.5;
	static float fRX	= 0.0;
	static float fRY	= 0.0;
	static float fRZ	= 0.0;

	fRX	+= 0.01f;
	fRY	+= 0.02f;
	fRZ	+= 0.03f;
	if( (fX+fDX>100) || (fX+fDX<-100) )fDX *= -1;
	if( (fY+fDY>100) || (fY+fDY<-100) )fDY *= -1;
	if( (fZ+fDZ>100) || (fZ+fDZ<-100) )fDZ *= -1;
	fX	+= fDX;
	fY	+= fDY;
	fZ	+= fDZ;

	bRes	= g_pDGControl->Draw3DObject( 0 , fX,fY,fZ , fRX,fRY,fRZ , 255 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : RcIuWFNg`揈Ɏs܂B\n" );
		PostQuitMessage( 1 );
		return;
	}


	// -----< eLXgEBhE`揈 >-----
	//
	static int countcheck=0;
	static DWORD time_start	= 0;
	static DWORD time_end	= 0;
	countcheck += 1;

	if( countcheck==60 ){
		DWORD time_span = 0;
		DWORD frames = 0;

		countcheck = 0;								// r߂
		time_end = timeGetTime();					// Ƃ
		if( time_start!=0 ){						// ŏłȂ΁A
			time_span = time_end - time_start;		// ^CXpZo
			frames = (60*1000) / ( time_span );		// t[[gZo
		}
		time_start = time_end;						// XV

		g_pDGControl->AddTWString( 0 , "FPS = %d" , frames );
	}
	bRes = g_pDGControl->DrawTW( 0 );
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::OnOneFrame : eLXgEBhE`ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}

	// -----< `I >-----
	//
	bRes = g_pDGControl->EndToDraw();
	if( bRes==FALSE ){
		g_objDebugLog.ErrorLog( "::WinMain : `ł܂łB\n" );
		PostQuitMessage( 1 );
		return;
	}
}
