//====================================================================
// X68000̃}bvƓ^̍\`
//====================================================================
#ifndef __MEMORY_MAP_BUFFER__
#define __MEMORY_MAP_BUFFER__

// obt@TCY{pӂĂAۂɂ128HWɓ]B
// SPƂ̍ől𖈓xŝ邽߂̎dg݁B
#define SP_UNIT_ARRAY_LENGTH (256)

//--------------------------------------------------------------------
// Rg[͂̃jbg
//--------------------------------------------------------------------
typedef union
{
    char mixed;
    struct
    {
        unsigned dummy1 : 1;
        unsigned trg_b : 1;
        unsigned trg_a : 1;
        unsigned dummy2 : 1;
        unsigned right : 1;
        unsigned left : 1;
        unsigned down : 1;
        unsigned up : 1;
    } bit;
    struct
    {
        unsigned dummy1 : 1;
        unsigned trg : 2;
        unsigned dummy2 : 1;
        unsigned stc : 4;
    } data;
} GAMEPAD_UNIT;

//--------------------------------------------------------------------
// rfIRg[̃vCIeBݒ
//--------------------------------------------------------------------
typedef union 
{
    short mixed;
    struct
    {
        unsigned reserve: 2;    // reserved
        unsigned sp: 2;         // SP̃vCIeB
        unsigned txt: 2;        // eLXg̃vCIeB
        unsigned grp: 2;        // OtBbÑvCIeB
        //
        unsigned grp_p4: 2;     // DxŒ̃OtBbÑy[Wԍ
        unsigned grp_p3: 2;     // F
        unsigned grp_p2: 2;     // F
        unsigned grp_p1: 2;     // Dxō̃OtBbÑy[Wԍ
    } bit;
} VC_PRIORITY;

//--------------------------------------------------------------------
// rfIRg[ON/OFFݒ
//--------------------------------------------------------------------
typedef union
{
    short mixed;
    struct
    {
        // ꃂ[h
        unsigned special_mode : 8;    // ꃂ[hݒ
        // ON/OFF
        unsigned nop : 1;     // Ȃ
        unsigned son : 1;     // SP ON/OFF
        unsigned ton : 1;     // eLXg ON/OFF
        unsigned gs4 : 1;     // 1024x1024 GRP ON/OFF
        unsigned gs3 : 1;     // GRP Page3 ON/OFF
        unsigned gs2 : 1;     // GRP Page2 ON/OFF
        unsigned gs1 : 1;     // GRP Page1 ON/OFF
        unsigned gs0 : 1;     // GRP Page0 ON/OFF
    } bit;
} VC_ONOFF;

//--------------------------------------------------------------------
// rfIRg[ON/OFFݒ
//--------------------------------------------------------------------
/*
typedef union
{
    short mixed;
    struct
    {
        unsigned special: 8;        // ꃂ[hݒ
        unsigned nop: 1;
        unsigned sw_sp: 1;          // SP ON/OFF
        unsigned sw_txt: 1;         // TEXT ON/OFF
        unsigned sw_grp_1024: 1;    // 1024x1024 GRP ON/OFF
        unsigned sw_grp_p3: 1;      // 512x512 GRP ON/OFF
        unsigned sw_grp_p2: 1;
        unsigned sw_grp_p1: 1;
        unsigned sw_grp_p0: 1;
    } bit;
} VC_SWITCH;
*/

//--------------------------------------------------------------------
// rõjbg
//--------------------------------------------------------------------
typedef struct SP_UNIT
{
    short x;
    short y;
    union
    {
        short mixed;
        struct
        {
            unsigned v_rev : 1;
            unsigned h_rev : 1;
            unsigned dummy : 2;
            unsigned color : 4;
            unsigned code : 8;
        } bit;
    } code;
    short prw;
} SP_UNIT;

//--------------------------------------------------------------------
// BG̃jbg
//--------------------------------------------------------------------
typedef struct BG_DEF_UNIT
{
    union
    {
        unsigned short mixed;
        struct
        {
            unsigned v_rev : 1;
            unsigned h_rev : 1;
            unsigned dummy : 2;
            unsigned color : 4;
            unsigned code : 8;
        } bit;
    } code;
} BG_DEF_UNIT;

//--------------------------------------------------------------------
// OtBbN XN[WX^
//--------------------------------------------------------------------
typedef struct
{
    unsigned short sc0_x;
    unsigned short sc0_y;
    unsigned short sc1_x;
    unsigned short sc1_y;
    unsigned short sc2_x;
    unsigned short sc2_y;
    unsigned short sc3_x;
    unsigned short sc3_y;
} GRP_SCRL_UNIT;

//--------------------------------------------------------------------
// eLXg XN[WX^
//--------------------------------------------------------------------
typedef struct
{
    unsigned short tx_x;
    unsigned short tx_y;
} TXT_SCRL_UNIT;

//--------------------------------------------------------------------
// BG XN[WX^
//--------------------------------------------------------------------
typedef struct
{ /*  XN[WX^  */
	unsigned short bg0x;
	unsigned short bg0y;
	unsigned short bg1x;
	unsigned short bg1y;
	union
	{
		unsigned short mixed;
		struct
		{
			unsigned dummy : 6;
			unsigned disp_cpu : 1;
			unsigned dummy2 : 3;
			unsigned textsel1 : 2;
			unsigned bg1onoff : 1;
			unsigned textsel0 : 2;
			unsigned bg0onoff : 1;
		} bit;
	} ctrl;
} BG_SCRL_UNIT;

//--------------------------------------------------------------------
// PCG]
//--------------------------------------------------------------------
typedef struct
{                           
    int set;                /*  f[^̃Zbgio[  */
    int offset;             /* ItZbg */
    int cnt;                /*  f[^̃p^[̌  */
    int target;             /*  ]̃R[hԍ  */
} TRANSSP_UNIT;

/*  pbgւf[^  */
typedef struct
{                      
    int set;                /*  f[^̃Zbgio[  */
    int offset;             /* ItZbg */
    int cnt;                /*  f[^̃ubŇ  */
    int target;             /*  ]̃R[hԍ  */
} TRANSPAL_UNIT;

//--------------------------------------------------------------------
// }bvobt@
//--------------------------------------------------------------------
typedef struct MEMORY_MAP_BUFFER {
    // <<< ͏ >>>
    GAMEPAD_UNIT input_unit;

    // <<< rfIRg[ >>>
    unsigned short video_contrast;  // RgXg
    VC_PRIORITY vc_priority;        // vCIeB
    VC_ONOFF vc_onoff;              // \ON/OFF

    // <<< XN[ >>>
    // XvCgXN[WX^
    SP_UNIT sp_unit[SP_UNIT_ARRAY_LENGTH];

    // BGXN[WX^
    BG_SCRL_UNIT bg_scroll_unit;

    // GRPXN[WX^
    GRP_SCRL_UNIT grp_scroll_unit;

    // TXTXN[WX^
    TXT_SCRL_UNIT txt_scroll_unit;

    // <<< ` >>>
    // BG`
    //BG_DEF_UNIT bg_def[2][64 * 64];
    BG_DEF_UNIT* bg_def[2];

    // PCG]
    int transsp_count;
    int transpal_count;
    TRANSSP_UNIT* transsp;
    TRANSPAL_UNIT* transpal;
} MEMORY_MAP_BUFFER;
#endif
