//=============================================================================
// foCX֘Ȁŋʉӏ
//=============================================================================
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "./x68/address_map.h"
#include "../core/game_context.h"
#include "../core/koncore.h"
#include "../core/kon_util.h"

//==============================================
// ^`
//==============================================
typedef struct _RES_KEYVALUE {
    int valid;          // LsƂ1
    char key[256];
    char value[256];
} RES_KEYVALUE;

//==============================================
// 萔`
//==============================================
#define TRIGGER_SAMETIME_THRESHOLD  (2)

//==============================================
// ϐ錾
//==============================================
int vd_wait_skipped;    // ҂XLbvꂽƂ1tO

//==============================================
// vg^Cv錾
//==============================================
RES_KEYVALUE parse_keyvalue(char* buffer);  // 1s̃eLXgKey-ValueɃp[X
int parse_kv_dir(RES_KEYVALUE kv);          // fBNgݒ荞
int parse_kv_bgm(RES_KEYVALUE kv);          // BGMݒ荞
int parse_kv_se(RES_KEYVALUE kv);           // SEݒ荞
int log_sound_settings();                   // ǂݍ݌ʂOo͂
char* null_to_empty(char* str);             // NULLꍇɂ͋󕶎Ԃ֐
int to_seindex(const char* value);          // 񂩂setypeenumɉ


//--------------------------------------------------------------------
//	[  ]
//		int stack_transfer_sp(int slot, int offsetIndex, int targetIndex, int count)
//
//	[  ]
//		int slot        ]̃p^[i[Zbgԍ
//      int offsetIndex ]SPR[h̃ItZbgl
//      int targetIndex ]SPR[h̃ItZbgl
//      int count       ]p^[
//
//	[ ߂l ]
//		]w̃CfbNXԍ
//
//	[  ]
//		O transsp ̗̈ɓǂݍłSP̃p^[
//      SP̒`̈ɓ]A]wݒ肵܂B
//      ۂ̓]́AʓrfoCXƂ̏ƂĎ܂B
//--------------------------------------------------------------------
int stack_transfer_sp(int slot, int offsetIndex, int targetIndex, int count)
{
    // ]w̃CfbNXԍ𓾂
    int index;
    index = p_memory_map_buffer->transsp_count;
    if(index>=p_game_properties->transsp_max_per_frame) {
        // 1t[̓]wʂ𒴂1񂾂Oɏo
        static int error_reported = 0;
        if (error_reported == 0) {
            int i;
			kon_log("[ERROR} stack_transfer_sp : 1t[̏Zbg𒴂܂Bstage=%d\n", p_stage_context->stage);
            for (i = 0; i < p_game_properties->transsp_max_per_frame; i++) {
                kon_log("\t[%d]slot=%d, offsetIndex=%d, targetIndex=%d, count=%d\n"
                    , i
                    , p_memory_map_buffer->transsp[i].set
                    , p_memory_map_buffer->transsp[i].offset
                    , p_memory_map_buffer->transsp[i].target
                    , p_memory_map_buffer->transsp[i].cnt
                );
            }
            kon_log("\t[x]slot=%d, offsetIndex=%d, targetIndex=%d, count=%d\n"
                , slot, offsetIndex, targetIndex, count
            );
        }
        return -1;
    }

    // ]w}bvobt@ɏ
    p_memory_map_buffer->transsp[index].set = slot;
    p_memory_map_buffer->transsp[index].offset = offsetIndex;
    p_memory_map_buffer->transsp[index].target = targetIndex;
    p_memory_map_buffer->transsp[index].cnt = count;
    p_memory_map_buffer->transsp_count++;
    return index;
}


//--------------------------------------------------------------------
//	[  ]
//		int stack_transfer_pal(int slot, int topBlock, int targetBlock, int count)
//
//	[  ]
//		int slot        ]̃p^[i[Zbgԍ
//      int offsetIndex ]SPR[h̃ItZbgl
//      int targetIndex ]SPR[h̃ItZbgl
//      int count       ]p^[
//
//	[ ߂l ]
//		]w̃CfbNXԍ
//
//	[  ]
//		O transpal ̗̈ɓǂݍłPAL̃p^[
//      PAL̒`̈ɓ]A]wݒ肵܂B
//      ۂ̓]́AʓrfoCXƂ̏ƂĎ܂B
//--------------------------------------------------------------------
int stack_transfer_pal(int slot, int topBlock, int targetBlock, int count)
{
    int index;

    // O`FbN
    if (slot < 0) {
        return -1;
    }

    // ]w̃CfbNXԍ𓾂
    index = p_memory_map_buffer->transpal_count;
    if (index >= p_game_properties->transpal_max_per_frame) {
        // 1t[̓]wʂ𒴂1񂾂Oɏo
        static int error_reported = 0;
        if (error_reported == 0) {
            kon_log("[ERROR} stack_transfer_pal : 1t[̏Zbg𒴂܂B\n");
        }
        return -1;
    }

    // ]w}bvobt@ɏ
    p_memory_map_buffer->transpal[index].set = slot;
    p_memory_map_buffer->transpal[index].offset = topBlock;
    p_memory_map_buffer->transpal[index].target = targetBlock;
    p_memory_map_buffer->transpal[index].cnt = count;
    p_memory_map_buffer->transpal_count++;
    return index;
}

//--------------------------------------------------------------------
//	[  ]
//		void parse_trigger_state()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		gK[̓͏Ԃp[XāAgK̓͂pĂ
//      t[JEgANbNԂ𔻒肷B
//--------------------------------------------------------------------
void parse_trigger_state()
{
    int trg_a, trg_b;
    GAMEPAD_UNIT* input_unit = &(p_memory_map_buffer->input_unit);

    // -----< WCXeBbNȊO̓͂󂯕t >-----
    //
    /*
    // I
    if (p_input_parser->keyin_pause) {
        p_application_context->quit_requested = 1;
    }
    */

    // -----< L[̒l0`9ŕ\ >-----
    //
    p_input_parser->direction_id = 5;   // j[g
    if (input_unit->bit.left) {
        if (input_unit->bit.up) {
            p_input_parser->direction_id = 7;
        }
        else if (input_unit->bit.down) {
            p_input_parser->direction_id = 1;
        }
        else {
            p_input_parser->direction_id = 4;
        }
    }
    else if (input_unit->bit.right) {
        if (input_unit->bit.up) {
            p_input_parser->direction_id = 9;
        }
        else if (input_unit->bit.down) {
            p_input_parser->direction_id = 3;
        }
        else {
            p_input_parser->direction_id = 6;
        }
    }
    else if (input_unit->bit.up) {
        p_input_parser->direction_id = 8;
    }
    else if (input_unit->bit.down) {
        p_input_parser->direction_id = 2;
    }

    // j[gj[gJE^Z
    if (p_input_parser->direction_id == 5) {
        // j[gɂȂJEgZbg
        p_input_parser->stick_in_count = 0;
    }
    else {
        // L[Cꂽ̂ŃJEg𑫂
        p_input_parser->stick_in_count += 1;
    }
    
    // -----< {^̓͏Ԃ𓾂 >-----
    //
    // C{^

    if (p_game_properties->reverse_trigger) {
        // A/Bւ
        trg_b = p_memory_map_buffer->input_unit.bit.trg_a;
        trg_a = p_memory_map_buffer->input_unit.bit.trg_b;
    }
    else {
        // A/B̂܂
        trg_a = p_memory_map_buffer->input_unit.bit.trg_a;
        trg_b = p_memory_map_buffer->input_unit.bit.trg_b;
    }

    // -----< ͂̏Ԕ >-----
    //
    // <<< gK̃NbN >>>
    p_input_parser->trg_main_clicked = 0;
    p_input_parser->trg_sub_clicked = 0;

    // gKBON/OFF
    if (trg_b == 1) {
        p_input_parser->trg_main_on_count += 1;
        if (p_input_parser->trg_main_on_count == 1) {
            p_input_parser->trg_main_clicked = 1;
        }
    }
    else {
        p_input_parser->trg_main_on_count = 0;
    }

    // gKAON/OFF
    if (trg_a == 1) {
        p_input_parser->trg_sub_on_count += 1;
        if (p_input_parser->trg_sub_on_count == 1) {
            p_input_parser->trg_sub_clicked = 1;
        }
    }
    else {
        p_input_parser->trg_sub_on_count = 0;
    }

    // <<< gK̓ >>>
    // gKꂽ烊Zbg
    if ((trg_a == 0) && (trg_b == 0)) {
        p_input_parser->trg_same_time = 0;
    }
    if (   (p_input_parser->trg_main_on_count > 0)
        && (p_input_parser->trg_sub_on_count > 0)
        && (p_input_parser->trg_main_on_count <= TRIGGER_SAMETIME_THRESHOLD)
        && (p_input_parser->trg_sub_on_count <= TRIGGER_SAMETIME_THRESHOLD)
        ) {
        // 
        p_input_parser->trg_same_time += 1;
    }
    if (p_input_parser->trg_same_time == 1) {
        p_input_parser->trg_same_time_clicked = 1;
    }
    else {
        p_input_parser->trg_same_time_clicked = 0;
    }
}

//--------------------------------------------------------------------
//	[  ]
//		int parse_resource_conf(const char* filename)
//
//	[  ]
//		const char* filename  ݒt@C̃t@C
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		\[Xݒǂݍ݂܂B
//--------------------------------------------------------------------
int parse_resource_conf(const char* filename)
{
    FILE* fn;
    char buffer[256];   // sǂ݃obt@
    int result;

    //kon_log("parse_resource_conf : filename = %s\n", filename);

    // -----< 1 REFȊO荞 >-----
    //
    // t@CJ
    fn = fopen(filename, "rt");
    if (fn == NULL) {
        kon_log("t@CJ܂łB\n");
        return -1;
    }

    // ǂݍ݂Ȃ珈
    while (fgets(buffer, 255, fn) != NULL) {
        // 1sǂݍ
        RES_KEYVALUE kv = parse_keyvalue(buffer);

        // sȂ玟
        if (kv.valid == 0) { continue; }

        // 擪񎟑ŏ𕪊
        if (strncmp(kv.key, "DIR_", strlen("DIR_")) == 0) {
            // fBNgݒ
            result = parse_kv_dir(kv);
        }
        else if (strncmp(kv.key, "BGM_", strlen("BGM_")) == 0) {
            // BGMݒ
            result = parse_kv_bgm(kv);
        }
        else if (strncmp(kv.key, "SE_", strlen("SE_")) == 0) {
            // SEݒ
            result = parse_kv_se(kv);
        }
        else {
            // sȃL[[h
            result = -1;
        }
        if (result != 0) {
            kon_log("l̎荞݂Ɏs܂Bkey = [%s], value=[%s]\n", kv.key, kv.value);
            continue;
        }
    }

    // t@C
    fclose(fn);

    // -----< I>-----
    //
    log_sound_settings();
    return 0;
}

//=======================================================================
// 1s̃eLXgKey-ValueɃp[X
//=======================================================================
RES_KEYVALUE parse_keyvalue(char* buffer)
{
    int i;
    char* cursor;
    char* equal_pos;
    char* comment_pos;
    int length;

    RES_KEYVALUE result;
    memset(&result, 0, sizeof(RES_KEYVALUE));
    cursor = buffer;

    // so
    //kon_log("parse_keyvalue : line = %s", buffer);

    // 󔒂XLbv
    while ((*cursor == ' ') || (*cursor == '\t')) {
        cursor++;
    }

    // 擪 # sisjȂXLbv
	if ((*cursor == '#') || (*cursor == '\n') || (*cursor == '\r')) {
        result.valid = 0;
        return result;
    }

    // = ̗LmF
    equal_pos = strchr(cursor, (int)'=');
    if (equal_pos == NULL) {
        // = Ȃ疳
        result.valid = 0;
        return result;
    }

    // Key, valueЂƂ܂荞
    length = equal_pos - cursor;
    strncpy(result.key, cursor, length);
    for (i = 255; i >= 0; i--) {
        if ((result.key[i] == 0x00)    \
            || (result.key[i] == ' ') \
            || (result.key[i] == '\t')    \
            || (result.key[i] == '\r')    \
            || (result.key[i] == '\n')  \
            || (result.key[i] == 0x00)
            ) {
            // 󔒂0Ŗ߂
            result.key[i] = 0x00;
        }
        else {
            // 󔒈ȊOoꂵA܂
            break;
        }
    }

    // Value荞
    cursor = equal_pos +1;
    while ((*cursor == ' ') || (*cursor == '\t')) {
        cursor++;
    }
    strcpy(result.value, cursor);
    comment_pos = strchr(result.value, (int)'#');
    if (comment_pos != NULL) {
        // #ȍ~0߂
        for (i = 0; i < 256; i++) {
            if (comment_pos[i] == 0x00) { break; }
            comment_pos[i] = 0;
        }
    }
    for (i = 255; i >= 0; i--) {
        if ((result.value[i] == ' ')   \
            || (result.value[i] == '\t') \
            || (result.value[i] == '\r') \
            || (result.value[i] == '\n') \
            || (result.value[i] == 0x00)
            ) {
            // 󔒂^u0Ŗ߂
            result.value[i] = 0x00;
        }
        else {
            // 󔒈ȊOoꂵ炻܂
            break;
        }
    }

    // 荞݊
    result.valid = 1;
    //kon_log("parse_keyvalue : key=[%s], value=[%s]\n", result.key, result.value);
    return result;
}

//=======================================================================
// fBNgݒ荞
//=======================================================================
int parse_kv_dir(RES_KEYVALUE kv)
{
    // L[Ōď
    if (strcmp(kv.key, "DIR_BGM") == 0) {
        // BGM̃fBNg
        if (resource_conf.dir_bgm != NULL) {
            free(resource_conf.dir_bgm);
        }
        resource_conf.dir_bgm = (char*)malloc(strlen(kv.value) + 1);
        strcpy(resource_conf.dir_bgm, kv.value);
    }
    else if (strcmp(kv.key, "DIR_SE") == 0) {
        // SẼfBNg
        if (resource_conf.dir_se != NULL) {
            free(resource_conf.dir_se);
        }
        resource_conf.dir_se = (char*)malloc(strlen(kv.value) + 1);
        strcpy(resource_conf.dir_se, kv.value);
    }
    else {
        // sȃL[
        kon_log("[ERROR] \[XݒɕsȃL[w肳܂Bkey = [%s]\n", kv.key);
    }
    return 0;
}

//=======================================================================
// BGMݒ荞
//=======================================================================
int parse_kv_bgm(RES_KEYVALUE kv)
{
    int i;
    int index = 0;
    int elem = -1;
    char buffer[_MAX_PATH];

    // Xe[Wibgmindexj𔻒
    if (strncmp(kv.key, "BGM_TTL_", strlen("BGM_TTL_")) == 0) {
        index = bgmindex_title;
    }
    else if (strncmp(kv.key, "BGM_ED_", strlen("BGM_ED_")) == 0) {
        index = bgmindex_ending;
    }
    else if (strncmp(kv.key, "BGM_ST1_", strlen("BGM_ST1_")) == 0) {
        index = bgmindex_st1;
    }
    else if (strncmp(kv.key, "BGM_ST2_", strlen("BGM_ST2_")) == 0) {
        index = bgmindex_st2;
    }
    else if (strncmp(kv.key, "BGM_ST3_", strlen("BGM_ST3_")) == 0) {
        index = bgmindex_st3;
    }
    else if (strncmp(kv.key, "BGM_ST4_", strlen("BGM_ST4_")) == 0) {
        index = bgmindex_st4;
    }
    else if (strncmp(kv.key, "BGM_ST5_", strlen("BGM_ST5_")) == 0) {
        index = bgmindex_st5;
    }
    else if (strncmp(kv.key, "BGM_ST6_", strlen("BGM_ST6_")) == 0) {
        index = bgmindex_st6;
    }
    else {
        kon_log("[ERROR] \[XݒŁABGMɖȃL[w肳܂Bkey = [%s]\n", kv.key);
        return -1;
    }

    // postfix𔻒i^j
    if (strstr(kv.key, "_MAIN") != NULL) {
        // C
        elem = bgmtype_main;
    }
    else if (strstr(kv.key, "_BOSS")!=NULL) {
        // {X
        elem = bgmtype_boss;
    }
    else if (strstr(kv.key, "_INTM") != NULL) {
        // C^[~bV
        elem = bgmtype_intermission;
    }
    else if (strstr(kv.key, "_CLEAR") != NULL) {
        // NAWO
        elem = bgmtype_clear;
    }

    // postfix𔻒iZNVԍj
    for (i = 0; i < MAX_SECTION; i++) {
        // postfix
        sprintf(buffer, "_SEC%d", i);
        // 
        if (strstr(kv.key, buffer) != NULL) {
            // elem
            elem = bgmtype_count + i;
        }
    }

    // elem肵ĂȂ΃G[
	if (elem == -1) {
        kon_log("[ERROR] \[XݒŁABGMɕspostfixw肳܂Bkey = [%s]\n", kv.key);
        return -1;
    }

    // 荞
    if (resource_conf.bgm[index][elem] != NULL) {
        free(resource_conf.bgm[index][elem]);
    }
    resource_conf.bgm[index][elem] = (char*)malloc(strlen(kv.value) + 1);
    if (resource_conf.bgm[index][elem] == NULL) {
        kon_log("[ERROR] \[XݒŁABGM̃t@Ci[邽߂̃mۂł܂łBkey = [%s]\n", kv.key);
        return -1;
    }
    strcpy(resource_conf.bgm[index][elem], kv.value);

    // I
    return 0;
}

//=======================================================================
// SEݒ荞
//=======================================================================
int parse_kv_se(RES_KEYVALUE kv)
{
    int index;
    char* cursor;
    char* pos;
    char buffer[256];

    // index
    index = to_seindex(kv.key);
	if (index < 0) {
        kon_log("[ERROR] \[XݒŁASE̐ݒɖȃL[w肳܂Bkey = [%s]\n", kv.key);
        return -1;
    }

    // vf𕪉
    cursor = kv.value;
    if (*cursor != '(') {
        kon_log("[ERROR] SEݒ̏słBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    cursor++;

    // t@C
    pos = strchr(cursor, (int)',');
    if (pos == NULL) {
        kon_log("[ERROR] SEݒŃt@C̋؂蕶܂łBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    memset(buffer, 0, sizeof(buffer));
    strncpy(buffer, cursor, pos - cursor);
    if (strchr(buffer, (int)'\t') != NULL) { *((char*)strchr(buffer, (int)'\t')) = 0; }
    if (strchr(buffer, (int)' ') != NULL) { *((char*)strchr(buffer, (int)' ')) = 0; }
    if (strchr(buffer, (int)',') != NULL) { *((char*)strchr(buffer, (int)' ')) = 0; }
    if (strchr(buffer, (int)')') != NULL) { *((char*)strchr(buffer, (int)' ')) = 0; }
    if (resource_conf.se[index].filename != NULL) {
        free(resource_conf.se[index].filename);
    }
    resource_conf.se[index].filename = (char*)malloc(strlen(buffer) + 1);
    strcpy(resource_conf.se[index].filename, buffer);

    // Dx
    cursor = pos + 1;
    pos = (char*)strchr(cursor, (int)',');
    if (pos == NULL) {
        kon_log("[ERROR] SEݒŗDx̋؂蕶܂łBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    memset(buffer, 0, sizeof(buffer));
    strncpy(buffer, cursor, pos - cursor);
    resource_conf.se[index].priority = atoi(buffer);

    // ҂t[
    cursor = pos + 1;
    pos = (char*)strchr(cursor, (int)',');
    if (pos == NULL) {
        kon_log("[ERROR] SEݒő҂t[̋؂蕶܂łBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    memset(buffer, 0, sizeof(buffer));
    strncpy(buffer, cursor, pos - cursor);
    resource_conf.se[index].frames = atoi(buffer);

    // Dxꔻ
    cursor = pos + 1;
    pos = (char*)strchr(cursor, (int)',');
    if (pos == NULL) {
        kon_log("[ERROR] SEݒŗDxꔻ̋؂蕶܂łBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    memset(buffer, 0, sizeof(buffer));
    strncpy(buffer, cursor, pos - cursor);
    resource_conf.se[index].same_priority_wait = atoi(buffer);

    // g
    cursor = pos + 1;
    pos = (char*)strchr(cursor, (int)')');
    if (pos == NULL) {
        kon_log("[ERROR] SEݒŎg̋؂蕶܂łBkey=[%s], value=[%s]\n", kv.key, kv.value);
        return -1;
    }
    memset(buffer, 0, sizeof(buffer));
    strncpy(buffer, cursor, pos - cursor);
    resource_conf.se[index].x68frq = atoi(buffer);

    // I
    return 0;
}

//====================================================================
// ږSETYPẼCfbNXɉ
//====================================================================
int to_seindex(const char* value) {
    int index = 0;
    if (strcmp(value, "SE_CURSOR") == 0) {
        index = setype_cursor;
    }
    else if (strcmp(value, "SE_CURSOR_OK") == 0) {
        index = setype_cursorok;
    }
    else if (strcmp(value, "SE_CURSOR_NG") == 0) {
        index = setype_cursorng;
    }
    else if (strcmp(value, "SE_JIKI_DOWN") == 0) {
        index = setype_jikidown;
    }
    else if (strcmp(value, "SE_JIKI_DAMAGE") == 0) {
        index = setype_jikidamage;
    }
    else if (strcmp(value, "SE_BLADE") == 0) {
        index = setype_blade;
    }
    else if (strcmp(value, "SE_DASH") == 0) {
        index = setype_dash;
    }
    else if (strcmp(value, "SE_ITEM") == 0) {
        index = setype_item;
    }
    else if (strcmp(value, "SE_MAGIC") == 0) {
        index = setype_magic;
    }
    else if (strcmp(value, "SE_BOMB") == 0) {
        index = setype_bomb;
    }
    else if (strcmp(value, "SE_BOMB_EXP") == 0) {
        index = setype_bombexp;
    }
    else if (strcmp(value, "SE_ENEMY_DOWN") == 0) {
        index = setype_enemy_down;
    }
    else if (strcmp(value, "SE_ENEMY_DAMAGE") == 0) {
        index = setype_enedamage;
    }
    else if (strcmp(value, "SE_ENEMY_SHOT") == 0) {
        index = setype_eneshot;
    }
    else if (strcmp(value, "SE_STAGE_CLEAR") == 0) {
        index = setype_stageclear;
    }
    else if (strcmp(value, "SE_SECTION_CLEAR") == 0) {
        index = setype_sectionclear;
    }
    else if (strcmp(value, "SE_DASH_HIT") == 0) {
        index = setype_dashhit;
    }
    else if (strcmp(value, "SE_JUMP") == 0) {
        index = setype_jump;
    }
    else if (strcmp(value, "SE_STEP_WATER") == 0) {
        index = setype_stepwater;
    }
    else if (strcmp(value, "SE_FLOW_WATER") == 0) {
        index = setype_flowwater;
    }
    else if (strcmp(value, "SE_ON_CHARGE") == 0) {
        index = setype_oncharge;
    }
    else if (strcmp(value, "SE_BOMB_CHARGE") == 0) {
        index = setype_bombcharge;
    }
    else if (strcmp(value, "SE_STEP") == 0) {
        index = setype_step;
    }
    else {
        kon_log("[ERROR] sȌʉw肳܂Bʉ=[%s]\n", value);
        index = -1;
    }
    return index;
}

//=======================================================================
// ǂݍ݌ʂOo͂
//=======================================================================
int log_sound_settings()
{
    int i, c;

    // fBNg
    kon_log("DIR_BGM : %s\n", resource_conf.dir_bgm);
    kon_log("DIR_SE  : %s\n", resource_conf.dir_se);
    for (i = 0; i < bgmindex_count; i++) {
        for (c = 0; c < bgmtype_count + MAX_SECTION; c++) {
            if (resource_conf.bgm[i][c] != NULL) {
                kon_log("BGM[%d][%d] : %s\n", i, c, resource_conf.bgm[i][c]);
            }
            else {
				kon_log("BGM[%d][%d] : NULL\n", i, c);
            }
        }
    }

    // SE
    for (i = 0; i < setype_count; i++) {
        kon_log("SE[%d] : (%s, %d, %d, %d, %d)\n"
            , i
            , resource_conf.se[i].filename
            , resource_conf.se[i].priority
            , resource_conf.se[i].frames
            , resource_conf.se[i].same_priority_wait
            , resource_conf.se[i].x68frq
        );
    }

    // I
    return 0;
}


//=======================================================================
// NULLꍇɂ͋󕶎Ԃ֐
//=======================================================================
char* null_to_empty(char* str)
{
    static char* empty = "";
    if (str == NULL) {
        return empty;
    }
    return str;
}


//--------------------------------------------------------------------
//	[  ]
//		int release_resource_conf()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		\[Xݒ̓ǂݍݐobt@܂
//--------------------------------------------------------------------
int release_resource_conf()
{
    int i;
    int c;

    // ̈
    // DIR
    if (resource_conf.dir_bgm != NULL) {
        free(resource_conf.dir_bgm);
        resource_conf.dir_bgm = NULL;
    }
    if (resource_conf.dir_se != NULL) {
        free(resource_conf.dir_se);
        resource_conf.dir_se = NULL;
    }

    // BGM
    for (i = 0; i < bgmindex_count; i++) {
        for (c = 0; c < bgmtype_count + MAX_SECTION; c++) {
            if (resource_conf.bgm[i][c] != NULL) {
                free(resource_conf.bgm[i][c]);
                resource_conf.bgm[i][c] = NULL;
            }
        }
    }

    // SE
    for (i = 0; i < setype_count; i++) {
        if (resource_conf.se[i].filename != NULL) {
            free(resource_conf.se[i].filename);
            resource_conf.se[i].filename = NULL;
        }
    }
    
    // I
    return 0;
}
