#define __TITLE_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "kon_util.h"
#include "constants.h"
#include "structs.h"
#include "common.h"
#include "game_context.h"
#include "../devs/devs.h"
#include "stage.h"

// -----< 萔` >-----
//
// TEheXgŎg\[X̃CfbNX
// ZMD_TRACK_MAXȏɂȂȂlŁA(bgmtype_count + MAX_SECTION)ȏ̒lɂ
// 
#define SOUNDTEST_ZMD_INDEX	(15)

// -----< ϐ錾 >-----
//
int config_sound_stage = 0;
int config_sound_track = 0;
int config_sound_index = -1;

// -----< vg^Cv錾 >-----
//
int title_init();		// ^Cgʂ̏
int title_main();		// ^Cgʂ̃C
int title_dispose();	// ^Cgʂ̌㏈
//
int push_start_move();		// ^Cgʂ̉Z
int push_start_draw();		// ^Cgʂ̕`揈
int main_menu_move();		// ^Cgʂ̉Z
int main_menu_draw();		// ^Cgʂ̕`揈
int config_move();			// config̉Z
int config_move_sound();	// configSOUND TEST
int config_next_track(int depth);	// ̃gbNI
int config_prev_track(int depth);	// ÕgbNI
int config_draw();		// config̕`揈
int help_move();		// config̉Z
int help_draw();		// config̕`揈
//
//
//// config̕ۑEǂݍ
//int game_settings_save(const char* filename);	// Q[ݒۑ
//int game_settings_load(const char* filename);	// Q[ݒǂݍ
//int game_settings_set_default();				// Q[ݒftHglɐݒ肷
////
void draw_version();		// o[Wԍ\

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int title()
{
	int result = 0;

	// 
	title_init();

	// ^Cgʂ̏
	result = title_main();

	// ^Cg㏈
	title_dispose();

	// I
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int title_init()
{
	int result;
	int i;
	SP_UNIT* sp;

	// Xe[W̃ReLXg0ŏ
	memset(p_stage_context, 0, sizeof(STAGE_CONTEXT));
	p_stage_context->stage = 0;		// stage=0PUSH START, stage=1̓^CgCstage=2CONFIGURATIONCstage=3HELP
	p_stage_context->section = 0;	// J[\ʒu
	p_stage_context->status = 0;	// 0: 1:X^[g

	// ʏ
	screen_init();

	// SP̈ʒuɏW߂
	sp = p_memory_map_buffer->sp_unit;
	for(i=0;i<128;i++) {
		SP_SET(sp, 0, 0, 0x00, 0, 0, 0, 3);
		sp++;
	}

	// xʂB
	p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;

	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;
	do_wait_vsync(1);

	// \[Xǂݍ
	result = resource_load_title();
	if (result != 0) {
		// s
		kon_log("title_init : \[X̓ǂݍݒɃG[܂B\n");
		return -1;
	}

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// ʂ̃vCIeBݒ肷
	p_memory_map_buffer->vc_priority.bit.sp = 0;      // XvCg
	p_memory_map_buffer->vc_priority.bit.txt = 1;     // eLXg
	p_memory_map_buffer->vc_priority.bit.grp = 2;     // OtBbN
	p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
	p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
	p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
	p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

	// BG̕\Ԃݒ肷i͕\ȂBXe[WJnONɂBj
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.disp_cpu = 1;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.textsel0 = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.textsel1 = 1;

	// Ԓlݒ
	p_stage_context->status = 0;
	p_stage_context->cmn_sp_top = 0x40;

	// O[oϐɂ鐧ݒ
	config_sound_stage = 0;
	config_sound_track = 0;
	config_sound_index = -1;

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int title_main()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		0 : ̃Xe[W
//		1 : exit
//		ȊO : G[
//
//	[  ]
//		^Cg
//--------------------------------------------------------------------
int title_main()
{
	int result = 0;

	// BGMĐ
	if (p_game_properties->disable_sound == 0) {
		sound_play_bgm(p_sound_context->bgm_index[bgmtype_main]);
	}

	// Q[[v
	while ( 1 ) {
		// ړ
		switch (p_stage_context->stage) {
		case 0:
			// PUSH START
			push_start_move();
			break;
		case 1:
			// Cj[
			main_menu_move();
			break;
		case 2:
			// config
			config_move();
			break;
		case 3:
			// help
			help_move();
			break;
		}

		// `揈
		switch (p_stage_context->stage) {
		case 0:
			push_start_draw();
			break;
		case 1:
			main_menu_draw();
			break;
		case 2:
			// config
			config_draw();
			break;
		case 3:
			// help
			help_draw();
			break;
		}

		// VSYNC҂т̑O
		do_wait_vsync(1);

		// t[JE^XV
		p_stage_objects->frame_count += 1;
		p_application_context->frame_count += 1;

		// 𔲂
		if (p_stage_context->status == 1) {
			break;
		}

		// vȌINGXgꂽI
		if (p_application_context->quit_requested) {
			break;
		}
	}

	// BGM~߂
	sound_stop_bgm();

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int title_dispose()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int title_dispose()
{
	// ǂݍݍς̃TEheXg\[X烊[X
	if (config_sound_index >= 0) {
		sound_stop_bgm();
		resource_release_bgm_single(config_sound_index);
		config_sound_index = -1;
	}
	config_sound_stage = 0;
	config_sound_track = 0;

	// Xe[W̃\[X
	resource_release_stage();
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int push_start_move()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̉Z
//--------------------------------------------------------------------
int push_start_move()
{
	// {^NbNꂽ甲
	if ((p_input_parser->trg_main_clicked)
		|| (p_input_parser->trg_sub_clicked)
		|| (p_input_parser->pause_clicked)
		) {
		// o
		play_se(&(p_sound_context->se_item[setype_cursorok]));

		// [hi߂
		p_stage_context->stage = 1;
		p_stage_context->section = 0;
	}
	else {
		// XN[ʒu
		p_stage_context->section = ((p_stage_objects->frame_count >> 5) & 1) == 0 ? 0 : 256;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int push_start_draw()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̕`揈
//--------------------------------------------------------------------
int push_start_draw()
{
	int i;
	int allocsp = 0;
	SP_UNIT* sp = p_memory_map_buffer->sp_unit;
	p_stage_objects->sp_index_seq = 0;

	// <<< SP` >>>
	/*
	// J[\`
	{
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(1);	// SP1g
		if (allocsp < 1) {
			// mۂłȂ`߂
			return 0;
		}
		SP_SET(sp, 178, 198 + (p_stage_context->section * 16), 0x45, 5, 0, 0, 3);
		sp++;
	}
	*/
	// o[W`悷
	draw_version();

	// <<< SP̎c̈ >>>
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		sp->x = 0;
		sp->y = 0;
		// ̃jbgɐi
		sp++;
	}

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// <<< OtBbN̈ʒuύX >>>
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = p_stage_context->section;
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = p_stage_context->section;
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;
	return 0;
}

void draw_version()
{
	SP_UNIT* sp = p_memory_map_buffer->sp_unit;
	int allocsp = 0;
	int x, y;
	// <<< o[W\ >>>
	x = 256 - 24;
	y = 16;
	// V
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
	allocsp = sp_alloc_index(1);
	SP_SET(sp, x - 6, y, 0x60, 5, 0, 0, 3);
	sp++;
	//
	x += 8;
	draw_digits(VERSION_0, x - 8, y);
	{
		x += 8;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 8, y, 0x61, 5, 0, 0, 3);
		sp++;
	}
	x += 8;
	draw_digits(VERSION_1, x - 8, y);
	x += 8;
	draw_digits(VERSION_2, x - 8, y);
}


//--------------------------------------------------------------------
//	[  ]
//		int main_menu_move()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̉Z
//--------------------------------------------------------------------
int main_menu_move()
{
	int i;
	// J[\̏㉺ړ
	if (p_input_parser->stick_in_count == 1) {
		// j[gL[CꂽuԂ𑨂
		if (p_input_parser->direction_id == 2) {
			// L[CF
			p_stage_context->section += 1;
		}
		if (p_input_parser->direction_id == 8) {
			// L[CF
			p_stage_context->section -= 1;
		}
		if (p_stage_context->section < 0) { p_stage_context->section = 3; }
		if (p_stage_context->section >= 4) { p_stage_context->section = 0; }

		// ʉ
		play_se(&(p_sound_context->se_item[setype_cursor]));
	}

	// {^NbNꂽ甲
	if ((p_input_parser->trg_main_clicked)
		|| (p_input_parser->pause_clicked)
		) {
		switch (p_stage_context->section) {
		case 0:
			// X^[g
			p_stage_context->status = 1;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
			// I邭炢܂ő҂
			for (i = 0; i < 90; i++) {
				do_wait_vsync(1);
			}
			break;

		case 1:
			// config
			p_stage_context->stage = 2;
			p_stage_context->section = 0;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
			break;

		case 2:
			// HELP
			p_stage_context->stage = 3;
			p_stage_context->section = 0;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
			break;

		case 3:
			// I
			p_application_context->quit_requested = 1;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
			// ʉȂI邭炢܂ő҂
			for (i = 0; i < 90; i++) {
				do_wait_vsync(1);
			}
			break;
		}
	}

	// ߂{^
	if ((p_input_parser->trg_sub_clicked)) {
		play_se(&(p_sound_context->se_item[setype_cursor]));
		p_stage_context->stage = 0;
		p_stage_context->section = 0;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int main_menu_draw()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̕`揈
//--------------------------------------------------------------------
int main_menu_draw()
{
	int i;
	int allocsp = 0;
	SP_UNIT* sp = p_memory_map_buffer->sp_unit;
	p_stage_objects->sp_index_seq = 0;

	// <<< SP` >>>
	// J[\`
	{
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(1);	// SP1g
		if (allocsp < 1) {
			// mۂłȂ`߂
			return 0;
		}
		SP_SET(sp, 178, 198 + (p_stage_context->section * 16), 0x45, 5, 0, 0, 3);
		sp++;
	}

	// o[W\
	draw_version();

	// LEVEL\
	{
		int idx = p_stage_context->section;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(4);	// SP4g
		if (allocsp < 4) {
			// mۂłȂ`߂
			return 0;
		}

		// SPzu
		for (i = 0; i < 4; i++) {
			int spTop = 0x50 + (p_game_properties->game_level << 2);
			SP_SET(sp, 20 + (i<<4), 252, spTop + i, 5, 0, 0, 3);
			sp++;
		}
	}

	// <<< SP̎c̈ >>>
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		sp->x = 0;
		sp->y = 0;
		// ̃jbgɐi
		sp++;
	}

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// <<< OtBbN̈ʒuύX >>>
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = 256;
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int config_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		0 : ̃Xe[W
//		1 : exit
//		ȊO : G[
//
//	[  ]
//		^Cg
//--------------------------------------------------------------------
int config_move()
{
	// J[\̏㉺ړ
	if (p_input_parser->stick_in_count == 1) {
		// j[gL[CꂽuԂ𑨂
		if (p_input_parser->direction_id == 2) {
			// L[CF
			p_stage_context->section += 1;
		}
		if (p_input_parser->direction_id == 8) {
			// L[CF
			p_stage_context->section -= 1;
		}
		if (p_stage_context->section < 0) { p_stage_context->section = 5; }
		if (p_stage_context->section >= 6) { p_stage_context->section = 0; }

		// ʉ
		play_se(&(p_sound_context->se_item[setype_cursor]));
	}

	// {^NbNꂽ甲
	switch (p_stage_context->section) {
	case 0:
		if (p_input_parser->stick_in_count == 1) {
			if (p_input_parser->direction_id == 6) { p_game_properties->game_level += 1; }
			if (p_input_parser->direction_id == 4) { p_game_properties->game_level -= 1; }
			if (p_game_properties->game_level == 4) { p_game_properties->game_level = 3; }
			if (p_game_properties->game_level < 0) { p_game_properties->game_level = 0; }
		}
		break;

	case 1:
		if (p_input_parser->stick_in_count == 1) {
			if (p_input_parser->direction_id == 6) { p_game_properties->life += 1; }
			if (p_input_parser->direction_id == 4) { p_game_properties->life -= 1; }
			if (p_game_properties->life >= 10) { p_game_properties->life = 9; }
			if (p_game_properties->life < 0) { p_game_properties->life = 0; }
		}
		break;

	case 2:
		// ATTACK̃oChݒ
		if (p_memory_map_buffer->input_unit.bit.trg_b) {
			if (p_game_properties->reverse_trigger == 1) {
				p_game_properties->reverse_trigger = 0;
			}
		}
		if (p_memory_map_buffer->input_unit.bit.trg_a) {
			if (p_game_properties->reverse_trigger == 0) {
				p_game_properties->reverse_trigger = 1;
			}
		}
		break;
	case 3:
		// JUMP̃oChݒ
		if (p_memory_map_buffer->input_unit.bit.trg_a) {
			if (p_game_properties->reverse_trigger == 1) {
				p_game_properties->reverse_trigger = 0;
			}
		}
		if (p_memory_map_buffer->input_unit.bit.trg_b) {
			if (p_game_properties->reverse_trigger == 0) {
				p_game_properties->reverse_trigger = 1;
			}
		}
		break;

	case 4:
		// SOUND TEST
		config_move_sound();
		break;

	case 5:
		// title
		if (p_input_parser->trg_main_clicked) {
			p_stage_context->stage = 1;
			p_stage_context->section = 1;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
		}
		break;
	}

	// ESCŃ^Cgʂɖ߂
	if (p_input_parser->pause_clicked) {
		p_stage_context->stage = 1;
		p_stage_context->section = 1;
		play_se(&(p_sound_context->se_item[setype_cursorok]));
	}

	return 0;
}

//======================================================================
// TEheXg[h̑n
//======================================================================
int config_move_sound()
{
	char fullpath[_MAX_PATH];
	memset(fullpath, 0, sizeof(fullpath));

	// <<< TRACK SELECT >>>
	if (p_input_parser->stick_in_count == 1) {
		int track_result = 0;
		// gbNV[N
		if (p_input_parser->direction_id == 6) {
			track_result = config_next_track(0);
			if (track_result == 0) {
				kon_log("config_move_sound : gbN̑IɎs܂B\n");
			}
		}
		if (p_input_parser->direction_id == 4) {
			track_result = config_prev_track(0);
			if (track_result == 0) {
				kon_log("config_move_sound : OgbN̑IɎs܂B\n");
			}
		}
		// V[Ns֐Ōɖ߂̂ŉȂĂǂ
	}

	// <<< PLAY >>>
	if (p_input_parser->trg_main_clicked) {
		const char* filename = resource_conf.bgm[config_sound_stage][config_sound_track];
		make_fullpath(fullpath, resource_conf.dir_bgm, filename);

		// U~߂
		sound_stop_bgm();

		// ǂݍݍς̃TEheXg\[X烊[X
		if (config_sound_index >= 0) {
			resource_release_bgm_single(config_sound_index);
			config_sound_index = -1;
		}

		// \[Xǂݍ݂
		config_sound_index = resource_load_bgm_single(SOUNDTEST_ZMD_INDEX, fullpath);
		if (config_sound_index < 0) {
			kon_log("config_move_sound : BGM\[X̓ǂݍ݂Ɏs܂Bpath=%s\n", fullpath);
			return -1;
		}

		// Đ
		sound_play_bgm(config_sound_index);
	}

	// <<< STOP >>>
	if (p_input_parser->trg_sub_clicked) {
		// Tu{^Ŏ~߂
		sound_stop_bgm();

		// ǂݍݍς̃TEheXg\[X烊[X
		if (config_sound_index >= 0) {
			resource_release_bgm_single(config_sound_index);
			config_sound_index = -1;
		}
	}

	// I
	return 0;
}

//=============================================================
// ̃gbNIԁi0FȂ  1Fj
//=============================================================
int config_next_track(int depth)
{
	int current_stage = config_sound_stage;	// ÕXe[W
	int current_track = config_sound_track;	// ÕgbN
	int stage_next = 0;	// Xe[WɃJ[\ڂꍇ1
	char* bgm_path = NULL;
	int bgm_buffer_max_size = bgmindex_count * (bgmtype_count + MAX_SECTION);

	// depths߂璆f
	if (depth > bgm_buffer_max_size) {
		// Ȃ̂Ōɖ߂ 0 Ԃ
		config_sound_stage = current_stage;
		config_sound_track = current_track;
		return 0;
	}

	// gbNi߂
	config_sound_track += 1;
	if (config_sound_track >= (bgmtype_count + MAX_SECTION)) {
		config_sound_track = 0;
		stage_next = 1;
	}

	// BGMi߂
	if (stage_next) {
		config_sound_stage += 1;
		if (config_sound_stage >= bgmindex_count) {
			config_sound_stage = 0;
		}
	}

	// BGM̑ݗLmF
	bgm_path = resource_conf.bgm[config_sound_stage][config_sound_track];
	if (
		   (bgm_path == NULL)
		|| (strcmp(bgm_path, SOUND_SILENT_WORD) == 0)
	) {
		int result;
		// \[XȂ΍ċNĂяo
		result = config_next_track(depth + 1);
		if (result != 1) {
			// Ȃ̂Ōɖ߂ 0 Ԃ
			config_sound_stage = current_stage;
			config_sound_track = current_track;
			return 0;
		}
	}

	// BGM̂1ŕԂ
	return 1;
}

//=============================================================
// ÕgbNIԁi0FȂ  1Fj
//=============================================================
int config_prev_track(int depth)
{
	int current_stage = config_sound_stage;	// ÕXe[W
	int current_track = config_sound_track;	// ÕgbN
	int stage_prev = 0;	// OXe[WɃJ[\ڂꍇ1
	char* bgm_path = NULL;
	int bgm_buffer_max_size = bgmindex_count * (bgmtype_count + MAX_SECTION);

	// depths߂璆f
	if (depth > bgm_buffer_max_size) {
		// Ȃ̂Ōɖ߂ 0 Ԃ
		config_sound_stage = current_stage;
		config_sound_track = current_track;
		return 0;
	}

	// gbN߂
	config_sound_track -= 1;
	if (config_sound_track < 0) {
		config_sound_track = (bgmtype_count + MAX_SECTION) - 1;
		stage_prev = 1;
	}

	// BGMi߂
	if (stage_prev) {
		config_sound_stage -= 1;
		if (config_sound_stage < 0) {
			config_sound_stage = bgmindex_count - 1;
		}
	}

	// BGM̑ݗLmF
	bgm_path = resource_conf.bgm[config_sound_stage][config_sound_track];
	if (
		   (bgm_path == NULL)
		|| (strcmp(bgm_path, SOUND_SILENT_WORD) == 0)
	) {
		int result;
		// \[XȂ΍ċNĂяo
		result = config_prev_track(depth + 1);
		if (result != 1) {
			// Ȃ̂Ōɖ߂ 0 Ԃ
			config_sound_stage = current_stage;
			config_sound_track = current_track;
			return 0;
		}
	}

	// BGM̂1ŕԂ
	return 1;
}

//--------------------------------------------------------------------
//	[  ]
//		int config_draw()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̕`揈
//--------------------------------------------------------------------
int config_draw()
{
	int i;
	int allocsp = 0;
	int cursor_x[6] = { 50,  50,  50,  50,  50, 112 };
	int cursor_y[6] = { 89, 109, 153, 173, 217, 238 };
	SP_UNIT* sp = p_memory_map_buffer->sp_unit;
	p_stage_objects->sp_index_seq = 0;

	// <<< SP` >>>
	// J[\`
	{
		int idx = p_stage_context->section;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(1);	// SP1g
		if (allocsp < 1) {
			// mۂłȂ`߂
			return 0;
		}
		SP_SET(sp, cursor_x[idx], cursor_y[idx], 0x45, 5, 0, 0, 3);
		sp++;
	}

	// LEVEL\
	{
		int idx = p_stage_context->section;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(4);	// SP4g
		if (allocsp < 4) {
			// mۂłȂ`߂
			return 0;
		}

		// SPzu
		for (i = 0; i < 4; i++) {
			int spTop = 0x50 + (p_game_properties->game_level << 2);
			SP_SET(sp, 144 + (i << 4), cursor_y[0], spTop + i, 5, 0, 0, 3);
			sp++;
		}
	}

	// c@\
	{
		draw_digits(p_game_properties->life, 141, cursor_y[1]);
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	}

	// L[oCh
	{
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(2);	// SP2g
		if (allocsp < 2) {
			// mۂłȂ`߂
			return 0;
		}
		if (p_game_properties->reverse_trigger == 0) {
			// ʏ:BōU AŃWv
			SP_SET(sp, 141, cursor_y[2], 0x50 + 19, 5, 0, 0, 3);
			sp++;
			SP_SET(sp, 141, cursor_y[3], 0x50 + 18, 5, 0, 0, 3);
			sp++;
		}
		else {
			// ]:AōU BŃWv
			SP_SET(sp, 141, cursor_y[2], 0x50 + 18, 5, 0, 0, 3);
			sp++;
			SP_SET(sp, 141, cursor_y[3], 0x50 + 19, 5, 0, 0, 3);
			sp++;
		}
	}

	// TEh
	{
		// stage
		draw_digits(config_sound_stage, 141, cursor_y[4]);
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^

		// track
		draw_digits(config_sound_track, 141+24, cursor_y[4]);
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^

		// |
		allocsp = sp_alloc_index(1);	// SP1g
		if (allocsp < 1) {
			// mۂłȂ`߂
			return 0;
		}
		SP_SET(sp, 141+8, cursor_y[4], 0x50 + 20, 5, 0, 0, 3);
		sp++;
	}

	// <<< SP̎c̈ >>>
	//
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {

		// Wړ
		sp->x = 0;
		sp->y = 0;
		// ̃jbgɐi
		sp++;
	}

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// <<< OtBbN̈ʒuύX >>>
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int help_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		0 : ̃Xe[W
//		1 : exit
//		ȊO : G[
//
//	[  ]
//		^Cg
//--------------------------------------------------------------------
int help_move()
{
	int help_exit = 0;
	int prev_page = p_stage_context->section;

	// {^EŃy[Wi߂
	if ((p_input_parser->trg_main_clicked)
		|| ((p_input_parser->stick_in_count==1) && (p_input_parser->direction_id==6))
	) {
		// y[Wi߂
		p_stage_context->section += 1;
		if (p_stage_context->section >= 16) {
			p_stage_context->section = 15;
		}

		// ŏIy[W`FbN
		if (((prev_page==15) && (p_stage_context->section == 15))
			&& (p_input_parser->direction_id != 6)) {
			// Ō̃y[W𒴂߂
			help_exit = 1;
		}
		else {
			// SE炷
			play_se(&(p_sound_context->se_item[setype_cursor]));
		}
	}

	// Ńy[W߂
	if ((p_input_parser->stick_in_count == 1) && (p_input_parser->direction_id == 4)) {
		// y[Wi߂
		p_stage_context->section -= 1;
		if (p_stage_context->section < 0) {
			p_stage_context->section = 0;
		}

		// SE炷
		play_se(&(p_sound_context->se_item[setype_cursor]));
	}

	// Tu{^ESCŃ^Cgʂɖ߂
	if ((p_input_parser->pause_clicked) || (p_input_parser->trg_sub_clicked)) {
		help_exit = 1;
	}

	// tO^Cgɖ߂
	if (help_exit) {
		p_stage_context->stage = 1;
		p_stage_context->section = 2;

		// SE炷
		play_se(&(p_sound_context->se_item[setype_cursorok]));
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int help_draw()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̕`揈
//--------------------------------------------------------------------
int help_draw()
{
	int i;
	int txt_x, txt_y;
	int palet_page[16] = { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 };
	int allocsp = 0;
	SP_UNIT* sp = p_memory_map_buffer->sp_unit;
	p_stage_objects->sp_index_seq = 0;

	// <<< TXT̍W߂ >>>
	txt_x = ((p_stage_context->section & 3) << 8) & 1023;
	txt_y = ((p_stage_context->section >> 2) << 8) & 1023;

	// <<< SP` >>>
	// NOP

	// <<< SP̎c̈ >>>
	//
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {

		// Wړ
		sp->x = 0;
		sp->y = 0;
		// ̃jbgɐi
		sp++;
	}

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 1;

	// <<< eLXg̈ʒuύX >>>
	p_memory_map_buffer->txt_scroll_unit.tx_x = txt_x;
	p_memory_map_buffer->txt_scroll_unit.tx_y = txt_y;

	// <<< eLXg̃pbg] >>>
	stack_transfer_pal(p_stage_context->text_pal_slot, palet_page[p_stage_context->section & 15], 0, 1);
	return 0;
}
