#define __SUBWEAPON_C__
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "subweapon.h"
#include "explode.h"
#include "esp.h"
#include "stage.h"

//=========================================
// vg^Cv錾
//=========================================
// Ռg
void subshot_w_init(SubWeaponType type, void* pTarget, int array_index, int dummy, int theta, int radius, int omega);	// 
void subshot_s_init(SubWeaponType type, void* pTarget, int array_index, int dummy, int theta, int radius, int omega);	// 
void subshot_init_core(void* pTarget, int array_index, int dummy, int theta, int radius, int omega);	// 
void subshot_move(void* pTarget);	// ړ֐ւ̃|C^
void subshot_draw(void* pTarget);	// `֐ւ̃|C^
//
void subshot_bomb_init(SubWeaponType type, void* pTarget, int array_index);	// {
void subshot_bomb_move(void* pTarget);	// ړ֐ւ̃|C^
void subshot_bomb_draw(void* pTarget);	// `֐ւ̃|C^

//--------------------------------------------------------------------
//	[  ]
//		void appear_subweapon(SubWeaponType type, int hx, int hy, int vel1, int vel2)
//
//	[  ]
//		SubWeaponType type  TuEF|̎
//      int hx              oXW
//      int hy              oYW
//      int p1              p[^1
//      int p2              p[^2
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		TuEF|o܂B
//      p1`p2̎ǵAtypeɂĈقȂ܂B
//--------------------------------------------------------------------
void appear_subweapon(SubWeaponType type, int hx, int hy, int p1, int p2)
{
    SUBWEAPON* pSub;
    int array_index;

    // ID𓾂
    array_index = POP_IDSTACK_SUBWEAPON;
    if (array_index < 0) {
        // gIDΉȂ
        return;
    }
    pSub = &(p_stage_objects->subweapon[array_index]);

    // TuEF|
    switch (type) {
    case subweapon_subshot_w:
        // ՌgijF(hx, hy)=oʒu, (p1, p2)=x
        subshot_w_init(type, pSub, array_index, hx, hy, p1, p2);
        break;

    case subweapon_subshot_s:
        // ՌgijF(hx, hy)=oʒu, (p1, p2)=x
        subshot_s_init(type, pSub, array_index, hx, hy, p1, p2);
        break;

    case subweapon_bomb:
        // {
        subshot_bomb_init(type, pSub, array_index);
        break;

    default:
        // sȃ^Cv
        kon_log_single(ERROR_UNKNOWN_SUBWEAPON, "appear_subeweapon : sȃTuEF|^Cv %d\n", type);
        break;
    }

    return;
}


//=============================================================================
// Ռg
//=============================================================================
// 
void subshot_w_init(SubWeaponType type, void* pTarget, int array_index, int hx, int hy, int vx, int vy)
{
    SUBWEAPON* pSub = pTarget;
    subshot_init_core(pTarget, array_index, hx, hy, vx, vy);
    pSub->type = type;
    pSub->hittype = hittype_blade;
    pSub->ap = SUBSHOT_W_AP;
}

// 
void subshot_s_init(SubWeaponType type, void* pTarget, int array_index, int hx, int hy, int vx, int vy)
{
    SUBWEAPON* pSub = pTarget;
    subshot_init_core(pTarget, array_index, hx, hy, vx, vy);
    pSub->type = type;
    pSub->hittype = hittype_blade;
    pSub->ap = SUBSHOT_S_AP;
}

// core
void subshot_init_core(void* pTarget, int array_index, int hx, int hy, int vx, int vy)
{
    SUBWEAPON* pSub = pTarget;
    CHROBJ* pObj = &(pSub->obj);
    OBJPOS* pPos = &(pSub->obj.pos);

    // NA
    memset(pSub, 0, sizeof(SUBWEAPON));

    // ʒuݒ肷
    pPos->hx = hx;
    pPos->hy = hy;
    pPos->vx = vx;
    pPos->vy = vy;
    pPos->px = pPos->hx >> 8;
    pPos->py = pPos->hy >> 8;

    // ̈ݒ肷
    pObj->hit_bbox.x0 = -24;
    pObj->hit_bbox.x1 = +24;
    pObj->hit_bbox.y0 = -12;
    pObj->hit_bbox.y1 = +12;

    // Xe[^Xݒ
    pSub->ap = 1;
    pSub->hp = 1;
    pSub->obj.status = status_normal;
    pSub->obj.array_index = array_index;
    // ݒ
	if (pPos->vx < 0) { pSub->obj.direction = dir_left; }
	else { pSub->obj.direction = dir_right; }

    // ֐ݒ
    pSub->obj.move = subshot_move;
    pSub->obj.draw = subshot_draw;

    // Nq
    pSub->p_next = p_stage_objects->subweapon_top;
    if (pSub->p_next != NULL) {
        pSub->p_next->p_prev = pSub;
    }
    p_stage_objects->subweapon_top = pSub;

    // I
    return;
}

//=============================================================================
// TuVbg̈ړ
//=============================================================================
void subshot_move(void* pTarget)
{
    SUBWEAPON* pSub = pTarget;
    CHROBJ* pObj = &(pSub->obj);
    OBJPOS* pPos = &(pObj->pos);

    // Wݒ
    pPos->hx += pPos->vx;
    pPos->hy += pPos->vy;
    pPos->px = pPos->hx >> 8;
    pPos->py = pPos->hy >> 8;

    // JEgi߂
    pObj->frame_count += 1;

    // 苗Ԑi񂾂
    if (pObj->frame_count > 8) {
        dispose_subweapon(pSub);
    }

    return;
}

//=============================================================================
// IvV̕`揈
//=============================================================================
void subshot_draw(void* pTarget)
{
    SUBWEAPON* pSub;
    OBJPOS* pPos;
    SP_UNIT* sp;
    int hx, hy, px, py;
    int sp_index;
    int allocsp = 0;
    //
    int pattern_offset;
    int pal;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x1C;

    pSub = pTarget;
    pPos = &(pSub->obj.pos);

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(2);
    if (allocsp < 2) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // p^[̃CfbNX𓱏o
    pattern_offset = (((pSub->obj.frame_count-1) >> 1) & 3) << 1;

    // pbg߂
    pal = (pSub->type == subweapon_subshot_w) ? 6 : 7;

    // }bvobt@Ƀf[^i[
    if (pSub->obj.direction == dir_right) {
        SP_SET(sp, px, py + 8, sp_code_top + pattern_offset, pal, 0, 0, 3);
        sp++;
        SP_SET(sp, px+16, py + 8, sp_code_top + 1 + pattern_offset, pal, 0, 0, 3);
        sp++;
    }
    else {
		SP_SET(sp, px, py + 8, sp_code_top + 1 + pattern_offset, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 8, sp_code_top + pattern_offset, pal, 1, 0, 3);
		sp++;
    }

    return;
}


//=============================================================================
// {̏
//=============================================================================
void subshot_bomb_init(SubWeaponType type, void* pTarget, int array_index)
{
    SUBWEAPON* pSub = pTarget;
    CHROBJ* pObj = &(pSub->obj);
    OBJPOS* pPos = &(pSub->obj.pos);

    // NA
    memset(pSub, 0, sizeof(SUBWEAPON));

    // ʒuݒ肷
    pPos->hx = 0;
    pPos->hy = 0;
    pPos->vx = 0;
    pPos->vy = 0;
    pPos->px = pPos->hx >> 8;
    pPos->py = pPos->hy >> 8;

    // ̈ݒ肷
    pObj->hit_bbox.x0 = 0;
    pObj->hit_bbox.x1 = 0;
    pObj->hit_bbox.y0 = 0;
    pObj->hit_bbox.y1 = 0;

    // Xe[^Xݒ
    pSub->type = subweapon_bomb;
    pSub->hittype = hittype_bomb;
    pSub->ap = BOMB_AP;
    pSub->hp = 1;
    pSub->obj.status = status_normal;
    pSub->obj.array_index = array_index;

    // ֐ݒ
    pSub->obj.move = subshot_bomb_move;
    pSub->obj.draw = subshot_bomb_draw;

    // Nq
    pSub->p_next = p_stage_objects->subweapon_top;
    if (pSub->p_next != NULL) {
        pSub->p_next->p_prev = pSub;
    }
    p_stage_objects->subweapon_top = pSub;

    // {AL𖳓Gɂ
    if (p_stage_objects->jiki.obj.status != status_absent) {
        p_stage_objects->jiki.invincible = (BOMB_DURATION + JIKI_SPECIAL_INVINCIBLE);
    }

    // I
    return;
}

//=============================================================================
// {̈ړ
//=============================================================================
void subshot_bomb_move(void* pTarget)
{
    SUBWEAPON* pSub = pTarget;
    CHROBJ* pObj = &(pSub->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy;

    // GtFNgo
    if ((pObj->frame_count & 3) == 0) {
        hx = p_stage_context->bgview_hx + ((vrand() & 255) << 8);
        hy = p_stage_context->bgview_hy + ((vrand() & 255) << 8);
        appear_exp(exptype_bigblue, hx, hy, 256);
    }

    if ((pObj->frame_count & 15) == 0) {
        // 
        play_se(&(p_sound_context->se_item[setype_bombexp]));
    }

    // 蔻̈ʑŜɐݒ肷
    hx = p_stage_context->bgview_hx + (128 << 8);
    hy = p_stage_context->bgview_hy + (128 << 8);
    pPos->hx = hx;
    pPos->hy = hy;
    pPos->px = hx >> 8;
    pPos->py = hy >> 8;
    pObj->hit_bbox.x0 = -128;
    pObj->hit_bbox.y0 = -128;
    pObj->hit_bbox.x1 = 128;
    pObj->hit_bbox.y1 = 128;

    // Ge
    {
        ENESHOT* pEneShot = p_stage_objects->eneshot_top;
        while (pEneShot != NULL) {
            ENESHOT* pNext = pEneShot->p_next;
            if (pEneShot->type != eneshottype_lastoinari) {
                // ŏIXe[ŴȂ͏Ȃ
                dispose_eneshot(pEneShot);
            }
            pEneShot = pNext;
        }
    }

    // GԂXVF{Ƀ_bVUƖGr؂̂ŋōXV
    p_stage_objects->jiki.invincible = JIKI_SPECIAL_INVINCIBLE;

    // JEgi߂
    pObj->frame_count += 1;

    // 苗Ԑi񂾂
    if (pObj->frame_count > BOMB_DURATION) {
        dispose_subweapon(pSub);
    }

    return;
}

//=============================================================================
// {̕`揈
//=============================================================================
void subshot_bomb_draw(void* pTarget)
{
    // `Ȃ
    return;
}
