#ifndef __STRUCTS_H__
#define __STRUCTS_H__
#include "constants.h"

//============================================================================
// 萔̌^`
//============================================================================
#define MAX_SUBWEAPON		8	// TuEF|̍ő吔
#define MAX_ENEMY			16	// GIuWFNg̍ő吔
#define MAX_ENESHOT			16	// GeIuWFNg̍ő吔
#define MAX_EXPLODE			16	// IuWFNg̍ő吔
#define MAX_ITEM			32	// ACeIuWFNg̍ő吔
#define MAX_ESP				16	// EffectSPIuWFNg̍ő吔
//
#define BGMESH_SIZE			(4)	// BGbV̉ʕ
#define STAGE_DESC_LINES	(2)	// Xe[WLq̒`C
//
#define JIKI_HISTORY_LENGTH	(8)	// L̎cqXg̒
#define JIKI_HISTORY_MASK	(7)	// L̎cqXgindex}XN

//============================================================================
// enum̒`
//============================================================================
//
// Փxݒl
typedef enum _GameLevel {
	game_level_easy = 0
	, game_level_novice
	, game_level_normal
	, game_level_hard
	//
	, game_level_count	// x
} GameLevel;

// IuWFNg̏Ԓl
typedef enum _ObjStatus {
	status_absent = 0	// s
	, status_normal		// ʏ
	//
	, status_attack		// ʏU
	, status_charge		// ߒ
	//
	, status_on_magic	// @
	, status_on_return	// @߂蒆
	, status_dash		// _bVړ
	//
	, status_damage		// _[WmbNobN
	, status_on_down	// _E
	//
	, status_boss_1		// {XԑJ1
	, status_boss_2		// {XԑJ2
	, status_boss_3		// {XԑJ3
	, status_boss_4		// {XԑJ4
	, status_boss_5		// {XԑJ5
	, status_boss_6		// {XԑJ6
	, status_boss_7		// {XԑJ7
	, status_boss_8		// {XԑJ8
	, status_boss_9		// {XԑJ9
} ObjStatus;

// TuEF|̎
typedef enum _SubWeaponType {
	  subweapon_absent = 0
	, subweapon_subshot_w	// Ռgij
	, subweapon_subshot_s	// Ռgij
	, subweapon_bomb		// {
	//
	, subweapontype_count
} SubWeaponType;

// U̎
typedef enum _HitType {
	hittype_blade	// ɂU
	, hittype_dash	// _bVU
	, hittype_bomb	// {ɂU
	, hittype_charge	// `[W̎LƂ̐ڐG
	, hittype_magic	// @ɂU
	//
	, hittype_enemy	// G{̂Ƃ̐ڐG
	, hittype_eneshot	// GeƂ̐ڐG
	, hittype_damage_floor	// _[W
	//
	, hittype_item	// ACe擾
} HitType;

// G̎
typedef enum _EneType {
	  enetype_dummy = 0	// _~[
	, enetype_slime		// XC
	, enetype_she_slime	// XCxX
	, enetype_mummy		// ~Cj
	, enetype_mummy_big	// ~Cjij
	, enetype_bat		// RE
	, enetype_ghost		// ΂
	, enetype_goblin	// Su
	, enetype_sorcerer	// \[T[
	, enetype_skel		// KCRc
	, enetype_eye		// 
	, enetype_knight	// Rm
	, enetype_robo		// {
	//
	, enetype_mid_mecha		// n
	, enetype_mid_cloud		// _
	, enetype_mid_barrel	// C
	, enetype_mid_madman	// }bh}
	//
	, enetype_boss1		// {X1
	, enetype_boss2		// {X2
	, enetype_boss3		// {X3
	, enetype_boss4		// {X4
	, enetype_boss5		// {X5
	, enetype_boss5opt	// {X5IvV
	, enetype_boss6		// {X6
	//
	, enetype_count		// Gʐ
} EneType;

// Ge̎
typedef enum _EneShotType {
	eneshottype_normal = 0	// ʏe
	, eneshottype_big		// ʏeij
	, eneshottype_wave		// Ռge
	, eneshottype_gravity	// e
	, eneshottype_grav_spd	// eij
	, eneshottype_axe		// 
	, eneshottype_fire		// 
	, eneshottype_flame		// 
	, eneshottype_laser		// [U[
	, eneshottype_sor		// \[T[̉
	, eneshottype_horming	// z[~Oe
	// {Xp
	, eneshottype_bubble	// {X1p̖A
	, eneshottype_boss2bat	// {X2p̃RE
	, eneshottype_boss3dust	// {X3p̃S~
	, eneshottype_boss4rock	// {X4p̊
	// ESP
	, eneshottype_lastoinari	// LastOinari
	//
	, eneshottype_count			// Geʐ
} EneShotType;

// ACe̎
typedef enum _ItemType {
	itemtype_dia = 0	// |CgACe
	, itemtype_boss_dia	// {Xo
	//
	, itemtype_count		// ʐ
} ItemType;

// Explode̎
typedef enum _ExplodeType {
	exptype_small = 0	// ij
	, exptype_big		// ij
	, exptype_bigblue	// ij
	//
	, exptype_count		// ESPʐ
} ExplodeType;

// ESP̎
typedef enum _ESPType {
	  esptype_smoke = 0		// 
	, esptype_bigsmoke		// ij
	, esptype_explode		// iFԁj
	, esptype_blueexp		// iFj
	, esptype_combolv		// R{x\
	, esptype_heart			// |Cgn[g
	, esptype_oinari		// Ȃ
	, esptype_eneshotmark	// Ge\
	, esptype_spark			// U˕Ԃ̃GtFNg
	, esptype_bossstar		// U˕Ԃ̃GtFNg
	, esptype_last			// XĝƂɂESP
	, esptype_glass			// KX̔j
	, esptype_lastoinari	// Ȃ
	//
	, esptype_count		// ESPʐ
} ESPType;

// BGM̎
typedef enum _BGMType {
	  bgmtype_main	= 0		// CBGM
	, bgmtype_boss			// {XBGM
	, bgmtype_intermission	// C^[~bVBGM
	, bgmtype_clear			// Xe[WNAWO
	//
	, bgmtype_count			// BGMʐ
} BGMType;

// SE̎
typedef enum _SEType {
	  setype_cursor = 0		// J[\
	, setype_blade			// u[h
	, setype_dash			// _bV
	, setype_item			// ACe擾
	, setype_enemy_down		// G_E
	, setype_magic			// @
	, setype_enedamage		// G_[W
	, setype_eneshot		// Ge
	, setype_cursorok		// J[\OK
	, setype_cursorng		// J[\NG
	, setype_jikidown		// @_E
	, setype_jikidamage		// @_[W
	, setype_stageclear		// Xe[WNA
	, setype_sectionclear	// ZNVNA
	, setype_dashhit		// _bVŨqbg
	, setype_bomb			// {
	, setype_bombexp		// {̔
	// XVI[hp
	, setype_jump			// Wv
	, setype_stepwater		// ̏
	, setype_flowwater		// 鉹
	, setype_oncharge		// `[WJn̉
	, setype_bombcharge		// {`[W̉
	, setype_step			// 
	//
	, setype_count			// SEʐ
} SEType;

//============================================================================
// \̂̌^`
//============================================================================
//-----------------
// SEɊւ
//-----------------
typedef struct _SE_ITEM {
	int valid;		// gp\ɂȂ1
	//
	int index;      // o^\[X̃CfbNXԍ
	int priority;   // ĐDx
	int frames;     // t[
	int same_priority_wait;    // Dx̂Ƃɑ҂ꍇ1w
	//
	int x68frq;		// X68000Ŗ炷Ƃ̎gݒi0`4j
} SE_ITEM;


//------------------------------------
// Np[^
//------------------------------------
typedef struct _STARTUP_PARAM {
	int start_stage;		// JnXe[W
	int start_stage_specified;	// JnXe[Ww肪ꂽƂ1
	int start_lv;			// Jn̎Lx
	//
	int XVI;				// XVI[ĥƂ1
	//
	int skip_title;			// ^CgXLbv
	int skip_intermission;	// C^[~bVXLbv
	int display_vd_wait_skipped;	// ɏԂɍȂɃ}[N\
	int disable_sound;	// TEhOFFɂ
	//
	int record_score_log;	// XRAOL^
	//
	int default_game_level;	// ftHg̃Q[x
	//
	int parse_result;		// p[X 0: 1:炩̎s
	char error_message[96];	// G[bZ[W
} STARTUP_PARAM;


//------------------------------------
// \[Xݒ
//------------------------------------
// BGM̔ԍ`
typedef enum _BGMIndex {
	bgmindex_title = 0
	, bgmindex_st1
	, bgmindex_st2
	, bgmindex_st3
	, bgmindex_st4
	, bgmindex_st5
	, bgmindex_st6
	, bgmindex_ending
	//
	, bgmindex_count
} BGMIndex;

// 1SE̐ݒl
typedef struct _SE_CONF {
	char* filename;			// t@C
	int priority;			// ĐDx
	int frames;				// t[
	int same_priority_wait;	// Dx̂Ƃɑ҂ꍇ1w
	int x68frq;				// X68000Ŗ炷Ƃ̎gݒi0`4j
} SE_CONF;

// \[Xݒl
typedef struct _RESOURCE_CONF {
	// DIR
	char* dir_bgm;
	char* dir_se;
	
	// BGM
	char* bgm[bgmindex_count][bgmtype_count + MAX_SECTION];	// 0:MAIN, 1:BOSS, 2:Intermission, 3`:ZNV

	// SE
	SE_CONF se[setype_count];
} RESOURCE_CONF;


//------------------------------------
// Wl
//------------------------------------
typedef struct _OBJCRD {
	int x;
	int y;
} OBJCRD;

//------------------------------------
// oEfBO{bNX
//------------------------------------
typedef struct _BBOX {
	int x0;	// (X)
	int y0;	// (Y)
	int x1;	// E(X)
	int y1;	// E(Y)
} BBOX;

//------------------------------------
// WǗ
//------------------------------------
typedef struct _OBJPOS {
	int ax;	// xiŒ菬_j
	int ay;
	int vx;	// xiŒ菬_j
	int vy;
	int hx;	// WiŒ菬_j
	int hy;
	int px;	// XN[W
	int py;
} OBJPOS;

//------------------------------------
// W
//------------------------------------
typedef struct _POSHISTORY {
	int px;	// XN[W
	int py;
	Direction direction;
} POSHISTORY;


//------------------------------------
// ǁEڐG茋
//------------------------------------
typedef struct _GROUNDING_COLLISION {
	int top;		// VɐڐG
	int bottom;		// ɐڐG
	int left;		// ̕ǂɐڐG
	int right;		// E̕ǂɐڐG
	int hook;		// Ԃ牺
} GROUNDING_COLLISION;

//------------------------------------
// LN^IuWFNg̊{
//------------------------------------
typedef struct _CHROBJ {
	// z֘A
	int array_index;	// zł̃CfbNXԍ

	// t[JE^
	int frame_count;

	// W
	OBJPOS pos;	// IuWFNg̍W
	OBJPOS prev_pos;	// 1t[O̍W

	// oEfBO{bNX
	BBOX grd_bbox;	// ڒnpoEfBO{bNX
	BBOX hit_bbox;	// UE_[W蔻
	int out_of_screen;	// ʊÔƂ1ɂȂtO

	// Ԓl
	ObjStatus status;			// 
	Direction direction;		// 
	int anim_index;				// Aj[ṼCfbNXԍ
	GROUNDING_COLLISION gcol;	// ڒnڐGi㉺Ej
	int effect_span;			// SEESPAŔۂ̃t[Xp
	int hit_stop_ready;			// qbgXgbv\ȂƂ1

	// \bh
	void (*move)(void* pTarget);			// ړ֐ւ̃|C^
	void (*draw)(void* pTarget);			// `֐ւ̃|C^
	void (*grounding)(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// ڒn֐ւ̃|C^
	void (*on_hit)(HitType hittype, void* pTarget, struct _CHROBJ* pObject, int ap);	// j󎞂̏
} CHROBJ;

//------------------------------------
// @L
//------------------------------------
typedef struct _JIKI {
	// ʒu
	CHROBJ	obj;

	// ʒuhistory
	OBJPOS pos_history[JIKI_HISTORY_LENGTH];

	// GJEgiJEg_Ej
	int invincible;

	// Gł_łȂƂ1
	int invincible_no_blink;

	// VbvɓƂ1
	int on_shopdoor;
} JIKI;

//------------------------------------
// u[hiUj
//------------------------------------
typedef struct _BLADE {
	int ap;
	CHROBJ	obj;
} BLADE;

//------------------------------------
// @
//------------------------------------
// qIuWFNg
typedef struct _MAGIC_BURRET {
	// IuWFNg
	OBJPOS target;	// ړ^[QbgW
	CHROBJ obj;		// IuWFNg̊{
} MAGIC_BURRET;

// eIuWFNg
typedef struct _MAGIC {
	// 
	int ap;

	// IuWFNg
	CHROBJ	obj;

	// qIuWFNg
	MAGIC_BURRET child[8];
} MAGIC;

//------------------------------------
// TuEF|
//------------------------------------
typedef struct _SUBWEAPON {
	SubWeaponType type;
	HitType hittype;
	int hp;
	int ap;
	CHROBJ	obj;
	struct _SUBWEAPON* p_prev;
	struct _SUBWEAPON* p_next;
} SUBWEAPON;

//------------------------------------
// GL
//------------------------------------
typedef struct _ENEMY {
	int desc_line;	// GLq̃CԍicǗpB-1̏ꍇ͎cǗOj
	EneType	type;	// 
	int param;		// ʃp[^
	int	hp;
	int hp_max;
	int on_damage;
	CHROBJ	obj;	// IuWFNg̊{
	//
	int eneshot_delay[64];	// Ge˃fBCJE^
	int eneshot_delay_control;	// CfbNX
	int eneshot_delay_regist;	// o^CfbNX
	void (*do_eneshot)(void* pTarget);	// Geˊ֐ւ̃|C^
	//
	int option_param[5];	// IvViRpp[^j
	//
	struct _ENEMY* p_prev;
	struct _ENEMY* p_next;
} ENEMY;

//------------------------------------
// Ge
//------------------------------------
typedef struct _ENESHOT {
	EneShotType	type;	// 
	CHROBJ	obj;	// IuWFNg̊{
	struct _ENESHOT* p_prev;
	struct _ENESHOT* p_next;
} ENESHOT;

//------------------------------------
// 
//------------------------------------
typedef struct _EXPLODE {
	CHROBJ	obj;
	struct _EXPLODE* p_prev;
	struct _EXPLODE* p_next;
} EXPLODE;

//------------------------------------
// ACe
//------------------------------------
typedef struct _ITEM {
	ItemType	type;	// 
	CHROBJ	obj;		// IuWFNg̊{
	int		lv;			// ACẽx
	int		timeout;	// ^CAEgJEg
	struct _ITEM* p_prev;
	struct _ITEM* p_next;
} ITEM;

//------------------------------------
// EffectSP
//------------------------------------
typedef struct _ESP {
	ESPType	type;	// 
	CHROBJ	obj;	// IuWFNg̊{
	// IvV
	int opt[5];	// ǉ5炢
	// N
	struct _ESP* p_prev;
	struct _ESP* p_next;
} ESP;

//------------------------------------
// VbvJ[\
//------------------------------------
typedef struct _SHOP_CURSOR {
	int disable;	// ~Ƃ1
	int sold[6];	// wςɂȂ1
	CHROBJ	obj;
} SHOP_CURSOR;

//--------------------------
// ̓p[T
//--------------------------
typedef struct _INPUT_PARSER {
	// <<< XeBbNȊO̓͏ >>>
	int keyin_pause;				// PAUSEL[
	int pause_clicked;				// PAUSENbNꂽuԂ1
	int keyin_ss;					// SSL[
	int ss_clicked;					// SSNbNꂽuԂ1
	int keyin_force_shop;			// SHOP
	int keyin_force_over;			// Q[I[o[
	int keyin_toggle_fullscreen;	// tXN[[h̃gO

	// <<< L[̓͏Ԓl >>>
	int direction_id;

	// <<< XeBbN͏ >>>
	// A͂̃t[
	int trg_main_on_count;
	int trg_sub_on_count;

	// gK̃NbN
	int trg_main_clicked;
	int trg_sub_clicked;

	// gK
	int trg_same_time;
	int trg_same_time_clicked;

	// XeBbN͒̃t[
	int stick_in_count;
} INPUT_PARSER;

//--------------------------
// obNOEhbV
//--------------------------
typedef struct _BGMESH {
	unsigned char bgmesh_enemy[BGMESH_SIZE][BGMESH_SIZE][MAX_ENEMY];		// BGbViGj
	unsigned char bgmesh_eneshot[BGMESH_SIZE][BGMESH_SIZE][MAX_ENESHOT];	// BGbViGej
	unsigned char bgmesh_item[BGMESH_SIZE][BGMESH_SIZE][MAX_ITEM];			// BGbViACej
	unsigned char bgmesh_count_enemy[BGMESH_SIZE][BGMESH_SIZE];				// o^iGj
	unsigned char bgmesh_count_eneshot[BGMESH_SIZE][BGMESH_SIZE];			// o^iGej
	unsigned char bgmesh_count_item[BGMESH_SIZE][BGMESH_SIZE];				// o^iACej
	//
	unsigned char processed_enemy[MAX_ENEMY];		// σCfbNXiGj
	unsigned char processed_eneshot[MAX_ENESHOT];	// σCfbNXiGej
	unsigned char processed_item[MAX_ITEM];			// σCfbNXiACej
} BGMESH;

//--------------------------
// Xe[W̃IuWFNg
//--------------------------
typedef struct _STAGE_OBJECTS {
	// <<< Xe[Wl >>>
	// t[JEg
	int		frame_count;
	int		slow_mode;
	int		hit_stop;	// hit stopƂ1
	int		pause_cursor;	// PAUSẼJ[\ʒu 0:NO  1:YES
	// ^C{[iXl
	int		time_limit[TIME_LIMIT_DIGITS];
	// R{
	int		combo_lv;
	int		combo_timeout;

	// SP蓖ẴCfbNX̃V[PXJE^
	int		sp_index_seq;

	// <<< NA{[iXXRAi\pj >>>
	int		clear_bonus_time;
	int		clear_bonus_hp;

	// <<< LN^ >>>
	// @IuWFNg
	JIKI	jiki;

	// u[h
	BLADE	blade;

	// @
	MAGIC	magic;

	// TuEF|
	SUBWEAPON	subweapon[MAX_SUBWEAPON];
	int subweapon_id_stack[MAX_SUBWEAPON];
	int subweapon_id_stack_ptr;
	SUBWEAPON* subweapon_top;

	// G
	ENEMY	enemy[MAX_ENEMY];
	int enemy_id_stack[MAX_ENEMY];
	int enemy_id_stack_ptr;
	ENEMY* enemy_top;	// Xg̐擪
	int enemy_existing[STAGE_DESC_LINES];	// Go

	// Ge
	ENESHOT	eneshot[MAX_ENESHOT];
	int eneshot_id_stack[MAX_ENESHOT];
	int eneshot_id_stack_ptr;
	ENESHOT* eneshot_top;

	// 
	EXPLODE	explode[MAX_EXPLODE];
	int explode_id_stack[MAX_EXPLODE];
	int explode_id_stack_ptr;
	EXPLODE* explode_top;

	// ACe
	ITEM item[MAX_ITEM];
	int item_id_stack[MAX_ITEM];
	int item_id_stack_ptr;
	ITEM* item_top;

	// EffectSP
	ESP esp[MAX_ESP];
	int esp_id_stack[MAX_ESP];
	int esp_id_stack_ptr;
	ESP* esp_top;

	// <<< BGbV@>>>
	BGMESH bgmesh;

	// <<< Vbv֘A >>>
	SHOP_CURSOR shop_cursor;
	int shop_closed;

	// <<<  >>>
	INPUT_PARSER input_parser;
} STAGE_OBJECTS;

//----------------------------
// Xe[WɏoG̒`
//----------------------------
typedef struct _STAGE_ENEMY_DESC {
	// Gʁienum EneTypej
	EneType	type;

	// p[^
	int param;

	// Gc
	int remains;
} STAGE_ENEMY_DESC;

//-----------------
// Xe[W̑
//-----------------
typedef struct _STAGE_DESC {
	// ɏo\ȓG̐
	int enemy_max;

	// Gc
	int enemy_remain;

	// Xe[WɏoG̃Xg
	STAGE_ENEMY_DESC stage_enemy_desc[enetype_count];
} STAGE_DESC;

#endif
