#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "stage.h"
#include "jiki.h"
#include "magic.h"
#include "subweapon.h"
#include "common.h"

void st5_scroll_txt_common(int sx0, int sy0, int sx1, int sy1, int ox, int oy, int width, int height);

int st5_txt_cx = 0;
int st5_txt_cy = 0;

//--------------------------------------------------------------------
//	[  ]
//		int st5_on_start()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[WJn1񂾂s鏈
//--------------------------------------------------------------------
int st5_on_start()
{
	// -----< XN[ʒu >-----
	// 
	st5_txt_cx = 0;
	st5_txt_cy = 256;

	// -----<  >-----
    //
    // BGMĐ
    if (p_game_properties->disable_sound == 0) {
        sound_play_bgm(p_sound_context->bgm_index[bgmtype_main]);
    }

    // -----< \ݒ >-----
    //
	stack_transfer_pal(p_stage_context->text_pal_slot, p_stage_context->text_pal_block, 0, 1);

    // I
    return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void st5_event()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[Ws̃Cxg
//--------------------------------------------------------------------
void st5_event()
{
	int anim_index;
	int shop_index;
	int on_anim;

	// ̉
	if (startup_param.XVI) {
		if ((p_application_context->frame_count & 31) == 0) {
			if (p_stage_context->section == 3) {
				play_se(&(p_sound_context->se_item[setype_flowwater]));
			}
		}
	}

	// ^C~OłȂΉȂ
	on_anim = ((p_stage_objects->frame_count & 7) == 0);	// 8t[11ɂȂ
	if (on_anim == 0) {
		return;
	}

	// Aj[ṼCfbNXԍ
	anim_index = (p_stage_objects->frame_count >> 3) & 3;
	shop_index = (p_stage_objects->frame_count >> 3) & 3;

	// VbṽAjp^[]
	if (on_anim) {
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot
			, 0x40 + (shop_index << 2) + (p_stage_objects->shop_closed == 0 ? 0 : 0x80)
			, 0x1C
			, 4);
	}

	// n`̃Ajp^[
	// SP̃p^[]̃CfbNX𓾂
	switch (p_stage_context->section) {
	case 2:
	case 3:
		// n
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0x58 + (anim_index << 4), 0x23, 6);
		// 
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0xA0 + ((anim_index << 1) + anim_index), 0x29, 3);
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0xB0 + ((anim_index << 1) + anim_index), 0x39, 3);
		break;
	case 4:
		// n
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0x50 + (anim_index << 4), 0x30, 8);
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0x58 + (anim_index << 4), 0x23, 6);
		break;
	case 7:
	case 8:
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0x90 + ((anim_index << 1) + anim_index), 0x27, 3);
		break;
	case 9:
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0x5E + (anim_index << 4), 0x23, 1);
		break;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void st5_section_clear_event(int next_section)
//
//	[  ]
//		int next_section	̃ZNV̔ԍiŏ̃ZNV1j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[Ws̃Cxg
//--------------------------------------------------------------------
void st5_section_clear_event(int next_section)
{
	switch (next_section) {
	case 5:
		// 
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 0, 0, 32);
		break;
	case 6:
		// ؂̃ZNV2 ~Co
		stack_transfer_sp(p_stage_context->ene_sp_slot, 0x10, 0x90, 16);
		break;
	case 7:
		// ؁
		stack_transfer_sp(p_stage_context->bgmap_anim_sp_slot, 32, 32, 32);
		//
		// ؂̃ZNVʉ߂̂Ō̊Gɖ߂
		stack_transfer_sp(p_stage_context->ene_sp_slot, 0x00, 0x90, 16);
		// K[SC̊G]
		stack_transfer_sp(p_stage_context->ene_sp_slot, 0x20, 0x90, 9);
		break;
	default:
		// NOP
		break;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void st5_scroll_txt()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[Ws̃eLXgʂ̃XN[
//--------------------------------------------------------------------
void st5_scroll_txt()
{
	int dx, dy;
	int speed = 8;
	int st = p_stage_context->stage - 1;
	int sc = p_stage_context->section - 1;

	switch (p_stage_context->section) {
	case 1:
	case 2:
		st5_scroll_txt_common(
			def_stage_section_area[st][0][0][0]		// ZNV1̍
			, def_stage_section_area[st][0][0][1]
			, def_stage_section_area[st][1][0][2]	// ZNV2̉E
			, def_stage_section_area[st][1][0][3]
			, 0, 256, 128, 0);
		// ŏ̃GA͋wBC^[~bV̍邽߁B
		p_memory_map_buffer->txt_scroll_unit.tx_x = st5_txt_cx;
		p_memory_map_buffer->txt_scroll_unit.tx_y = st5_txt_cy;
		break;
	case 3:
		st5_scroll_txt_common(
			def_stage_section_area[st][2][0][0]		// ZNV3̍
			, def_stage_section_area[st][2][0][1]
			, def_stage_section_area[st][2][0][2]	// ZNV3̉E
			, def_stage_section_area[st][2][0][3]
			, 384, 256, 128, 0);
		break;
	case 4:
		st5_scroll_txt_common(
			def_stage_section_area[st][3][0][0]		// ZNV4̍
			, def_stage_section_area[st][3][0][1]
			, def_stage_section_area[st][3][0][2]	// ZNV4̉E
			, def_stage_section_area[st][3][0][3]
			,384, 0, 128, 0);
		break;
	case 5:
		st5_scroll_txt_common(
			def_stage_section_area[st][4][0][0]		// ZNV5̍iCӂŗǂj
			, def_stage_section_area[st][4][0][1]
			, def_stage_section_area[st][4][0][2]	// ZNV5̉EiCӂŗǂj
			, def_stage_section_area[st][4][0][3]
			, 128, 0, 0, 0);
		break;
	case 6:
		st5_scroll_txt_common(
			def_stage_section_area[st][5][0][0]		// ZNV6̍iCӂŗǂj
			, def_stage_section_area[st][5][0][1]
			, def_stage_section_area[st][5][0][2]	// ZNV6̉EiCӂŗǂj
			, def_stage_section_area[st][5][0][3]
			,768, 256, 0, 0);
		// 摜ōWύX
		p_memory_map_buffer->txt_scroll_unit.tx_x = st5_txt_cx;
		p_memory_map_buffer->txt_scroll_unit.tx_y = st5_txt_cy;
		break;
	case 7:
	case 8:
	case 9:
		st5_scroll_txt_common(
			def_stage_section_area[st][6][0][0]		// ZNV7̍iCӂŗǂj
			, def_stage_section_area[st][6][0][1]
			, def_stage_section_area[st][6][0][2]	// ZNV7̉EiCӂŗǂj
			, def_stage_section_area[st][6][0][3]
			, 768, 0, 0, 0);
		break;
	}

	// ̍WʒuvZ
	dx = st5_txt_cx - p_memory_map_buffer->txt_scroll_unit.tx_x;
	dy = st5_txt_cy - p_memory_map_buffer->txt_scroll_unit.tx_y;
	if (dx > speed) { dx = speed; }
	if (dx < -speed) { dx = -speed; }
	if (dy > speed) { dy = speed; }
	if (dy < -speed) { dy = -speed; }

	// Wݒ肷
	p_memory_map_buffer->txt_scroll_unit.tx_x += dx;
	p_memory_map_buffer->txt_scroll_unit.tx_y += dy;
}


void st5_scroll_txt_common(int sx0, int sy0, int sx1, int sy1, int ox, int oy, int width, int height)
{
	int section_width, section_height;
	int stage_index = p_stage_context->stage - 1;
	int bx, by;
	int tx, ty;

	// ZNV̂Ȃŉʍ̍W͈
	section_width = (sx1 + 1) - sx0 - 256;
	section_height = (sy1 + 1) - sy0 - 256;

	// BGXN[ʒũZNV[JW
	bx = (p_stage_context->bgview_hx >> 8) - sx0;
	by = (p_stage_context->bgview_hy >> 8) - sy0;

	// px, pyXN[Έʒu߂
	tx = 0;
	ty = 0;
	if (section_width > 0) {
		tx = bx * width / section_width;
	}
	if (section_height > 0) {
		ty = by * height / section_height;
	}

	// XN[̃^[Qbgʒuݒ
	st5_txt_cx = ox + tx;
	st5_txt_cy = oy + ty;
}
