#define __STAGE_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "kon_util.h"
#include "game_context.h"
#include "common.h"
#include "constants.h"
#include "collision.h"
#include "../devs/devs.h"
#include "stage.h"
#include "jiki.h"
#include "subweapon.h"
#include "magic.h"
#include "shop.h"
#include "gameover.h"
//
#include "stage1.h"
#include "stage2.h"
#include "stage3.h"
#include "stage4.h"
#include "stage5.h"
#include "stage6.h"

#include "enemy.h"
#include "explode.h"

// 萔`
#define CURSOR_NEAR_TH	(128)		// ʊOJ[\̐Fς臒l

// vg^Cv錾
int exec_stage_intermission(int stage_no);
int exec_stage_instcard(int stage_no);
int exec_stage_main(int stage_no);	// Xe[W̃C
int start_stage_common(int stage_no);	// Xe[WJn̏̋ʕ
int convert_endian_word(unsigned short* array, int elementCount);
//
void open_mask();
void close_mask();

// {[iX֘A\bh
void set_timelimit_bonus(int seconds);	// ^C~bglݒ肷
void set_section_clear_score();			// ZNVNÃ{[iXlm肷
void set_stage_clear_score();			// Xe[WNÃ{[iXlm肷

// ړ
int bomb_move(int status);

// `揈
int stage_on_one_frame();	// eXe[W1t[̈ړ
int stage_on_section_clear_move();	// ZNVNA[u
int is_section_clear_move_finished();	// ZNVNA[ȕI֐
int stage_on_stage_clear_move();	// Xe[WNA[u
int stage_on_pause_move();	// |[Y
void handle_section_clear();			// ZNVNA̔EԑJڏ
void draw_on_one_frame();	// Xe[WIuWFNg1t[̕`揈
void draw_on_clear_move();	// NA[u̕`揈
void draw_on_pause();	// PAUSE̕`揈
//
void draw_gauge();			// Q[W`
void draw_numbers();		// `
void draw_enemy_cursor(ENEMY* pEnemy);	// ʊO̓Gւ̃J[\\

// C^[~bV
int intermission_main(int stage_no, int text_pal_slot, int text_pal_topblock);
void intermission_move(int stage_no);	// C^[~bV̎s
void intermission_draw();

// O[oϐ
extern int vd_wait_skipped;

// O[oϐ
int intermission_txt_scroll_x = 0;
int intermission_txt_scroll_y = 0;

//--------------------------------------------------------------------
//	[  ]
//		do_wait_vsync(int force_wait)
//
//	[  ]
//		int force_wait	ő҂Ƃ1
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		V-SYNC֘Åe폈܂Ƃ߂čs
//--------------------------------------------------------------------
void do_wait_vsync(int force_wait)
{
	system_pre_vsync();
	screen_pre_vsync();
	#ifdef NOWAIT_TO_BOSS
	if (
		(p_stage_context->section == def_stage_sections[p_stage_context->stage - 1])
		|| (force_wait)
	) {
	#endif
		wait_for_vsync(force_wait);
	#ifdef NOWAIT_TO_BOSS
	}
	#endif
	screen_post_vsync();
	system_post_vsync();

	// SEĐ̗D揇ʐ
	if (p_sound_context->se_play_timeout > 0) {
		p_sound_context->se_play_timeout -= 1;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		do_slow_vsync()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		V-SYNC֘Åe폈܂Ƃ߂čsBinput̎荞݂͍sȂ
//--------------------------------------------------------------------
void do_slow_vsync()
{
	//system_pre_vsync();
	screen_pre_vsync();
	wait_for_vsync(0);
	screen_post_vsync();
	system_post_vsync();

	// SEĐ̗D揇ʐ
	if (p_sound_context->se_play_timeout > 0) {
		p_sound_context->se_play_timeout -= 1;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		int initialize_stage_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		STAGE_CONTEXT ̓e܂B
//		Q[Jn1񂾂s鏈łB
//--------------------------------------------------------------------
int initialize_stage_context()
{
	// <<< ReLXgŜ0ŏ >>>
	memset(p_stage_context, 0, sizeof(STAGE_CONTEXT));

	// AvP[VReLXg
	// XRA
	memset(p_application_context->score, 0, sizeof(p_application_context->score));
	// pt
	memset(p_application_context->point, 0, sizeof(p_application_context->point));
	// ReBj[
	p_application_context->cont = 0;
	// c@w񐔂0ɏ
	p_application_context->left_buy_count = 0;

	// @
	p_application_context->left = p_game_properties->life;
	p_application_context->hp = HP_DEFAULT;
	p_application_context->mp = MP_MAX;
	p_application_context->bomb_charge = 0;
	// p[Abvx
	p_application_context->lv_blade = startup_param.start_lv;	// u[h̃x
	p_application_context->lv_magic = startup_param.start_lv;	// @̃x
	p_application_context->lv_charge = startup_param.start_lv;	// `[Wx̃x

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int prepare_stage(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[WsȌs܂B
//--------------------------------------------------------------------
int prepare_stage(int stage_no)
{
	int result = 0;
	int i;

	// <<< Xe[WɊւ{lݒ肷 >>>
	{
		// Xe[W̔ԍݒ肷
		p_stage_context->stage = stage_no;
		p_stage_context->section = 1;

		// NAԂ
		p_stage_context->on_clear_move = 0;
		p_stage_context->exit_code = STAGE_EXIT_NOP;
	}

	// <<< ʂC^[~bV̏Ԃɂ >>>
	{
		// ʂ
		result = screen_init();
		if (result != 0) {
			kon_log("prepare_stage_context : ʂ̏Ɏs܂Bstage_no = %d\n", stage_no);
			return -1;
		}

		// ʃ[h֘A̐ݒs
		p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
		p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
		p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
		p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
		p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
		p_memory_map_buffer->vc_onoff.bit.son = 1;
		p_memory_map_buffer->vc_onoff.bit.ton = 1;

		// ʂ̃vCIeBݒ肷
		p_memory_map_buffer->vc_priority.bit.sp = 1;      // XvCg̓eLXgƃOtBbN̊
		p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
		p_memory_map_buffer->vc_priority.bit.grp = 0;     // OtBbNO
		p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
		p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
		p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
		p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

		// GRP̃XN[ʒuݒ肷
		p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc0_y = 0;
		p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
		p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
		p_memory_map_buffer->grp_scroll_unit.sc3_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;

		// BG̕\Ԃݒ肷i͕\ȂBXe[WJnONɂBj
		p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
		p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
		p_memory_map_buffer->bg_scroll_unit.ctrl.bit.disp_cpu = 1;
		p_memory_map_buffer->bg_scroll_unit.ctrl.bit.textsel0 = 0;
		p_memory_map_buffer->bg_scroll_unit.ctrl.bit.textsel1 = 1;
	}

	// <<< Xe[WIuWFNg⃁obt@ >>>
	{
		// Xe[WIuWFNg̏
		initialize_stage_objects();

		// XvCg̃p^[`̓ǂݍݐ擪ʒu
		p_stage_context->cmn_sp_top = common_sp_code_top[stage_no - 1];
		p_stage_context->ene_sp_top = ene_sp_code_top[stage_no - 1];

		// \[Xǂݍݐ
		memset(p_memory_map_buffer->sp_unit, 0, sizeof(p_memory_map_buffer->sp_unit));      // SP`
		memset(p_memory_map_buffer->transsp, 0, sizeof(p_memory_map_buffer->transsp));      // SPp^[
		memset(p_memory_map_buffer->transpal, 0, sizeof(p_memory_map_buffer->transpal));    // PAL
		p_memory_map_buffer->transsp_count = 0;
		p_memory_map_buffer->transpal_count = 0;

		// GZbg荞
		for (i = 0; i < STAGE_DESC_LINES; i++) {
			p_stage_context->stage_desc[i] = def_stage_section_enemy_desc[stage_no - 1][0][i];
		}

		// Ԓlݒ
		p_stage_context->status = 0;
	}

	// <<< \[Xǂݍ >>>
	{
		initialize_bgmap(1, def_stage_bg_size[stage_no - 1][0], def_stage_bg_size[stage_no - 1][1]);
		p_stage_context->pworld_page = 0;   // p[h}bv̓y[W0

		// Xe[WƂ̏Ăяo
		result = 0;
		p_stage_context->event = NULL;
		p_stage_context->section_clear_event = NULL;
		p_stage_context->scroll_txt = stage_scroll_txt;
		switch (stage_no) {
		case 1:
			resource_load_st1();
			p_stage_context->scroll_txt = st1_scroll_txt;
			p_stage_context->event = st1_event;
			break;
		case 2:
			resource_load_st2();
			p_stage_context->event = st2_event;
			break;
		case 3:
			resource_load_st3();
			p_stage_context->scroll_txt = st3_scroll_txt;
			p_stage_context->event = st3_event;
			p_stage_context->section_clear_event = st3_section_clear_event;
			break;
		case 4:
			resource_load_st4();
			p_stage_context->scroll_txt = st4_scroll_txt;
			p_stage_context->event = st4_event;
			break;
		case 5:
			resource_load_st5();
			p_stage_context->scroll_txt = st5_scroll_txt;
			p_stage_context->event = st5_event;
			p_stage_context->section_clear_event = st5_section_clear_event;
			break;
		case 6:
			resource_load_st6();
			p_stage_context->scroll_txt = st6_scroll_txt;
			p_stage_context->event = st6_event;
			break;
		default:
			// z肵ȂXe[Wԍ
			result = -1;
			break;
		}
		if (result != 0) {
			kon_log("Xe[W̏ɃG[܂Bstage_no = %d\n", stage_no);
		}
	}

	// <<< L̏Ԃݒ肷 >>>
	if (p_game_properties->game_level <= game_level_novice) {
		// EASY/NOVICÊƂɂ́AHP/MPS񕜂
		p_application_context->hp = HP_MAX;
		p_application_context->mp = MP_MAX;
	}

	// <<< I >>>
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int exec_stage(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[Ws܂
//--------------------------------------------------------------------
int exec_stage(int stage_no)
{
	int result;

	// Xe[W̃C^[~bV
	if (startup_param.skip_intermission==0) {
		result = exec_stage_intermission(stage_no);
		if (result != 0) {
			kon_log("C^[~bV̎sɃG[܂Bstage_no=%d\n", stage_no);
			return result;
		}
	}

	// CXgNVJ[h\
	result = exec_stage_instcard(stage_no);
	if (result != 0) {
		return result;
	}

	// Xe[W̃C
	result = exec_stage_main(stage_no);
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		int exec_stage_instcard(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		CXgNVJ[h\郂[h
//--------------------------------------------------------------------
int exec_stage_instcard(int stage_no)
{
	// ŏ
	if (stage_no != 1) {
		// BGMĐ~
		sound_stop_bgm();
		// I
		return 0;
	}

	// CXgNVJ[h\
	// }XNʒuݒ
	p_stage_context->mask_pos = 512;
	// page1\
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = 256;
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 256;
	// \XCb`ύX
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// ʏ
	do_wait_vsync(1);

	// }XNI[v
	while (p_stage_context->mask_pos > 0) {
		open_mask();
		stage_scroll_mask();
		// ҂
		do_wait_vsync(1);
	}

	// ͑҂
	p_stage_context->status_count = 0;
	while (1) {
		// L[͔
		if (p_input_parser->pause_clicked) {
			// |[YL[ꂽԂɊւ炸
			break;
		}
		if (
			(p_input_parser->trg_main_clicked)
			|| (p_input_parser->trg_sub_clicked)
		) {
			// {^ꂽ玟
			if (p_stage_context->status_count == 1) {
				break;
			}
			else {
				p_stage_context->status_count = 1;
				// \ʒuύX
				p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
				p_memory_map_buffer->vc_onoff.bit.gs2 = 1;

				// ʉ
				play_se(&(p_sound_context->se_item[setype_cursor]));
			}
		}
/*
		// J[\
		p_stage_objects->sp_index_seq = 0; // SP`̃R[hԍ
		sp_index = p_stage_objects->sp_index_seq;
		sp = p_memory_map_buffer->sp_unit + sp_index;
		allocsp = sp_alloc_index(1);
		if (allocsp >= 1) {
			SP_SET(sp, 248, 240 + (((p_application_context->frame_count>> 4) & 1) << 3), 0x44, 7, 0, 1, 3);
			sp++;
		}
		// cSP
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
			// Wړ
			sp->x = 0;
			sp->y = 0;
			// ̃jbgɐi
			sp++;
		}
*/
		// ҂
		do_wait_vsync(1);

		// JEg
		p_application_context->frame_count += 1;

		// vȌINGXgꂽI
		if (p_application_context->quit_requested) {
			break;
		}
	}

	// ʉ
	play_se(&(p_sound_context->se_item[setype_cursorok]));

	// }XNN[Y
	while (p_stage_context->mask_pos < 512) {
		close_mask();
		stage_scroll_mask();
		// ҂
		do_wait_vsync(1);
	}

	// ʕ\ʒu߂
	// page2߂
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	// page1߂
	p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
	// page0߂
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
	// \XCb`߂
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 1;

	// BGMĐ~
	sound_stop_bgm();

	// ʕ\
	do_wait_vsync(1);

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int exec_stage_intermission(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W̃C^[~bVs܂
//--------------------------------------------------------------------
int exec_stage_intermission(int stage_no)
{
	int result = 0;
	int slot, topblock;
	slot = 0;
	topblock = 0;

	switch (stage_no) {
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
		slot = p_stage_context->text_pal_slot;
		topblock = p_stage_context->int_pal_block;
		break;
	default:
		kon_log("exec_stage_intermission : sȃXe[Wԍw肳܂Bstage_no=%d\n", stage_no);
		result = -1;
		break;
	}

	// s
	result = intermission_main(stage_no, slot, topblock);

	// I
	return result;
}

//--------------------------------------------------------------------
//	[  ]
//		int exec_stage_main(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[Ws܂
//--------------------------------------------------------------------
int exec_stage_main(int stage_no)
{
	int i;
	// Xe[WJnȌiʁj
	start_stage_common(stage_no);

	// Xe[WsO
	switch (stage_no) {
	case 1:
		st1_on_start();
		break;
	case 2:
		st2_on_start();
		break;
	case 3:
		st3_on_start();
		break;
	case 4:
		st4_on_start();
		break;
	case 5:
		st5_on_start();
		break;
	case 6:
		st6_on_start();
		break;
	default:
		kon_log("exec_stage_main : stage_nosłBstage_no = %d\n", stage_no);
		break;
	}

	// Q[[v
	while (1) {
		// <<< SP`eSɏ >>>
		p_stage_objects->sp_index_seq = 0; // SP`̃R[hԍ

		// <<< ړE`揈 >>>
		switch (p_stage_context->stage_mode) {
		case STAGE_MODE_SHOP:
		{
			// Vbv
			int status = p_stage_context->status;
			shop_move(status);		// ړ
			shop_draw(status);		// `
		}
		break;
		//
		case STAGE_MODE_CONTINUE:
		{
			// ReBj[
			int status = p_stage_context->status;
			continue_move(status);	// ړ
			continue_draw(status);	// `
		}
		break;
		//
		case STAGE_MODE_GAMEOVER:
		{
			// Q[I[o[
			int status = p_stage_context->status;
			gameover_move(status);	// ړ
			gameover_draw(status);	// `
		}
		break;
		//
		case STAGE_MODE_BOMB:
		{
			// BOMB
			int status = p_stage_context->status;
			bomb_move(status);	// ړ
			stage_draw(status);	// `͒ʏƓ
		}
		break;
		//
		default:
		{
			// ʏ
			stage_move();			// ړ
			stage_draw();			// `
		}
		break;
		}

		// VSYNC҂т̑O
		do_wait_vsync(0);
		// X[[h
		if (p_stage_objects->slow_mode) {
			// X[[ĥƂɂ́A]vɑ҂
			do_slow_vsync();
			do_slow_vsync();
		}
		// qbgXgbv
		if (p_stage_objects->hit_stop != 0) {
			// ҂
			for (i = 0; i < 10; i++) {
				do_slow_vsync();
			}
			// ԒlZbg
			p_stage_objects->hit_stop = 0;
		}

		if (startup_param.record_score_log) {
			if ((p_application_context->frame_count & 0xF) == 0) {
				// XRAO
				score_log("frame"
					, p_application_context->frame_count
					, p_stage_objects->frame_count
					, p_stage_context->stage
					, p_stage_context->section
					, digits_get_int(p_application_context->score, SCORE_DIGITS)
					, digits_get_int(p_application_context->point, POINT_DIGITS)
					, p_application_context->left
					, p_application_context->hp
					, p_application_context->mp
					, p_stage_objects->combo_lv
					, digits_get_int(p_stage_objects->time_limit, TIME_LIMIT_DIGITS)
					, p_application_context->lv_blade
					, p_application_context->lv_magic
					, p_application_context->lv_charge
					, p_application_context->bomb_charge
					, 0
					, 0
				);
			}
		}

		// t[JE^XV
		p_stage_objects->frame_count += 1;
		p_application_context->frame_count += 1;

		// Xe[WNAEQ[I[o[Ȃ甲
		if (p_stage_context->exit_code != STAGE_EXIT_NOP) {
			break;
		}

		// vȌINGXgꂽI
		if (p_application_context->quit_requested) {
			break;
		}
	}

	// Xe[WIBGM~߂
	sound_stop_bgm();

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int init_stage_common(int stage_no)
//
//	[  ]
//		int stage_no	Xe[Wԍ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[WJn̏iʁj
//--------------------------------------------------------------------
int start_stage_common(int stage_no)
{
	// -----< ReLXg̏Ԓl >-----
	//
	p_stage_context->on_clear_move = 0;	// NA[ȕԒl

	// -----< ʂ̕\ON/OFF >-----
	//
	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 1;

	// ʂ̃vCIeBݒ肷
	p_memory_map_buffer->vc_priority.bit.sp = 1;      // XvCg̓eLXgƃOtBbN̊
	p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
	p_memory_map_buffer->vc_priority.bit.grp = 0;     // OtBbNO
	p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
	p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
	p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
	p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

	// BG\ԂXV
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 1;

	// -----< IuWFNgzu >-----
	//
	// @
	jiki_init(&(p_stage_objects->jiki)
		, def_stage_start_pos[stage_no - 1][2]    // X
		, def_stage_start_pos[stage_no - 1][3]    // Y
		, (stage_no == 4) ? dir_left : dir_right
	);

	// @
	magic_init(&(p_stage_objects->magic));

	// -----< BGXN[ʒu >-----
	//
	// XN[ʒu
	p_stage_context->s_tx = (stage_no == 4 ? 170 : 85) << 8;
	p_stage_context->s_ty = (256 * 2 / 3) << 8;
	p_stage_context->s_cursor_x = p_stage_context->s_tx;
	p_stage_context->s_cursor_y = p_stage_context->s_ty;
	//
	p_stage_context->bgview_hx = def_stage_start_pos[stage_no - 1][0] << 8;
	p_stage_context->bgview_hy = def_stage_start_pos[stage_no - 1][1] << 8;
	p_stage_context->prev_bgview_hx = p_stage_context->bgview_hx;
	p_stage_context->prev_bgview_hy = p_stage_context->bgview_hy;

	// Xe[W̃GANbsOݒ
	p_stage_context->stage_clipping_area.x0 = def_stage_section_area[stage_no - 1][0][0][0];
	p_stage_context->stage_clipping_area.y0 = def_stage_section_area[stage_no - 1][0][0][1];
	p_stage_context->stage_clipping_area.x1 = def_stage_section_area[stage_no - 1][0][0][2];
	p_stage_context->stage_clipping_area.y1 = def_stage_section_area[stage_no - 1][0][0][3];

	// Xe[W̓Go\GANbsOݒ
	p_stage_context->enemy_appear_area.x0 = def_stage_section_area[stage_no - 1][0][2][0];
	p_stage_context->enemy_appear_area.y0 = def_stage_section_area[stage_no - 1][0][2][1];
	p_stage_context->enemy_appear_area.x1 = def_stage_section_area[stage_no - 1][0][2][2];
	p_stage_context->enemy_appear_area.y1 = def_stage_section_area[stage_no - 1][0][2][3];

	// XN[̌vZs
	stage_scroll_bg();

	// BGʏ`
	redraw_bgmap_full(0, 1);    // BG}bv0̃f[^gBGy[W1ւ

	// -----< GRPXN[ʒu >-----
	//
	// XN[ʒuݒi}XNőŜBj
	p_stage_context->mask_pos = 512;
	stage_scroll_mask();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int stage_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[W̉Z
//--------------------------------------------------------------------
int stage_move()
{
	int res;

	// ͏Ԕ
	// SŋVbvij
//	if (p_input_parser->keyin_force_shop) { shop_start(); }
	// GŋQ[I[o[ij
//	if (p_input_parser->keyin_force_over) { continue_start(); }

	// {^Ń{
	if ((p_input_parser->trg_same_time_clicked)
		&& (p_stage_context->stage_mode == STAGE_MODE_NORMAL)
		&& (p_stage_context->on_clear_move == 0)
		&& (p_application_context->bomb_charge == BOMB_CHARGE_MAX)
		) {
		p_stage_context->status = 0;
		p_stage_context->status_count = 0;
		p_stage_context->stage_mode = STAGE_MODE_BOMB;
		// `[W
		p_application_context->bomb_charge = 0;

		// ʉ
		play_se(&(p_sound_context->se_item[setype_bomb]));
	}

	// ZNVNA̔EԑJڏ
	if (p_stage_context->on_clear_move == 0) {
		handle_section_clear();
	}

	// BGbV̏Ԃ
	collision_clear_bgmesh();

	// Q[1t[̈ړ
	switch (p_stage_context->on_clear_move) {
	case 1:
		// ZNVNA[u
		open_mask();	// }XNI[v
		res = stage_on_section_clear_move();
		collision_jiki_item();		// NA[uAACe肾͍s
		break;
	case 2:
		// Xe[WNA[u
		res = stage_on_stage_clear_move();
		collision_jiki_item();		// NA[uAACe肾͍s
		break;
	case 3:
		// PAUSE[h
		res = stage_on_pause_move();
		break;
	default:
		// ʏ타[u
		open_mask();	// }XNI[v
		res = stage_on_one_frame();		// ړ
		collision_check();			// 蔻

		// ESCPAUSEύX
		if (p_input_parser->pause_clicked) {
			p_stage_context->on_clear_move = 3;
			p_stage_objects->pause_cursor = 0;	// INOɐݒ
			//p_application_context->quit_requested = 1;
		}
		break;
	}
	if (res != 0) {
		kon_log_single(ERROR_ON_ONE_FRAME, "Xe[W1t[̈ړŃG[܂Bres = %d\n", res);
	}

	// I
	return 0;
}

//
void open_mask()
{
	if (p_stage_context->mask_pos > 0) {
		p_stage_context->mask_pos -= MASK_SCROLL_SPEED;
		if (p_stage_context->mask_pos < 0) {
			p_stage_context->mask_pos = 0;
		}
	}
}

//
void close_mask()
{
	if (p_stage_context->mask_pos < 512) {
		p_stage_context->mask_pos += MASK_SCROLL_SPEED;
		if (p_stage_context->mask_pos >= 512) {
			p_stage_context->mask_pos = 512;
		}
	}
}

//--------------------------------------------------------------------
//	[  ]
//		bomb_move(int status)
//
//	[  ]
//		int status		Xe[W̃Xe[^X
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		BOMB̋
//--------------------------------------------------------------------
int bomb_move(int status)
{
	// 
	if (p_stage_context->status == 0) {
		p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc1_y += 8;

		// ړ玟̃Xe[g
		if (p_memory_map_buffer->grp_scroll_unit.sc1_y >= 512) {
			p_stage_context->status = 1;
			p_memory_map_buffer->grp_scroll_unit.sc1_x = 1024;
			p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
		}
		return 0;
	}

	// ړ
	if (p_stage_context->status == 1) {
		p_memory_map_buffer->grp_scroll_unit.sc1_x -= 16;
		p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;

		// ړ玟̃Xe[g
		if (p_memory_map_buffer->grp_scroll_unit.sc1_x <= 768) {
			p_stage_context->status = 2;
			p_memory_map_buffer->grp_scroll_unit.sc1_x = 768;
			p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
		}
		return 0;
	}

	// ړ~
	if (p_stage_context->status == 2) {
		p_memory_map_buffer->grp_scroll_unit.sc1_x = 768;
		p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
		p_stage_context->status_count += 1;

		// ړ玟̃Xe[g
		if (p_stage_context->status_count >= 30) {
			p_stage_context->status = 3;
			p_stage_context->status_count = 0;
			p_memory_map_buffer->grp_scroll_unit.sc1_x = 768;
			p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
		}
		return 0;
	}

	// ړ2
	if (p_stage_context->status == 3) {
		p_memory_map_buffer->grp_scroll_unit.sc1_x -= 16;
		p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;

		// ړ玟̃Xe[g
		if (p_memory_map_buffer->grp_scroll_unit.sc1_x <= 512) {
			p_stage_context->status = 0;
			p_stage_context->status_count = 0;
			p_memory_map_buffer->grp_scroll_unit.sc1_x = 0;
			p_memory_map_buffer->grp_scroll_unit.sc1_y = 0;
			p_stage_context->stage_mode = STAGE_MODE_NORMAL;

			// {o
			appear_subweapon(subweapon_bomb, 0, 0, 0, 0);
		}
		return 0;
	}

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int stage_draw()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[W̕`揈
//--------------------------------------------------------------------
void stage_draw()
{
	SP_UNIT* pSpUnit;
	//STAGE_OBJECTS* p_stage_objects = &(p_stage_context->stage_objects);
	int i;

	// <<<<< Q[W\ >>>>>
	draw_frame_items();

	// <<< Xe[WIuWFNg1t[̕`揈 >>>
	switch(p_stage_context->on_clear_move) {
		case 0:
			// ʏ`
			draw_on_one_frame();
			break;
		case 1:
		case 2:
			// NA[u̕`
			draw_on_clear_move();
			break;
		case 3:
			// |[Y̕`
			draw_on_pause();
			break;
	}

	// <<< SP̎c̈ >>>
	//
	pSpUnit = p_memory_map_buffer->sp_unit;
	pSpUnit += p_stage_objects->sp_index_seq;
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		pSpUnit->x = 0;
		pSpUnit->y = 0;
		// ̃jbgɐi
		pSpUnit++;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int intermission_main(int stage_no)
//
//	[  ]
//		int stage_no		Xe[Wԍ
//		int text_pal_slot	eLXgʂ̃pbg]̃Xbgԍ
//		int text_pal_block	eLXgʂ̃pbg]̐擪ubN
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[WJnÕC^[~bV
//--------------------------------------------------------------------
int intermission_main(int stage_no, int text_pal_slot, int text_pal_topblock)
{
	// -----< ʂ̕\ON/OFF >-----
	//
	// OtBbNON
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;

	// eLXgON
	p_memory_map_buffer->vc_onoff.bit.ton = 1;

	// -----< ʂ̃XN[ʒu >-----
	//
	// OtBbNXN[ʒu
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 256;

	// eLXgXN[ʒu
	p_memory_map_buffer->txt_scroll_unit.tx_x = def_intermission_txt_target[stage_no - 1][0][0];
	p_memory_map_buffer->txt_scroll_unit.tx_y = def_intermission_txt_target[stage_no - 1][0][1];

	// -----< Ԃ >-----
	//
	intermission_txt_scroll_x = def_intermission_txt_target[stage_no - 1][0][0];
	intermission_txt_scroll_y = def_intermission_txt_target[stage_no - 1][0][1];
	p_stage_context->mask_pos = 512;
	p_stage_context->status_count = 0;

	// -----< pbg] >-----
	//
	stack_transfer_pal(text_pal_slot, text_pal_topblock, 0, 1);

	// -----< BGMĐ >-----
	//
	if (p_game_properties->disable_sound == 0) {
		sound_play_bgm(p_sound_context->bgm_index[bgmtype_intermission]);
	}

	// -----< Q[[v >-----
	//
	while (1) {
		// ړ
		intermission_move(stage_no);

		// `揈
		intermission_draw();

		// VSYNC҂т̑O
		do_wait_vsync(1);

		// t[JE^XV
		p_stage_objects->frame_count += 1;
		p_application_context->frame_count += 1;

		// Xe[WNA甲
		if (p_stage_context->status_count == 1) {
			p_stage_context->status_count = 0;
			break;
		}

		// vȌINGXgꂽI
		if (p_application_context->quit_requested) {
			break;
		}
	}

	// Đ~
	//sound_stop_bgm();

	// ʂ̏Ԃ
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
	do_wait_vsync(1);

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		void intermission_move(int stage_no)
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		C^[~bV̓
//--------------------------------------------------------------------
void intermission_move(int stage_no)
{
	int txt_tx, txt_ty, txt_vel, txt_pal, mask_tx;	// ڕWʒuƃXN[x
	int txt_dx, txt_dy, mask_dx;	// ڕWʒuƂ̍
	int txt_nx, txt_ny, mask_nx;	// ړXN[ʒu

	// eLXgEOtBbÑXN[ڕWʒu𓾂
	txt_tx = def_intermission_txt_target[stage_no - 1][p_stage_context->status][0];
	txt_ty = def_intermission_txt_target[stage_no - 1][p_stage_context->status][1];
	txt_vel = def_intermission_txt_target[stage_no - 1][p_stage_context->status][2];
	txt_pal = def_intermission_txt_target[stage_no - 1][p_stage_context->status][3];
	mask_tx = def_intermission_grp_target_x[stage_no - 1][p_stage_context->status];

	// pbg]w
	stack_transfer_pal(p_stage_context->text_pal_slot, txt_pal, 0, 1);

	// I
	if ((txt_tx == -1) && (txt_ty == -1)) {
		// XN[ŏIʒu
		if (p_stage_context->mask_pos == 512) {
			// gWVIĂ
			// status_count=1intermissionȈԂƂĈ
			p_stage_context->status_count = 1;
			return;
		}
		else {
			// gWV
			p_stage_context->mask_pos += MASK_SCROLL_SPEED;
			if (p_stage_context->mask_pos >512) {
				p_stage_context->mask_pos = 512;
			}
			return;
		}
	}

	// ڕWʒuƂ̍𓾂
	txt_dx = txt_tx - intermission_txt_scroll_x;
	txt_dy = txt_ty - intermission_txt_scroll_y;
	mask_dx = mask_tx - p_stage_context->mask_pos;

	// XN[ʒu߂
	txt_nx = txt_tx;
	txt_ny = txt_ty;
	mask_nx = mask_tx;
	if (txt_dx != 0) {
		txt_nx = (txt_dx > 0 ? intermission_txt_scroll_x + txt_vel : intermission_txt_scroll_x - txt_vel);
	}
	if (txt_dy != 0) {
		txt_ny = (txt_dy > 0 ? intermission_txt_scroll_y + txt_vel : intermission_txt_scroll_y - txt_vel);
	}
	if (mask_dx != 0) {
		mask_nx = (mask_dx > 0 ? p_stage_context->mask_pos + MASK_SCROLL_SPEED : p_stage_context->mask_pos - MASK_SCROLL_SPEED);
	}
	// s߂͕␳
	if (((txt_dx > 0) && (txt_nx > txt_tx)) || ((txt_dx < 0) && (txt_nx < txt_tx))) {
		txt_nx = txt_tx;
	}
	if (((txt_dy > 0) && (txt_ny > txt_ty)) || ((txt_dy < 0) && (txt_ny < txt_ty))) {
		txt_ny = txt_ty;
	}
	if (((mask_dx > 0) && (mask_nx > mask_tx)) || ((mask_dx < 0) && (mask_nx < mask_tx))) {
		mask_nx = mask_tx;
	}

	// XN[ʒu
	intermission_txt_scroll_x = txt_nx;
	intermission_txt_scroll_y = txt_ny;
	p_stage_context->mask_pos = mask_nx;

	// {^ꂽ玟̃Xe[g
	if ((intermission_txt_scroll_x == txt_tx)
		&& (intermission_txt_scroll_y == txt_ty)
		&& (p_stage_context->mask_pos == mask_tx)
		) {
		//int next_tx, next_ty;
		//next_tx = def_intermission_txt_target[stage_no - 1][p_stage_context->status + 1][0];
		//next_ty = def_intermission_txt_target[stage_no - 1][p_stage_context->status + 1][1];

		// {^ꂽAŌ̃Xe[^XŃgWV玟
		if (p_input_parser->trg_main_clicked) {
			p_stage_context->status += 1;

			// ʉ
			if (def_intermission_txt_target[stage_no - 1][p_stage_context->status][0] != -1) {
				play_se(&(p_sound_context->se_item[setype_cursor]));
			}
			else {
				play_se(&(p_sound_context->se_item[setype_cursorok]));
			}
		}
	}

	// ESCŒf
	if (p_input_parser->pause_clicked) {
		// f
		p_stage_context->status_count = 1;
	}
	return;
}

//--------------------------------------------------------------------
//	[  ]
//		int intermission_draw()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[W̕`揈
//--------------------------------------------------------------------
void intermission_draw()
{
	SP_UNIT* pSpUnit;
	//STAGE_OBJECTS* p_stage_objects = &(p_stage_context->stage_objects);
	int i;

	// <<< TXT, GRPXN[ >>>
	// eLXgXN[ݒ
	p_memory_map_buffer->txt_scroll_unit.tx_x = intermission_txt_scroll_x;
	p_memory_map_buffer->txt_scroll_unit.tx_y = intermission_txt_scroll_y;

	// GRPXN[ݒ
	stage_scroll_mask();

	// <<< SP`eSɏ >>>
	p_stage_objects->sp_index_seq = 0; // SP`̃R[hԍ

	// Q[W\Ȃ

	// <<< Xe[WIuWFNg1t[̕`揈 >>>
	draw_on_one_frame();

	// <<< SP̎c̈ >>>
	//
	pSpUnit = p_memory_map_buffer->sp_unit;
	pSpUnit += p_stage_objects->sp_index_seq;
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		pSpUnit->x = 0;
		pSpUnit->y = 0;
		// ̃jbgɐi
		pSpUnit++;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int stage_release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[W̃\[X
//--------------------------------------------------------------------
int release_stage()
{
	// UʂB
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
	do_wait_vsync(1);

	// Ɋi[BG}bvf[^
	release_bgmap();
	resource_release_stage();
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void initialize_stage_objects()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[WIuWFNg̊Ǘ\܂
//--------------------------------------------------------------------
void initialize_stage_objects()
{
	// <<< ܂̓[NA >>>
	memset(p_stage_objects, 0, sizeof(STAGE_OBJECTS));

	// <<< lݒ >>>
	// ^C~bg{[iXݒ肷
	set_timelimit_bonus(300);

	// VbvN[YtO
	p_stage_objects->shop_closed = 0;

	// <<< LN^ƂIDX^bN >>>
	// TuEF|
	initialize_id_stack(
		p_stage_objects->subweapon_id_stack
		, &p_stage_objects->subweapon_id_stack_ptr
		, MAX_SUBWEAPON);

	// G
	initialize_id_stack(
		p_stage_objects->enemy_id_stack
		, &p_stage_objects->enemy_id_stack_ptr
		, MAX_ENEMY);

	// Ge
	initialize_id_stack(
		p_stage_objects->eneshot_id_stack
		, &p_stage_objects->eneshot_id_stack_ptr
		, MAX_ENESHOT);

	// 
	initialize_id_stack(
		p_stage_objects->explode_id_stack
		, &p_stage_objects->explode_id_stack_ptr
		, MAX_EXPLODE);

	// ITEM
	initialize_id_stack(
		p_stage_objects->item_id_stack
		, &p_stage_objects->item_id_stack_ptr
		, MAX_ITEM);

	// EffectSP
	initialize_id_stack(
		p_stage_objects->esp_id_stack
		, &p_stage_objects->esp_id_stack_ptr
		, MAX_ESP);
}

//--------------------------------------------------------------------
//	[  ]
//		int stage_on_one_frame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		eXe[Wʂ1t[̏s܂B
//--------------------------------------------------------------------
int stage_on_one_frame()
{
	int i;
	JIKI* pJiki;
	BLADE* pBlade;
	MAGIC* pMagic;

	int frame_count = p_stage_objects->frame_count;

	// -----< Cxgs >-----
	//
	if (p_stage_context->event != NULL) {
		p_stage_context->event();
	}

	// -----< LN^o >-----
	//
	for (i = 0; i < STAGE_DESC_LINES; i++) {
		appear_enemy(i);
	}

	// -----< LN^𓮂 >-----
	//
	// <<<<< @ >>>>>
	pJiki = &(p_stage_objects->jiki);
	if ((pJiki->obj.status != status_absent) && (pJiki->obj.move != NULL)) {
		pJiki->obj.move(pJiki);
	}

	// <<<<< u[h >>>>>
	pBlade = &(p_stage_objects->blade);
	if ((pBlade->obj.status != status_absent) && (pBlade->obj.move != NULL)) {
		pBlade->obj.move(pBlade);
	}

	// <<<<< @ >>>>>
	pMagic = &(p_stage_objects->magic);
	if ((pMagic->obj.status != status_absent) && (pMagic->obj.move != NULL)) {
		pMagic->obj.move(pMagic);
	}

	// <<<<< TuEF| >>>>>
	{
		SUBWEAPON* pSub = p_stage_objects->subweapon_top;
		while (pSub != NULL) {
			pSub->obj.move(pSub);
			pSub = pSub->p_next;
		}
	}

	// <<<<< G >>>>>
	{
		ENEMY* pEnemy = p_stage_objects->enemy_top;
		while (pEnemy != NULL) {
			pEnemy->on_damage = 0;
			pEnemy->obj.move(pEnemy);
			process_eneshot_delay(pEnemy);
			enemy_clip_section(pEnemy);	// G̍WZNVGAɃNbsO
			pEnemy = pEnemy->p_next;
		}
	}

	// <<<<< Ge >>>>>
	{
		ENESHOT* pEneShot = p_stage_objects->eneshot_top;
		while (pEneShot != NULL) {
			pEneShot->obj.move(pEneShot);
			pEneShot = pEneShot->p_next;
		}
	}

	// <<<<<  >>>>>
	{
		EXPLODE* pExplode = p_stage_objects->explode_top;
		while (pExplode != NULL) {
			pExplode->obj.move(pExplode);
			pExplode = pExplode->p_next;
		}
	}

	// <<<<< ACe >>>>>
	{
		ITEM* pItem = p_stage_objects->item_top;
		while (pItem != NULL) {
			pItem->obj.move(pItem);
			pItem = pItem->p_next;
		}
	}

	// <<<<< ESP >>>>>
	{
		ESP* pESP = p_stage_objects->esp_top;
		while (pESP != NULL) {
			pESP->obj.move(pESP);
			pESP = pESP->p_next;
		}
	}

	// -----< wiXN[ >-----
	//
	// <<<<< BGEGRP >>>>>
	stage_scroll_mask();
	stage_scroll_bg();
	p_stage_context->scroll_txt();

	// -----< ^C~bgJEg >-----
	//
	// Xe[W^CAEg
	p_stage_context->second_counter += 1;
	if ((p_stage_context->on_clear_move == 0)
		&& (p_stage_context->second_counter >= FRAMES_PER_SECOND)) {
		// ^C~bg1炷
		sub_digit(p_stage_objects->time_limit, TIME_LIMIT_DIGITS, 0, 1);

		// JEg
		p_stage_context->second_counter = 0;
	}

	// R{JEg_E
	if ((p_stage_objects->combo_lv > 0) && (p_stage_context->on_clear_move == 0)) {
		// Q[W炷
		p_stage_objects->combo_timeout -= (p_game_properties->game_level <= game_level_easy ? 1 : 2);

		// ^CAEgŃx_E
		if (p_stage_objects->combo_timeout < 0) {
			p_stage_objects->combo_timeout = 0;
			// x_E
			switch (p_game_properties->game_level) {
			case game_level_hard:
				// HARDȂC0ɂȂ
				p_stage_objects->combo_lv = 0;
				break;
			case game_level_easy:
				// EASYȂ1x_E
				p_stage_objects->combo_lv -= 1;
				break;
			case game_level_novice:
			case game_level_normal:
			default:
				// NORMALȂ2x_E
				p_stage_objects->combo_lv -= 2;
				break;
			}

			// xNbsO
			if (p_stage_objects->combo_lv < 0) {
				p_stage_objects->combo_lv = 0;
			}

			// ^CAEgJEgĐݒ
			if (p_stage_objects->combo_lv > 0) {
				p_stage_objects->combo_timeout = COMBO_TIMEOUT;
			}
		}
	}

	// -----< I >-----
	//
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int stage_on_section_clear_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		eXe[Wʂ1t[̏s܂B
//--------------------------------------------------------------------
int stage_on_section_clear_move()
{
	int i;
	int result;
	int section_move_finished;
	int stage_index, section_index;
	CHROBJ* pJikiObj = &(p_stage_objects->jiki.obj);

	// NAt[ɐ؂ւ
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 256;

	// ʏ̈ړp
	result = stage_on_one_frame();

	// ړ
	section_move_finished = is_section_clear_move_finished();
	if (section_move_finished) {
		// NA[ũ[hOFFɂ
		p_stage_context->on_clear_move = 0;

		// ZNVɐi߂
		p_stage_context->section += 1;

		// GLqXV
		stage_index = p_stage_context->stage - 1;
		section_index = p_stage_context->section - 1;
		for (i = 0; i < STAGE_DESC_LINES; i++) {
			p_stage_context->stage_desc[i] = def_stage_section_enemy_desc[stage_index][section_index][i];
		}

		// ړ\GÃNbsOݒ
		p_stage_context->stage_clipping_area.x0 = def_stage_section_area[stage_index][section_index][0][0];
		p_stage_context->stage_clipping_area.y0 = def_stage_section_area[stage_index][section_index][0][1];
		p_stage_context->stage_clipping_area.x1 = def_stage_section_area[stage_index][section_index][0][2];
		p_stage_context->stage_clipping_area.y1 = def_stage_section_area[stage_index][section_index][0][3];

		// Go\GANbsOĐݒ肷
		p_stage_context->enemy_appear_area.x0 = def_stage_section_area[stage_index][section_index][2][0];
		p_stage_context->enemy_appear_area.y0 = def_stage_section_area[stage_index][section_index][2][1];
		p_stage_context->enemy_appear_area.x1 = def_stage_section_area[stage_index][section_index][2][2];
		p_stage_context->enemy_appear_area.y1 = def_stage_section_area[stage_index][section_index][2][3];

		// NAt[NA
		p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;

		// ^C~bgi{[iXljݒ
		set_timelimit_bonus(300);

		// LꎞIɖGɂ
		p_stage_objects->jiki.invincible = JIKI_START_INVINCIBLE;

		// VbvN[Y
		//p_stage_objects->shop_closed = 0;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int is_section_clear_move_finished()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ZNVNA[uIꍇ1BłȂꍇ0B
//
//	[  ]
//		ZNṼNA[ȕIs܂B
//--------------------------------------------------------------------
int is_section_clear_move_finished()
{
	int bg_x0, bg_y0, bg_x1, bg_y1;
	int x0, y0, x1, y1;
	int st_index, sc_index;
	int result;

	// Xe[W̃CfbNXiXe[W2̏ꍇ1j
	st_index = p_stage_context->stage - 1;

	// ̃ZNṼCfbNX
	sc_index = p_stage_context->section;

	// BG̃XN[ʒu
	bg_x0 = (p_stage_context->bgview_hx >> 8);
	bg_y0 = (p_stage_context->bgview_hy >> 8);
	bg_x1 = (p_stage_context->bgview_hx >> 8) + 255;
	bg_y1 = (p_stage_context->bgview_hy >> 8) + 255;

	// ZNVGA
	x0 = def_stage_section_area[st_index][sc_index][0][0];
	y0 = def_stage_section_area[st_index][sc_index][0][1];
	x1 = def_stage_section_area[st_index][sc_index][0][2];
	y1 = def_stage_section_area[st_index][sc_index][0][3];

	// 肷
	result = 0;
	if (
		((bg_x0 >= x0) && (bg_x0 <= x1) && (bg_y0 >= y0) && (bg_y0 <= y1))	// bg_x0,y0
		&& ((bg_x1 >= x0) && (bg_x1 <= x1) && (bg_y1 >= y0) && (bg_y1 <= y1))	// bg_x1,y1
		//			((bg_x0 >= x0) && (bg_x0 <= x1))	// bg_x0,y0
		//			&& ((bg_x1 >= x0) && (bg_x1 <= x1))	// bg_x1,y1
		) {
		result = 1;
	}

	// ʂԂ
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		int stage_on_stage_clear_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		eXe[Wʂ1t[̏s܂B
//--------------------------------------------------------------------
int stage_on_stage_clear_move()
{
	int result;
	CHROBJ* pJikiObj = &(p_stage_objects->jiki.obj);

	// NAt[ɐ؂ւ
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 256;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;

	// ʏ̈ړp
	result = stage_on_one_frame();

	// 莞ԂŃNA
	if (p_stage_context->status_count >= (300 + 120)) {
		if (p_stage_context->mask_pos < 512) {
			p_stage_context->mask_pos += MASK_SCROLL_SPEED;
			if (p_stage_context->mask_pos > 512) {
				p_stage_context->mask_pos = 512;
			}
			stage_scroll_mask();
		}
		else {
			p_stage_context->exit_code = STAGE_EXIT_CLEAR;
		}
	}

	// JE^i߂
	p_stage_context->status_count += 1;
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int stage_on_pause_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		|[YԂ1t[̏
//--------------------------------------------------------------------
int stage_on_pause_move()
{
	int i;

	// NAt[ɐ؂ւ
	p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc2_y = 256;

	// J[\ړ
	if (p_input_parser->stick_in_count == 1) {
		if (p_input_parser->direction_id == 4) {
			p_stage_objects->pause_cursor = 1;
			play_se(&(p_sound_context->se_item[setype_cursor]));
		}
		if (p_input_parser->direction_id == 6) {
			p_stage_objects->pause_cursor = 0;
			play_se(&(p_sound_context->se_item[setype_cursor]));
		}
	}

	// ESCPAUSE
	if (p_input_parser->pause_clicked) {
		p_stage_context->on_clear_move = 0;
		p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
		p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
	}

	// C{^NbNŏ
	if (p_input_parser->trg_main_clicked) {
		if (p_stage_objects->pause_cursor == 0) {
			// NȌꍇ̓|[Y甲
			p_stage_context->on_clear_move = 0;
			p_memory_map_buffer->grp_scroll_unit.sc2_x = 0;
			p_memory_map_buffer->grp_scroll_unit.sc2_y = 0;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
		}
		else {
			// YES̏ꍇQUIT
			//p_application_context->quit_requested = 1;
			p_stage_context->exit_code = STAGE_EXIT_GAMEOVER;
			play_se(&(p_sound_context->se_item[setype_cursorok]));
			for (i = 0; i < 90; i++) {
				p_stage_context->mask_pos += MASK_SCROLL_SPEED;
				if (p_stage_context->mask_pos >= 512) {
					p_stage_context->mask_pos = 512;
				}
				stage_scroll_mask();
				do_wait_vsync(1);
			}
		}
	}

	// JE^i߂
	p_stage_context->status_count += 1;
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int handle_section_clear()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G|ăNAɂȂǂ𔻒肵AԑJڂ
//--------------------------------------------------------------------
void handle_section_clear()
{
	int i;
	int enemy_existing;
	int enemy_remain;
	int stage_index = p_stage_context->stage - 1;
	int section_index = p_stage_context->section - 1;
	int next_bgm_index;

	// GcJEg
	enemy_existing = MAX_ENEMY - 1 - p_stage_objects->enemy_id_stack_ptr;
	enemy_remain = 0;
	for (i = 0; i < STAGE_DESC_LINES; i++) {
		enemy_remain += p_stage_context->stage_desc[i].enemy_remain;
	}

	// Gc疢NA
	if ((enemy_existing != 0) || (enemy_remain != 0)) {
		// NAȂ̂ŁAł
		return;
	}

	// X[[hiX{XNA㉉ỏj
	p_stage_objects->slow_mode = 0;
		
	// ŏIZNVۂ𔻒
	if (def_stage_clear_move_type[stage_index][section_index] != 5) {
		// ZNVNA̐ݒs
		p_stage_context->on_clear_move = 1;

		// NbsOĐݒ肷
		p_stage_context->stage_clipping_area.x0 = def_stage_section_area[stage_index][section_index][1][0];
		p_stage_context->stage_clipping_area.y0 = def_stage_section_area[stage_index][section_index][1][1];
		p_stage_context->stage_clipping_area.x1 = def_stage_section_area[stage_index][section_index][1][2];
		p_stage_context->stage_clipping_area.y1 = def_stage_section_area[stage_index][section_index][1][3];

		// NAXRAݒ肷
		set_section_clear_score();

		// ZNVNACxg
		if (p_stage_context->section_clear_event != NULL) {
			p_stage_context->section_clear_event(p_stage_context->section + 1);
		}

		// ʉ
		play_se(&(p_sound_context->se_item[setype_sectionclear]));

		// ZNVƂBGMݒ肳ĂꍇBGM炵
		if (resource_conf.bgm[bgmindex_st1 + stage_index][bgmtype_count + p_stage_context->section + 1] != NULL) {
			// BGM`ꍇ͖炵
			sound_stop_bgm();
			// Đ
			next_bgm_index = p_sound_context->bgm_index[bgmtype_count + p_stage_context->section + 1];
			sound_play_bgm(next_bgm_index);
		}
	}
	else {
		// Xe[WNAݒs
		p_stage_context->on_clear_move = 2;
		p_stage_context->status_count = 0;

		// NAXRAݒ肷
		set_stage_clear_score();

		// ʉ
		play_se(&(p_sound_context->se_item[setype_stageclear]));
	}

	// NAHP(EASY/NOVICÊ)
	if ((p_game_properties->game_level<=game_level_novice)
		&& (p_application_context->hp < HP_MAX)
	) {
		// 1
		p_application_context->hp += 1;
	}

	// VbvN[Y
	p_stage_objects->shop_closed = 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_on_one_frame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[W1t[̕`揈
//--------------------------------------------------------------------
void draw_on_one_frame() {
	CHROBJ* pObj;

	// -----< ` >-----
	//
	// <<<<< @\ >>>>>
	pObj = &(p_stage_objects->jiki.obj);
	if ((pObj->status != status_absent) && (pObj->draw != NULL)) {
		pObj->draw(&(p_stage_objects->jiki));
	}

	// <<<<< u[h\ >>>>>
	pObj = &(p_stage_objects->blade.obj);
	if ((pObj->status != status_absent) && (pObj->draw != NULL)) {
		pObj->draw(&(p_stage_objects->blade));
	}

	// <<<<< @\ >>>>>
	pObj = &(p_stage_objects->magic.obj);
	if ((pObj->status != status_absent) && (pObj->draw != NULL)) {
		pObj->draw(&(p_stage_objects->magic));
	}

	// <<<<< TuEF| >>>>>
	{
		SUBWEAPON* pSub = p_stage_objects->subweapon_top;
		while (pSub != NULL) {
			pSub->obj.draw(pSub);
			pSub = pSub->p_next;
		}
	}

	// <<<<< Ge\ >>>>>
	{
		ENESHOT* pEneShot = p_stage_objects->eneshot_top;
		while (pEneShot != NULL) {
			pEneShot->obj.draw(pEneShot);
			pEneShot = pEneShot->p_next;
		}
	}

	// <<<<< ESP\ >>>>>
	{
		ESP* pESP = p_stage_objects->esp_top;
		while (pESP != NULL) {
			pESP->obj.draw(pESP);
			pESP = pESP->p_next;
		}
	}

	// <<<<< \ >>>>>
	{
		EXPLODE* pExplode = p_stage_objects->explode_top;
		while (pExplode != NULL) {
			pExplode->obj.draw(pExplode);
			pExplode = pExplode->p_next;
		}
	}

	// <<<<< G\ >>>>>
	{
		ENEMY* pEnemy = p_stage_objects->enemy_top;
		while (pEnemy != NULL) {
			if (pEnemy->obj.out_of_screen) {
				// ʊOȂJ[\`
				draw_enemy_cursor(pEnemy);
			}
			else {
				// G`
				pEnemy->obj.draw(pEnemy);
			}
			pEnemy = pEnemy->p_next;
		}
	}

	// <<<<< ACe\ >>>>>
	{
		ITEM* pItem = p_stage_objects->item_top;
		while (pItem != NULL) {
			pItem->obj.draw(pItem);
			pItem = pItem->p_next;
		}
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_on_clear_move()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[W1t[̕`揈iNA[uj
//--------------------------------------------------------------------
void draw_on_clear_move()
{
	int sp_index;
	int allocsp;
	SP_UNIT* sp;
	int i;
	int time_bonus, hp_bonus;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// <<< ZXRA\ >>>
	time_bonus = p_stage_objects->clear_bonus_time;
	hp_bonus = p_stage_objects->clear_bonus_hp;
	// TIME BONUS
	draw_digits(time_bonus, 440 - 256 + 16 + 45, 104 + 16);
	// HP BONUS
	draw_digits(hp_bonus, 440 - 256 + 16 + 45, 128 + 16);

	// <<< pľߕ\ >>>
	// SPm
	sp_index = p_stage_objects->sp_index_seq;
	allocsp = sp_alloc_index(8);
	if (allocsp < 8) { return; }  // SPindexmۂłȂ`掩̂߂
	sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

	// 
	for (i = 0; i < 3; i++) {
		// TIME BONUS
		SP_SET(sp, 441 - 256 + 16 + (16 * i), 104 + 16, sp_code_top + 0x1B, 5, 0, 0, 3);
		sp++;
		// HP BONUS
		SP_SET(sp, 441 - 256 + 16 + (16 * i), 128 + 16, sp_code_top + 0x1B, 5, 0, 0, 3);
		sp++;
	}
	// TIME BONUS
	SP_SET(sp, 482 - 256 + 16, 104 + 16, sp_code_top + 0x1B, 5, 0, 0, 3);
	sp++;
	// HP BONUS
	SP_SET(sp, 482 - 256 + 16, 128 + 16, sp_code_top + 0x1B, 5, 0, 0, 3);
	sp++;

	// <<< ʏ̕`揈s >>>
	draw_on_one_frame();
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_on_pause()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[W1t[̕`揈iNA[uj
//--------------------------------------------------------------------
void draw_on_pause()
{
	int sp_index;
	int allocsp;
	SP_UNIT* sp;
	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;
	int x = (p_stage_objects->pause_cursor == 0) ? 152 : 90;

	// <<< J[\`悷 >>>
	sp_index = p_stage_objects->sp_index_seq;
	allocsp = sp_alloc_index(1);
	if (allocsp >= 1) {
		// SPindexmۂłꍇɕ`
		sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]
		SP_SET(sp, x, 152, sp_code_top + 0x05, 5, 0, 0, 3);
		sp++;
	}

	// <<< ʏ̕`揈s >>>
	draw_on_one_frame();
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_frame_items()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[W`
//--------------------------------------------------------------------
void draw_frame_items()
{
	draw_gauge();
	draw_numbers();
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_gauge()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[W`
//--------------------------------------------------------------------
void draw_gauge()
{
	int i;
	SP_UNIT* sp;
	int allocsp;
	int sp_index;
	int x;
	int enemy_remain;
	int enemy_existing;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// <<< gSP̃|C^ >>>
	sp_index = p_stage_objects->sp_index_seq;
	sp = p_memory_map_buffer->sp_unit + sp_index;

	// <<< vd_wait_skipped >>>
	if((startup_param.display_vd_wait_skipped) && (vd_wait_skipped)) {
		OBJPOS* pPos = &(p_stage_objects->jiki.obj.pos);
		int px, py;
		px = (pPos->hx - p_stage_context->bgview_hx) >> 8;
		py = (pPos->hy - p_stage_context->bgview_hy) >> 8;
		allocsp = sp_alloc_index(1);
		if (allocsp < 1) { return; }
		SP_SET(sp, px-6, py-14, sp_code_top + 0x43 + ((p_application_context->frame_count >> 3)&1), 7, 0, 0, 3);
		sp++;
	}

	// <<< HP >>>
	allocsp = sp_alloc_index(p_application_context->hp);
	if (allocsp < p_application_context->hp) { return; }  // SPindexmۂłȂ`掩̂߂

	// HP`
	x = 40;
	for (i = 0; i < p_application_context->hp; i++) {
		SP_SET(sp, x, 257, sp_code_top, 7, 0, 0, 3);
		sp++;
		x += 16;
	}

	// <<< p[AbvQ[W >>>
	allocsp = sp_alloc_index(3);
	if (allocsp < 3) { return; }  // SPindexmۂłȂ`掩̂߂
	{
		// u[h
		SP_SET(sp, 24 + ((p_application_context->lv_blade << 1) + p_application_context->lv_blade) , 19, sp_code_top + 0x01, 7, 0, 0, 3);
		sp++;

		// @
		SP_SET(sp, 64 + ((p_application_context->lv_magic << 1) + p_application_context->lv_magic), 19, sp_code_top + 0x01, 6, 0, 0, 3);
		sp++;

		// `[W
		SP_SET(sp, 104 + ((p_application_context->lv_charge << 1) + p_application_context->lv_charge), 19, sp_code_top + 0x01, 8, 0, 0, 3);
		sp++;
	}

	// <<< MPQ[W >>>
	p_memory_map_buffer->grp_scroll_unit.sc3_x = ((128 << 8) - p_application_context->mp) >> 8;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 0;

	// <<< Remains >>>
	enemy_existing = MAX_ENEMY - 1 - p_stage_objects->enemy_id_stack_ptr;
	enemy_remain = 0;
	for (i = 0; i < STAGE_DESC_LINES; i++) {
		enemy_remain += p_stage_context->stage_desc[i].enemy_remain;
	}
	draw_digits(enemy_existing + enemy_remain, 188, 32);
}

//--------------------------------------------------------------------
//	[  ]
//		void draw_numbers()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[W`
//--------------------------------------------------------------------
void draw_numbers()
{
	int i;
	SP_UNIT* sp;
	int allocsp;
	JIKI* pJiki = &(p_stage_objects->jiki);
	int* score = p_application_context->score;
	int* point = p_application_context->point;
	int* timelimit = p_stage_objects->time_limit;
	int digit_on = 0;
	int left = 0;
	int x;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// <<< gSP̃|C^ >>>
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
	
	// <<< LEFT >>>
	allocsp = sp_alloc_index(1);
	if (allocsp==0) { return; }  // SPindexmۂłȂ`掩̂߂
	if (pJiki->obj.status != status_absent) {
		left = p_application_context->left;
		if (left > 9) { left = 9; }
	}
	SP_SET(sp, 256, 257, sp_code_top + 0x06 + left, 5, 0, 0, 3);
	sp++;

	// <<< XRA\ >>>
	x = 184;
	digit_on = 0;
	for (i = (SCORE_DIGITS-1); i>=0 ; i--) {
		if (i == 0) { digit_on = 1; }
		if (score[i] != 0) { digit_on = 1; }
		//digit_on = 1;
		// \
		if (digit_on != 0) {
			allocsp = sp_alloc_index(1);
			if (allocsp == 0) { break; }
			SP_SET(sp, x, 16, sp_code_top + 0x06 + score[i], 5, 0, 0, 3);
			sp++;
		}
		x += 9;
	}

	// <<< ^C~bg >>>
	x = 124;
	digit_on = 0;
	for (i = (TIME_LIMIT_DIGITS - 1); i >= 0; i--) {
		if (i == 0) { digit_on = 1; }
		if (timelimit[i] != 0) { digit_on = 1; }
		//digit_on = 1;
		// \
		if (digit_on != 0) {
			allocsp = sp_alloc_index(1);
			if (allocsp == 0) { break; }
			SP_SET(sp, x, 32, sp_code_top + 0x06 + timelimit[i], 5, 0, 0, 3);
			sp++;
		}
		x += 9;
	}

	// <<< |Cg >>>
	x = 168;
	digit_on = 0;
	for (i = (POINT_DIGITS - 1); i >= 0; i--) {
		if (i == 0) { digit_on = 1; }
		if (point[i] != 0) { digit_on = 1; }
		//digit_on = 1;
		// \
		if (digit_on != 0) {
			allocsp = sp_alloc_index(1);
			if (allocsp == 0) { break; }
			SP_SET(sp, x, 256, sp_code_top + 0x06 + point[i], 5, 0, 0, 3);
			sp++;
		}
		x += 8;
	}

	// <<< R{JEg >>>
	x = 80;
	allocsp = sp_alloc_index(1);
	if (allocsp == 1) {
		SP_SET(sp, x, 32, sp_code_top + 0x06 + p_stage_objects->combo_lv, 5, 0, 0, 3);
		sp++;
	}

	if (p_stage_objects->combo_lv > 0) {
		allocsp = sp_alloc_index(1);
		if (allocsp == 1) {
			SP_SET(sp, x - 8 - (p_stage_objects->combo_timeout >> 4), 32, sp_code_top + 0x05, 5, 0, 0, 3);
			sp++;
		}
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void stage_scroll_bg()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		BGʂXN[ʒuvZāAXe[WReLXg
//		lAɂ킹BGʂ⊮EXN[܂
//--------------------------------------------------------------------
void stage_scroll_bg()
{
	int s_dx, s_dy;
	int s_vx, s_vy;
	int max_scroll_x, max_scroll_y, min_scroll_x, min_scroll_y;

	// -----< @̏𓾂 >-----
	//
	JIKI* pJiki = &(p_stage_objects->jiki);
	if (pJiki->obj.status == status_absent) {
		// L݂Ȃꍇ͖
		return;
	}

	// -----< XN[ʒuvZ >-----
	//
	//coef = 5;
	//max_scroll_x = (p_stage_context->bgmap_width * 8) - 256;
	//max_scroll_y = (p_stage_context->bgmap_height * 8) - 256;
	max_scroll_x = (p_stage_context->stage_clipping_area.x1) - 255;
	max_scroll_y = (p_stage_context->stage_clipping_area.y1) - 255;
	min_scroll_x = (p_stage_context->stage_clipping_area.x0);
	min_scroll_y = (p_stage_context->stage_clipping_area.y0);

	// OXN[ʒuۑ
	p_stage_context->prev_bgview_hx = p_stage_context->bgview_hx;
	p_stage_context->prev_bgview_hy = p_stage_context->bgview_hy;

	// L̃XN[WvZ
	p_stage_context->s_hx = pJiki->obj.pos.hx - p_stage_context->bgview_hx;  // LXN[W
	p_stage_context->s_hy = pJiki->obj.pos.hy - p_stage_context->bgview_hy;
	// XN[ʒuJ[\
	if (p_stage_context->s_cursor_x > p_stage_context->s_tx) {
		p_stage_context->s_cursor_x -= SCROLL_CURSOR_SPEED;
		if (p_stage_context->s_cursor_x < p_stage_context->s_tx) {
			p_stage_context->s_cursor_x = p_stage_context->s_tx;
		}
	}
	if (p_stage_context->s_cursor_x < p_stage_context->s_tx) {
		p_stage_context->s_cursor_x += SCROLL_CURSOR_SPEED;
		if (p_stage_context->s_cursor_x > p_stage_context->s_tx) {
			p_stage_context->s_cursor_x = p_stage_context->s_tx;
		}
	}
	if (p_stage_context->s_cursor_y > p_stage_context->s_ty) {
		p_stage_context->s_cursor_y -= SCROLL_CURSOR_SPEED;
		if (p_stage_context->s_cursor_y < p_stage_context->s_ty) {
			p_stage_context->s_cursor_y = p_stage_context->s_ty;
		}
	}
	if (p_stage_context->s_cursor_y < p_stage_context->s_ty) {
		p_stage_context->s_cursor_y += SCROLL_CURSOR_SPEED;
		if (p_stage_context->s_cursor_y > p_stage_context->s_ty) {
			p_stage_context->s_cursor_y = p_stage_context->s_ty;
		}
	}
	// XN[ʒuJ[\Ƃ̍]
	s_dx = p_stage_context->s_cursor_x - p_stage_context->s_hx;   // XN[W
	s_dy = p_stage_context->s_cursor_y - p_stage_context->s_hy;

	// t[ł̕\ʒu𓱏o
	s_vx = -(s_dx >> 4);    // 1t[BGXN[
	s_vy = -(s_dy >> 4);

	// BGXN[ʒu̍ĕ]
	p_stage_context->bgview_hx = p_stage_context->bgview_hx + s_vx;
	p_stage_context->bgview_hy = p_stage_context->bgview_hy + s_vy;
	// NbsO
	if (p_stage_context->bgview_hx < (min_scroll_x << 8)) {
		p_stage_context->bgview_hx = (min_scroll_x << 8);
	}
	if (p_stage_context->bgview_hy < (min_scroll_y << 8)) {
		p_stage_context->bgview_hy = (min_scroll_y << 8);
	}
	if (p_stage_context->bgview_hx > (max_scroll_x << 8)) {
		p_stage_context->bgview_hx = (max_scroll_x << 8);
	}
	if (p_stage_context->bgview_hy > (max_scroll_y << 8)) {
		p_stage_context->bgview_hy = (max_scroll_y << 8);
	}
	// LXN[W̍ĕ]
	p_stage_context->s_hx = pJiki->obj.pos.hx - p_stage_context->bgview_hx;
	p_stage_context->s_hy = pJiki->obj.pos.hy - p_stage_context->bgview_hy;

	// -----< BG̒` >-----
	//
	redraw_bgmap_diff(0, 1);    // BG}bv0̃f[^gBGy[W1ւ

	// -----< n`𓮂 >-----
	//
	// BG̃XN[
	p_memory_map_buffer->bg_scroll_unit.bg0x = 0;
	p_memory_map_buffer->bg_scroll_unit.bg0y = 0;
	p_memory_map_buffer->bg_scroll_unit.bg1x = (p_stage_context->bgview_hx >> 8) & 511;
	p_memory_map_buffer->bg_scroll_unit.bg1y = (p_stage_context->bgview_hy >> 8) & 511;
}


//--------------------------------------------------------------------
//	[  ]
//		void stage_scroll_txt()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		wieLXgʂ̃XN[
//--------------------------------------------------------------------
void stage_scroll_txt()
{
	int world_width, world_height;
	int grp_width, grp_height;
	int grp_hx, grp_hy;
	int stage_index = p_stage_context->stage - 1;

	world_width = (def_stage_bg_size[stage_index][0] * 8) - 256;
	world_height = (def_stage_bg_size[stage_index][1] * 8) - 256;
	grp_width = 512 - 256;
	grp_height = 512 - 256;
	grp_hx = p_stage_context->bgview_hx * grp_width / world_width;
	grp_hy = p_stage_context->bgview_hy * grp_height / world_height;

	p_memory_map_buffer->txt_scroll_unit.tx_x = (grp_hx >> 8) & 511;
	p_memory_map_buffer->txt_scroll_unit.tx_y = (grp_hy >> 8) & 511;
}


//--------------------------------------------------------------------
//	[  ]
//		void stage_scroll_grp()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		}XÑXN[
//--------------------------------------------------------------------
void stage_scroll_mask()
{
	p_memory_map_buffer->grp_scroll_unit.sc0_x = p_stage_context->mask_pos;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = (p_stage_context->mask_pos >= 256) ? 256 : 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int initialize_bgmap(int pages, int bgmap_width, int bgmap_height)
//
//	[  ]
//		int pages					BG̃y[W
//		int bgmap_width				BG}bvisNZ/8)
//		int bgmap_height			BG}bvisNZ/8)
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		STAGE_CONTEXT́ABG}bv, p[h}bṽf[^
//		ǂݍݐ܂B
//--------------------------------------------------------------------
int initialize_bgmap(int pages, int bgmap_width, int bgmap_height)
{
	int result;
	int i;

	// f[^ꍇ͉
	result = release_bgmap();
	if (result != 0) {
		kon_log("initialize_bgmap : BG}bv̊̈̉ɃG[܂B\n");
		return -1;
	}

	//===============================
	// BG̃y[Wmۂ
	//===============================
	// BG̃y[Wmۂ
	p_stage_context->bg_map = (BG_DEF_UNIT**)malloc(pages * sizeof(BG_DEF_UNIT*));
	if (p_stage_context->bg_map == NULL) {
		kon_log("initialize_bgmap : BG}bṽy[Ẅmۂł܂łBpages=%d\n", pages);
		return -1;
	}
	memset(p_stage_context->bg_map, 0, pages * sizeof(BG_DEF_UNIT*));

	// YCfbNXm
	p_stage_context->bg_map_yindex = (BG_DEF_UNIT***)malloc(pages * sizeof(BG_DEF_UNIT*));
	if (p_stage_context->bg_map_yindex == NULL) {
		kon_log("initialize_bgmap : BG}bvYCfbNẌmۂł܂łBpages=%d\n", pages);
		free(p_stage_context->bg_map);
		p_stage_context->bg_map = NULL;
		return -1;
	}
	memset(p_stage_context->bg_map_yindex, 0, pages * sizeof(BG_DEF_UNIT*));

	// BG̃}bv̗̈mۂ
	for (i = 0; i < pages; i++) {
		// f[^̈S
		p_stage_context->bg_map[i] = (BG_DEF_UNIT*)malloc(bgmap_width * bgmap_height * sizeof(BG_DEF_UNIT));
		if (p_stage_context->bg_map[i] == NULL) {
			release_bgmap();
			kon_log("initialize_bgmap : BG̗̈mۂł܂łBpage=%d, size=(%d, %d)\n", i, bgmap_width, bgmap_height);
			return -1;
		}
		memset(p_stage_context->bg_map[i], 0, bgmap_width * bgmap_height * sizeof(BG_DEF_UNIT));

		// YCfbNXo
		{
			int y;
			BG_DEF_UNIT* pCursor;

			// CfbNẌ̗pӂ
			p_stage_context->bg_map_yindex[i] = (BG_DEF_UNIT**)malloc(sizeof(BG_DEF_UNIT*) * bgmap_height);
			if (p_stage_context->bg_map_yindex[i] == NULL) {
				release_bgmap();
				kon_log("initialize_bgmap : BG̃CfbNẌmۂł܂łB\n");
				return -1;
			}
			// 擪̃|C^𓾂
			pCursor = p_stage_context->bg_map[i];
			// 擪珇ɃCfNXpӂ
			for (y = 0; y < bgmap_height; y++) {
				// CfLVO
				p_stage_context->bg_map_yindex[i][y] = pCursor;
				// J[\i߂
				pCursor += bgmap_width;
			}
		}
	}

	//===========================================
	// p[h}bṽy[Wmۂ
	//===========================================
	// p[h}bṽy[Wmۂ
	p_stage_context->bg_pworld = (unsigned char**)malloc(pages * sizeof(unsigned char*));
	if (p_stage_context->bg_pworld == NULL) {
		kon_log("initialize_bgmap : p[h}bṽy[Ẅmۂł܂łBpages=%d\n", pages);
		release_bgmap();
		return -1;
	}
	memset(p_stage_context->bg_pworld, 0, pages * sizeof(unsigned char*));

	// YCfbNXmۂ
	p_stage_context->bg_pworld_yindex = (unsigned char***)malloc(pages * sizeof(unsigned char**));
	if (p_stage_context->bg_pworld_yindex == NULL) {
		kon_log("initialize_bgmap : p[h}bvYCfbNẌmۂł܂łBpages=%d\n", pages);
		release_bgmap();
		return -1;
	}
	memset(p_stage_context->bg_pworld_yindex, 0, pages * sizeof(unsigned char**));

	// p[h}bv̗̈mۂ
	for (i = 0; i < pages; i++) {
		p_stage_context->bg_pworld[i] = (unsigned char*)malloc(bgmap_width * bgmap_height * sizeof(unsigned char));
		if (p_stage_context->bg_pworld[i] == NULL) {
			release_bgmap();
			kon_log("initialize_bgmap : p[h}bv̗̈mۂł܂łBpage=%d, size=(%d, %d)\n", i, bgmap_width, bgmap_height);
			return -1;
		}
		memset(p_stage_context->bg_pworld[i], 0, bgmap_width * bgmap_height * sizeof(unsigned char));

		// YCfbNXo
		{
			int y;
			unsigned char* pCursor;

			// CfbNẌ̗pӂ
			p_stage_context->bg_pworld_yindex[i] = (unsigned char**)malloc(sizeof(unsigned char*) * bgmap_height);
			if (p_stage_context->bg_pworld_yindex[i] == NULL) {
				kon_log("initialize_bgmap : p[h}bvYCfbNẌmۂł܂łB\n");
				release_bgmap();
				return -1;
			}
			// 擪̃|C^𓾂
			pCursor = p_stage_context->bg_pworld[i];
			// 擪珇ɃCfNXpӂ
			for (y = 0; y < bgmap_height; y++) {
				// CfLVO
				p_stage_context->bg_pworld_yindex[i][y] = pCursor;
				// J[\i߂
				pCursor += bgmap_width;
			}
		}
	}

	// I
	p_stage_context->bgmap_pages = pages;
	p_stage_context->bgmap_width = bgmap_width;
	p_stage_context->bgmap_height = bgmap_height;
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int release_bgmap()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		STAGE_CONTEXTɊmۍςBG}bv̗̈܂B
//--------------------------------------------------------------------
int release_bgmap()
{
	int i;

	// mۍς̗̈
	for (i = 0; i < p_stage_context->bgmap_pages; i++) {
		if (p_stage_context->bg_map != NULL) {
			// BG̈
			if (p_stage_context->bg_map[i] != NULL) {
				free(p_stage_context->bg_map[i]);
			}
			// YCfbNX
			if (p_stage_context->bg_map_yindex[i] != NULL) {
				free(p_stage_context->bg_map_yindex[i]);
			}
		}
		if (p_stage_context->bg_pworld != NULL) {
			// PWorld
			if (p_stage_context->bg_pworld[i] != NULL) {
				free(p_stage_context->bg_pworld[i]);
			}
			// YCfbNX
			if (p_stage_context->bg_pworld_yindex[i] != NULL) {
				free(p_stage_context->bg_pworld_yindex[i]);
			}
		}
	}

	// BG
	free(p_stage_context->bg_map);
	p_stage_context->bg_map = NULL;
	free(p_stage_context->bg_map_yindex);
	p_stage_context->bg_map_yindex = NULL;
	// PWorld
	free(p_stage_context->bg_pworld);
	p_stage_context->bg_pworld = NULL;
	free(p_stage_context->bg_pworld_yindex);
	p_stage_context->bg_pworld_yindex = NULL;

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int load_bgmap(const char* bgmap_filename, const char* pwmap_filename, int bgmap_width, int bgmap_height)
//
//	[  ]
//		const char* bgmap_filename	ǂݍBG}bvf[^̉摜t@C
//		const char* pwmap_filename	ǂݍBG}bvɑΉp[h}bṽt@C
//		int page					BG̃y[Wԍ
//		int bgmap_width				BG}bvisNZ/8)
//		int bgmap_height			BG}bvisNZ/8)
//		int little_endian			gGfBÂƂ1w肷
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		BG}bv, p[h}bṽf[^STAGE_CONTEXTɓǂݍ݂܂B
//		p[h}bvꍇ́Apwmap_filenameNULL
//		w肵܂B
//--------------------------------------------------------------------
int load_bgmap(const char* bgmap_filename, const char* pwmap_filename, int page, int bgmap_width, int bgmap_height, int little_endian)
{
	// -----< BG}bv̓ǂݍ >-----
	//
	{
		int i;
		FILE* fn;
		struct stat fileInfo;
		unsigned short* databuffer;

		// t@CTCY𓾂
		stat(bgmap_filename, &fileInfo);
		if (fileInfo.st_size <= 0) {
			kon_log("load_bgmap : BG}bv`̃t@CTCY擾ł܂łBsize = %d\n", fileInfo.st_size);
			return -1;
		}

		// x^œǂݍ
		databuffer = (unsigned short*)malloc(fileInfo.st_size);
		if (databuffer == NULL) {
			kon_log("load_bgmap : BG}bv`ǂݍݗpobt@mۂł܂łB\n");
			return -1;
		}
		fn = fopen(bgmap_filename, "rb");
		fread(databuffer, fileInfo.st_size, 1, fn);
		fclose(fn);

		// rbOGfBAgGfBAϊsĂrbgZĒl荞
		if (little_endian == 1) {
			convert_endian_word((unsigned short*)databuffer, fileInfo.st_size / 2);
		}
		for (i = 0; i < bgmap_width * bgmap_height; i++) {
			unsigned short v = (unsigned short)(databuffer[i]);
			p_stage_context->bg_map[page][i].code.bit.code = v & 0x00FF;
			p_stage_context->bg_map[page][i].code.bit.color = (v >> 8) & 0x000F;
			p_stage_context->bg_map[page][i].code.bit.h_rev = (v >> 14) & 0x0001;
			p_stage_context->bg_map[page][i].code.bit.v_rev = (v >> 15) & 0x0001;
		}

		// obt@
		free(databuffer);
	}

	// -----< p[h}bv̓ǂݍ >-----
	//
	{
		struct stat fileInfo;
		FILE* fn;

		// t@CTCY𓾂
		stat(pwmap_filename, &fileInfo);
		if (fileInfo.st_size <= 0) {
			kon_log("load_bgmap : p[h}bṽt@CTCY擾ł܂łBsize = %d\n", fileInfo.st_size);
			return -1;
		}

		// x^œǂݍ
		fn = fopen(pwmap_filename, "rb");
		fread(p_stage_context->bg_pworld[0], fileInfo.st_size, 1, fn);
		fclose(fn);
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL convert_endian_word(WORD* array, int elementCount)
//
//	[  ]
//		WORD* array			ϊΏۂ̔z
//		int elementCount	z̗vf
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽWORDl̔zɂāA8oCgƉ8oCg
//		ւ܂B
//--------------------------------------------------------------------
int convert_endian_word(unsigned short* array, int elementCount)
{
	int i;
	unsigned char s;
	unsigned char* p = (unsigned char*)(array);
	for (i = 0; i < elementCount; i++) {
		s = *p;
		*p = *(p + 1);
		*(p + 1) = s;
		p += 2;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void set_timelimit_bonus(int seconds)
//
//	[  ]
//		int seconds	^C~bg{[iX̒libj
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[W̃^C~bg{[iX̒lݒ肵܂B
//		^Ŏw肵ĎsƁA{ŏ܂B
//--------------------------------------------------------------------
void set_timelimit_bonus(int seconds) {
	p_stage_objects->time_limit[0] = (seconds / 1) % 10;
	p_stage_objects->time_limit[1] = (seconds / 10) % 10;
	p_stage_objects->time_limit[2] = (seconds / 100) % 10;

	// t[JEgĂ
	p_stage_context->second_counter = 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void set_section_clear_score()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ZNVNÃ{[iXlm肵stage_objects
//		ݒ肵AXRAɉZ܂B
//--------------------------------------------------------------------
void set_section_clear_score()
{
	int time, left, hp;
	int score;

	// vZɎglW߂
	time = digits_get_int(p_stage_objects->time_limit, TIME_LIMIT_DIGITS);
	left = p_application_context->left;
	hp = p_application_context->hp;

	// c莞ԃ{[iX
	p_stage_objects->clear_bonus_time = time * CLEAR_BONUS_TIME;
	// cHP{[iX
	p_stage_objects->clear_bonus_hp = ((5 * left) + hp) * CLEAR_BONUS_HP;

	// XRAɉZ
	score = digits_get_int(p_application_context->score, SCORE_DIGITS);
	score += p_stage_objects->clear_bonus_time;
	score += p_stage_objects->clear_bonus_hp;

	// {ɏ߂
	digits_set_int(score, p_application_context->score, SCORE_DIGITS);

	// XRAO
	if (startup_param.record_score_log) {
		score_log("section_clear"
			, p_application_context->frame_count
			, p_stage_objects->frame_count
			, p_stage_context->stage
			, p_stage_context->section
			, digits_get_int(p_application_context->score, SCORE_DIGITS)
			, digits_get_int(p_application_context->point, POINT_DIGITS)
			, p_application_context->left
			, p_application_context->hp
			, p_application_context->mp
			, p_stage_objects->combo_lv
			, digits_get_int(p_stage_objects->time_limit, TIME_LIMIT_DIGITS)
			, p_application_context->lv_blade
			, p_application_context->lv_magic
			, p_application_context->lv_charge
			, p_application_context->bomb_charge
			, p_stage_objects->clear_bonus_time
			, p_stage_objects->clear_bonus_hp
		);
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void set_section_clear_score()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[WNÃ{[iXlm肵stage_objects
//		ݒ肵܂B
//--------------------------------------------------------------------
void set_stage_clear_score()
{
	// ЂƂ܂ZNVNAƓɂĂ
	set_section_clear_score();
}



//--------------------------------------------------------------------
//	[  ]
//		int redraw_bgmap_full(int bgmap_page, int bg_page)
//
//	[  ]
//		int bgmap_page	f[^BG}bṽy[Wԍ
//		int bg_page		`BGy[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		BG}bvSʂ`ւ܂
//--------------------------------------------------------------------
int redraw_bgmap_full(int bgmap_page, int bg_page)
{
	int x, y;
	int bgmap_width;
	int bgmap_height;

	// <<< BG̃r[ʒu`͈͂肷 >>>
	//
	// Ẍ̗őSʂJo[AŸ̗͎gȂ
	p_stage_context->bg_redraw_x.x0 = ((p_stage_context->bgview_hx >> 8) + 0) / 8;
	p_stage_context->bg_redraw_x.y0 = ((p_stage_context->bgview_hy >> 8) + 0) / 8;
	p_stage_context->bg_redraw_x.x1 = ((p_stage_context->bgview_hx >> 8) + 255) / 8;
	p_stage_context->bg_redraw_x.y1 = ((p_stage_context->bgview_hy >> 8) + 255) / 8;
	memset(&(p_stage_context->bg_redraw_y), 0, sizeof(BBOX));

	// <<< `GA >>>
	//
	// BG}bṽTCYoicj
	bgmap_width = p_stage_context->bgmap_width;
	bgmap_height = p_stage_context->bgmap_height;

	// 
	for (y = p_stage_context->bg_redraw_x.y0; y <= p_stage_context->bg_redraw_x.y1; y++) {
		for (x = p_stage_context->bg_redraw_x.x0; x <= p_stage_context->bg_redraw_x.x1; x++) {
			int mx, my;
			mx = x & 63;
			my = y & 63;
			p_memory_map_buffer->bg_def[bg_page][(my << 6) + mx] = p_stage_context->bg_map_yindex[bgmap_page][y][x];
		}
	}

	// <<< I >>>
	//
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int redraw_bgmap_diff(int bgmap_page, int bg_page)
//
//	[  ]
//		int bgmap_page	f[^BG}bṽy[Wԍ
//		int bg_page		`BGy[Wԍ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		BG}bv`ւ܂
//--------------------------------------------------------------------
int redraw_bgmap_diff(int bgmap_page, int bg_page)
{
	int x, y;
	int bgview_x, bgview_y;		// ړOr[ʒuihbgPʁj
	int n_bgview_x, n_bgview_y;	// ړr[ʒuihbgPʁj
	int dx, dy;			// XN[ʁihbgj
	int bgmap_width;	// BG}bv
	int bgmap_height;	// BG}bv
	BBOX* pBGReDrawX;
	BBOX* pBGReDrawY;

	// <<< S̕`ւ >>>
	// ړʂʕ傫Sʕ`ւ
	if (abs(p_stage_context->bgview_hx - p_stage_context->prev_bgview_hx) >= (256 << 8)) {
		return redraw_bgmap_full(bgmap_page, bg_page);
	}
	if (abs(p_stage_context->bgview_hy - p_stage_context->prev_bgview_hy) >= (256 << 8)) {
		return redraw_bgmap_full(bgmap_page, bg_page);
	}

	// <<< BG̃r[ʒu`͈͂肷 >>>
	// W
	bgview_x = p_stage_context->prev_bgview_hx >> 8;	// Ot[ʒu
	bgview_y = p_stage_context->prev_bgview_hy >> 8;
	n_bgview_x = p_stage_context->bgview_hx >> 8;	// t[ʒu
	n_bgview_y = p_stage_context->bgview_hy >> 8;
	dx = n_bgview_x - bgview_x;	// 
	dy = n_bgview_y - bgview_y;

	// Ẍ̗
	pBGReDrawX = &(p_stage_context->bg_redraw_x);
	pBGReDrawY = &(p_stage_context->bg_redraw_y);
	if (dx > 0) {
		// X͍
		pBGReDrawX->x0 = ((bgview_x + 255) >> 3) + 1;
		pBGReDrawX->x1 = (n_bgview_x + 255) >> 3;
		// Y͏[牺[܂
		pBGReDrawX->y0 = n_bgview_y >> 3;
		pBGReDrawX->y1 = (n_bgview_y + 255) >> 3;
	}
	if (dx < 0) {
		// X͍
		pBGReDrawX->x0 = (n_bgview_x) >> 3;
		pBGReDrawX->x1 = ((bgview_x) >> 3) - 1;
		// Y͏[牺[܂
		pBGReDrawX->y0 = n_bgview_y >> 3;
		pBGReDrawX->y1 = (n_bgview_y + 255) >> 3;
	}

	// Ÿ̗
	if (dy > 0) {
		// X͍[E[܂
		pBGReDrawY->x0 = n_bgview_x >> 3;
		pBGReDrawY->x1 = (n_bgview_x + 255) >> 3;
		// Y͍
		pBGReDrawY->y0 = ((bgview_y + 255) >> 3) + 1;
		pBGReDrawY->y1 = (n_bgview_y + 255) >> 3;
	}
	if (dy < 0) {
		// X͍[E[܂
		pBGReDrawY->x0 = n_bgview_x >> 3;
		pBGReDrawY->x1 = (n_bgview_x + 255) >> 3;
		// Y͍
		pBGReDrawY->y0 = (n_bgview_y) >> 3;
		pBGReDrawY->y1 = ((bgview_y) >> 3) - 1;
	}

	// <<< `GA >>>
	//
	{
		BG_DEF_UNIT* pBGTop = p_memory_map_buffer->bg_def[bg_page];
		BG_DEF_UNIT* pBG = NULL;
		//BG_DEF_UNIT* pMapTop = p_stage_context->bg_map[bgmap_page];
		BG_DEF_UNIT* pMap = NULL;

		// BG}bṽTCYoicj
		bgmap_width = p_stage_context->bgmap_width;
		bgmap_height = p_stage_context->bgmap_height;

		// iXj
		if (dx != 0) {
			//BG_DEF_UNIT* pLineTop = pMapTop + (pBGReDrawX->y0 * bgmap_width);	// Y̍s̍[
			BG_DEF_UNIT* pLineTop = p_stage_context->bg_map_yindex[bgmap_page][pBGReDrawX->y0];	// Y̍s̍[
			for (y = pBGReDrawX->y0; y <= pBGReDrawX->y1; y++) {
				pMap = pLineTop + pBGReDrawX->x0;	// pMapTop[(y * bgmap_width) + x] = pLineTop[x]
				for (x = pBGReDrawX->x0; x <= pBGReDrawX->x1; x++) {
					int mx, my;
					mx = x & 63;
					my = y & 63;
					pBG = pBGTop + (my << 6) + mx;	// pBGTop[(my * 64) + mx]
					*pBG = *(pMap++);
				}
				// }bv̍[ʒuA̍s
				pLineTop += bgmap_width;
			}
		}

		// iYj
		if (dy != 0) {
			//BG_DEF_UNIT* pLineTop = pMapTop + (pBGReDrawY->y0 * bgmap_width);	// Y̍s̍[
			BG_DEF_UNIT* pLineTop = p_stage_context->bg_map_yindex[bgmap_page][pBGReDrawY->y0];	// Y̍s̍[
			for (y = pBGReDrawY->y0; y <= pBGReDrawY->y1; y++) {
				pMap = pLineTop + p_stage_context->bg_redraw_y.x0;	// pLineTop[(y * bgmap_width) + x] = pLineTop + x
				for (x = pBGReDrawY->x0; x <= pBGReDrawY->x1; x++) {
					int mx, my;
					mx = x & 63;
					my = y & 63;
					pBG = pBGTop + (my << 6) + mx;	// pBGTop[(my * 64) + mx]
					*pBG = *(pMap++);
				}
				// }bv̍[ʒuA̍s
				pLineTop += bgmap_width;
			}
		}
	}

	// <<< I >>>
	//
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_enemy_cursor(ENEMY* pEnemy)
//
//	[  ]
//		ENEMY* pEnemy		Gւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ʊO̓Gւ̃J[\\
//--------------------------------------------------------------------
void draw_enemy_cursor(ENEMY* pEnemy)
{
	int px, py;	// LN^̃XN[W
	int cx, cy;	// J[\̍Wƕ
	int pattern, hrev, vrev, pal;
	OBJPOS* pPos = &(pEnemy->obj.pos);
	SP_UNIT* sp;
	int allocsp;

	// SP̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// SPm
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// mۂłȂ`߂
		return;
	}

	// LN^̃XN[W
	px = (pPos->hx - p_stage_context->bgview_hx) >> 8;
	py = (pPos->hy - p_stage_context->bgview_hy) >> 8;

	// 肷
	pal = 6;
	if (px < 8) {
		if (py < 8+16) {
			// dir = 7F
			cx = 16;
			cy = 32;
			pattern = sp_code_top + 0x02;
			hrev = 1;
			vrev = 0;
			if ((px > (-CURSOR_NEAR_TH)) && (py > (-CURSOR_NEAR_TH))) {
				pal = 7;
			}
		}
		else if (py >= (256 - 8 - 16)) {
			// dir = 1F
			cx = 16;
			cy = 255-16;
			pattern = sp_code_top + 0x02;
			hrev = 1;
			vrev = 1;
			if ((px > (-CURSOR_NEAR_TH)) && (py < (256 + CURSOR_NEAR_TH))) {
				pal = 7;
			}
		}
		else {
			// dir = 4F
			cx = 16;
			cy = py + 8;
			pattern = sp_code_top + 0x03;
			hrev = 1;
			vrev = 0;
			if ((px > (-CURSOR_NEAR_TH))) {
				pal = 7;
			}
		}
	}
	else if (px >= (256 - 8)) {
		if (py < 8 + 16) {
			// dir = 9FE
			cx = 255;
			cy = 32;
			pattern = sp_code_top + 0x02;
			hrev = 0;
			vrev = 0;
			if ((px < (256+CURSOR_NEAR_TH)) && (py > (-CURSOR_NEAR_TH))) {
				pal = 7;
			}
		}
		else if (py >= (256 - 8 - 16)) {
			// dir = 3FE
			cx = 255;
			cy = 255 - 16;
			pattern = sp_code_top + 0x02;
			hrev = 0;
			vrev = 1;
			if ((px < (256 + CURSOR_NEAR_TH)) && (py < (256+CURSOR_NEAR_TH))) {
				pal = 7;
			}
		}
		else {
			// dir = 6FE
			cx = 255;
			cy = py + 8;
			pattern = sp_code_top + 0x03;
			hrev = 0;
			vrev = 0;
			if (px < (256 + CURSOR_NEAR_TH)) {
				pal = 7;
			}
		}
	}
	else {
		if (py < 8 + 16) {
			// dir = 8F
			cx = px + 8;
			cy = 32;
			pattern = sp_code_top + 0x04;
			hrev = 0;
			vrev = 0;
			if (py > (-CURSOR_NEAR_TH)) {
				pal = 7;
			}
		}
		else if (py >= (256 - 8 -16)) {
			// dir = 2F
			cx = px + 8;
			cy = 255 - 16;
			pattern = sp_code_top + 0x04;
			hrev = 0;
			vrev = 1;
			if (py < (256 + CURSOR_NEAR_TH)) {
				pal = 7;
			}
		}
		else {
			// dir = 5GiȂj
			cx = px + 8;
			cy = py + 8;
			pattern = sp_code_top + 0x25;
			hrev = 0;
			vrev = 0;
			pal = 2;
		}
	}

	// `
	SP_SET(sp, cx, cy, pattern, pal, hrev, vrev, 3);
}


//--------------------------------------------------------------------
//	[  ]
//		void enemy_play_clear_jingle(int stage_index)
//
//	[  ]
//		int stage_index		Xe[W̃CfbNXԍiXe[W1̂Ƃ0j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Xe[WNÃWO炵܂
//--------------------------------------------------------------------
void stage_play_clear_jingle(int stage_index)
{
	if (resource_conf.bgm[bgmindex_st1 + stage_index][bgmtype_clear] != NULL) {
		int bgm_index = -1;
		sound_stop_bgm();
		bgm_index = p_sound_context->bgm_index[bgmtype_clear];
		sound_play_bgm(bgm_index);
	}
}
