#define __SHOP_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "kon_util.h"
#include "game_context.h"
#include "common.h"
#include "../devs/devs.h"
#include "stage.h"
#include "shop.h"
#include "jiki.h"
#include "blade.h"

// <<< vg^Cv錾 >>>
void shop_start_mask(int status);	// Jñ}XN
void shop_in(int status);			// ؂ւ
void shop_open(int status);			// ʂ𓮂ă}XN
void shop_main(int status);			// C
void shop_close(int status);		// 
void shop_out(int status);			// ؂ւ
void shop_exit(int status);			// 
//
void set_price(int* price_array);	// ݂̉iݒ肷

// <<< ` >>>
int item_area_x[6][2] = {
	  {  13, 122}	// 
	, { 133, 242}	// E
	, {  13, 122}	// 
	, { 133, 242}	// E
	, {  13, 122}	// 
	, { 133, 242}	// E
};
int item_area_y[6][2] = {
	  {  53, 106}	// 
	, {  53, 106}	// E
	, { 117, 170}	// 
	, { 117, 170}	// E
	, { 181, 234}	// 
	, { 181, 234}	// E
};

// <<< ACẻiݒ >>>>>
//
int price[game_level_count][6][6] = SHOP_PRICE;

// <<< eLXgʏ̃Vbv摜̈ʒu >>>
int shop_txt_tx[MAX_STAGE] = {0, 0, 0, 0, 0, 0};
int shop_txt_ty[MAX_STAGE] = {512, 512, 512, 0, 512, 512};

// <<< O[oϐ >>>
// Vbvɓ钼ÕeLXgXN[ʒu
int shop_prev_text_px;
int shop_prev_text_py;

//--------------------------------------------------------------------
//	[  ]
//		int shop_start()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbvɓ
//--------------------------------------------------------------------
int shop_start()
{
	SHOP_CURSOR* pCursor = &(p_stage_objects->shop_cursor);
	p_stage_context->stage_mode = STAGE_MODE_SHOP;
	p_stage_context->status = 0;
	memset(&(p_stage_objects->shop_cursor), 0, sizeof(SHOP_CURSOR));

	// SOLD OUT𔻒
	if (p_application_context->lv_blade == 5) { pCursor->sold[0] = 1; }
	if (p_application_context->lv_magic == 5) { pCursor->sold[1] = 1; }
	if (p_application_context->lv_charge == 5) { pCursor->sold[2] = 1; }
	if (p_application_context->hp == 5) { pCursor->sold[3] = 1; }
	if (p_application_context->left >= 9) { pCursor->sold[4] = 1; }

	// MPő܂ŉ񕜂
	p_application_context->mp = MP_MAX;

	// eLXg̃XN[ʒuۑ
	shop_prev_text_px = p_memory_map_buffer->txt_scroll_unit.tx_x;
	shop_prev_text_py = p_memory_map_buffer->txt_scroll_unit.tx_y;

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_move(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbv̉Z
//--------------------------------------------------------------------
int shop_move(int status)
{
	switch (status) {
	case 0:
		shop_start_mask(status);
		break;

	case 1:
		shop_in(status);
		break;

	case 2:
		shop_open(status);
		break;

	case 3:
		shop_main(status);
		break;

	case 4:
		shop_close(status);
		break;

	case 5:
		shop_out(status);
		break;

	case 6:
		shop_exit(status);
		break;

	default:
		break;
	}
	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_start_mask(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		VbvɓƂ̃}XN
//--------------------------------------------------------------------
void shop_start_mask(int status)
{
	p_stage_context->mask_pos += MASK_SCROLL_SPEED;
	if (p_stage_context->mask_pos >= 512) {
		p_stage_context->mask_pos = 512;
	}

	// gWVI
	if (p_stage_context->mask_pos >= 512) {
		p_stage_context->status = 1;	// ̃Xe[^XɑJ
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_in(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		VbvɓƂ̊e؂ւ
//--------------------------------------------------------------------
void shop_in(int status)
{
	int sp_top = p_stage_context->cmn_sp_top;

	// OtBbÑ}XNȊOOFFɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;	// GRP0\
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;

	// eLXgpbg]
	stack_transfer_pal(p_stage_context->text_pal_slot, p_stage_context->shop_pal_block, 0, 1);

	// eLXgXN[
	p_memory_map_buffer->txt_scroll_unit.tx_x = shop_txt_tx[p_stage_context->stage - 1];
	p_memory_map_buffer->txt_scroll_unit.tx_y = shop_txt_ty[p_stage_context->stage - 1];

	// BG̕\
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;

	// J[\ݒ
	p_stage_objects->shop_cursor.disable = 0;	// ~Ȃ
	p_stage_objects->shop_cursor.obj.pos.px = 128;
	p_stage_objects->shop_cursor.obj.pos.py = 128;

	// p^[]
	stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x74, sp_top + 0x10, 4);	// 
	stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x7C, sp_top + 0x14, 4);	// SOLDOUT

	// 
	p_stage_context->status = 2;	// ̃Xe[^XɑJ
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_open(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbvɓ
//--------------------------------------------------------------------
void shop_open(int status)
{
	p_stage_context->mask_pos -= MASK_SCROLL_SPEED;
	if (p_stage_context->mask_pos <= 0) {
		p_stage_context->mask_pos = 0;
	}

	// gWVI
	if (p_stage_context->mask_pos <= 0) {
		p_stage_context->status = 3;	// ̃Xe[^XɑJ
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_main(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbvɓ
//--------------------------------------------------------------------
void shop_main(int status)
{
	int i;
	GAMEPAD_UNIT* pPad = &(p_memory_map_buffer->input_unit);
	SHOP_CURSOR* pCursor = &(p_stage_objects->shop_cursor);
	int item_index = -1;
	int icon_disabled = 0;
	int px, py;
	//
	// i
	int current_price[6];
	int wallet;

	int sp_top = p_stage_context->cmn_sp_top;

	// -----< iݒ >-----
	//
	set_price(current_price);

	// -----< J[\ړ >-----
	//
	if (pPad->bit.left) {
		pCursor->obj.pos.px -= 3;
	}
	if (pPad->bit.right) {
		pCursor->obj.pos.px += 3;
	}
	if (pPad->bit.up) {
		pCursor->obj.pos.py -= 3;
	}
	if (pPad->bit.down) {
		pCursor->obj.pos.py += 3;
	}

	// NbsO
	if (pCursor->obj.pos.px < 10) {
		pCursor->obj.pos.px = 10;
	}
	if (pCursor->obj.pos.py < 10) {
		pCursor->obj.pos.py = 10;
	}
	if (pCursor->obj.pos.px > 256-10) {
		pCursor->obj.pos.px = 256-10;
	}
	if (pCursor->obj.pos.py > 256-10) {
		pCursor->obj.pos.py = 256-10;
	}

	// -----< J[\ړŃACe肷 >-----
	//
	px = pCursor->obj.pos.px;
	py = pCursor->obj.pos.py;
	for (i = 0; i < 6; i++) {
		if (   (px >= item_area_x[i][0]) && (px <= item_area_x[i][1])
			&& (py >= item_area_y[i][0]) && (py <= item_area_y[i][1]) )
		{
			item_index = i;
			break;
		}
	}

	// ACRix}bNXj
	icon_disabled = 1;	// ~
	if (item_index >= 0) {
		switch (item_index) {
		case 0:
			if (p_application_context->lv_blade < 5) { icon_disabled = 0; }
			break;
		case 1:
			if (p_application_context->lv_magic < 5) { icon_disabled = 0; }
			break;
		case 2:
			if (p_application_context->lv_charge < 5) { icon_disabled = 0; }
			break;
		case 3:
			if (p_application_context->hp < 5) { icon_disabled = 0; }
			break;
		case 4:
			if (p_application_context->left < 9) { icon_disabled = 0; }
			break;
		case 5:
			icon_disabled = 0;
			break;
		default:
			break;
		}
	}

	// ACRiwρj
	switch (item_index) {
	case 0:
		if (p_application_context->lv_blade == 5) { icon_disabled = 1; }
		break;
	case 1:
		if (p_application_context->lv_magic == 5) { icon_disabled = 1; }
		break;
	case 2:
		if (p_application_context->lv_charge == 5) { icon_disabled = 1; }
		break;
	case 3:
		if (p_application_context->hp == 5) { icon_disabled = 1; }
		break;
	case 4:
		if (p_application_context->left >= 9) { icon_disabled = 1; }
		break;
	case 5:
		icon_disabled = 0;
		break;
	default:
		break;
	}
	if (item_index >= 0) {
		if (pCursor->sold[item_index]!=0) {
			icon_disabled = 1;
		}
	}

	// -----< cȂ΁~ >-----
	//
	wallet = digits_get_int(p_application_context->point, POINT_DIGITS);
	if ((item_index < 0) || (wallet < current_price[item_index])) {
		icon_disabled = 1;
	}

	// -----< ACRSPp^[] >-----
	//
	if (icon_disabled==0) {
		// ~Ȃ
		stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x74, sp_top + 0x10, 4);
	}
	else {
		// ~
		stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x78, sp_top + 0x10, 4);
	}

	// -----< gKNbNōws >-----
	// 
	if (p_input_parser->trg_main_clicked) {
		if ((item_index >= 0) && (icon_disabled == 0)) {
			// w\
			switch (item_index) {
			case 0:
				p_application_context->lv_blade += 1;
				pCursor->sold[item_index] = 1;
				break;
			case 1:
				p_application_context->lv_magic += 1;
				pCursor->sold[item_index] = 1;
				break;
			case 2:
				p_application_context->lv_charge += 1;
				pCursor->sold[item_index] = 1;
				break;
			case 3:
				p_application_context->hp += 1;
				pCursor->sold[item_index] = 1;
				break;
			case 4:
				p_application_context->left += 1;
				p_application_context->left_buy_count += 1;
				pCursor->sold[item_index] = 1;
				break;
			default:
				// EXIT
				p_stage_context->status = 4;
				break;
			}

			// z琔炷
			if ((item_index >= 0) && (item_index <= 4)) {
				wallet -= current_price[item_index];
				digits_set_int(wallet, p_application_context->point, POINT_DIGITS);
			}

			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursorok]));
		}
		else {
			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursorng]));
		}
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_close(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbvo
//--------------------------------------------------------------------
void shop_close(int status)
{
	// OtBbNʂXN[
	p_stage_context->mask_pos += MASK_SCROLL_SPEED;
	if (p_stage_context->mask_pos >= 512) {
		p_stage_context->mask_pos = 512;
	}

	// gWVI
	if (p_stage_context->mask_pos >= 512) {
		p_stage_context->mask_pos = 512;
		p_stage_context->status = 5;	// ̃Xe[^XɑJ
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_out(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		VbvɓƂ̊e؂ւ
//--------------------------------------------------------------------
void shop_out(int status)
{
	// OtBbN̏Ԃɖ߂
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;

	// eLXgpbg]
	stack_transfer_pal(p_stage_context->text_pal_slot, p_stage_context->text_pal_block, 0, 1);

	// eLXgXN[
	p_stage_context->scroll_txt();
	stage_scroll_bg();

	// BG̕\߂
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 1;

	// `揈1s
	// L
	jiki_stack_trans_sp(
		  &(p_stage_objects->jiki.obj)
		, &(p_stage_objects->blade.obj)
		, p_stage_objects->jiki.obj.frame_count);
	// u[h
	blade_stack_trans_sp(&(p_stage_objects->blade));
	stage_draw();

	// 
	p_stage_context->status = 6;	// ̃Xe[^XɑJ
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_exit(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		VbvoƂ̊e؂ւ
//--------------------------------------------------------------------
void shop_exit(int status)
{
	// OtBbNʂXN[
	p_stage_context->mask_pos -= MASK_SCROLL_SPEED;
	if (p_stage_context->mask_pos <= 0) {
		p_stage_context->mask_pos = 0;
	}

	// eLXg̃XN[ʒu߂
	p_memory_map_buffer->txt_scroll_unit.tx_x = shop_prev_text_px;
	p_memory_map_buffer->txt_scroll_unit.tx_y = shop_prev_text_py;

	// gWVI
	if (p_stage_context->mask_pos == 0) {
		p_stage_context->status = 7;	// ̃Xe[^XɑJ
		p_stage_context->stage_mode = STAGE_MODE_NORMAL;	// SHOPo

		// VbvouԂ͖Gɂ
		p_stage_objects->jiki.invincible = JIKI_SPECIAL_INVINCIBLE;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int shop_draw(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Xe[W1t[̕`揈
//--------------------------------------------------------------------
int shop_draw(int status) {
	int i;
	SP_UNIT* pSpUnit;
	OBJPOS* pCursorPos = &(p_stage_objects->shop_cursor.obj.pos);
	int offset;
	int current_price[6];
	int sp_top = p_stage_context->cmn_sp_top + 0x10;

	// <<< }XN𐧌 >>>
	stage_scroll_mask();

	// <<< SP`eSɏ >>>
	p_stage_objects->sp_index_seq = 0; // SP`̃R[hԍ

	// <<< Q[W`悷 >>>
	draw_frame_items();

	// 쒆łȂΔ
	if ((status != 2)
		&& (status != 3)
		) {
		return 0;
	}

	// -----< ` >-----
	//
	// <<<  >>>
	offset = 0;
	if (p_input_parser->trg_main_on_count) {
		offset = 4;
	}
	pSpUnit = &(p_memory_map_buffer->sp_unit[p_stage_objects->sp_index_seq]);
	SP_SET((pSpUnit + 0), pCursorPos->px + offset - 9 , pCursorPos->py + offset + 14, sp_top + 0, 5, 0, 0, 3);
	SP_SET((pSpUnit + 1), pCursorPos->px + offset + 16 -9, pCursorPos->py + offset + 14, sp_top + 1, 5, 0, 0, 3);
	SP_SET((pSpUnit + 2), pCursorPos->px + offset -9, pCursorPos->py + offset + 16 + 14, sp_top + 2, 5, 0, 0, 3);
	SP_SET((pSpUnit + 3), pCursorPos->px + offset + 16 -9, pCursorPos->py + offset + 16 + 14, sp_top + 3, 5, 0, 0, 3);
	p_stage_objects->sp_index_seq += 4;

	// <<< SOLD >>>
	for (i = 0; i < 5; i++) {
		int c;
		int x = item_area_x[i][0] + 55;
		int y = item_area_y[i][0] + 28;

		if (p_stage_objects->shop_cursor.sold[i] == 0) { continue; }
		for (c = 0; c < 4; c++) {
			pSpUnit = &(p_memory_map_buffer->sp_unit[p_stage_objects->sp_index_seq++]);
			SP_SET(pSpUnit, x + (c*16), y, sp_top + 4 + c, 5, 0, 0, 3);
		}
	}

	// -----< |Cg` >-----
	//
	set_price(current_price);
	// u[h
	draw_digits(p_application_context->lv_blade + 1, 51, 106);
	draw_digits(current_price[0], 106, 106);

	// @
	draw_digits(p_application_context->lv_magic + 1, 171, 106);
	draw_digits(current_price[1], 225, 106);

	// Xs[h
	draw_digits(p_application_context->lv_charge + 1, 51, 170);
	draw_digits(current_price[2], 106, 170);

	// 
	draw_digits(1, 147, 170);
	draw_digits(current_price[3], 225, 170);

	// 1UP
	draw_digits(1, 28, 234);
	draw_digits(current_price[4], 106, 234);

	// -----< SP̎c̈ >-----
	//
	pSpUnit = p_memory_map_buffer->sp_unit;
	pSpUnit += p_stage_objects->sp_index_seq;
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		pSpUnit->x = 0;
		pSpUnit->y = 0;
		// ̃jbgɐi
		pSpUnit++;
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void set_price(int* price_array)
//
//	[  ]
//		int* price_array	ݒ̔zւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		zɉiݒ
//--------------------------------------------------------------------
void set_price(int* price_array)
{
	int game_level = p_game_properties->game_level;
	int left_index = p_application_context->left_buy_count;
	if (left_index > 5) { left_index = 5; }

	price_array[0] = price[game_level][0][p_application_context->lv_blade];	// u[h
	price_array[1] = price[game_level][1][p_application_context->lv_magic];	// @
	price_array[2] = price[game_level][2][p_application_context->lv_charge];	// `[W
	price_array[3] = price[game_level][3][p_application_context->hp];	// HP
	price_array[4] = price[game_level][4][left_index];	// LIFE
	price_array[5] = 0;	// EXIT
}
