#define __MAGIC_C__
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "magic.h"
#include "stage.h"
#include "esp.h"

//=========================================
// 萔`
//=========================================
// Ƃ̐eIuWFNg̈ړx
#define MAGIC_VELOCITY (12<<8)
int magic_velocity_x[10] = {0, -MAGIC_VELOCITY , 0, MAGIC_VELOCITY , -MAGIC_VELOCITY , 0, MAGIC_VELOCITY , -MAGIC_VELOCITY , 0, MAGIC_VELOCITY };
int magic_velocity_y[10] = {0, MAGIC_VELOCITY , MAGIC_VELOCITY , MAGIC_VELOCITY , 0,0,0,-MAGIC_VELOCITY ,-MAGIC_VELOCITY ,-MAGIC_VELOCITY };

// qIuWFNg̔a
int burret_radius_index[2][8] = {
      {4, 4, 5, 5, 3, 3, 6, 6}
	, {1, 1, 2, 2, 0, 0, 3, 3}
};
int burret_velocity[2][8] = {
      { 8,  8,  -8,  -8,  8,  8,  -8,  -8}
    , {12, 12, -12, -12, 12, 12, -12, -12}
};

// З
int magic_ap[6] = MAGIC_AP;

//=========================================
// vg^Cv錾
//=========================================
void magic_move(void* pTarget);	// ړ֐ւ̃|C^
void magic_draw(void* pTarget);	// `֐ւ̃|C^
//
void control_burrets(MAGIC* pTarget);
//
void magic_normal_transition(MAGIC* pTarget);
void magic_normal_move(MAGIC* pTarget);
//
void magic_charge_transition(MAGIC* pTarget);
void magic_charge_move(MAGIC* pTarget);
//
void magic_on_magic_transition(MAGIC* pTarget);
void magic_on_magic_move(MAGIC* pTarget);
//
void magic_on_return_transition(MAGIC* pTarget);
void magic_on_return_move(MAGIC* pTarget);
//
void burret_init(MAGIC* pMagic, MAGIC_BURRET* pBurret, int index, int theta, int radius, int omega);
void burret_move(void* pTarget);	// ړ֐ւ̃|C^
void burret_draw(void* pTarget);	// `֐ւ̃|C^
void burret_draw_round(void* pTarget, int palet_gray);  // ]
void burret_draw_attack_small(void* pTarget, int palet_gray);  // U
void burret_draw_attack_big(void* pTarget);  // U

//=============================================================================
// @
//=============================================================================
void magic_init(void* pTarget)
{
    MAGIC* pMagic = pTarget;
    JIKI* pJiki = &(p_stage_objects->jiki);

    // @s݂牽Ȃ
    if (pJiki->obj.status == status_absent) {
        return;
    }

    // NA
    memset(pMagic, 0, sizeof(MAGIC));

    // ʒu͎LƓ
    pMagic->obj.pos = pJiki->obj.pos;

    // ֐ݒ
    pMagic->obj.move = magic_move;
    pMagic->obj.draw = magic_draw;

    // Ԃݒ
    pMagic->obj.status = status_normal;

    // ^[Qbgʒuݒ肷
    burret_init(pMagic, &(pMagic->child[0]), 0,   0, burret_radius_index[0][0] , burret_velocity[0][0]);
    burret_init(pMagic, &(pMagic->child[1]), 1, 256, burret_radius_index[0][1] , burret_velocity[0][1]);
    burret_init(pMagic, &(pMagic->child[2]), 2,   0, burret_radius_index[0][2] , burret_velocity[0][2]);
    burret_init(pMagic, &(pMagic->child[3]), 3, 256, burret_radius_index[0][3] , burret_velocity[0][3]);
    //
    burret_init(pMagic, &(pMagic->child[4]), 4, 128, burret_radius_index[0][4] , burret_velocity[0][4]);
    burret_init(pMagic, &(pMagic->child[5]), 5, 374, burret_radius_index[0][5] , burret_velocity[0][5]);
    burret_init(pMagic, &(pMagic->child[6]), 6, 128, burret_radius_index[0][6] , burret_velocity[0][6]);
    burret_init(pMagic, &(pMagic->child[7]), 7, 374, burret_radius_index[0][7] , burret_velocity[0][7]);

    // ݒ肷
    pMagic->ap = magic_ap[p_application_context->lv_magic];

    // 蔻͈̔͂ݒ肷
    pMagic->obj.hit_bbox.x0 = 0;
    pMagic->obj.hit_bbox.x1 = 0;
    pMagic->obj.hit_bbox.y0 = 0;
    pMagic->obj.hit_bbox.y1 = 0;

    // I
    return;
}

//=============================================================================
// obg
//=============================================================================
void burret_init(MAGIC* pMagic, MAGIC_BURRET* pBurret, int index, int theta, int radius, int omega)
{
    // NA
    memset(pBurret, 0, sizeof(MAGIC_BURRET));

    // aCpxvx, vyɓ
    pBurret->target.vx = radius;
    pBurret->target.vy = theta;

    // pxayɓ
    pBurret->target.ax = 0;
    pBurret->target.ay = omega;

    // WݒFe𒆐SƂʒuݒ肷
    theta = pBurret->obj.frame_count & VARY_TABLE_MASK;
    pBurret->target.hx = pMagic->obj.pos.hx + ((precos[radius][theta]));
    pBurret->target.hy = pMagic->obj.pos.hy + ((presin[radius][theta]));
    pBurret->target.px = pBurret->target.hx >> 8;
    pBurret->target.py = pBurret->target.hy >> 8;

    // Xe[^Xݒ
    pBurret->obj.status = status_normal;
    pBurret->obj.array_index = index;
    pBurret->obj.pos = pMagic->obj.pos; // ʒu͐eIuWFNg̈ʒu𕡐

    // ֐ݒ
    pBurret->obj.move = burret_move;
    pBurret->obj.draw = burret_draw;

    // I
    return;
}


//=============================================================================
// @̈ړ
//=============================================================================
void magic_move(void* pTarget)
{
    MAGIC* pMagic = pTarget;
    CHROBJ* pObj = &(pMagic->obj);
    ObjStatus prev_status = pObj->status;

    // -----< U͐ݒ >-----
    //
    pMagic->ap = magic_ap[p_application_context->lv_magic];

    // -----< ͏Ԃp[X >-----
    //
    switch (pObj->status) {
    case status_absent:
        // ŝ݂Ƃ͉Ȃ
        break;

    case status_charge:
        // ߒ
        magic_charge_transition(pMagic);
        break;

    case status_on_magic:
        // @
        magic_on_magic_transition(pMagic);
        break;

    case status_on_return:
        // @߂蒆
        magic_on_return_transition(pMagic);
        break;

    default:
        // 쒆̒ʏpMagic
        magic_normal_transition(pMagic);
        break;
    }

    // ԂωAt[JEg
    if (prev_status != pObj->status) {
        pObj->frame_count = 0;
    }

    // -----< ړ >-----
    //
    switch (pObj->status) {
    case status_absent:
        // ŝ݂Ƃ͉Ȃ
        break;

    case status_charge:
        // ߒ
        magic_charge_move(pMagic);
        break;

    case status_on_magic:
        // @
        magic_on_magic_move(pMagic);
        break;

    case status_on_return:
        // @߂蒆
        magic_on_return_move(pMagic);
        break;

    default:
        // 쒆̒ʏ̏
        magic_normal_move(pMagic);
        break;
    }
}

//=============================================================================
// @̕`揈
//=============================================================================
void magic_draw(void* pTarget)
{
    int i;
    MAGIC* pMagic = pTarget;
    MAGIC_BURRET* pBurret;

    if (pMagic->obj.status == status_absent) {
        return;
    }

    // qIuWFNg𐧌䂷
    pBurret = pMagic->child;
    for (i = 0; i < 8; i++) {
        if (pBurret->obj.status == status_absent) { continue; }

        pMagic->child[i].obj.draw(pBurret);
        pBurret++;
    }
    return;
}


//=============================================================================
// qIuWFNg𐧌䂷
//=============================================================================
void control_burrets(MAGIC* pMagic)
{
    int i;
    MAGIC_BURRET* pBurret;
    OBJPOS* pBurretPos;

    pBurret = pMagic->child;
    for (i = 0; i < 8; i++) {
        if (pBurret->obj.status == status_absent) { continue; }
        // ړ
        pMagic->child[i].obj.move(pBurret);

        // XVI[h̏ꍇAESPo
        if (startup_param.XVI) {
            if ((pMagic->obj.status == status_on_magic) || (pMagic->obj.status == status_on_return)) {
                if ((vrand() & 7) == 0) {
                    pBurretPos = &(pMagic->child[i].obj.pos);
                    appear_esp_rnd(esptype_blueexp, pBurretPos->hx, pBurretPos->hy, 3);
                }
            }
        }

        // 
        pBurret++;
    }
}


//=============================================================================
// @̈ړFʏ
//=============================================================================
void magic_normal_transition(MAGIC* pMagic)
{
    int i;
    ObjStatus jiki_status = p_stage_objects->jiki.obj.status;

    if (jiki_status == status_charge) {
        // LߒȂA@ߒɑJ
        pMagic->obj.status = status_charge;

        // aƊpxĐݒ
        for (i = 0; i < 8; i++) {
            pMagic->child[i].target.vx = burret_radius_index[1][i];
            pMagic->child[i].target.ay = burret_velocity[1][i];
        }
    }

    // qbgXgbvready
    pMagic->obj.hit_stop_ready = 1;
}


//=============================================================================
// @̈ړFʏ
//=============================================================================
void magic_normal_move(MAGIC* pMagic)
{
    CHROBJ* pObj = &(pMagic->obj);
    OBJPOS* pPos = &(pObj->pos);
    OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

    // LƓꏊɈړ
    pPos->vx = pJikiPos->vx;
    pPos->vy = pJikiPos->vy;
    pPos->hx = pJikiPos->hx;
    pPos->hy = pJikiPos->hy;
    pPos->px = pPos->hx >> 8;
    pPos->py = pPos->hy >> 8;

    // qIuWFNg𐧌䂷
    control_burrets(pMagic);

    // JEgi߂
    pObj->frame_count += 1;

    return;
}


//=============================================================================
// @̏ԑJځFߒ
//=============================================================================
void magic_charge_transition(MAGIC* pMagic)
{
    int i;
    // L̏ԂߒOꂽ߂
    if (p_stage_objects->jiki.obj.status != status_charge) {
        pMagic->obj.status = status_normal;

        // aƊpxĐݒ
        for (i = 0; i < 8; i++) {
            pMagic->child[i].target.vx = burret_radius_index[0][i];
            pMagic->child[i].target.ay = burret_velocity[0][i];
        }
    }

    // Wv{^ꂽ甭ɂBMPȂꍇ͔ȂB
    if ((p_input_parser->trg_sub_clicked) && (p_application_context->mp >= MP_MAGIC)) {
        int dir;

        // MP
        p_application_context->mp -= MP_MAGIC;
        if (p_application_context->mp < 0) {
            p_application_context->mp = 0;
        }

        // x^
        dir = p_input_parser->direction_id;
        if (dir == 5 || dir == 0) {
            if (p_stage_objects->jiki.obj.direction == dir_left) { dir = 4; }
            else { dir = 6; }
        }
        pMagic->obj.pos.vx = magic_velocity_x[dir];
        pMagic->obj.pos.vy = magic_velocity_y[dir];

        // aƊpxĐݒ
        for (i = 0; i < 8; i++) {
            pMagic->child[i].target.vx = burret_radius_index[0][i];
            pMagic->child[i].target.ay = burret_velocity[1][i];
        }

        // ԒlύX
        pMagic->obj.status = status_on_magic;

        // ʉ
        play_se(&(p_sound_context->se_item[setype_magic]));
    }
}

//=============================================================================
// @̈ړFߒ
//=============================================================================
void magic_charge_move(MAGIC* pMagic)
{
    // GtFNgXp
    if (pMagic->obj.effect_span > 0) {
        pMagic->obj.effect_span -= 1;
    }

    // ʏƓ
    magic_normal_move(pMagic);
}

//=============================================================================
// @̏ԑJڏF@
//=============================================================================
void magic_on_magic_transition(MAGIC* pMagic)
{
    int i;

    // t[o߂ŏԑJ
    if (pMagic->obj.frame_count > MAGIC_FRAMES) {
        pMagic->obj.status = status_on_return;


        // aƊpxĐݒ
        for (i = 0; i < 8; i++) {
            pMagic->child[i].target.vx = burret_radius_index[0][i];
            pMagic->child[i].target.ay = burret_velocity[0][i];
        }
    }
}


//=============================================================================
// @̈ړF@
//=============================================================================
void magic_on_magic_move(MAGIC* pMagic)
{
    OBJPOS* pPos = &(pMagic->obj.pos);
    int current_sx, current_sy;

    // ݂̉ʏ̕\ʒumF
    current_sx = ((pPos->hx + pPos->vx) - p_stage_context->bgview_hx) >> 8;
    current_sy = ((pPos->hy + pPos->vy) - p_stage_context->bgview_hy) >> 8;

    // ʂ̊OɐHłꍇ͓~߂
    if ((current_sx < 0) || (current_sy < 0) || (current_sx > 255) || (current_sy > 255)) {
        // Nothing to do.
    }
    else {
        // ړ
        pPos->hx += pPos->vx;
        pPos->hy += pPos->vy;
        pPos->px = pPos->hx >> 8;
        pPos->py = pPos->hy >> 8;
    }

    // t[JEgXV
    pMagic->obj.frame_count += 1;

    // qIuWFNg𐧌
    control_burrets(pMagic);
}


//=============================================================================
// @̈ړF@߂蒆
//=============================================================================
void magic_on_return_transition(MAGIC* pMagic)
{
    // t[o߂ŏԑJ
    if (pMagic->obj.frame_count > MAGIC_RETURN) {
        pMagic->obj.status = status_normal;
    }
}


//=============================================================================
// @̏ԑJڏF@
//=============================================================================
void magic_on_return_move(MAGIC* pMagic)
{
    CHROBJ* pObj = &(pMagic->obj);
    OBJPOS* pPos = &(pObj->pos);
    OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

    // LƓꏊɈړ
    pPos->vx = (pJikiPos->hx - pPos->hx) >> 3;
    pPos->vy = (pJikiPos->hy - pPos->hy) >> 3;
    pPos->hx += pPos->vx;
    pPos->hy += pPos->vy;
    pPos->px = pPos->hx >> 8;
    pPos->py = pPos->hy >> 8;

    // qIuWFNg𐧌䂷
    control_burrets(pMagic);

    // JEgi߂
    pObj->frame_count += 1;
}


//=============================================================================
// @ëړ
//=============================================================================
void burret_move(void* pTarget)
{
    MAGIC_BURRET* pBurret = pTarget;
    int radius, theta;
    OBJPOS* pTargetPos = &(pBurret->target);
    OBJPOS* pParentPos = &(p_stage_objects->magic.obj.pos); // @eIuWFNg
    int omega;

    // _bVłȂقMPȂHP0̂Ƃɂ͓x
    omega = pTargetPos->ay;
    if ((p_application_context->mp < MP_DASH)   // MP
        || (p_application_context->hp==0)   // HP
        ) {
        omega >>= 1;
    }

    // <<< ^[QbgʒuvZ >>>
    // aƊpxvZ
    radius = pTargetPos->vx;
    theta = pTargetPos->vy;
    theta += omega;   // px
    theta &= VARY_TABLE_MASK;
    pTargetPos->vx = radius;
    pTargetPos->vy = theta;

    // WݒFL𒆐SƂʒuݒ肷
    pTargetPos->hx = pParentPos->hx + ((precos[radius][theta]));
    pTargetPos->hy = pParentPos->hy + ((presin[radius][theta]));
    pTargetPos->px = pTargetPos->hx >> 8;
    pTargetPos->py = pTargetPos->hy >> 8;

    // <<< IuWFNg̈ʒu肷 >>>
    {
        OBJPOS* pPos = &(pBurret->obj.pos);
        int dx, dy;
        dx = pTargetPos->hx - pPos->hx;
        dy = pTargetPos->hy - pPos->hy;
        pPos->vx = (dx >> 2);
        pPos->vy = (dy >> 2);
        pPos->hx += pPos->vx;
        pPos->hy += pPos->vy;
        pPos->px = pPos->hx >> 8;
        pPos->py = pPos->hy >> 8;
    }

    // JEgi߂
    pBurret->obj.frame_count += 1;
}

//=============================================================================
// @e̕`揈
//=============================================================================
void burret_draw(void* pTarget)
{
    MAGIC_BURRET* pBurret = pTarget;
    int lv = p_application_context->lv_magic;
    int index = pBurret->obj.array_index;
    ObjStatus status = p_stage_objects->magic.obj.status;
    int type;

    // <<< ]͂̂悤ɂ >>>
    if (status != status_on_magic) {
        int palet_gray = (p_application_context->mp < MP_MAGIC);
        burret_draw_round(pTarget, palet_gray);
        return;
    }

    // <<< @˒ >>>
    type = 0;   // 0:small, 1:big
    // \𔻒肷
    switch (lv) {
    case 0:
    case 1:
    case 2:
    case 3:
        break;
    case 4:
        if (index < 4) { type = 1; }    // 
        break;
    case 5:
        type = 1;
        break;
    }


    if (type == 0) {
        burret_draw_attack_small(pTarget, 0);
    }
    else {
        burret_draw_attack_big(pTarget);
    }
}

// `]
void burret_draw_round(void* pTarget, int palet_gray)
{
    MAGIC_BURRET* pBurret = pTarget;
    OBJPOS* pPos;
    SP_UNIT* sp;
    int hx, hy, px, py;
    int sp_index;
    //
    int pattern_offset;
    int hrev_offset;
    //
    int pal_block = 6;
    // ẽCfbNX
    int index = pBurret->obj.array_index;
    int lv = p_application_context->lv_magic;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x24;

    // <<< \𔻒肷 >>>
    switch(lv) {
    case 0:
        if (index >= 2) { return; } // Ԃ2
        break;
    case 1:
        if (index >= 4) { return; } // 4
        break;
    case 2:
        if (index >= 6) { return; } // 6
        break;
    case 3:
        break;
    case 4:
        if (index < 4) { pal_block = 7; }    // 
        break;
    case 5:
        pal_block = 7;    // 
        break;
    }

    // O[\
    if(palet_gray) {
        pal_block = 8;
    }

    // <<< ` >>>
    // ʒu
    pPos = &(pBurret->obj.pos);

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // LN^
    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        // ől𒴂Ă
        kon_log_single(SIGLE_REPORT_LOGCODE_COUNT, "draw_blade : SP̍ől𒴂܂B\n");
        return;
    }
    p_stage_objects->sp_index_seq++;

    // p^[̃CfbNX𓱏o
    pattern_offset = (p_stage_objects->frame_count >> 2) & 1;

    // ]Ԃ𓱏o
    hrev_offset = (p_stage_objects->frame_count >> 3) & 1;

    // }bvobt@Ƀf[^i[
    sp = (SP_UNIT*)(&(p_memory_map_buffer->sp_unit[sp_index]));
    SP_SET(sp, px + 8, py + 8, sp_code_top + pattern_offset, pal_block, hrev_offset, 0, 3);
    sp++;
}

// `ij
void burret_draw_attack_small(void* pTarget, int palet_gray)
{
    burret_draw_round(pTarget, palet_gray);
}

// `ij
void burret_draw_attack_big(void* pTarget)
{
    MAGIC_BURRET* pBurret = pTarget;
    OBJPOS* pPos;
    SP_UNIT* sp;
    int hx, hy, px, py;
    int sp_index;
    int allocsp;
    //
    int pattern_offset;
    int hrev_offset;
    //
    int pal_block = 6;

    // ẽCfbNX
    int index = pBurret->obj.array_index;
    int lv = p_application_context->lv_magic;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x26;

    // <<< \𔻒肷 >>>
    switch (lv) {
    case 0:
        if (index >= 2) { return; } // Ԃ2
        break;
    case 1:
        if (index >= 4) { return; } // 4
        break;
    case 2:
        if (index >= 6) { return; } // 6
        break;
    case 3:
        break;
    case 4:
        if (index < 4) { pal_block = 7; }    // 
        break;
    case 5:
        pal_block = 7;    // 
        break;
    }

    // <<< ` >>>
    pPos = &(pBurret->obj.pos);

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(2);
    if (allocsp < 2) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // p^[̃CfbNX𓱏o
    pattern_offset = ((p_stage_objects->frame_count >> 2) & 1) << 1;

    // ]Ԃ𓱏o
    hrev_offset = (p_stage_objects->frame_count >> 3) & 1;

    // }bvobt@Ƀf[^i[
    SP_SET(sp, px + 8, py - 16, sp_code_top + pattern_offset, pal_block, hrev_offset, 0, 3);
    sp++;
    SP_SET(sp, px + 8, py , sp_code_top + 1 + pattern_offset, pal_block, hrev_offset, 0, 3);
    sp++;
}
