#define __KONCORE_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "../devs/devs.h"

#include "constants.h"
#include "game_context.h"
#include "koncore.h"
#include "kon_util.h"
#include "game.h"
#include "stage.h"

// -----< vg^Cv錾 >-----
//
int initialize_game_context();  // game_context
int release_game_context();     // game_context
int check_param_int(int i, int argc, char* argv[], char* opt, int min, int max);    // p[^荞

//--------------------------------------------------------------------
//	[  ]
//		int parse_parameters(int argc, char* argv[], int XVI_default, int default_game_level)
//
//	[  ]
//		int argc                Cmain֐argĉ܂܃pX
//      char* argv[]            Cmain֐argv̂܂܃pX
//      int XVI_default         w肪ꍇXVI[h̃ftHgl
//      int default_game_level  ftHg̃Q[x
//
//	[ ߂l ]
//		F0
//      o[W\ďIF1
//
//	[  ]
//		s͂āAstartup_param\́iO[oϐj
//      ɔf܂B
//      o[Wԍ\wꍇ́A\
//      1Ԃ܂B
//      sȃp[^wȂǂɂẮAstartup_param.parse_result
//       startup_param.error_message ɂ̎|i[A֐
//      ߂l͐ŕԂ܂B
//--------------------------------------------------------------------
int parse_parameters(int argc, char* argv[], int XVI_default, int default_game_level)
{
    int i;
    int int_value = 0;
    int return_value = 0;
    int param_handled = 0;
    // f[^i[̈
    memset(&startup_param, 0, sizeof(STARTUP_PARAM));

    // ftHglݒ肷
    startup_param.start_stage = START_STAGE;  // JnXe[W
    startup_param.start_lv = STARTLV_BLADE;   // Jnx
    startup_param.XVI = XVI_default;          // XVI[h
    startup_param.default_game_level = default_game_level;
    //
    startup_param.skip_title = 0;               // ^CgXLbv
    startup_param.skip_intermission = 0;        // C^[~bVXLbv

    // p[^
    for (i = 0; i < argc; i++)
    {
        // p[^XLbv
        if (param_handled) {
            param_handled = 0;
            continue;
        }

        // o[W\
        if (strcmp("-v", argv[i]) == 0) {
            // o[W\
            return_value = 1;
            break;
        }

        // wv\
        if (strcmp("-h", argv[i]) == 0) {
            // wv\
            return_value = 2;
            break;
        }

        // JnXe[Ww
        if(strcmp("-s", argv[i])==0) {
            startup_param.start_stage = check_param_int(i, argc, argv, "-s", 1, 6);
            if(startup_param.parse_result!=0) { break; }
            param_handled = 1;
            continue;
        }

        // xw
        if(strcmp("-lv", argv[i])==0) {
            startup_param.start_lv = check_param_int(i, argc, argv, "-lv", 0, 5);
            if(startup_param.parse_result!=0) { break; }
            param_handled = 1;
            continue;
        }

        // XVI
        if(strcmp("-xvi", argv[i])==0) {
            startup_param.XVI = 1;
            continue;
        }

        // ftHg̃Q[xw
        if (strcmp("-gl", argv[i]) == 0) {
            startup_param.default_game_level = check_param_int(i, argc, argv, "-gl", 0, 3);
            if (startup_param.parse_result != 0) { break; }
            param_handled = 1;
            continue;
        }

        // ^CgXLbv
        if (strcmp("-st", argv[i]) == 0) {
            startup_param.skip_title = 1;
            continue;
        }

        // C^[~bVXLbv
        if (strcmp("-si", argv[i]) == 0) {
            startup_param.skip_intermission = 1;
            continue;
        }

        // ɊԂɍȂƂ̃}[N\IvV
        if (strcmp("-vd", argv[i]) == 0) {
            startup_param.display_vd_wait_skipped = 1;
            continue;
        }

        // TEhOFF
        if (strcmp("-ds", argv[i]) == 0) {
            startup_param.disable_sound = 1;
            continue;
        }

        // XRAOL^
        if (strcmp("-rs", argv[i]) == 0) {
            startup_param.record_score_log = 1;
            continue;
        }

        // ܂ŗĂ܂A͖m̃p[^w
        startup_param.parse_result = 4; // m̃p[^
		sprintf(startup_param.error_message, startup_error_message[startup_param.parse_result], argv[i]);
        return -1;
    }

    // 
    return return_value;
}

//====================================================================
// wvԂ
//====================================================================
char* get_usage_string()
{
    char* result =
        "[OPTION]\n"
        "-h         : wv\ďI\n"
        "-v         : o[W\ďI\n"
        "-s [1`6]  : JnXe[Ww肷\n"
        "-lv [0`5] : Jñp[Abvxw肷\n"
        "-gl [0`3] : NɃQ[x 0:EASY, 1:NOVICE, 2:NORMAL, 3:HARD\n"
        "-xvi       : XVI[hɐݒ肷\n"
        "-st        : ^CgXLbv\n"
        "-si        : C^[~bVXLbv\n"
        "-vd        : ɊԂɍȂƂ̃}[N\\n"
        "-ds        : 炳Ȃ\n"
        "-rs        : XRAOL^iWindows onlyj\n"
        "\n"
        "-s, -lv w肳ꂽꍇASNAÕXRA0ɂȂ܂B\n"
        "\n";

    return result;
}

//--------------------------------------------------------------------
//	[  ]
//		int check_param_int(int i, int argc, char* argv[], char* opt, int min, int max)
//
//	[  ]
//		int i           `FbNCfbNX
//      int argc        R}hC̐
//      char* argv[]    R}hC̒l
//      char* opt       IvVwq
//      int min         ŏlBƃG[
//      int max         őlBƃG[
//
//	[ ߂l ]
//		ϊl
//
//	[  ]
//		l^IvVw̃`FbNƕϊs܂
//      G[̏ꍇ́Astartup_param result0ȊOɂȂAerror_message
//      bZ[Wi[܂B
//--------------------------------------------------------------------
int check_param_int(int i, int argc, char* argv[], char* opt, int min, int max) {
    int result = 0;

    // p[^̒lw肳ĂȂ΃G[
    if ((i + 1) >= argc)
    {
        startup_param.parse_result = 1; // p[^s
        sprintf(
            startup_param.error_message
            , startup_error_message[startup_param.parse_result]
            , opt
        );
        return startup_param.parse_result;
    }

    // p[^𓾂
    result = atoi(argv[i + 1]);
    /*
    if (errno != 0)
    {
        // ϊG[
        startup_param.parse_result = 2; // ϊG[
        sprintf(
            startup_param.error_message
            , startup_error_message[startup_param.parse_result]
            , opt, argv[i+1]
        );
        return startup_param.parse_result;
    }
    */

    // ͈̓`FbNG[
    if (result < min || (result > max))
    {
        // ͈̓I[o[
        startup_param.parse_result = 3; // ͈͊O
        sprintf(
            startup_param.error_message
            , startup_error_message[startup_param.parse_result]
            , min, max, opt, result
        );
        return startup_param.parse_result;
    }

    // 
    startup_param.parse_result = 0;
    memset(startup_param.error_message, 0, sizeof(startup_param.error_message));
    return result;
}

//--------------------------------------------------------------------
//	[  ]
//		int koncore()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF-1
//
//	[  ]
//		Q[̃C
//--------------------------------------------------------------------
int koncore() {
    int result;

    // O
    result = open_kon_log("kon_core.log");
    if (result != 0) {
        printf("kon_logJ܂łB");
        return -1;
    }
    //kon_log("koncore : start.\n");

    // ReLXg
    initialize_game_context();

    // VXe
    result = system_startup();
    if(result!=0) {
        system_dispose();
        kon_log("VXȅɃG[܂B\n");
        return result;
    }

    // ʏiŚj
    result = screen_startup();
    if (result != 0) {
        screen_dispose();
        kon_log("XN[̏Ɏs܂B\n");
        return result;
    }

    // Q[s
    result = game();
    if (result != 0) {
        kon_log("Q[̏ŃG[܂B\n");
    }

    // I
    result = screen_dispose();
    if (result != 0) {
        kon_log("ʂ̏IɃG[܂B\n");
    }

    result = system_dispose();
    if (result != 0) {
        kon_log("VXȅIɃG[܂B");
    }

    // O
    //kon_log("koncore : Finish.\n");
    result = close_kon_log();
    if (result != 0) {
        printf("koncore : ÕN[YɎs܂B\n");
    }
    if (startup_param.record_score_log) {
        close_score_log();
    }

    // ReLXg
    release_game_context();

    // I
    return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int initialize_game_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Q[Ɋւݒ̏s܂B
//--------------------------------------------------------------------
int initialize_game_context() {
    int i, c, d;
    GAME_PROPERTIES* pProp = &(game_context.game_properties);

    // ^Op֐e[u
    init_precos_presin();

    // ReLXgŜ0ŏ
    memset(&game_context, 0, sizeof(game_context));
    memset(&resource_conf, 0, sizeof(RESOURCE_CONF));

    // Properties̏
    {
        // }Vxݒ
        pProp->XVI = startup_param.XVI;

        // 1t[ŏłSP, PALp^[̍őZbg
        pProp->transsp_max_per_frame = 12;
        pProp->transpal_max_per_frame = 8;

        // ̍Đ֎~XCb`iJAזȎɐݒ肷j
        pProp->disable_sound = startup_param.disable_sound;

        // gKA/BւXCb`
        pProp->reverse_trigger = 0;

        // Փx
        pProp->game_level = startup_param.default_game_level;

        // c@
        pProp->life = LEFT_DEFAULT;

        // gK]tO
        pProp->reverse_trigger = 0; // ʏ
    }

    // BG`̈̃screen.c/screen.cppŏ
    game_context.memory_map_buffer.bg_def[0] = NULL;
    game_context.memory_map_buffer.bg_def[1] = NULL;

    // SP, BG̃p^[obt@m
    game_context.memory_map_buffer.transsp = (TRANSSP_UNIT*)(calloc(pProp->transsp_max_per_frame, sizeof(TRANSSP_UNIT)));
    game_context.memory_map_buffer.transpal = (TRANSPAL_UNIT*)(calloc(pProp->transpal_max_per_frame, sizeof(TRANSSP_UNIT)));

    // Xe[WLq GJEg
    for (i = 0; i < MAX_STAGE; i++) {
        for(c=0;c<MAX_SECTION;c++) {
            for (d = 0; d < STAGE_DESC_LINES; d++) {
                int remain = 0;
                int type;
                STAGE_DESC* pStageDesc = &(def_stage_section_enemy_desc[i][c][d]);

                // G𐔂
                for (type = 0; type < enetype_count; type++) {
                    STAGE_ENEMY_DESC* pEneDesc = &(pStageDesc->stage_enemy_desc[type]);
                    if (pEneDesc->type == enetype_dummy) { continue; }
                    remain += pEneDesc->remains;
                }

                // ݒ
                pStageDesc->enemy_remain = remain;
            }
        }
    }

    // rfIRg[̐ݒ
    // ON/OFF̐ݒ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs4 = 1;
    p_memory_map_buffer->vc_onoff.bit.son = 1;
    p_memory_map_buffer->vc_onoff.bit.ton = 1;

    // ʂ̃vCIeBݒ肷
    p_memory_map_buffer->vc_priority.bit.sp = 1;      // XvCg̓eLXgƃOtBbN̊
    p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
    p_memory_map_buffer->vc_priority.bit.grp = 0;     // OtBbNO
    p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
    p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
    p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
    p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

    return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int release_game_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Q[Ɋւݒ̉s܂B
//--------------------------------------------------------------------
int release_game_context() {
    // SP, BG̃p^[obt@
    free(game_context.memory_map_buffer.transsp);
    free(game_context.memory_map_buffer.transpal);

    // ReLXgŜ0ŏ
    memset(&game_context, 0, sizeof(game_context));

    return 0;
}
