#define __KON_UTIL_C__
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "../devs/devs.h"
#include "kon_util.h"

// -----< O[oϐ̐錾 >-----
//
FILE* kon_log_fn = NULL;

// Ŝ1񂵂o͂ȂȌo͍ϊǗ
int single_log_reported[SIGLE_REPORT_LOGCODE_COUNT];

//--------------------------------------------------------------------
//	[  ]
//		int open_kon_log(const char* log_filename)
//
//	[  ]
//		const char* log_filename	Ot@C
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Ot@C̏o͏s܂B
//--------------------------------------------------------------------
int open_kon_log(const char* log_filename) {
	// SINGLE REPORTNA
	memset(single_log_reported, 0, sizeof(single_log_reported));

	// t@CɊJĂꍇ́AU
	if (kon_log_fn != NULL) {
		fclose(kon_log_fn);
	}

	// t@CJ
	kon_log_fn = fopen(log_filename, "wt");
	if (kon_log_fn == NULL) {
		printf("open_kon_log : t@CJ܂łB[%s]\n", log_filename);
		return -1;
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int close_kon_log()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Ot@C܂
//--------------------------------------------------------------------
int close_kon_log() {
	if (kon_log_fn != NULL) {
		fclose(kon_log_fn);
	}
	kon_log_fn = NULL;
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void kon_log(const char* pMes , ... )
//
//	[  ]
//		const char* pMes	ObZ[W
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RÃOo͂܂B
//		o͐́AvbgtH[rh̏ɂقȂ܂B
//--------------------------------------------------------------------
void kon_log(const char* pMes , ... ) {
	va_list marker;

	// OI[vĂȂꍇ́Â܂ܕԂ
	if (kon_log_fn == NULL) {
		return;
	}

	// Oo͂
	va_start( marker , pMes );

	vfprintf(kon_log_fn, pMes, marker);

	va_end( marker );
	fflush(kon_log_fn);
}

//--------------------------------------------------------------------
//	[  ]
//		void kon_log_single(int code, const char* pMes, ...)
//
//	[  ]
//		int code			OR[h
//		const char* pMes	ObZ[W
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RÃOo͂܂B
//		w肵codeɑΉ郍Ȍo͂ŁAs1񂾂o͂A
//		2ڈȍ~͏o͂𖳎܂B
//		Oɂ SINGLE_LOG_CODE Œ`Ălw肵܂B
//		o͐́AvbgtH[rh̏ɂقȂ܂B
//--------------------------------------------------------------------
void kon_log_single(int code, const char* pMes, ...)
{
	va_list marker;

	// Oo͍ϊmF
	if (single_log_reported[code] != 0) {
		// ɃOo͍ςȂ̂Ŗ
		return;
	}
	single_log_reported[code] = 1;

	// OI[vĂȂꍇ́Â܂ܕԂ
	if (kon_log_fn == NULL) {
		return;
	}

	// Oo͂
	va_start(marker, pMes);

	vfprintf(kon_log_fn, pMes, marker);

	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void initialize_id_stack(int* stack, int* stack_ptr_ptr, int stack_size)
//
//	[  ]
//		int stack*	X^bNzւ̃|C^
//		int stack_ptr_ptr	X^bN|C^ւ̃|C^
//		int stack_size		X^bÑTCY
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		uIDX^bNv܂B
//		uIDX^bNv́ALN^IuWFNg̔z񂩂󂫂
//		T߂ɎgX^bNŁAԂ
//		@@{ stack_size-1, stack_size-2, stack_size-3...., 2, 1, 0 }
//		i[܂B
//		X^bNgbvpopID擾ALN^IuWFNg
//		ꂽAIDPUSH܂
//--------------------------------------------------------------------
void initialize_id_stack(int* stack, int* stack_ptr_ptr, int stack_size)
{
	int i;
	for (i = 0; i < stack_size; i++) {
		stack[i] = stack_size - 1 - i;
	}
	* stack_ptr_ptr = stack_size - 1;
}

//--------------------------------------------------------------------
//	[  ]
//		int stack_pop(int* stack, int* ptr)
//
//	[  ]
//		int* stack	X^bNz
//		int* ptr	X^bN|C^ւ̃|C^
//
//	[ ߂l ]
//		POPlB
//		X^bN̂ƂɎs-1ԂB
//
//	[  ]
//		w肵X^bNlPOP܂B
//		X^bNɓl͐̐ł̂Ƃ܂B
//		X^bNɉȂƂPOP-1Ԃ܂B
//--------------------------------------------------------------------
int stack_pop(int* stack, int* ptr)
{
	int value = -1;
	if (*ptr < 0) {
		return value;
	}
	return stack[(*ptr)--];

}

//--------------------------------------------------------------------
//	[  ]
//		void stack_push(int value, int* stack, int* ptr, int stack_size)
//
//	[  ]
//		int value		pushl	
//		int* stack		X^bNz
//		int* ptr		X^bN|C^ւ̃|C^
//		int stack_size	X^bNz̃TCY
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		w肵X^bNpush܂B
//		X^bNɁAstack_size̒lĂƂpush
//		ȂɂɕԂ܂B
//--------------------------------------------------------------------
void stack_push(int value, int* stack, int* ptr, int stack_size)
{
	// X^bNI[o[t[̏ꍇ͉Ȃ
	if (*ptr >= stack_size) {
		kon_log_single(ERROR_STACK_OVERFLOW, "stack_push : stack over flow.stack = %X\n", stack);
		return;
	}

	// X^bNɒlς
	stack[++(*ptr)] = value;
}


//--------------------------------------------------------------------
//	[  ]
//		int make_continuous_filename(char* buffer, const char* dir_path, const char* main, const char* ext)
//
//	[  ]
//
//	[ ߂l ]
//		dir_path̑ݗLԂ܂B
//			 0 : ݂ȂBmkdirKv
//			 1 : ݂Bmkdir͕KvȂ
//			-1 : G[
//
//	[  ]
//		AԂ̃t@C𐶐܂B
//		dir_path̒ mainXXXXX.ext ̃t@CŁAXXXXXɘAԂăt@C
//		܂B
//		ʂ buffer Ɋi[܂B
//--------------------------------------------------------------------
int make_continuous_filename(char* buffer, const char* dir_path, const char* filename_main, const char* ext)
{
	int i;
	int dir_exists = 0;
	char work_dir[_MAX_PATH];	// Ɨpobt@ifBNgj
	char work_path[_MAX_PATH];
	int length;
	FILE* fn;

	memset(work_dir, 0, _MAX_PATH);
	memset(work_path, 0, _MAX_PATH);

	// fBNg݊mF
	dir_exists = check_dir_exists(dir_path);

	// dir_work
	strcpy(work_dir, dir_path);
	length = strlen(dir_path);
	if ((work_dir[length - 1] == '\\') || (work_dir[length - 1] == '/')) {
		work_dir[length - 1] = 0;
	}

	// t@CȂ瑶݂mF
	for (i = 0; i <= 99999; i++) {
		sprintf(work_path, "%s/%s%05d.%s", work_dir, filename_main, i, ext);
		// ݊mF
		//kon_log("check file=%s\n", work_path);
		fn = fopen(work_path, "rb");
		if (fn == NULL) {
			// t@C݂͑ȂBŊmB
			break;
		}
		//kon_log("fn=%08X\n", fn);

		// t@Ĉ݂ŁAt@CĎs
		fclose(fn);
	}

	// 肵t@CԂ
	strcpy(buffer, work_path);
	return dir_exists;
}

//--------------------------------------------------------------------
//	[  ]
//		void make_fullpath(char* buffer, const char* dir, const char* filename)
//
//	[  ]
//      char* buffer            ʊi[̃obt@
//		const char* dir			fBNg
//		const char* filename	t@C
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		dirfilenameătpXAbufferɔf܂B
//--------------------------------------------------------------------
void make_fullpath(char* buffer, const char* dir, const char* filename)
{
    int length;

    strcpy(buffer, dir);
    length = strlen(dir);

    // fBNgZbg
    if ((buffer[length - 1] != '\\') && (buffer[length - 1] != '/'))
    {
        buffer[length] = '/';
        buffer[length + 1] = 0x00;
    }
    length = strlen(buffer);

    // t@CZbg
    strcpy(buffer + length, filename);

    // I
    return;
}
