#define __JIKI_C__
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "constants.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "stage.h"
#include "jiki.h"
#include "blade.h"
#include "esp.h"
#include "shop.h"
#include "gameover.h"

//=========================================
// 萔`
//=========================================
int charge_pattern_offset[] = { 0x1E, 0x24, 0x2A, 0x30 };   // ߃p^[
int dash_pattern_offset[] = { 0x36, 0x3C };                 // _bVp^[
int mp_charge_speed[] = MP_CHARGE_SPEED;     // MP`[WʁiWvj
int mp_recover_speed[] = MP_RECOVER_SPEED;     // MP`[Wʁiԁj
BBOX jiki_shopdoor_bbox = { -8,-20,8,24 };
int hook_anim[] = { 0,6,12,6 };
int jiki_flow_speed[game_level_count] = { 128, 256, 256, 256 }; // Q[LVƂ̑̊₷
int jiki_slip_speed[game_level_count] = { 256, 512, 512, 512 }; // Q[LVƂ̑̊₷

// 蔻̈`
#define JIKI_HIT_HWIDTH     (10)    // L蔻蕝̔
#define JIKI_HIT_HHEIGHT    (32)    // L蔻荂̔
#define JIKI_HIT_HDWIDTH    (48)    // _bV̎L蔻蕝̒ґ

//=========================================
// vg^Cv錾
//=========================================
// ԑJ
void jiki_state_transition(CHROBJ* pObj, GROUNDING_COLLISION* collision);
void state_transition_normal(CHROBJ* pObj, GROUNDING_COLLISION* collision);
void state_transition_damage(CHROBJ* pObj, GROUNDING_COLLISION* collision);
void state_transition_on_magic(CHROBJ* pObj, GROUNDING_COLLISION* collision);
void state_transition_on_down(CHROBJ* pObj, GROUNDING_COLLISION* collision);
// @
void jiki_move(void* pTarget);	    // ړ֐ւ̃|C^
void jiki_draw(void* pTarget);	// `֐ւ̃|C^
int jiki_is_on_shopdoor(OBJPOS* pPos);  // VbṽhAɏdȂĂꍇ1Ԃ
void jiki_do_on_clear(JIKI* pJiki); // NA[uɓ͂
void jiki_do_on_clear_6(JIKI* pJiki);   // E
void jiki_do_on_clear_4(JIKI* pJiki);   // 
void jiki_do_on_clear_8(JIKI* pJiki);   // 

// ԂƂ̏
// ʏ
void jiki_normal_transition(JIKI* pJiki);   // ԑJڐ
void jiki_normal_move(JIKI* pJiki);         // ړ
void jiki_normal_move_input(JIKI* pJiki, int* downstair, int* gravity);   // ړi͏j
void jiki_normal_draw(JIKI* pJiki);         // `
void jiki_stack_trans_sp(CHROBJ* pJikiObj, CHROBJ* pBladeObj, int frame_count);

// ߒ
void jiki_charge_transition(JIKI* pJiki);  // ԑJڐ
void jiki_charge_move(JIKI* pJiki);  // ړ
void jiki_charge_draw(JIKI* pJiki);  // `

// _bV
void jiki_dash_transition(JIKI* pJiki);  // ԑJڐ
void jiki_dash_move(JIKI* pJiki);  // ړ
void jiki_dash_draw(JIKI* pJiki);  // `

// @
void jiki_on_magic_transition(JIKI* pJiki);  // ԑJڐ
void jiki_on_magic_move(JIKI* pJiki);  // ړ
void jiki_on_magic_draw(JIKI* pJiki);  // `

// _[WmbNobN
void jiki_damage_transition(JIKI* pJiki);  // ԑJڐ
void jiki_damage_move(JIKI* pJiki);  // ړ
void jiki_damage_draw(JIKI* pJiki);  // `

// _E
void jiki_on_down_transition(JIKI* pJiki);  // ԑJڐ
void jiki_on_down_move(JIKI* pJiki);  // ړ
void jiki_on_down_draw(JIKI* pJiki);  // `

// R[obN
void jiki_on_hit(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);

//--------------------------------------------------------------------
//	[  ]
//		void jiki_init(void* pTarget, int x, int y, Direction direction)
//
//	[  ]
//		void* pTarget       @IuWFNgւ̃|C^
//      int px              ʒuX
//      int py              ʒuY
//      Direction direction Ă
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		@̏
//--------------------------------------------------------------------
void jiki_init(void* pTarget, int px, int py, Direction direction)
{
    JIKI* pJiki = pTarget;
    memset(pTarget, 0, sizeof(JIKI));

    // \bh蓖
    p_stage_objects->jiki.obj.move = jiki_move;           // ړ֐
    p_stage_objects->jiki.obj.draw = jiki_draw;           // `֐
    p_stage_objects->jiki.obj.grounding = move_grounding_jiki; // ڒn֐

    // ڒn苫Eݒ
    pJiki->obj.grd_bbox.x0 = -8;
    pJiki->obj.grd_bbox.x1 = +7;
    pJiki->obj.grd_bbox.y0 = -8;
    pJiki->obj.grd_bbox.y1 = +8 + 16 -1;

    // UE_[W苫Eݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.y0 = (8 + 16 - 1) - JIKI_HIT_HHEIGHT;
    pJiki->obj.hit_bbox.y1 = (8 + 16 - 1);

    // ʒuݒ
    pJiki->obj.pos.px = px;
    pJiki->obj.pos.py = py;
    pJiki->obj.pos.hx = px << 8;
    pJiki->obj.pos.hy = py << 8;
    pJiki->obj.prev_pos = pJiki->obj.pos;
    pJiki->obj.direction = direction;

    // Ԓl
    pJiki->obj.status = status_normal;   // ʏԂJn

    // R[obN
    pJiki->obj.on_hit = jiki_on_hit;

    // GJEg
    pJiki->invincible = JIKI_START_INVINCIBLE;

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_move(void* pTarget)
//
//	[  ]
//		void* pTarget   @IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		@̈ړ
//--------------------------------------------------------------------
void jiki_move(void* pTarget) {
    JIKI* pJiki = pTarget;
    CHROBJ* pObj = &(pJiki->obj);
    ObjStatus prev_status = pObj->status;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // ԏ
    pJiki->on_shopdoor = 0; // VbṽhAɂ͏dȂĂȂ肩n߂

    // -----< ͏Ԃp[Xitransitionj >-----
    //
    switch (pObj->status) {
    case status_absent:
        // ŝ݂Ƃ͉Ȃ
        break;

    case status_charge:
        // ߒ
        jiki_charge_transition(pJiki);
        break;

    case status_dash:
        // _bV
        jiki_dash_transition(pJiki);
        break;

    case status_on_magic:
        // @
        jiki_on_magic_transition(pJiki);
        break;

    case status_damage:
        // _[W
        jiki_damage_transition(pJiki);
        break;

    case status_on_down:
        // _E
        jiki_on_down_transition(pJiki);
        break;

    default:
        // 쒆̒ʏ̏
        jiki_normal_transition(pJiki);
        break;
    }

    // ԂωAt[JEg
    if (prev_status != pObj->status) {
        pObj->frame_count = 0;
    }
    // GJEgJEg_E
    pJiki->invincible--;
    if (pJiki->invincible < 0) {
        pJiki->invincible = 0;
    }
    // GtFNgXp𐧌
    if (pObj->effect_span > 0) {
        pObj->effect_span -= 1;
    }

    // -----< ړ >-----
    //
    switch (pObj->status) {
    case status_absent:
        // ŝ݂Ƃ͉Ȃ
        break;

    case status_charge:
        // ߒ
        jiki_charge_move(pJiki);
        break;

    case status_dash:
        // _bV
        jiki_dash_move(pJiki);
        break;

    case status_on_magic:
        // @
        jiki_on_magic_move(pJiki);
        break;

    case status_damage:
        // _[W
        jiki_damage_move(pJiki);
        break;

    case status_on_down:
        // _[W
        jiki_on_down_move(pJiki);
        break;

    default:
    // 쒆̒ʏ̏
    jiki_normal_move(pJiki);
    break;
    }

    // BOMBQ[W
    {
		int index = (((p_application_context->bomb_charge << 8) / BOMB_CHARGE_MAX) << 4) >> 8;
        stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x63 + index, sp_code_top + 0x0A, 1);
    }
}



//--------------------------------------------------------------------
//	[  ]
//		void jiki_draw(void* pTarget)
//
//	[  ]
//		void* pTarget   ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void jiki_draw(void* pTarget) {
    JIKI* pJiki = pTarget;
    OBJPOS* pPos = &(pJiki->obj.pos);
    int idx;
    int sp_index;
    int allocsp;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // BOMB READY}[N
    int bomb_ready = 0;
    int bomb_ready_x;
    int bomb_ready_y;
    int bomb_ready_front = 0;
    int bomb_ready_spcode;
    int bomb_ready_hrev;

    // {Q[W
    {
        // Q[W
        sp_index = p_stage_objects->sp_index_seq;
        allocsp = sp_alloc_index(1);
        if (allocsp >= 1) { // SPindexmۂłȂ`掩̂߂
            SP_UNIT* sp = p_memory_map_buffer->sp_unit + sp_index;
            SP_SET(sp, 234, 232, sp_code_top + 0x0A, 7, 0, 0, 3);
            sp++;
        }
    }

    // BOMBQ[W܂Ƃ̃n[g}[N̔
	if ((p_application_context->bomb_charge == (BOMB_CHARGE_MAX)) || (0)) {
        bomb_ready = 1;
        idx = (pJiki->obj.frame_count << 3) & VARY_TABLE_MASK;
        bomb_ready_x = (p_stage_context->s_hx >> 8) + ((vcos[idx]) >> 4) + 8;
        bomb_ready_y = (p_stage_context->s_hy >> 8) + ((vsin[idx]) >> 5) + 16;
        bomb_ready_front = (idx < (VARY_TABLE_SIZE >> 1)) ? 1 : 0;
		//bomb_ready_spcode = sp_code_top + 0x33 + ((p_stage_objects->frame_count >> 3) & 1);
        //bomb_ready_hrev = (p_stage_objects->frame_count >> 4) & 1;
        bomb_ready_spcode = sp_code_top + 0x09;
        bomb_ready_hrev = 0;
    }

    // G̏ꍇ͓_Łi2t[Ƃɕ\E\؂ւj
    // qbgXgbv͓_łȂ悤ɂBqbgXgbvɏĂƂ邢B
    if ((pJiki->invincible > 0)
        && (pJiki->invincible_no_blink == 0)
        && (p_stage_objects->hit_stop == 0)
    ) {
        if ((pJiki->obj.status != status_damage) && (pJiki->obj.status != status_on_down)) {
            if ((p_stage_objects->frame_count >> 1) & 1) {
                // 2t[ƂɃXLbv
                return;
            }
        }
    }

    // `揈iBOMB READY}[NOj
    if ((bomb_ready == 1) && (bomb_ready_front == 1)) {
        sp_index = p_stage_objects->sp_index_seq;
        allocsp = sp_alloc_index(1);
        if (allocsp >= 1) { // SPindexmۂłȂ`掩̂߂
            SP_UNIT* sp = p_memory_map_buffer->sp_unit + sp_index;
			SP_SET(sp, bomb_ready_x, bomb_ready_y, bomb_ready_spcode, 7, bomb_ready_hrev, 0, 3);
            sp++;
        }
    }

    // `揈
    switch (pJiki->obj.status) {
    case status_absent:
        // ŝ݂Ƃ͉Ȃ
        break;

    case status_charge:
        // ߒ
        jiki_charge_draw(pJiki);
        break;

    case status_dash:
        // _bV
        jiki_dash_draw(pJiki);
        break;

    case status_on_magic:
        // @
        jiki_on_magic_draw(pJiki);
        break;

    case status_damage:
        // _[W
        jiki_damage_draw(pJiki);
        break;

    case status_on_down:
        // _E
        jiki_on_down_draw(pJiki);
        break;

    default:
        // 쒆̒ʏ̏
        jiki_normal_draw(pJiki);
        break;
    }

    // `揈iBOMB READY}[Nj
    if ((bomb_ready == 1) && (bomb_ready_front == 0)) {
        sp_index = p_stage_objects->sp_index_seq;
        allocsp = sp_alloc_index(1);
        if (allocsp >= 1) { // SPindexmۂłȂ`掩̂߂
            SP_UNIT* sp = p_memory_map_buffer->sp_unit + sp_index;
			SP_SET(sp, bomb_ready_x, bomb_ready_y, bomb_ready_spcode, 7, bomb_ready_hrev, 0, 3);
            sp++;
        }
    }

}


//--------------------------------------------------------------------
//	[  ]
//		int jiki_is_on_shopdoor(JIKI* pJiki)
//
//	[  ]
//		OBJPOS* pPos     ʒu\̂ւ̃|C^
//
//	[ ߂l ]
//		dȂĂȂF0
//      dȂĂ  F1
//
//	[  ]
//		VbṽhAɏdȂĂ邩ۂ𔻒肵ČʂԂ܂B
//--------------------------------------------------------------------
int jiki_is_on_shopdoor(OBJPOS* pPos)
{
    int x, y;
    BBOX jiki_bg_bbox;  // LBG̃oEfBO{bNX
    int pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ
    int code;
    int area_x0, area_y0, area_x1, area_y1;

    // NA[u͏OFF
    if (p_stage_context->on_clear_move != 0) {
        return 0;
    }

    // oEfBO{bNX𓾂
    get_collision_bgs(pPos, &(jiki_shopdoor_bbox), &jiki_bg_bbox);

    // ZNV͈̔͂ŃNbsO
    area_x0 = (def_stage_section_area[p_stage_context->stage - 1][p_stage_context->section - 1][0][0] >> 3);
    area_y0 = (def_stage_section_area[p_stage_context->stage - 1][p_stage_context->section - 1][0][1] >> 3);
    area_x1 = (def_stage_section_area[p_stage_context->stage - 1][p_stage_context->section - 1][0][2] >> 3);
    area_y1 = (def_stage_section_area[p_stage_context->stage - 1][p_stage_context->section - 1][0][3] >> 3);
    if (jiki_bg_bbox.x0 < area_x0) {
        jiki_bg_bbox.x0 = area_x0;
    }
    if (jiki_bg_bbox.y0 < area_y0) {
        jiki_bg_bbox.y0 = area_y0;
    }
    if (jiki_bg_bbox.x1 > area_x1) {
        jiki_bg_bbox.x1 = area_x1;
    }
    if (jiki_bg_bbox.y1 > area_y1) {
        jiki_bg_bbox.y1 = area_y1;
    }

    // 肷
    for (y = jiki_bg_bbox.y0; y <= jiki_bg_bbox.y1; y++) {
        for (x = jiki_bg_bbox.x0; x <= jiki_bg_bbox.x1; x++) {
            code = GET_BG_ATTRIBUTE(pw_page, x, y);
            if (code == 4) {
                return 1;
            }
        }
    }

    // qbgȂ
    return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_state_transition(CHROBJ* pObj, GROUNDING_COLLISION* collision)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		GROUNDING_COLLISION* collision	ڒnEǏՓ˔茋
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		w肳ꂽpObjɂāAcollisionق̏ɂ
//		ԂJڂ܂B
//--------------------------------------------------------------------
void jiki_state_transition(CHROBJ* pObj, GROUNDING_COLLISION* collision)
{
    // Ԃɂď؂ւ
    switch (pObj->status) {
    case status_normal:
        // ʏړ
        state_transition_normal(pObj, collision);
        break;

    case status_damage:
        // _[WmbNobN
        state_transition_damage(pObj, collision);
        break;

    case status_on_magic:
        // @
        state_transition_on_magic(pObj, collision);
        break;

    case status_on_down:
        // @
        state_transition_on_down(pObj, collision);
        break;

    default:
        // 䂵ȂԒlBȂɂȂB
        break;
    }

    // I
    return;
}

//=============================================================================
// ԑJ ڒn
//=============================================================================
void state_transition_normal(CHROBJ* pObj, GROUNDING_COLLISION* collision)
{
    // Nothing to do.
    return;
}

//=============================================================================
// ԑJ _[WmbNobN
//=============================================================================
void state_transition_damage(CHROBJ* pObj, GROUNDING_COLLISION* collision)
{
    // ʏԂƓ
    state_transition_normal(pObj, collision);
    return;
}


//=============================================================================
// ԑJ _E
//=============================================================================
void state_transition_on_down(CHROBJ* pObj, GROUNDING_COLLISION* collision)
{
    // ڒn瓮~߂
    if (collision->bottom) {
        pObj->pos.vx = 0;
    }
    return;
}


//=============================================================================
// ԑJ @
//=============================================================================
void state_transition_on_magic(CHROBJ* pObj, GROUNDING_COLLISION* collision)
{
    return;
}


//=============================================================================
// ʏ
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		void jiki_normal_transition(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki     ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ʏԂł̏ԑJڐ
//--------------------------------------------------------------------
void jiki_normal_transition(JIKI* pJiki)
{
    CHROBJ* pObj = &(pJiki->obj);
    OBJPOS* pPos = &(pObj->pos);

    if (p_input_parser->trg_main_on_count > LONG_PRESS) {
        if (p_application_context->mp > 0) {
            // Ăꍇ͗߂ɓ
            pPos->ax = 0;
            pPos->ay = 0;
            pPos->vx = 0;
            pPos->vy = 0;
            pObj->status = status_charge;
            // ʉ
            play_se(&(p_sound_context->se_item[setype_oncharge]));
        }
    }
    else if (pObj->gcol.bottom== BG_ATTRIBUTE_DAMAGE) {
        if ((!pJiki->invincible) && (p_stage_context->on_clear_move == 0)) {
            // _[W𓥂񂾂_[W
            pJiki->obj.on_hit(hittype_damage_floor, pJiki, NULL, 1);
        }
    }
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_normal_move(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki    @IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		@̈ړ
//--------------------------------------------------------------------
void jiki_normal_move(JIKI* pJiki) {
    CHROBJ* pJikiObj;
    OBJPOS* pJikiPos;
    BLADE* pBlade;
    CHROBJ* pBladeObj;
    int frame_count;
    int downstair;
    int gravity = MOVE_GRAVITY;
    GROUNDING_COLLISION* collision;
    int ground_attribute;
    int on_esp;

    // NA[ûƂɓ͂
    if (p_stage_context->on_clear_move == 1) {
        // NA[u
        jiki_do_on_clear(pJiki);
    }
    else {
        // NAłȂƂ͐ڒn\bhĐݒ
        pJiki->obj.grounding = move_grounding_jiki;
    }

    // W
    pBlade = &(p_stage_objects->blade);
    pBladeObj = &(pBlade->obj);
    pJikiObj = &(pJiki->obj);
    pJikiPos = &(pJikiObj->pos);
    frame_count = pJiki->obj.frame_count;
    collision = &(pJikiObj->gcol);

    // qbgXgbv\Ԃɂ
    pJikiObj->hit_stop_ready = 1;

    // 蔻͈̔͐ݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;

    // -----< L[͂ɂړ >-----
    //
    jiki_normal_move_input(pJiki, &downstair, &gravity);

    // -----< ʏł̕\^[Qbgʒu >-----
    //
    // X
	if ((CENTER_AT_NEUTRAL != 0)
		&& (p_memory_map_buffer->input_unit.bit.left == 0)
		&& (p_memory_map_buffer->input_unit.bit.right == 0)
		&& (    // Xe[W3{X̏ꍇO
			!((p_stage_context->stage == 3) && (p_stage_context->section == def_stage_sections[3]))
			)
		) {
		p_stage_context->s_tx = (128) << 8;
	}
	else {
		if (pJikiObj->direction == dir_left) {
			// 
			p_stage_context->s_tx = (170 + 48) << 8;   // (256 * 2 / 3) << 8;
		}
		else {
			// E
			p_stage_context->s_tx = (85 - 48) << 8;    // (256 * 1 / 3) << 8;
		}
	}
    // Y
    if ((pJikiObj->status = status_normal)
        && (pJikiObj->gcol.bottom == 0)
        && (pJikiPos->vy > 0)) {
        // Wv
        p_stage_context->s_ty = 85 << 8;   // (256 * 1 / 3) << 8;
    }
    else {
        // n
        p_stage_context->s_ty = 170 << 8;   // (256 * 2 / 3) << 8;
    }

    // -----< MP񕜁FWv㏸Ǝԉ >-----
    //
	if (pJikiObj->status == status_normal) {
        // Wv㏸̉
        if ((pJikiObj->gcol.bottom == 0) && (pJikiPos->vy < 0))
        {
            p_application_context->mp += mp_charge_speed[p_application_context->lv_charge];
        }

        // ԉ񕜁i{^̂݁j
        if ((p_input_parser->trg_main_on_count==0)  // {^
			|| ((p_input_parser->trg_main_on_count != 0)    // {^MPsĂȂꍇi`[WԂMPsĂꍇ͂̂܂܂Ƃ邱Ɓj
                && (p_application_context->mp >= mp_recover_speed[p_application_context->lv_charge])
                )
            ) {
            p_application_context->mp += mp_recover_speed[p_application_context->lv_charge];
        }

        // MP MAXNbsO
        if (p_application_context->mp > MP_MAX) {
            p_application_context->mp = MP_MAX;
        }
    }

    // -----< PCG]w >-----
    //
    jiki_stack_trans_sp(pJikiObj, pBladeObj, frame_count);

    // -----< ړʏ >-----
    //
    move_common(pJikiObj, downstair, gravity);
    jiki_state_transition(pJikiObj, collision);

    // -----< Vbv >-----
    //
	if (   (p_stage_objects->shop_closed == 0)
		&& (jiki_is_on_shopdoor(pJikiPos))
		) {
		pJiki->on_shopdoor = 1;
	}
    if (   (pJiki->on_shopdoor)                     // VbṽhAɏdȂĂ
        && (p_input_parser->direction_id == 2)      // ɃL[CĂ
        && (p_input_parser->trg_main_clicked != 0)  // U{^NbN
        && (p_input_parser->trg_sub_on_count == 0)  // Wv{^͉
        )
    {
        // Vbv
        shop_start();
        p_stage_objects->shop_closed = 1;
    }

    // -----< ESPo >-----
    //
    on_esp = (startup_param.XVI) ? ((pJikiObj->frame_count & 3) == 0) : ((pJikiObj->frame_count & 7) == 0);
    ground_attribute = pJikiObj->gcol.bottom;
    if ((pJikiPos->vx != 0)
        && (pJikiObj->status==status_normal)
        && (ground_attribute!=0)
        && (on_esp)
        ) {
        switch (ground_attribute) {
        case 0:
            // 
            break;
        case BG_ATTRIBUTE_SLIP:
            // X̏ꍇ̓zRȂ
            break;
        default:
            // nɂ
            appear_esp_vec(esptype_smoke, pJikiPos->hx, pJikiPos->hy + (24 << 8), 0, -128 + (vrand() & 0xFF));
            break;
        }
    }

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_normal_move_input(JIKI* pJiki, int* p_downstair, int* p_gravity)
//
//	[  ]
//		JIKI* pJiki         @IuWFNgւ̃|C^
//      int* p_downstair    ~葀쒆ۂ̔茋ʔfւ̃|C^[W]
//      int* p_gravity      d͉x̕ϐւ̃|C^[R/W]
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		@̈ړ
//--------------------------------------------------------------------
void jiki_normal_move_input(JIKI* pJiki, int* p_downstair, int* p_gravity)
{
    CHROBJ* pJikiObj;
    OBJPOS* pJikiPos;
    BLADE* pBlade;
    CHROBJ* pBladeObj;
    int speed_normal    = 768;  // @ړxiʏj
    int speed_low       = 384;  // @ړxiꂪꍇj
    int on_step_se = 0;

    // W
    pJikiObj = &(pJiki->obj);
    pJikiPos = &(pJikiObj->pos);
    pBlade = &(p_stage_objects->blade);
    pBladeObj = &(pBlade->obj);

    pJikiPos->ax = 0;
    pJikiPos->vx = 0;
    if (pJikiObj->gcol.hook != 0) {
        // Ԃ牺蒆͍EɈړłȂ
        pJikiPos->vx = 0;

        // EύX
        if (p_memory_map_buffer->input_unit.bit.left) {
            pJikiObj->direction = dir_left;
        }
        if (p_memory_map_buffer->input_unit.bit.right) {
            pJikiObj->direction = dir_right;
        }
    }
    else {
        // ڒnnʂ̑𓾂
        int att = pJikiObj->gcol.bottom;
        int n_spd = speed_normal;
		if (p_stage_context->on_clear_move == 0) {
			if ((att == BG_ATTRIBUTE_SLOW) || (att == BG_ATTRIBUTE_SLOWBOARD)) {
				n_spd = speed_low;
			}
		}

        // Eړ
        if (p_memory_map_buffer->input_unit.bit.left) {
            pJikiPos->vx = -n_spd;
            pJikiObj->direction = dir_left;
            if (att != 0) { on_step_se = 1; }
        }
        if (p_memory_map_buffer->input_unit.bit.right) {
            pJikiPos->vx = n_spd;
            pJikiObj->direction = dir_right;
            if (att != 0) { on_step_se = 1; }
        }
        // Eړ̌ʉ
        if ((startup_param.XVI) &&(on_step_se)) {
            if (p_stage_context->stage == 5) {
                if (p_stage_context->section == 3) {
                    // ̏
                    if ((pJikiObj->frame_count & 7) == 0) {
                        play_se(&(p_sound_context->se_item[setype_stepwater]));
                    }
                }
                else if (p_stage_context->section == 4) {
                    // ǂǂ됅̏
                    if ((pJikiObj->frame_count & 15) == 0) {
                        play_se(&(p_sound_context->se_item[setype_stepwater]));
                    }
                }
                else {
                    // ʏ
                    if ((pJikiObj->frame_count & 7) == 0) {
                        play_se(&(p_sound_context->se_item[setype_step]));
                    }
                }
            } else {
                // ʏ
                if ((pJikiObj->frame_count & 7) == 0) {
                    play_se(&(p_sound_context->se_item[setype_step]));
                }
            }
        }

        // ꂪƂ͉e󂯂
        if (att == BG_ATTRIBUTE_FLOW_RIGHT) {
            pJikiPos->vx += jiki_flow_speed[p_game_properties->game_level];
        }
        if(att == BG_ATTRIBUTE_FLOW_LEFT) {
            pJikiPos->vx -= jiki_flow_speed[p_game_properties->game_level];
        }

        // j[g
        if ((p_memory_map_buffer->input_unit.bit.left == 0) && (p_memory_map_buffer->input_unit.bit.right==0)) {
            // XȂ犊
            if (att == BG_ATTRIBUTE_SLIP) {
                if (pJikiObj->direction == dir_left) {
                    pJikiPos->vx = -jiki_slip_speed[p_game_properties->game_level];
                }
                else {
                    pJikiPos->vx = jiki_slip_speed[p_game_properties->game_level];
                }
            }
        }
    }

    // Wv or ~
    *p_downstair = 0;
    if ((p_input_parser->trg_sub_clicked) // Wv{^Ă
        && (p_memory_map_buffer->input_unit.bit.down == 0)    // ͉ĂȂ
        && (pJiki->obj.status == status_normal)
        && ((pJiki->obj.gcol.bottom != 0) || (pJiki->obj.gcol.hook != 0))   // nԂ牺
        ) {
        // Wv
        if (p_memory_map_buffer->input_unit.bit.up) {
            // ĂnCWv
            pJiki->obj.pos.vy = -12 * 256;
        }
        else {
            // ʏWv
            pJiki->obj.pos.vy = -8 * 256;
        }
        // ʉ炷
        play_se(&(p_sound_context->se_item[setype_jump]));
    }
    else if ((p_input_parser->trg_sub_on_count > 0)   // Wv{^Ă
        && (p_memory_map_buffer->input_unit.bit.down != 0)  // Ă
        //&& (pJikiObj->status == status_normal)    // ڒnĂ
        //&& (pJikiObj->gcol.bottom != 0)           
        ) {
        // 
        *p_downstair = 1;
    }

    // u[h
    if (p_input_parser->trg_main_clicked) { // U{^ꂽ
        if (pBladeObj->status == status_absent) {
            // u[h
            int px, py;
            Direction dir;
            dir = pJikiObj->direction;
            if (dir == dir_left) {
                // 
                px = pJikiPos->px - 40;
            }
            else {
                // E
                px = pJikiPos->px + 40;
            }
            py = pJikiPos->py;
            blade_init(pBlade, px, py, dir);

            // ʉ
            play_se(&(p_sound_context->se_item[setype_blade]));
        }
    }

    // d͉x̒
    // ㏸ɃWv{^ĂƁAd͂Ɍy
    if ((pJikiPos->vy < 0)
        && (p_input_parser->trg_sub_on_count)
        ) {
        *p_gravity -= (MOVE_GRAVITY) / 2;
    }
    // ~ɂĂd͂Ȃ
    if ((pJikiPos->vy > 0)
        && (p_memory_map_buffer->input_unit.bit.down)
        ) {
        *p_gravity += (MOVE_GRAVITY) / 2;
    }
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_do_on_clear(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki     @ւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		NA[u̓͏
//--------------------------------------------------------------------
void jiki_do_on_clear(JIKI* pJiki)
{
    int type;
    int stage_index;
    int section_index;

    // ^Cv𓾂
    stage_index = p_stage_context->stage - 1;
    section_index = p_stage_context->section - 1;
    type = def_stage_clear_move_type[stage_index][section_index];

    // ^CvƂɏ𕪂
    switch (type) {
    case 6:
        // E
        jiki_do_on_clear_6(pJiki);
        break;

    case 4:
        // 
        jiki_do_on_clear_4(pJiki);
        break;

    case 8:
        // 
        jiki_do_on_clear_8(pJiki);
        break;

    default:
        // Ȃ
        break;
    }
}


//=============================================================================
// NA[u E
//=============================================================================
void jiki_do_on_clear_6(JIKI* pJiki)
{
    // ڒn\bh㏑
    pJiki->obj.grounding = move_grounding;

    // 
    p_memory_map_buffer->input_unit.bit.down = 0;
    p_memory_map_buffer->input_unit.bit.left = 0;
    p_memory_map_buffer->input_unit.bit.right = 1;
    p_memory_map_buffer->input_unit.bit.up = 0;
    p_memory_map_buffer->input_unit.bit.trg_a = 0;
    p_memory_map_buffer->input_unit.bit.trg_b = 0;
    p_input_parser->trg_main_on_count = 0;
    p_input_parser->trg_sub_on_count = 0;
    p_input_parser->trg_main_clicked = 0;
    p_input_parser->trg_sub_clicked = 0;

    // EɐڐĜWvŔ
    if (pJiki->obj.gcol.right != 0) {
        p_memory_map_buffer->input_unit.bit.up = 1;
        p_memory_map_buffer->input_unit.bit.trg_b = 1;
    }

    // Xe[W6Ŕ̏ꍇ͍~
    if (p_stage_context->stage == 6) {
        if (BG_BOARD_CONDITION(pJiki->obj.gcol.bottom)) {
            p_memory_map_buffer->input_unit.bit.down = 1;
            p_memory_map_buffer->input_unit.bit.trg_b = 1;
        }
    }

    // Ԃ牺肪~
    if (pJiki->obj.gcol.hook != 0) {
        p_memory_map_buffer->input_unit.bit.down = 1;
        p_memory_map_buffer->input_unit.bit.trg_b = 1;
    }

    // gK삪ꍇ̕⑫
    if (p_memory_map_buffer->input_unit.bit.trg_b != 0) {
        p_input_parser->trg_main_clicked = 0;
        p_input_parser->trg_sub_on_count += 1;
        p_input_parser->trg_sub_clicked = (p_input_parser->trg_sub_on_count == 1);
    }
}

//=============================================================================
// NA[u 
//=============================================================================
void jiki_do_on_clear_4(JIKI* pJiki)
{
    // ڒn\bh㏑
    pJiki->obj.grounding = move_grounding;

    // 
    // 
    p_memory_map_buffer->input_unit.bit.down = 0;
    p_memory_map_buffer->input_unit.bit.left = 1;
    p_memory_map_buffer->input_unit.bit.right = 0;
    p_memory_map_buffer->input_unit.bit.up = 0;
    p_memory_map_buffer->input_unit.bit.trg_a = 0;
    p_memory_map_buffer->input_unit.bit.trg_b = 0;
    p_input_parser->trg_main_on_count = 0;
    p_input_parser->trg_sub_on_count = 0;
    p_input_parser->trg_main_clicked = 0;
    p_input_parser->trg_sub_clicked = 0;

    // ɕǂWvŔ
    if (pJiki->obj.gcol.left != 0) {
        p_memory_map_buffer->input_unit.bit.up = 1;
        p_memory_map_buffer->input_unit.bit.trg_b = 1;
    }

    // Ԃ牺肪~
    if (pJiki->obj.gcol.hook != 0) {
        p_memory_map_buffer->input_unit.bit.down = 1;
        p_memory_map_buffer->input_unit.bit.trg_b = 1;
    }

    // gK삪ꍇ̕⑫
    if (p_memory_map_buffer->input_unit.bit.trg_b != 0) {
        p_input_parser->trg_main_clicked = 0;
        p_input_parser->trg_sub_on_count += 1;
        p_input_parser->trg_sub_clicked = (p_input_parser->trg_sub_on_count == 1);
    }
}

//=============================================================================
// NA[u 
//=============================================================================
void jiki_do_on_clear_8(JIKI* pJiki)
{
    // ڒn\bh㏑Bɓ˂B
    pJiki->obj.grounding = move_grounding_bottom_single;

    // 
    p_memory_map_buffer->input_unit.bit.down = 0;
    p_memory_map_buffer->input_unit.bit.left = 0;
    p_memory_map_buffer->input_unit.bit.right = 0;
    p_memory_map_buffer->input_unit.bit.up = 0;
    p_memory_map_buffer->input_unit.bit.trg_a = 0;
    p_memory_map_buffer->input_unit.bit.trg_b = 0;
    p_input_parser->trg_main_on_count = 0;
    p_input_parser->trg_sub_on_count = 0;
    p_input_parser->trg_main_clicked = 0;
    p_input_parser->trg_sub_clicked = 0;

    // ʒ[璆Ɋ񂹂
	if ((p_stage_context->s_hx>>8) < (48)) {
		p_memory_map_buffer->input_unit.bit.right = 1;
	}
	if ((p_stage_context->s_hx>>8) > (256-48)) {
		p_memory_map_buffer->input_unit.bit.left = 1;
	}

    // ւ̈ړ
    pJiki->obj.pos.vy = -(8 << 8);
}


//--------------------------------------------------------------------
//	[  ]
//		jiki_stack_trans_sp(CHROBJ* pJikiObj, CHROBJ* pBladeObj, int frame_count)
//
//	[  ]
//		CHROBJ* pJikiObj
//      CHROBJ* pBladeObj
//      int frame_count
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		
//--------------------------------------------------------------------
void jiki_stack_trans_sp(CHROBJ* pJikiObj, CHROBJ* pBladeObj, int frame_count)
{
    OBJPOS* pJikiPos = &(pJikiObj->pos);
    int jiki_slot = p_stage_context->jiki_sp_slot;
    int sp_code_top;
    
    // ]I
    sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // ]
    if ((pBladeObj->status == status_attack)
        && (pJikiObj->gcol.bottom != 0)
        && (pJikiPos->vx == 0)) {
        // n~ŁAȔꍇ͍\
        stack_transfer_sp(jiki_slot, 6, sp_code_top, 2 * 3);
    }
    else if (pJikiObj->gcol.hook != 0) {
        // Ԃ牺蒆̃Aj[V\p^[
        int anim_index = (pJikiObj->frame_count >> 4) & 3;
        stack_transfer_sp(jiki_slot, 0x42 + hook_anim[anim_index], sp_code_top, 2 * 3);
    }
    else if (pJikiObj->gcol.bottom != 0) {
        // ñAj[V\p^[
        //if (pJikiPos->vx != 0) {
		if (
			((p_memory_map_buffer->input_unit.bit.left != 0)
				|| (p_memory_map_buffer->input_unit.bit.right != 0))
			&& (pJikiPos->vx != 0)
    	) {
			int idx = (frame_count >> 2) & 3;
			stack_transfer_sp(jiki_slot, 6 + ((idx << 2) + (idx << 1)), sp_code_top, 2 * 3);
			//stack_transfer_pal(0, 0, 4, 1);
		}
        else {
            stack_transfer_sp(jiki_slot, 0, sp_code_top, 2 * 3);
            //stack_transfer_pal(0, 0, 4, 1);
        }
    }
    else {
        // 󒆂̕\p^[
        stack_transfer_sp(jiki_slot, 6, sp_code_top, 2 * 3);
    }
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_normal_draw(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki   ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void jiki_normal_draw(JIKI* pJiki) {
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    //x = pJiki->obj.pos.px;
    //y = pJiki->obj.pos.py;
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // LN^
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            } else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // VbvC}[N
	if ((pJiki->on_shopdoor)
		&& (((p_application_context->frame_count >> 2) & 3)!=0)
		) {
        sp_index = p_stage_objects->sp_index_seq;
        allocsp = sp_alloc_index(1);
        if (allocsp < 1) { return; }  // SPindexmۂłȂ`掩̂߂
        sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]
		if (pJiki->obj.direction == dir_right) {
			SP_SET(sp, x + 28, y, sp_code_top - 0x10 + 4, 7, 0, 1, 3);
		}
		else {
			SP_SET(sp, x - 12, y, sp_code_top - 0x10 + 4, 7, 0, 1, 3);
		}
        sp++;
    }

    // I
    return;
}


//=============================================================================
// ߒ
//=============================================================================
//-------------------------
// ߒFԑJڐ
//-------------------------
void jiki_charge_transition(JIKI* pJiki)
{
    int i;
    OBJPOS* pPos = &(pJiki->obj.pos);
    GAMEPAD_UNIT* pInput = &(p_memory_map_buffer->input_unit);
    int vx = 0;
    int vy = 0;
    int ax = 0;
    int ay = 0;

    // @{^疂@ցBMPȂꍇ͔ȂB
    if ((p_input_parser->trg_sub_clicked) && (p_application_context->mp >= MP_MAGIC)) {
        // ԑJ
        pJiki->obj.status = status_on_magic;
        return;
    }

    // UL[ꂽ_bVUBMPȂꍇ͔ȂB
	if ((p_input_parser->trg_main_on_count == 0)    //
		&& (p_application_context->mp >= MP_DASH)   //
		&& (p_input_parser->direction_id != 5)
		) {
        if (pInput->bit.left) {
            vx = -DASH_SPEED_X;
            ax = DASH_ACC;
        }
        if (pInput->bit.right) {
            vx = DASH_SPEED_X;
            ax = -DASH_ACC;
        }
        if (pInput->bit.up) {
            vy = -DASH_SPEED_Y;
            ay = DASH_ACC;
        }
        if (pInput->bit.down) {
            vy = DASH_SPEED_Y;
            ay = -DASH_ACC;
        }

        // MP
        p_application_context->mp -= MP_DASH;
        if (p_application_context->mp < 0) {
            p_application_context->mp = 0;
        }

        // _bVɏԑJ
        pPos->ax = ax;
        pPos->ay = ay;
        pPos->vx = vx;
        pPos->vy = vy;
        pJiki->obj.status = status_dash;

        // XVI[ĥƂ͎cW
        if (startup_param.XVI) {
            for (i = 0; i < JIKI_HISTORY_LENGTH; i++) {
                pJiki->pos_history[i].hx = pPos->hx;
                pJiki->pos_history[i].hy = pPos->hy;
            }
        }

        // ʉ炷
        play_se(&(p_sound_context->se_item[setype_dash]));
        return;
    }

    // MP؂ꂽ`[WێłȂ
	if (p_application_context->mp == 0) {
        // j[gŃ{^ꂽʏԂ
        pJiki->obj.status = status_normal;
        return;
    }

    // ȊȌԂŃ{^ꂽʏԂɑJ
    if (p_input_parser->trg_main_on_count == 0) {
        pJiki->obj.status = status_normal;
        return;
    }

}

//-------------------------
// ߒFړ
//-------------------------
void jiki_charge_move(JIKI* pJiki)
{
    OBJPOS* pJikiPos = &(pJiki->obj.pos);

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // 蔻͈̔͐ݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;

    // \͈ړȂ
    if (p_memory_map_buffer->input_unit.bit.left) {
        pJiki->obj.direction = dir_left;
    }
    if (p_memory_map_buffer->input_unit.bit.right) {
        pJiki->obj.direction = dir_right;
    }

    // MP
    p_application_context->mp -= MP_CHARGE_MP;
    if (p_application_context->mp < 0) {
        p_application_context->mp = 0;
    }

    // SP̕\p^[]ݒ
    {
        int jiki_slot = p_stage_context->jiki_sp_slot;
        int offset_idx = (p_stage_objects->frame_count >> 2) & 0x3;

        stack_transfer_sp(jiki_slot, charge_pattern_offset[offset_idx], sp_code_top, 2 * 3);
        stack_transfer_sp(jiki_slot, 0x60, sp_code_top + 0x06, 2);
    }
}

//-------------------------
// ߒF`
//-------------------------
void jiki_charge_draw(JIKI* pJiki)
{
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    //x = pJiki->obj.pos.px;
    //y = pJiki->obj.pos.py;
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // LN^
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(8);
    if (allocsp < 8) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // LN^
    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            }
            else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // n
    SP_SET(sp, x, y +32+4, sp_code_top + 0x06, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, x+16, y +32+4, sp_code_top + 0x07, 5, 0, 0, 3);
    sp++;

    // I
    return;
}


//=============================================================================
// _bVړ̏
//=============================================================================
//-------------------------
// _bVFԑJڐ
//-------------------------
void jiki_dash_transition(JIKI* pJiki)
{
    // ̃t[o߂Ƃɖ߂
    if (pJiki->obj.frame_count > 20) {
        // ~܂
        pJiki->obj.status = status_normal;

        // ̖GԂ^
        pJiki->invincible = JIKI_SPECIAL_INVINCIBLE;
    }
}

//-------------------------
// _bVFړ
//-------------------------
void jiki_dash_move(JIKI* pJiki)
{
    CHROBJ* pJikiObj = &(pJiki->obj);
    OBJPOS* pJikiPos = &(pJikiObj->pos);

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // 蔻͈̔͐ݒ
    if (pJikiObj->direction == dir_right) {
        pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
        pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HDWIDTH;
    }
    else {
        pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HDWIDTH;
        pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;
    }

    // SP̕\p^[]ݒ
    {
        int jiki_slot = p_stage_context->jiki_sp_slot;
        int offset_idx = (p_stage_objects->frame_count >> 2) & 0x1;

        stack_transfer_sp(jiki_slot, dash_pattern_offset[offset_idx], sp_code_top, 2 * 3);
    }

    // -----< ړʏ >-----
    //
    {
        GROUNDING_COLLISION* collision = &(pJiki->obj.gcol);

        // ړ
        move_obj(pJikiPos);

        // GROUNDING
        if (pJikiObj->grounding != NULL) {
            // ڒn֐̎w肪AĂяo
            // _bV downstair  1 ɂĉ̔˂
            pJikiObj->grounding(pJikiObj, 1, collision);
        }

        // ڐGx
        if ((collision->top) || (collision->bottom)) {
            pJikiPos->ay = 0;
        }
        if ((collision->right) || (collision->left)) {
            pJikiPos->ax = 0;
        }

        // uO̒lvXV
        pJikiObj->prev_pos = *pJikiPos;

        // t[JEg
        pJikiObj->frame_count += 1;
    }

    // XVI[hȂcc
    if (startup_param.XVI) {
        pJiki->pos_history[pJikiObj->frame_count & JIKI_HISTORY_MASK].hx = pJikiPos->hx;
        pJiki->pos_history[pJikiObj->frame_count & JIKI_HISTORY_MASK].hy = pJikiPos->hy;
    }
}

//-------------------------
// _bVF`
//-------------------------
void jiki_dash_draw(JIKI* pJiki)
{
    int i;
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;
    int spoffset;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    //x = pJiki->obj.pos.px;
    //y = pJiki->obj.pos.py;
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // <<< U >>>
    spoffset = ((p_stage_objects->frame_count>>2) & 1) << 2;
	if (pJiki->obj.direction == dir_right) {
        // 1
        SP_SET(sp, x + 32, y + 8, sp_code_top + 0x0C + spoffset, 7, 0, 0, 3);
        sp++;
        SP_SET(sp, x + 48, y + 8, sp_code_top + 0x0D + spoffset, 7, 0, 0, 3);
        sp++;
        // 2
        SP_SET(sp, x + 32 - 16, y + 8-8, sp_code_top + 0x0E + spoffset, 7, 0, 0, 3);
        sp++;
        SP_SET(sp, x + 48 - 16, y + 8-8, sp_code_top + 0x0F + spoffset, 7, 0, 0, 3);
        sp++;
        // 3
        SP_SET(sp, x + 32 - 16, y + 8+8, sp_code_top + 0x0E + spoffset, 7, 0, 0, 3);
        sp++;
        SP_SET(sp, x + 48 - 16, y + 8+8, sp_code_top + 0x0F + spoffset, 7, 0, 0, 3);
        sp++;
    }
	else {
        // 1
        SP_SET(sp, x - 16, y + 8, sp_code_top + 0x0C + spoffset, 7, 1, 0, 3);
        sp++;
        SP_SET(sp, x - 32, y + 8, sp_code_top + 0x0D + spoffset, 7, 1, 0, 3);
        sp++;
        // 2
        SP_SET(sp, x - 16 + 16, y + 8-8, sp_code_top + 0x0E + spoffset, 7, 1, 0, 3);
        sp++;
        SP_SET(sp, x - 32 + 16, y + 8-8, sp_code_top + 0x0F + spoffset, 7, 1, 0, 3);
        sp++;
        // 3
        SP_SET(sp, x - 16 + 16, y + 8+8, sp_code_top + 0x0E + spoffset, 7, 1, 0, 3);
        sp++;
        SP_SET(sp, x - 32 + 16, y + 8+8, sp_code_top + 0x0F + spoffset, 7, 1, 0, 3);
        sp++;
    }

    // <<< L >>>
    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // `
    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            }
            else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // <<< LXVIc >>>
    if (startup_param.XVI) {
        //int fc = pJiki->obj.frame_count;
        int fc = p_application_context->frame_count;
		for (i = 0; i < JIKI_HISTORY_LENGTH; i++) {
            // 1u
			if ((i & 1) != 0) { continue; }
            if ((fc >> 1) & 1) { continue; }

            // LXN[W
			x = (pJiki->pos_history[(fc - i) & JIKI_HISTORY_MASK].hx - p_stage_context->bgview_hx) >> 8;
			y = (pJiki->pos_history[(fc - i) & JIKI_HISTORY_MASK].hy - p_stage_context->bgview_hy) >> 8;

            // SPm
            sp_index = p_stage_objects->sp_index_seq;
            allocsp = sp_alloc_index(6);
            if (allocsp < 6) { break; }  // SPindexmۂłȂ`掩̂߂
            sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

            // `
            for (ix = 0; ix < 2; ix++) {
                for (iy = 0; iy < 3; iy++) {
                    int pos_x;
                    // }bvobt@Ƀf[^i[
                    if (pJiki->obj.direction == dir_left) {
                        // ̏ꍇSP𔽓]\
                        pos_x = x + 16 - (ix * 16);
                    }
                    else {
                        // E͒~Ȃʏ\
                        pos_x = x + (ix * 16);
                    }
                    SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
                    sp++;
                }
            }
        }
    }

    // I
    return;
}


//=============================================================================
// @̏
//=============================================================================
//-------------------------
// @FԑJڐ
//-------------------------
void jiki_on_magic_transition(JIKI* pJiki)
{
    // ̃t[o߂Ƃɖ߂
    if (pJiki->obj.frame_count > 20) {
        pJiki->obj.status = status_normal;

        // {^̌pZbg
        p_input_parser->trg_main_on_count = 1;
        p_input_parser->trg_main_clicked = 0;
        p_input_parser->trg_sub_on_count = 1;
        p_input_parser->trg_sub_clicked = 0;

        // ˌɏGԂ^
        pJiki->invincible = JIKI_SPECIAL_INVINCIBLE;
    }
}

//-------------------------
// @Fړ
//-------------------------
void jiki_on_magic_move(JIKI* pJiki)
{
    CHROBJ* pJikiObj = &(pJiki->obj);
    OBJPOS* pJikiPos = &(pJikiObj->pos);

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // 蔻͈̔͐ݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;

    // SP̕\p^[]ݒ
    {
        int jiki_slot = p_stage_context->jiki_sp_slot;
        int offset_idx = (p_stage_objects->frame_count >> 2) & 0x1;

        if (pJikiObj->gcol.hook == 0) {
            // ʏ̓_bVƓp^[
            stack_transfer_sp(jiki_slot, dash_pattern_offset[offset_idx], sp_code_top, 2 * 3);
        }
        else {
            // Ԃ炳莞̓Aj[V
            int anim_index = (pJikiObj->frame_count >> 4) & 3;
            stack_transfer_sp(jiki_slot, 0x42 + hook_anim[anim_index], sp_code_top, 2 * 3);
        }
    }

    // ړȂ

    // t[JEg
    pJikiObj->frame_count += 1;
}

//-------------------------
// @F`
//-------------------------
void jiki_on_magic_draw(JIKI* pJiki)
{
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    //x = pJiki->obj.pos.px;
    //y = pJiki->obj.pos.py;
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // <<< L >>>
    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // `
    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            }
            else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // I
    return;
}


//=============================================================================
// _[WmbNobN
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		void jiki_normal_transition(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki     ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		_[WmbNobN̏ԑJڐ
//--------------------------------------------------------------------
void jiki_damage_transition(JIKI* pJiki)
{
    CHROBJ* pObj = &(pJiki->obj);
    OBJPOS* pPos = &(pObj->pos);

    // U
    if (p_input_parser->trg_main_on_count > LONG_PRESS) {
        if (p_application_context->mp > 0) {
            // Ăꍇ͗߂ɓ
            pPos->ax = 0;
            pPos->ay = 0;
            pPos->vx = 0;
            pPos->vy = 0;
            pObj->status = status_charge;
            return;
        }
    }

    // ڒnʏԂ
    if ((pPos->vy >= 0) && (pObj->gcol.bottom != 0 || (pObj->gcol.hook != 0))) {
        pPos->ax = 0;
        pPos->ay = 0;
        pPos->vx = 0;
        pPos->vy = 0;
        pJiki->obj.status = status_normal;
        return;
    }
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_damage_move(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki    @IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		_[WmbNobN̎@̈ړ
//--------------------------------------------------------------------
void jiki_damage_move(JIKI* pJiki) {
    CHROBJ* pJikiObj;
    OBJPOS* pJikiPos;
    BLADE* pBlade;
    CHROBJ* pBladeObj;
    int frame_count;
    int gravity = MOVE_GRAVITY;
    GROUNDING_COLLISION* collision;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // W
    pBlade = &(p_stage_objects->blade);
    pBladeObj = &(pBlade->obj);
    pJikiObj = &(pJiki->obj);
    pJikiPos = &(pJikiObj->pos);
    frame_count = pJiki->obj.frame_count;
    collision = &(pJikiObj->gcol);

    // 蔻͈̔͐ݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;

    // -----< ړn >-----
    //
    // ͂ȂBɉēB

    // -----< ړʏ >-----
    //
    move_common(pJikiObj, 0, gravity);
    jiki_state_transition(pJikiObj, collision);

    // -----< PCG]w >-----
    //
    stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x80, sp_code_top, 6);

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_damage_draw(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki   ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void jiki_damage_draw(JIKI* pJiki) {
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // ʒu擾
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // LN^
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            }
            else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            SP_SET(sp, pos_x, y - 8 + (iy * 16), sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // I
    return;
}


//=============================================================================
// _E
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		void jiki_on_down_transition(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki     ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		_EԂł̏ԑJڐ
//--------------------------------------------------------------------
void jiki_on_down_transition(JIKI* pJiki)
{
    CHROBJ* pObj = &(pJiki->obj);
    OBJPOS* pPos = &(pObj->pos);

    // -----< t[ŏԑJ >-----
    //
    if (pJiki->obj.frame_count < JIKI_DOWN_FRAMES) {
        return;
    }

    // -----< x_E >-----
    //
	p_application_context->lv_blade -= (p_application_context->lv_blade > 0 ? 1 : 0);
    p_application_context->lv_magic -= (p_application_context->lv_magic > 0 ? 1 : 0);
    p_application_context->lv_charge -= (p_application_context->lv_charge > 0 ? 1 : 0);

    // -----< ĊJ̓Q[I[o[ >-----
    //
    if (p_application_context->left > 0) {
        // c@炵ĕ
        p_application_context->left -= 1;
        p_application_context->hp = HP_DEFAULT;
        p_application_context->mp = MP_MAX;
        pJiki->obj.status = status_normal;
        pJiki->invincible = JIKI_START_INVINCIBLE;
    }
    else {
        // c@Ȃ΃Q[I[o[
        continue_start();
    }
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_on_down_move(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki    @IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		_E̎@̈ړ
//--------------------------------------------------------------------
void jiki_on_down_move(JIKI* pJiki) {
    CHROBJ* pJikiObj;
    OBJPOS* pJikiPos;
    BLADE* pBlade;
    CHROBJ* pBladeObj;
    int frame_count;
    int gravity = MOVE_GRAVITY;
    GROUNDING_COLLISION* collision;
    int anim = (p_stage_objects->frame_count >> 5) & 1;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // W
    pBlade = &(p_stage_objects->blade);
    pBladeObj = &(pBlade->obj);
    pJikiObj = &(pJiki->obj);
    pJikiPos = &(pJikiObj->pos);
    frame_count = pJiki->obj.frame_count;
    collision = &(pJikiObj->gcol);

    // 蔻͈̔͐ݒ
    pJiki->obj.hit_bbox.x0 = -JIKI_HIT_HWIDTH;
    pJiki->obj.hit_bbox.x1 = +JIKI_HIT_HWIDTH;

    // -----< ړn >-----
    //
    // ͂ȂBɉēB
    // Gw
    pJiki->invincible = 10;  // ɖG

    // -----< ړʏ >-----
    //
    move_common(pJikiObj, 0, gravity);
    jiki_state_transition(pJikiObj, collision);

    // -----< PCG]w >-----
    //
    if (anim == 0) {
        stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x80 + 6, sp_code_top, 6);
    } else {
        stack_transfer_sp(p_stage_context->jiki_sp_slot, 0x80 + 12, sp_code_top, 6);
    }

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void jiki_on_down_draw(JIKI* pJiki)
//
//	[  ]
//		JIKI* pJiki   ΏۂJIKIւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void jiki_on_down_draw(JIKI* pJiki) {
    int ix, iy;
    int x, y;
    SP_UNIT* sp;
    int sp_index;
    int allocsp = 0;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x10;

    // ʒu擾
    x = p_stage_context->s_hx >> 8;
    y = p_stage_context->s_hy >> 8;

    // LN^
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(6);
    if (allocsp < 6) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    for (ix = 0; ix < 2; ix++) {
        for (iy = 0; iy < 3; iy++) {
            int pos_x;
            // }bvobt@Ƀf[^i[
            if (pJiki->obj.direction == dir_left) {
                // ̏ꍇSP𔽓]\
                pos_x = x + 16 - (ix * 16);
            }
            else {
                // E͒~Ȃʏ\
                pos_x = x + (ix * 16);
            }
            // 1hbgɕ`Bڒn̂߁B
            SP_SET(sp, pos_x, y - 8 + (iy * 16) + 1, sp_code_top + ((iy * 2) + ix), 5, (pJiki->obj.direction == dir_left), 0, 3);
            sp++;
        }
    }

    // I
    return;
}


//=============================================================================
// 蔻R[obN
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		void jiki_on_hit(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
//
//	[  ]
//		void* pTarget       Lւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		L_[W󂯂Ƃ̃R[obN
//--------------------------------------------------------------------
void jiki_on_hit(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
    JIKI* pJiki = pTarget;
    CHROBJ* pObj = &(pJiki->obj);
    OBJPOS* pPos = &(pObj->pos);
    int on_down = 0;

    // 
    if (pObject != NULL) {
        if (pJiki->obj.pos.hx < pObject->pos.hx) {
            // @̕ȂEɂĒe
            pJiki->obj.direction = dir_right;
        }
        else {
            // @̕EȂɂĒe
            pJiki->obj.direction = dir_left;
        }
    }

    // e
    if (pObj->direction == dir_right) {
        pPos->vx = -(2 << 8);
    }
    else {
        pPos->vx = (2 << 8);
    }
    pPos->vy = -(6 << 8);

    // ̗͌炷
    on_down = 0;
    p_application_context->hp -= ap;
    if (p_application_context->hp < 0) {
        p_application_context->hp = 0;
        on_down = 1;
    }

    // ԒlύX
    pJiki->obj.frame_count = 0;
    if (on_down) {
        pJiki->obj.status = status_on_down;

        // ʉ
        play_se(&(p_sound_context->se_item[setype_jikidown]));
    }
    else {
        pJiki->obj.status = status_damage;

        // ʉ
        play_se(&(p_sound_context->se_item[setype_jikidamage]));
    }
    pJiki->invincible = JIKI_DAMAGE_INVINCIBLE;
}
