#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"

#include "game_context.h"
#include "common.h"
#include "kon_util.h"
#include "collision.h"
#include "item.h"
#include "stage.h"

// -----< 萔` >-----
//
int item_timeout[4] = ITEM_TIMEOUT;

// -----< vg^Cv錾 >-----
//
// <<<<< _CA >>>>>
void init_dia(int item_index, int hx, int hy, int vx, int vy);	// _CAo
void init_boss_dia(int item_index, int hx, int hy, int vx, int vy);	// _CAo
void move_dia(void* pEnemy);				// slimëړ
void draw_dia(void* pEnemy);				// slime̕`揈

//--------------------------------------------------------------------
//	[  ]
//		void appear_item(ItemType type, int hx, int hy, int vx, int vy)
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		
//--------------------------------------------------------------------
void appear_item(ItemType type, int hx, int hy, int vx, int vy)
{
	int absent_index;

	// X^bN^[Qbg̃CfbNX𓾂
	absent_index = POP_IDSTACK_ITEM;
	if (absent_index < 0) {
		// 󂫂Ȃ疳
		return;
	}

	// o
	memset(&(p_stage_objects->item[absent_index]), 0, sizeof(ITEM));
	switch (type) {
	case itemtype_dia:
		// _CAo
		init_dia(absent_index, hx, hy, vx, vy);
		break;

	case itemtype_boss_dia:
		// _CAi{Xjo
		init_boss_dia(absent_index, hx, hy, vx, vy);
		break;

	default:
		// sȎ
		PUSH_IDSTACK_ITEM(absent_index);
		kon_log("sȃACeʂw肳܂Btype=%d\n", type);
		break;
	}

	// I
	return;
}

//=============================================================================
// ACȅ
//=============================================================================
void on_hit_item(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ITEM* pItem = pTarget;

	// ACe
	pItem->obj.status = status_absent;

	// XRAZ
	add_digit(p_application_context->score, SCORE_DIGITS, 2, 1);	// 10^2 ̌ 1Zi100_j

	// |CgZ
	switch (pItem->lv) {
	case 0:
		add_digit(p_application_context->point, POINT_DIGITS, 1, 1);	// 10^1 ̌ 1Zi10ptj
		break;
	case 1:
		add_digit(p_application_context->point, POINT_DIGITS, 1, 2);	// 10^1 ̌ 2Zi20ptj
		break;
	case 2:
		add_digit(p_application_context->point, POINT_DIGITS, 1, 3);	// 10^1 ̌ 3Zi30ptj
		break;
	case 3:
		add_digit(p_application_context->point, POINT_DIGITS, 1, 5);	// 10^1 ̌ 5Zi50ptj
		break;
	case 4:
		add_digit(p_application_context->point, POINT_DIGITS, 1, 7);	// 10^1 ̌ 7Zi70ptj
		break;
	case 5:
		add_digit(p_application_context->point, POINT_DIGITS, 2, 1);	// 10^2 ̌ 1Zi100ptj
		break;
	case 99:
		// {Xo_CÃx
		add_digit(p_application_context->point, POINT_DIGITS, 2, 3);	// 10^2 ̌ 3Zi300ptj
		break;
	default:
		kon_log("on_hit_item : R{xɑzO̒lw肳܂Blv=%d\n", pItem->lv);
		break;
	}

	// R{Q[W񕜂
	p_stage_objects->combo_timeout += (COMBO_TIMEOUT >> 3);
	if (p_stage_objects->combo_timeout > COMBO_TIMEOUT) {
		p_stage_objects->combo_timeout = COMBO_TIMEOUT;
	}

	// X^bNIDԂ
	dispose_item(pItem);

	// ʉ
	play_se(&(p_sound_context->se_item[setype_item]));
}

//=============================================================================
// {XACȅ
//=============================================================================
void on_hit_boss_item(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ITEM* pItem = pTarget;
	if ((pItem->obj.pos.vy < 0) && (pItem->obj.gcol.bottom == 0)) {
		// ㏸͎Ȃ
		return;
	}

	// юUƂ͓
	on_hit_item(hittype, pTarget, pObject, ap);
}

//=============================================================================
// _CAo
//=============================================================================
void init_dia(int item_index, int hx, int hy, int vx, int vy)
{
	ITEM* pItem;
	CHROBJ* pObj;
	OBJPOS* pPos;

	// o̍\̂𓾂
	pItem = &(p_stage_objects->item[item_index]);
	pObj = &(pItem->obj);
	pPos = &(pObj->pos);
	memset(pItem, 0, sizeof(ITEM));

	// zEXg
	pItem->obj.array_index = item_index;	// z̃CfbNXlۑ
	// NXg̐擪ɍ
	if (p_stage_objects->item_top != NULL) {
		p_stage_objects->item_top->p_prev = pItem;
	}
	pItem->p_next = p_stage_objects->item_top;
	p_stage_objects->item_top = pItem;

	// 蔻͈͂ݒ
	pObj->grd_bbox.x0 = -4;
	pObj->grd_bbox.x1 = +4;
	pObj->grd_bbox.y0 = -1;
	pObj->grd_bbox.y1 = +7;

	// G̍UE_[W蔻͈͂ݒ
	pObj->hit_bbox.x0 = -4;
	pObj->hit_bbox.x1 = +4;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +7;

	// ^Cvݒ
	pItem->type = itemtype_dia;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = MOVE_GRAVITY;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = hx >> 8;
	pPos->py = hy >> 8;
	pItem->obj.prev_pos = pItem->obj.pos;	// Ot[ʒut[ʒu

	// Ԃݒ肷
	pItem->obj.status = status_normal;	// WvԂ

	// lݒ
	pItem->lv = p_stage_objects->combo_lv;	// ACex=R{x
	pItem->timeout = item_timeout[p_game_properties->game_level];

	// ݒ
	pItem->obj.move = move_dia;			// ړ֐
	pItem->obj.draw = draw_dia;			// `֐
	pItem->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	pItem->obj.on_hit = on_hit_item;	// ACȅ

	return;
}

//=============================================================================
// _CAi{Xjo
//=============================================================================
void init_boss_dia(int item_index, int hx, int hy, int vx, int vy)
{
	ITEM* pItem;
	CHROBJ* pObj;
	OBJPOS* pPos;

	// o̍\̂𓾂
	pItem = &(p_stage_objects->item[item_index]);
	pObj = &(pItem->obj);
	pPos = &(pObj->pos);
	memset(pItem, 0, sizeof(ITEM));

	// zEXg
	pItem->obj.array_index = item_index;	// z̃CfbNXlۑ
	// NXg̐擪ɍ
	if (p_stage_objects->item_top != NULL) {
		p_stage_objects->item_top->p_prev = pItem;
	}
	pItem->p_next = p_stage_objects->item_top;
	p_stage_objects->item_top = pItem;

	// 蔻͈͂ݒ
	pObj->grd_bbox.x0 = -7;
	pObj->grd_bbox.x1 = +7;
	pObj->grd_bbox.y0 = -7;
	pObj->grd_bbox.y1 = +7;

	// G̍UE_[W蔻͈͂ݒ
	pObj->hit_bbox.x0 = -7;
	pObj->hit_bbox.x1 = +7;
	pObj->hit_bbox.y0 = -7;
	pObj->hit_bbox.y1 = +7;

	// ^Cvݒ
	pItem->type = itemtype_boss_dia;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = MOVE_GRAVITY;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = hx >> 8;
	pPos->py = hy >> 8;
	pItem->obj.prev_pos = pItem->obj.pos;	// Ot[ʒut[ʒu

	// Ԃݒ肷
	pItem->obj.status = status_normal;	// WvԂ

	// lݒ
	pItem->lv = 99;			// ACex=R{xŒ
	pItem->timeout = 65535;	// 

	// ݒ
	pItem->obj.move = move_dia;			// ړ֐
	pItem->obj.draw = draw_dia;			// `֐
	pItem->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	pItem->obj.on_hit = on_hit_boss_item;	// ACȅ

	return;
}


//=============================================================================
// _CÄړ
//=============================================================================
void move_dia(void* pTarget)
{
	ITEM* pItem = (ITEM*)pTarget;
	CHROBJ* pObj = &(pItem->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړʏ
	//
	if (pObj->gcol.bottom == 0) {
		// nȂ
		move_common(pObj, 0, MOVE_GRAVITY);
	}
	else {
		pObj->frame_count += 1;
	}

	// BGbVɔzuʊO肷
	collision_put_bgmesh_item(&(pItem->obj));

	// t[ŏ
	if (pObj->frame_count > pItem->timeout) {
		dispose_item(pItem);
	}

	// I
	return;
}


//=============================================================================
// _CA̕`揈
//=============================================================================
void draw_dia(void* pTarget)
{
	ITEM* pItem = (ITEM*)pTarget;
	CHROBJ* pObj = &(pItem->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = 6;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x3F;

	// ʊOȂ`悹ɏI
	if (pObj->out_of_screen) {
		return;
	}

	// t[߂_
	if (pObj->frame_count > (pItem->timeout - 100)) {
		if ((pObj->frame_count >> 1) & 1) {
			// 2t[1͕\Ȃ
			return;
		}
	}

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 3) & 1;

	// LN^̃XN[W
	px = (pPos->hx - p_stage_context->bgview_hx) >> 8;
	py = (pPos->hy - p_stage_context->bgview_hy) >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + anim, pal + (pItem->lv>=4), 0, 0, 3);
	sp++;

	return;
}
