#define __SHOP_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "kon_util.h"
#include "game_context.h"
#include "common.h"
#include "../devs/devs.h"
#include "stage.h"
#include "shop.h"
#include "jiki.h"

// <<< vg^Cv錾 >>>
// ReBj[
void continue_countdown(int status);	// ReBj[̃JEg_E
void do_continue();						// ReBj[s
// Q[I[o[
void gameover_start();					// Q[I[o[̏ݒ
void gameover_in(int status);			// Q[I[o[̃gWV
void gameover_main(int status);			// Q[I[o[
void gameover_close(int status);		// Q[I[o[̃N[YgWV

// <<< O[oϐ >>>
int continue_yes_no = 1;

//--------------------------------------------------------------------
//	[  ]
//		void continue_start()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ReBj[tJn
//--------------------------------------------------------------------
void continue_start()
{
	// Ԓl
	p_stage_context->stage_mode = STAGE_MODE_CONTINUE;
	p_stage_context->status = 0;
	p_stage_context->status_count = (12 * 60);	// ReBj[̃JEg{2b
	continue_yes_no = 1;
}

//--------------------------------------------------------------------
//	[  ]
//		int continue_move(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		Vbv̉Z
//--------------------------------------------------------------------
int continue_move(int status)
{
	switch (p_stage_context->status) {
	case 0:
		continue_countdown(status);
		break;
	}

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int continue_countdown(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		VbvɓƂ̃}XN
//--------------------------------------------------------------------
void continue_countdown(int status)
{
	// JEg_E
	if (p_stage_context->status_count > 0) {
		p_stage_context->status_count -= 1;
	}

	// YES/NOI
	if (p_input_parser->stick_in_count == 1) {
		if (p_memory_map_buffer->input_unit.bit.left) {
			continue_yes_no = 1;
		}
		if (p_memory_map_buffer->input_unit.bit.right) {
			continue_yes_no = 0;
		}

		// ʉ
		play_se(&(p_sound_context->se_item[setype_cursor]));
	}

	// tJn
	if (p_stage_context->status_count <= ((10 * 60) - 1)) {
		// {^NbN
		if (p_input_parser->trg_main_clicked) {
			if (continue_yes_no == 0) {
				// Q[I[o[
				p_stage_context->status_count = 0;
			}
			else {
				// ReBj[
				do_continue();
			}

			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursorok]));
		}
	}
	else {
		// {^NbN
		if (p_input_parser->trg_main_clicked) {
			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursorng]));
		}
	}

	// JEg[ɂȂQ[I[o[
	if (p_stage_context->status_count <= 0) {
		gameover_start();
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void do_continue()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ReBj[s
//--------------------------------------------------------------------
void do_continue()
{
	// [h߂
	p_stage_context->stage_mode = STAGE_MODE_NORMAL;

	// c@𑫂
	p_application_context->left = p_game_properties->life;
	p_stage_objects->jiki.obj.status = status_normal;
	p_stage_objects->jiki.invincible = JIKI_START_INVINCIBLE;
	p_application_context->hp = HP_DEFAULT;
	p_application_context->mp = MP_MAX;

	// XRA1
	add_digit(p_application_context->score, SCORE_DIGITS, 0, 1);

	// ReBj[񐔂JEg
	p_application_context->cont += 1;

	// p[Abvݒ
	if (p_application_context->lv_blade < 3) { p_application_context->lv_blade = 3; }
	if (p_application_context->lv_charge < 3) { p_application_context->lv_charge = 3; }
	if (p_application_context->lv_magic < 3) { p_application_context->lv_magic = 3; }
}

//--------------------------------------------------------------------
//	[  ]
//		void continue_draw(int status)
//
//	[  ]
//		int status
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ReBj[̕`揈
//--------------------------------------------------------------------
void continue_draw(int status)
{
	SP_UNIT* pSpUnit;
	int allocsp;
	int count;
	int x;
	int on_wait;
	int cursor_spcode_def[MAX_STAGE] = { 0x45, 0x45, 0x45 , 0x35 , 0x45 , 0x45 };
	int cursor_spcode;
	pSpUnit = &(p_memory_map_buffer->sp_unit[p_stage_objects->sp_index_seq]);
	cursor_spcode = cursor_spcode_def[p_stage_context->stage - 1];

	// <<< JEg_E\ >>>
	//
	on_wait = 0;
	count = p_stage_context->status_count / 60;
	if (count > 9) {
		on_wait = 1;
		count = 9;
	}
	if ((on_wait == 0)
		|| ((p_application_context->frame_count >> 1) & 1)) {
		allocsp = sp_alloc_index(1);
		// JEg\
		SP_SET(pSpUnit, 140, 102, cursor_spcode + 1 + (count), 5, 0, 0, 3);
		pSpUnit++;
	}

	// <<< YesNoJ[\\ >>>
	//
	allocsp = sp_alloc_index(1);
	x = 128;
	if (continue_yes_no == 0) {
		x += 23;
	}
	else {
		x -= 38;
	}
	SP_SET(pSpUnit, x, 119, cursor_spcode, 5, 0, 0, 3);
	pSpUnit++;

	// <<< Xe[W̒ʏ̕` >>>
	//
	stage_draw();

	// <<< OtBbNʂ̃XN[ >>>
	//
	p_memory_map_buffer->grp_scroll_unit.sc3_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 256;
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_start()
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Vbv̉Z
//--------------------------------------------------------------------
void gameover_start()
{
	GRP_SCRL_UNIT* pGrp = &(p_memory_map_buffer->grp_scroll_unit);

	// Ԓl
	p_stage_context->stage_mode = STAGE_MODE_GAMEOVER;
	p_stage_context->status = 0;
	p_stage_context->status_count = 0;

	// }XNʒuꉞ
	pGrp->sc0_x = 0;
	pGrp->sc0_y = 0;
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_move(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Vbv̉Z
//--------------------------------------------------------------------
void gameover_move(int status)
{
	switch (p_stage_context->status) {
	case 0:
		gameover_in(status);
		break;

	case 1:
		gameover_main(status);
		break;

	case 2:
		gameover_close(status);
		break;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_in(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[I[o[̃gWV̉Z
//--------------------------------------------------------------------
void gameover_in(int status)
{
	// XN[
	p_stage_context->status_count += 4;
	if (p_stage_context->status_count > 256) {
		p_stage_context->status_count = 256;
	}

	// gWVI玟
	if (p_stage_context->status_count == 256) {
		p_stage_context->status = 1;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_main(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[I[o[̃gWV̉Z
//--------------------------------------------------------------------
void gameover_main(int status)
{
	// L[͂󂯕tgWV
	if (p_input_parser->trg_main_clicked) {
		p_stage_context->status = 2;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_close(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Q[I[o[̃gWV̉Z
//--------------------------------------------------------------------
void gameover_close(int status)
{
	// OtBbNʂXN[
	p_stage_context->mask_pos += MASK_SCROLL_SPEED;
	if (p_stage_context->mask_pos >= 512) {
		p_stage_context->mask_pos = 512;
	}

	// XN[II
	if (p_stage_context->mask_pos == 512) {
		// gWVI
		p_stage_context->exit_code = STAGE_EXIT_GAMEOVER;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void gameover_draw(int status)
//
//	[  ]
//		int status	sJñXe[^Xl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Vbv̉Z
//--------------------------------------------------------------------
void gameover_draw(int status)
{
	// <<< Xe[W̒ʏ̕` >>>
	//
	stage_draw();

	// <<< OtBbNʂ̃XN[ >>>
	//
	stage_scroll_mask();
	p_memory_map_buffer->grp_scroll_unit.sc3_x = p_stage_context->status_count;
	p_memory_map_buffer->grp_scroll_unit.sc3_y = 256;
}
