#ifndef __GAME_CONTEXT__
#define __GAME_CONTEXT__

#include "../devs/memory_map_buffer.h"
#include "constants.h"
#include "structs.h"

//====================================================================
// 萔`
//====================================================================
#ifdef __KONCORE_C__
const char* startup_error_message[] = {
    "success."
    , "p[^̒lw肳Ă܂BIvV=[%s]"
    , "p[^̒l͐Ŏw肵ĂBIvV=[%s], w肳ꂽl=[%s]"
    , "%d  %d ̊Ԃ̒lw肵ĂBIvV=[%s], w肳ꂽl=[%d]"
    , "m̃IvVw肳܂BIvV=[%s]"
};
#else
extern const char* startup_error_message[];
#endif

//====================================================================
// }N`
//====================================================================
//
// wʒuBG̃p^[`擾
//
#define GET_BG_ATTRIBUTE(   PAGE, X, Y) (p_stage_context->bg_pworld_yindex[PAGE][Y][X]);
#define GET_BG_ATTRIBUTE_SC(PAGE, X, Y) (p_stage_context->bg_pworld_yindex[PAGE][(Y>>3)][(X>>3)]);
//
// SP
//
#define SP_SET(SPPTR, POS_X, POS_Y, SPCODE, PALBLOCK, H_REV, V_REV, PRW)    {   \
	SPPTR->x = (POS_X);  \
    SPPTR->y = (POS_Y);  \
    SPPTR->code.bit.code = (SPCODE); \
    SPPTR->code.bit.color = (PALBLOCK); \
    SPPTR->code.bit.h_rev = (H_REV); \
    SPPTR->code.bit.v_rev = (V_REV); \
    SPPTR->prw = PRW;    \
}


//====================================================================
// Q[ReLXg
//====================================================================
//--------------------------------------------------------------------
// Application context.
//--------------------------------------------------------------------
typedef struct _APPLICATION_CONTEXT {
    // <<< VXen̑ >>>
    int SSP;    // X[p[oCU[h

    // <<< Q[Ŝ̑ >>>
    // XRA
    int score[SCORE_DIGITS];
    // pt
    int point[POINT_DIGITS];
    // c@
    int left;		// c@
    int cont;       // ReBj[
    int left_buy_count; // c@w

    // 
    int	hp;
    int mp;
    // p[Abvx
    int lv_blade;	// u[h̃x
    int lv_magic;	// @̃x
    int lv_charge;	// `[Wx̃x

    // {`[W
    int bomb_charge;

    // <<< ptO >>>
    int quit_requested;
    int grp_already_read;   // GRPǂݍݍ

    // <<< t[JE^ >>>
    int frame_count;
} APPLICATION_CONTEXT;

//--------------------------------------------------------------------
// Xe[WɊւ\
//--------------------------------------------------------------------
typedef enum _StageMode {
    STAGE_MODE_NORMAL = 0   // ʏ
    , STAGE_MODE_SHOP       // Vbv
    , STAGE_MODE_CONTINUE   // ReBj[t
    , STAGE_MODE_GAMEOVER   // Q[I[o[
    , STAGE_MODE_BOMB       // BOMB
} StageMode;

typedef enum _StageExitCode {
    STAGE_EXIT_NOP  = 0     // Xe[WIĂȂ
    , STAGE_EXIT_CLEAR      // Xe[WNA
    , STAGE_EXIT_GAMEOVER   // Q[I[o[
    , STAGE_EXIT_ENDING     // GfBO
} StageExitCode;

typedef struct _STAGE_CONTEXT {
    // Xe[Wԍ
    int stage;                  // Xe[Wԍi1`5j
    int section;                // Xe[W̃ZNVԍi1`5j

    int on_clear_move;          // NA[ûƂ1, Xe[WNÂƂ2
    StageMode stage_mode;       // Xe[W̓샂[h
    StageExitCode exit_code;    // IR[h
    int status;                 // Xe[^Xlig͏ʂɂĈقȂj
    int status_count;           // Xe[^X̃JE^
                                // intermission̏ꍇ 0: 1:I
    //
    int second_counter;         // 1bނ߂̃JE^i0`591Zj

    // SP, BG̒`̈̓ǂݍݐ
    int cmn_sp_top;  // SP̒`̈̐擪R[hԍ
    int ene_sp_top;     // GSP̒`̈̐擪R[hԍ

    // PCG̓]pf[^Xbgԍ
    int jiki_sp_slot;   // LSP]f[^̃Xbgԍ
    int boss_sp_slot;   // {XLSP]f[^̃Xbgԍ
    int ene_sp_slot;    // GLSP]f[^̃Xbgԍ
    int boss_pal_stot;  // {X̃pbgXbg
    // eLXgʂ̃pbg̃f[^Xbg֘Aԍ
    int text_pal_slot;  // eLXg̃pbgXbg
    int text_pal_block; // wĩpbgubN
    int shop_pal_block; // SHOP̃pbgubN
    int int_pal_block;  // C^[~bṼpbgubN

    // BG}bvf[^
    int bgmap_pages;            // BG}bvy[W
    int bgmap_width;            // BG}bv
    int bgmap_height;           // BG}bv
    BG_DEF_UNIT** bg_map;       // BG̃}bvf[^
    BG_DEF_UNIT*** bg_map_yindex; // BG̃}bvf[^YCfbNX : bg_map_yindex[page][Y]=(BG_DEF_UNITւ̃|C^)
    unsigned char** bg_pworld;  // BG̕ǁEp[h
    unsigned char*** bg_pworld_yindex;    // p[hYCfbNX : bg_pworld_index[page][Y] = (unsigned charւ̃|C^j
    int bgmap_anim_sp_slot;     // BGAj̃Xbg

    // BG̃XN[ʒu
    int pworld_page;            // p[h}bṽy[Wԍ
    int bgview_hx;               // BGXN[ʒu
    int bgview_hy;
    int prev_bgview_hx;          // Ot[BGXN[ʒu
    int prev_bgview_hy;

    // BG`̈
    BBOX bg_redraw_x; // XړɊւp^[̈
    BBOX bg_redraw_y; // YړɊւp^[̈

    // Xe[Ẅړ\GA
    BBOX stage_clipping_area;   // Xe[Ẅړ\GA
    BBOX enemy_appear_area;     // G̏o\GA

    // L̕\ʒuڕWW
    int s_tx;
    int s_ty;
    // L̕\ʒuڕWWɌJ[\
    int s_cursor_x;
    int s_cursor_y;
    // L̃XN[W
    int s_hx;
    int s_hy;

    // }XNXN[ʒu 0`512
    // mask_pos<256̂ƂAGRP0YW=0, mask_pos>=256̂ƂGRP0YW=256
    int mask_pos;

    // Xe[W̑`
    STAGE_DESC stage_desc[STAGE_DESC_LINES];

    // Xe[WIuWFNg
    STAGE_OBJECTS stage_objects;

    // Xe[WCxg
    void (*scroll_txt)();
    void (*event)();
    void (*section_clear_event)(int next_section);
} STAGE_CONTEXT;


//--------------------------------------------------------------------
// eݒ
//--------------------------------------------------------------------
typedef struct _GAME_PROPERTIES {
    // 1t[ŋep^[̃Zbg
    int transsp_max_per_frame;
    int transpal_max_per_frame;

    // ֘A
    int disable_sound;  // ̍Đ֎~Ƃ1w

    // Փx
    int game_level;     // 0:EASY  1:NOVICE  2:NORMAL  3:HARD

    // LIFE
    int life;           // Jn̎c@

    // gK]tO
    int reverse_trigger;    // 0:ʏ 1:]

    // xݒ
    int XVI;            // XVIȏ̑xꍇ1ݒ
} GAME_PROPERTIES;


//--------------------------------------------------------------------
// TEhɊւReLXg
//--------------------------------------------------------------------
typedef struct _SOUND_COUNTEXT {
    // <<< BGM >>>
    // resource
    int bgm_index[bgmtype_count + MAX_SECTION];

    // <<< SE resource >>>
    // resource
    SE_ITEM se_item[setype_count];
    // read state
    int se_already_read;    // SEǂݍݍ
    // SE playing control.
    int se_play_priority;   // ĐSE̗Dx
    int se_play_timeout;    // ĐSẼ^CAEg
} SOUND_CONTEXT;

//====================================================================
// Q[Ŝ̃ReLXg
//====================================================================
typedef struct _GAME_CONTEXT {
    // eݒ
    GAME_PROPERTIES game_properties;

    // AvP[VReLXg
    APPLICATION_CONTEXT application_context;

    // Xe[WReLXg
    STAGE_CONTEXT stage_context;

    // TEhReLXg
    SOUND_CONTEXT sound_context;

    // }bvobt@
    MEMORY_MAP_BUFFER memory_map_buffer;
} GAME_CONTEXT;

//====================================================================
// O[oϐ`
//====================================================================
#ifdef __KONCORE_C__
STARTUP_PARAM        startup_param;    // Np[^
RESOURCE_CONF        resource_conf;    // \[Xݒl
GAME_CONTEXT         game_context;     // Q[Ŝ̃ReLXg
GAME_PROPERTIES*     p_game_properties = &(game_context.game_properties); // eݒ
APPLICATION_CONTEXT* p_application_context = &(game_context.application_context);  // AvP[VReLXg
STAGE_CONTEXT*       p_stage_context = &(game_context.stage_context);        // Xe[WReLXg
STAGE_OBJECTS* p_stage_objects = &(game_context.stage_context.stage_objects); // Xe[W̃IuWFNgz
SOUND_CONTEXT* p_sound_context = &(game_context.sound_context); // TEhReLXgւ̃|C^
INPUT_PARSER* p_input_parser = &(game_context.stage_context.stage_objects.input_parser); // ̓p[T
MEMORY_MAP_BUFFER*   p_memory_map_buffer = &(game_context.memory_map_buffer);    // }bv
#else
extern STARTUP_PARAM        startup_param;          // Np[^
extern RESOURCE_CONF        resource_conf;          // \[Xݒl
extern GAME_CONTEXT         game_context;           // Q[Ŝ̃ReLXg
extern GAME_PROPERTIES*     p_game_properties;      // eݒ
extern APPLICATION_CONTEXT* p_application_context;  // AvP[VReLXg
extern STAGE_CONTEXT*       p_stage_context;        // Xe[WReLXg
extern STAGE_OBJECTS*       p_stage_objects;        // Xe[W̃IuWFNgz
extern SOUND_CONTEXT*       p_sound_context;        // TEhReLXg
extern INPUT_PARSER*        p_input_parser;         // ͏ԃp[T
extern MEMORY_MAP_BUFFER*   p_memory_map_buffer;    // }bv
#endif

#endif
