#define __EXPLODE_C__
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "explode.h"
#include "stage.h"

// vg^Cv錾
// F
void exp_init(void* pTarget, int array_index, int hx, int hy, int velocity);	// 
void exp_move(void* pTarget);	// ړ֐ւ̃|C^
void exp_draw(void* pTarget);	// `֐ւ̃|C^

// F
void expbig_init(void* pTarget, int array_index, int hx, int hy, int velocity);	// 
void expbig_move(void* pTarget);	// ړ֐ւ̃|C^
void expbig_draw(void* pTarget);	// `֐ւ̃|C^

// F
void expbigblue_init(void* pTarget, int array_index, int hx, int hy, int velocity);	// 
void expbigblue_move(void* pTarget);	// ړ֐ւ̃|C^
void expbigblue_draw(void* pTarget);	// `֐ւ̃|C^

//--------------------------------------------------------------------
//	[  ]
//		void appear_exp(ExplodeType type, int hx, int hy, int velocity)
//
//	[  ]
//      ExplodeType type    
//      int px              ʒuX
//      int py              ʒuY
//		int velocity		XY_̍ő呬x
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o
//--------------------------------------------------------------------
void appear_exp(ExplodeType type, int hx, int hy, int vel)
{
    //int i;
	int index;
    EXPLODE* pExplode;

    index = POP_IDSTACK_EXPLODE;
    if (index < 0) {
        // 󂫂牽Ȃ
        return;
    }
    pExplode = &(p_stage_objects->explode[index]);

    switch (type) {
    case exptype_small:
        // ij
        exp_init(pExplode, index, hx, hy, vel);
        break;
    case exptype_big:
        // ij
        expbig_init(pExplode, index, hx, hy, vel);
        break;
    case exptype_bigblue:
        // ij
        expbigblue_init(pExplode, index, hx, hy, vel);
        break;
    default:
        // zÕ^Cvw肳ꂽ
        kon_log("appear_exp : sȃ^Cvw肳܂Btype=%d\n", type);
        PUSH_IDSTACK_EXPLODE(index);
        return;
        break;
    }

    // Nq
    pExplode->p_next = p_stage_objects->explode_top;
    if (pExplode->p_next != NULL) {
        pExplode->p_next->p_prev = pExplode;
    }
    p_stage_objects->explode_top = pExplode;

    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void exp_init(void* pTarget, int hx, int hy, int velocity)
//
//	[  ]
//		void* pTarget       IuWFNgւ̃|C^
//      int hx              ʒuX
//      int hy              ʒuY
//		int velocity		XY_̍ő呬x
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		̏
//--------------------------------------------------------------------
void exp_init(void* pTarget, int array_index, int hx, int hy, int vel)
{
    EXPLODE* pExplode = pTarget;
    CHROBJ* pObj = &(pExplode->obj);
    OBJPOS* pPos = &(pObj->pos);
    memset(pTarget, 0, sizeof(EXPLODE));

    // \bh蓖
    pObj->move = exp_move;           // ړ֐
    pObj->draw = exp_draw;           // `֐

    // ʒuݒ
    pPos->hx = hx;
    pPos->hy = hy;
    pPos->px = hx >> 8;
    pPos->py = hy >> 8;
    pObj->prev_pos = pObj->pos;

	// xݒF255܂ł̗ɑxāA256ŊB
    pPos->vx = (((vrand()&0xFF)-127) * vel) >> 8;
    pPos->vy = (((vrand()&0xFF)-127) * vel) >> 8;

    // Ԓl
    pObj->status = status_normal;   // ʏ
    pObj->frame_count = 0;
    pObj->array_index = array_index;

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void exp_move(void* pTarget)
//
//	[  ]
//		void* pTarget   IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		̈ړ
//--------------------------------------------------------------------
void exp_move(void* pTarget) {
    EXPLODE* pExplode;
    CHROBJ* pObj;
    int idx;

    // W
    pExplode = pTarget;
    pObj = &(pExplode->obj);

    // `p^[̃CfbNX𓾂
    idx = (pObj->frame_count >> 3);
    if (idx >= 5) {
        // őt[𒴂
        pObj->status = status_absent;
        pObj->frame_count = 0;

        // IDX^bNɕԋp
        PUSH_IDSTACK_EXPLODE(pObj->array_index);

        // NqȂ
        if (pExplode->p_prev != NULL) {
            pExplode->p_prev->p_next = pExplode->p_next;
        }
        if (pExplode->p_next != NULL) {
            pExplode->p_next->p_prev = pExplode->p_prev;
        }
        // 擪ȂgbvXV
        if (pExplode->p_prev == NULL) {
            p_stage_objects->explode_top = pExplode->p_next;
        }
        return;
    }
    pObj->anim_index = idx;

    // ړʏ
    move_common(pObj, 0, 0);

    // t[JEg𓮂
    pObj->frame_count += 1;

    // I
    return;
}

//--------------------------------------------------------------------
//	[  ]
//		void exp_draw(void* pTarget)
//
//	[  ]
//		void* pTarget   ΏۂEXOLODEւ̃|C^
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void exp_draw(void* pTarget) {
    EXPLODE* pExplode;
    CHROBJ* pObj;
    SP_UNIT* sp;
    int hx, hy;
    int px, py;
    int sp_index;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x2A;

    pExplode = pTarget;
    pObj = &(pExplode->obj);

    // LN^̃XN[W
    hx = (pObj->pos.hx - p_stage_context->bgview_hx);
    hy = (pObj->pos.hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // LN^
    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    //SP_SET(sp, px + 8, py + 8, sp_code_top + 0x00 + pObj->anim_index, 7, 0, 0, 3);
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x00 + pObj->anim_index, 6, 0, 0, 3);

    return;
}


//=============================================================================
// ij 
//=============================================================================
void expbig_init(void* pTarget, int array_index, int hx, int hy, int vel)
{
    EXPLODE* pExplode = pTarget;
    CHROBJ* pObj = &(pExplode->obj);
    OBJPOS* pPos = &(pObj->pos);
    memset(pExplode, 0, sizeof(EXPLODE));

    // ʒuw
    pPos->hx = hx;
    pPos->hy = hy;
    pPos->px = hx >> 8;
    pPos->py = hy >> 8;

    // xݒF255܂ł̗ɑxāA256ŊB
    pPos->vx = (((vrand() & 0xFF) - 127) * vel) >> 8;
    pPos->vy = (((vrand() & 0xFF) - 127) * vel) >> 8;

    // lݒ
    pObj->status = status_normal;
    pObj->array_index = array_index;

    // ֐ݒ
    pObj->move = expbig_move;
    pObj->draw = expbig_draw;

    // I
    return;
}

//=============================================================================
// ij ړ
//=============================================================================
void expbig_move(void* pTarget)
{
    EXPLODE* pExplode = (EXPLODE*)pTarget;
    CHROBJ* pObj = &(pExplode->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // t[ŏI
    if (pObj->frame_count >= (1<<3) * 4) {
        pObj->status = status_absent;
        dispose_explode(pExplode);
    }

    // I
    pObj->anim_index = (pObj->frame_count >> 3) & 3;
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// ij `
//=============================================================================
void expbig_draw(void* pTarget)
{
    EXPLODE* pExplode = (EXPLODE*)pTarget;
    CHROBJ* pObj = &(pExplode->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;
    int pattern;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x2A;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(4);
    if (allocsp < 4) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    pattern = sp_code_top + 0x05 + (pObj->anim_index << 2);
    SP_SET(sp, px, py, pattern + 0, 7, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py, pattern + 1, 7, 0, 0, 3);
    sp++;
    SP_SET(sp, px, py + 16, pattern + 2, 7, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py + 16, pattern + 3, 7, 0, 0, 3);
    sp++;

    // I
    return;
}


//=============================================================================
// ij 
//=============================================================================
void expbigblue_init(void* pTarget, int array_index, int hx, int hy, int vel)
{
    EXPLODE* pExplode = pTarget;
    CHROBJ* pObj = &(pExplode->obj);
    OBJPOS* pPos = &(pObj->pos);
    memset(pExplode, 0, sizeof(EXPLODE));

    // ʒuw
    pPos->hx = hx;
    pPos->hy = hy;
    pPos->px = hx >> 8;
    pPos->py = hy >> 8;

    // xݒF255܂ł̗ɑxāA256ŊB
    pPos->vx = (((vrand() & 0xFF) - 127) * vel) >> 8;
    pPos->vy = (((vrand() & 0xFF) - 127) * vel) >> 8;

    // lݒ
    pObj->status = status_normal;
    pObj->array_index = array_index;

    // ֐ݒ
    pObj->move = expbigblue_move;
    pObj->draw = expbigblue_draw;

    // I
    return;
}

//=============================================================================
// ij ړ
//=============================================================================
void expbigblue_move(void* pTarget)
{
    EXPLODE* pExplode = (EXPLODE*)pTarget;
    CHROBJ* pObj = &(pExplode->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // t[ŏI
    if (pObj->frame_count >= (1 << 3) * 4) {
        pObj->status = status_absent;
        dispose_explode(pExplode);
    }

    // I
    pObj->anim_index = (pObj->frame_count >> 3) & 3;
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// ij `
//=============================================================================
void expbigblue_draw(void* pTarget)
{
    EXPLODE* pExplode = (EXPLODE*)pTarget;
    CHROBJ* pObj = &(pExplode->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;
    int pattern;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x2A;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(4);
    if (allocsp < 4) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    pattern = sp_code_top + 0x05 + (pObj->anim_index << 2);
    SP_SET(sp, px, py, pattern + 0, 6, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py, pattern + 1, 6, 0, 0, 3);
    sp++;
    SP_SET(sp, px, py + 16, pattern + 2, 6, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py + 16, pattern + 3, 6, 0, 0, 3);
    sp++;

    // I
    return;
}
