#define __ESP_C__
#include <string.h>
#include <stdlib.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "esp.h"
#include "stage.h"

// 萔`
// "x"SPR[h
int esp_x_spcode[MAX_STAGE] = { 0xA0, 0x3F, 0x3F, 0xB0, 0xB8, 0x3F };

// vg^Cv錾
// 
void esp_init_common(void* pTarget, ESPType type, int array_index, int hx, int hy, int vx, int vy, void* func_move, void* func_draw, void* func_grounding);

// 
void esp_move_smoke(void* pTarget);
void esp_draw_smoke(void* pTarget);

// ij
void esp_move_bigsmoke(void* pTarget);
void esp_draw_bigsmoke(void* pTarget);

// ij
void esp_move_explode(void* pTarget);
void esp_draw_explode(void* pTarget);

// iFj
void esp_move_blueexp(void* pTarget);
void esp_draw_blueexp(void* pTarget);

// R{x\
void esp_move_clv(void* pTarget);
void esp_draw_clv(void* pTarget);

// n[gi|Cgj
void esp_move_heart(void* pTarget);
void esp_draw_heart(void* pTarget);

// Ȃ
void esp_move_oinari(void* pTarget);
void esp_draw_oinari(void* pTarget);

// GU\
void esp_move_eneshotmark(void* pTarget);
void esp_draw_eneshotmark(void* pTarget);

// U˕Ԃ̃GtFNg
void esp_move_spark(void* pTarget);
void esp_draw_spark(void* pTarget);

// {Xo̐}[ÑGtFNg
void esp_move_bossstar(void* pTarget);
void esp_draw_bossstar(void* pTarget);

// XgESP
void esp_move_last(void* pTarget);
void esp_draw_last(void* pTarget);

// KX̔j
void esp_move_glass(void* pTarget);
void esp_draw_glass(void* pTarget);

// XĝȂ
void esp_move_lastoinari(void* pTarget);

//=============================================================================
// 
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		ESP* appear_esp_rnd(ESPType type, int hx, int hy, int velocity)
//
//	[  ]
//      int hx              ʒuX
//      int hy              ʒuY
//		int velocity		XY_̍ő呬x
//
//	[ ߂l ]
//		ESPւ̃|C^
//
//	[  ]
//		ESPo
//--------------------------------------------------------------------
ESP* appear_esp_rnd(ESPType type, int hx, int hy, int velocity)
{
    ESP* pESP;
    // 
    int theta = vrand() & VARY_TABLE_MASK;
    int vx = (velocity * vcos[theta]) >> 8;
    int vy = (velocity * vsin[theta]) >> 8;

    // pX
    pESP = appear_esp_vec(type, hx, hy, vx, vy);
    return pESP;
}

//--------------------------------------------------------------------
//	[  ]
//		ESP* appear_esp_vec(ESPType type, int hx, int hy, int vx, int vy)
//
//	[  ]
//      int hx              ʒuX
//      int hy              ʒuY
//		int vx      		Xx
//		int vy      		Yx
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ESPo
//--------------------------------------------------------------------
ESP* appear_esp_vec(ESPType type, int hx, int hy, int vx, int vy)
{
    int esp_index = -1;
    ESP* pESP;
    CHROBJ* pObj;
    void* func_move;
    void* func_draw;
    void* func_grounding;

    esp_index = POP_IDSTACK_ESP;
    if (esp_index == -1) {
        // 󂫂牽Ȃ
        return NULL;
    }
    pESP = &(p_stage_objects->esp[esp_index]);
    pObj = &(pESP->obj);

    // ^CvŐ؂ւ
    switch (type) {
    case esptype_smoke:
        // 
        func_move = esp_move_smoke;
        func_draw = esp_draw_smoke;
        func_grounding = NULL;
        break;

    case esptype_bigsmoke:
        // 
        func_move = esp_move_bigsmoke;
        func_draw = esp_draw_bigsmoke;
        func_grounding = NULL;
        break;

    case esptype_explode:
        // 
        func_move = esp_move_explode;
        func_draw = esp_draw_explode;
        func_grounding = NULL;
        break;

    case esptype_blueexp:
        // 
        func_move = esp_move_blueexp;
        func_draw = esp_draw_blueexp;
        func_grounding = NULL;
        break;

    case esptype_combolv:
        func_move = esp_move_clv;
        func_draw = esp_draw_clv;
        func_grounding = NULL;
        break;

    case esptype_heart:
        func_move = esp_move_heart;
        func_draw = esp_draw_heart;
        func_grounding = NULL;
        break;

    case esptype_oinari:
        func_move = esp_move_oinari;
        func_draw = esp_draw_oinari;
        func_grounding = move_grounding_bottom_single;
        break;

    case esptype_eneshotmark:
        func_move = esp_move_eneshotmark;
        func_draw = esp_draw_eneshotmark;
        func_grounding = NULL;
        break;

    case esptype_spark:
        // U˕Ԃ̃GtFNg
        func_move = esp_move_spark;
        func_draw = esp_draw_spark;
        func_grounding = NULL;
        break;

    case esptype_bossstar:
        // U˕Ԃ̃GtFNg
        func_move = esp_move_bossstar;
        func_draw = esp_draw_bossstar;
        func_grounding = NULL;
        break;

    case esptype_last:
        // Xg{
        func_move = esp_move_last;
        func_draw = esp_draw_last;
        func_grounding = NULL;
        break;

    case esptype_glass:
        // KX̔j
        func_move = esp_move_glass;
        func_draw = esp_draw_glass;
        func_grounding = NULL;
        break;

    case esptype_lastoinari:
        // Xg{
        func_move = esp_move_lastoinari;
        func_draw = esp_draw_oinari;
        func_grounding = move_grounding_bottom_single;
        break;

    default:
        // sȃ^Cv
        func_move = NULL;
        func_draw = NULL;
        PUSH_IDSTACK_ESP(esp_index);
        kon_log("appear_esp_vec : sȃ^Cvw肳܂Btype=%d\n", type);
        return NULL;
    }

    // ʏ
    esp_init_common(pESP, type, esp_index, hx, hy, vx, vy, func_move, func_draw, func_grounding);

    // ^CvƂ̐ݒ
    switch (type) {
    case esptype_oinari:
        pObj->status = status_normal;
        pObj->grd_bbox.x0 = -8;
        pObj->grd_bbox.y0 = -8;
        pObj->grd_bbox.x1 = 8;
        pObj->grd_bbox.y1 = 8;
        pObj->prev_pos = pESP->obj.pos;
        if (vrand() & 1) {
            pObj->direction = dir_left;
        }
        else {
            pObj->direction = dir_right;
        }
        break;

    case esptype_lastoinari:
        pObj->status = status_normal;
        pObj->grd_bbox.x0 = -8;
        pObj->grd_bbox.y0 = -8;
        pObj->grd_bbox.x1 = 8;
        pObj->grd_bbox.y1 = 8;
        pObj->prev_pos = pESP->obj.pos;
        break;

    case esptype_glass:
        // jЂ̊G̃p^[ݒ
        pESP->opt[0] = vrand() & 3;
        break;
    }

    // Nq
    pESP->p_next = p_stage_objects->esp_top;
    if (pESP->p_next != NULL) {
        pESP->p_next->p_prev = pESP;
    }
    p_stage_objects->esp_top = pESP;

    return pESP;
}


//--------------------------------------------------------------------
//	[  ]
//		void esp_init_common(void* pTarget, ESPType type, int array_index, int hx, int hy, int vx, int vy, void* func_move, void* func_draw)
//
//	[  ]
//      void* pTarget           IuWFNgւ̃|C^
//      ESPType type            ESP
//      int array_index         z̃CfbNXԍ
//      int hx                  ʒuX
//      int hy                  ʒuY
//		int vx      		    Xx
//		int vy      		    Yx
//      void* func_move         ړ֐
//      void* func_draw         `֐
//      void* func_grounding    ڒn֐
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ESPoiʏj
//--------------------------------------------------------------------
void esp_init_common(void* pTarget, ESPType type, int array_index, int hx, int hy, int vx, int vy, void* func_move, void* func_draw, void* func_grounding)
{
    ESP* pESP = pTarget;
    CHROBJ* pObj = &(pESP->obj);
    memset(pESP, 0, sizeof(ESP));

    // ʒuw
    pObj->pos.hx = hx;
    pObj->pos.hy = hy;
    pObj->pos.px = hx >> 8;
    pObj->pos.py = hy >> 8;
    pObj->pos.vx = vx;
    pObj->pos.vy = vy;

    // lݒ
    pESP->type = type;
    pObj->status = status_normal;
    pObj->array_index = array_index;

    // ֐ݒ
    pObj->move = func_move;
    pObj->draw = func_draw;
    pObj->grounding = func_grounding;

    // I
    return;
}

//=============================================================================
//  ړ
//=============================================================================
void esp_move_smoke(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // 5t[ŏI
    pObj->anim_index = pObj->frame_count >> 2;
    if (pObj->anim_index >= 5) {
        pObj->status = status_absent;

        // IDԋp
        PUSH_IDSTACK_ESP(pObj->array_index);

        // NqȂ
        if (pESP->p_prev != NULL) {
            pESP->p_prev->p_next = pESP->p_next;
        }
        if (pESP->p_next != NULL) {
            pESP->p_next->p_prev = pESP->p_prev;
        }
        // 擪ȂgbvXV
        if (pESP->p_prev == NULL) {
            p_stage_objects->esp_top = pESP->p_next;
        }
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
//  `
//=============================================================================
void esp_draw_smoke(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x2A + pObj->anim_index, 8, 0, 0, 3);

    // I
    return;
}

//=============================================================================
// ij ړ
//=============================================================================
void esp_move_bigsmoke(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // t[ŏI
    if (pObj->frame_count >= (1 << 3) * 4) {
        pObj->status = status_absent;
        dispose_esp(pESP);
    }

    // I
    pObj->anim_index = (pObj->frame_count >> 3) & 3;
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// ij `
//=============================================================================
void esp_draw_bigsmoke(void* pTarget)
{
    ESP* pEsp = (ESP*)pTarget;
    CHROBJ* pObj = &(pEsp->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;
    int pattern;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(4);
    if (allocsp < 4) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    pattern = sp_code_top + 0x2F + (pObj->anim_index << 2);
    SP_SET(sp, px, py, pattern + 0, 8, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py, pattern + 1, 8, 0, 0, 3);
    sp++;
    SP_SET(sp, px, py + 16, pattern + 2, 8, 0, 0, 3);
    sp++;
    SP_SET(sp, px + 16, py + 16, pattern + 3, 8, 0, 0, 3);
    sp++;

    // I
    return;
}

//=============================================================================
//  ړ
//=============================================================================
void esp_move_explode(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // 5t[ŏI
    pObj->anim_index = pObj->frame_count >> 2;
    if (pObj->anim_index >= 5) {
        pObj->status = status_absent;

        // IDԋp
        PUSH_IDSTACK_ESP(pObj->array_index);

        // NqȂ
        if (pESP->p_prev != NULL) {
            pESP->p_prev->p_next = pESP->p_next;
        }
        if (pESP->p_next != NULL) {
            pESP->p_next->p_prev = pESP->p_prev;
        }
        // 擪ȂgbvXV
        if (pESP->p_prev == NULL) {
            p_stage_objects->esp_top = pESP->p_next;
        }
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
//  `
//=============================================================================
void esp_draw_explode(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x2A + pObj->anim_index, 7, 0, 0, 3);

    // I
    return;
}

//=============================================================================
// iFj ړ
//=============================================================================
void esp_move_blueexp(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // 5t[ŏI
    pObj->anim_index = pObj->frame_count >> 2;
    if (pObj->anim_index >= 5) {
        pObj->status = status_absent;

        // IDԋp
        PUSH_IDSTACK_ESP(pObj->array_index);

        // NqȂ
        if (pESP->p_prev != NULL) {
            pESP->p_prev->p_next = pESP->p_next;
        }
        if (pESP->p_next != NULL) {
            pESP->p_next->p_prev = pESP->p_prev;
        }
        // 擪ȂgbvXV
        if (pESP->p_prev == NULL) {
            p_stage_objects->esp_top = pESP->p_next;
        }
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// iFj `
//=============================================================================
void esp_draw_blueexp(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x2A + pObj->anim_index, 6, 0, 0, 3);

    // I
    return;
}

//=============================================================================
// R{x ړ
//=============================================================================
void esp_move_clv(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    if (pObj->frame_count < 5) {
        pObj->pos.vy = -(2048);
    }
    else {
        pObj->pos.vy = 0;
    }
    move_obj(&(pObj->pos));

    // 莞Ԍo߂ŏI
    if (pObj->frame_count >= 45) {
        pObj->status = status_absent;
        dispose_esp(pESP);
    }

    // I
    pObj->frame_count += 1;
    return;
}


//=============================================================================
// R{x `
//=============================================================================
void esp_draw_clv(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;
    int clv;
    int sp_code_top;
    int x_sp_code;

    // "x" SP̃R[hԍ𓾂
	x_sp_code = esp_x_spcode[p_stage_context->stage - 1];

    // t[ȍ~œ_
    if (pObj->frame_count >= 25) {
        if ((pObj->frame_count>>1) & 1) {
            return;
        }
    }

    // SP̐擪I
    sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    clv = pESP->opt[0];
    if (clv > 5) { clv = 5; }
    if (clv < 0) { clv = 0; }
    sp_index = p_stage_objects->sp_index_seq;
    switch (clv) {
    case 0: // x1
    case 1: // x2
    case 2: // x3
    case 3: // x4
        allocsp = sp_alloc_index(2);
        if (allocsp < 2) { return; }  // SPindexmۂłȂ`掩̂߂
        break;
    case 4: // x16
    case 5: // x32
        allocsp = sp_alloc_index(3);
        if (allocsp < 3) { return; }  // SPindexmۂłȂ`掩̂߂
        break;
    }
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    {
        // x
        SP_SET(sp, px + 8 - 8, py + 8, x_sp_code, 8, 0, 0, 3);
        sp++;
    }
	switch (clv) {
	case 0: // x1
	{
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x07, 8, 0, 0, 3);
        sp++;
    }
	break;
    case 1: // x2
    {
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x08, 8, 0, 0, 3);
        sp++;
    }
    break;
    case 2: // x4
    {
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x0A, 8, 0, 0, 3);
        sp++;
    }
    break;
    case 3: // x8
    {
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x0E, 8, 0, 0, 3);
        sp++;
    }
    break;
    case 4: // x16
    {
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x07, 8, 0, 0, 3);
        sp++;
        SP_SET(sp, px + 8 + 8, py + 8, sp_code_top + 0x0C, 8, 0, 0, 3);
        sp++;
    }
    break;
    case 5: // x32
    {
        SP_SET(sp, px + 8, py + 8, sp_code_top + 0x09, 8, 0, 0, 3);
        sp++;
        SP_SET(sp, px + 8 + 8, py + 8, sp_code_top + 0x08, 8, 0, 0, 3);
        sp++;
    }
    break;
    }

    // I
    return;
}

//=============================================================================
// n[g ړ
//=============================================================================
void esp_move_heart(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int threshold = 20;

    // t[ړAʉEڎwĈړ
    if (pObj->frame_count == threshold) {
        int dx, dy;
        int sx, sy;
        // W̍
        sx = (pPos->hx - p_stage_context->bgview_hx);
        sy = (pPos->hy - p_stage_context->bgview_hy);
        dx = (256 << 8) - sx;
        dy = (256 << 8) - sy;
        // xݒ肷
        pPos->vx = dx >> 4;
        pPos->vy = dy >> 4;
        // ʒuXN[WǗɕύX
        pPos->hx = sx;
        pPos->hy = sy;
        pObj->status = status_dash;
    }

    // ʏړ
    move_obj(&(pObj->pos));

    // ʊO
    if (pObj->frame_count > threshold) {
        pObj->out_of_screen = 0;
        if ((pPos->px > 262)
            || (pPos->py > 262)
            || (pPos->px < -8)
            || (pPos->py < -8)
            ) {
            pObj->out_of_screen = 1;
        }

        // ʂOɏo
        if (pObj->out_of_screen) {
			pObj->status = status_absent;
			dispose_esp(pESP);
        }
    }

    // I
    pObj->frame_count += 1;
    pObj->anim_index = (pObj->frame_count >> 4) & 1;
    return;
}

//=============================================================================
// n[g `
//=============================================================================
void esp_draw_heart(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // XN[Wŕ\
    if (pObj->status != status_dash) {
        // Ɉړ̓[hWň
        hx = pPos->hx - p_stage_context->bgview_hx;
        hy = pPos->hy - p_stage_context->bgview_hy;
    }
    else {
        // EɈړƂ̓XN[Wň
        hx = pPos->hx;
        hy = pPos->hy;
    }
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(1);
    if (allocsp < 1) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x19, 7, 0, 0, 3);
    sp++;

    // I
    return;
}

//=============================================================================
// Ȃ ړ
//=============================================================================
void esp_move_oinari(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int vel = 1280;
    int px, py;

    // ʏړ
    move_common(pObj, 0, MOVE_GRAVITY);

    // n獶EɈړ
    if ((pObj->gcol.bottom != 0)
        && (pESP->opt[0]==0)
        ) {
        // n
        pESP->opt[0] = 1;

        // x^
		if (pObj->direction == dir_left) {
            pPos->vx = -vel;
        }
        else {
            pPos->vx = vel;
        }
    }

    // ʊO
    px = (pPos->hx - p_stage_context->bgview_hx) >> 8;
    py = (pPos->hy - p_stage_context->bgview_hy) >> 8;
    if ((px <= 0) || (py <= 0)
        || (px >= 255) || (py >= 255)
        ) {
        // 
        dispose_esp(pESP);
    }

    // I
    //pObj->frame_count += 1;
    pObj->anim_index = (pObj->frame_count >> 2) & 1;
    return;
}

//=============================================================================
// Ȃ `
//=============================================================================
void esp_draw_oinari(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    hx = pPos->hx - p_stage_context->bgview_hx;
    hy = pPos->hy - p_stage_context->bgview_hy;
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(1);
    if (allocsp < 1) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // }bvobt@Ƀf[^i[
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x41 + pObj->anim_index, 7, (pObj->direction==dir_right), 0, 3);
    sp++;

    // I
    return;
}

//=============================================================================
// GU\ ړ
//=============================================================================
void esp_move_eneshotmark(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);

    // ړȂ
    pPos->ax = 0;
    pPos->ay = 0;
    pPos->vx = 0;
    pPos->vy = 0;

    // ʏړ
    move_common(pObj, 0, 0);

	pObj->anim_index = 0;
	if (pObj->frame_count > 5) { pObj->anim_index = 1; }

    // 40t[ŏI
    if (pObj->frame_count >= 10) {
        pObj->status = status_absent;
        dispose_esp(pESP);
    }

    // I
    return;
}

//=============================================================================
// GU\ `
//=============================================================================
void esp_draw_eneshotmark(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;
    int allocsp;
    int offset;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    hx = pPos->hx - p_stage_context->bgview_hx;
    hy = pPos->hy - p_stage_context->bgview_hy;
    px = hx >> 8;
    py = hy >> 8;

    // SPm
    sp_index = p_stage_objects->sp_index_seq;
    allocsp = sp_alloc_index(4);
    if (allocsp < 4) { return; }  // SPindexmۂłȂ`掩̂߂
    sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

    // ItZbg𓱏o
    offset = pObj->frame_count << 2;

    // }bvobt@Ƀf[^i[
	// E
	SP_SET(sp, px + 0 + offset, py + 8, sp_code_top + 0x20 + (pObj->anim_index << 1), 7, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 16 + offset, py + 8, sp_code_top + 0x21 + (pObj->anim_index << 1), 7, 0, 0, 3);
	sp++;

	// 
	SP_SET(sp, px + 16 - offset, py + 8, sp_code_top + 0x20 + (pObj->anim_index << 1), 7, 1, 0, 3);
	sp++;
	SP_SET(sp, px + 0 - offset, py + 8, sp_code_top + 0x21 + (pObj->anim_index << 1), 7, 1, 0, 3);
	sp++;

    // I
    return;
}

//=============================================================================
// U˕Ԃ̃GtFNg ړ
//=============================================================================
void esp_move_spark(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // Aj[ṼCfbNX𓱏o
    pObj->anim_index = (pObj->frame_count >> 2) & 1;

    // 10t[ŏI
    if (pObj->frame_count > 10) {
        pObj->status = status_absent;

        // IDԋp
        PUSH_IDSTACK_ESP(pObj->array_index);

        // NqȂ
        if (pESP->p_prev != NULL) {
            pESP->p_prev->p_next = pESP->p_next;
        }
        if (pESP->p_next != NULL) {
            pESP->p_next->p_prev = pESP->p_prev;
        }
        // 擪ȂgbvXV
        if (pESP->p_prev == NULL) {
            p_stage_objects->esp_top = pESP->p_next;
        }
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// U˕Ԃ̃GtFNg `
//=============================================================================
void esp_draw_spark(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x43 + pObj->anim_index, 7, 0, 0, 3);

    // I
    return;
}

//=============================================================================
// {Xo̐}[ÑGtFNg ړ
//=============================================================================
void esp_move_bossstar(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // Aj[ṼCfbNX𓱏o
    pObj->anim_index = (pObj->frame_count >> 2) & 1;

    // 20t[ŏI
    if (pObj->frame_count > 20) {
        pObj->status = status_absent;

        // IDԋp
        PUSH_IDSTACK_ESP(pObj->array_index);

        // NqȂ
        if (pESP->p_prev != NULL) {
            pESP->p_prev->p_next = pESP->p_next;
        }
        if (pESP->p_next != NULL) {
            pESP->p_next->p_prev = pESP->p_prev;
        }
        // 擪ȂgbvXV
        if (pESP->p_prev == NULL) {
            p_stage_objects->esp_top = pESP->p_next;
        }
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// {Xo̐}[ÑGtFNg `
//=============================================================================
void esp_draw_bossstar(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int hx, hy, px, py;
    SP_UNIT* sp;
    int sp_index;

    // SP̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // `ɎgSPR[h𓾂
    sp_index = p_stage_objects->sp_index_seq;
    if (sp_index >= 128) {
        return;
    }
    p_stage_objects->sp_index_seq++;

    // }bvobt@Ƀf[^i[
    sp = p_memory_map_buffer->sp_unit + sp_index;   // sp_unit[sp_index]
    SP_SET(sp, px + 8, py + 8, sp_code_top + 0x43 + pObj->anim_index, 7, 0, 0, 3);

    // I
    return;
}

//=============================================================================
// Xg ړ
//=============================================================================
void esp_move_last(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    move_obj(&(pObj->pos));

    // SP`iLN^j
    pObj->anim_index = (pObj->frame_count >> 4) & 1;
    stack_transfer_sp(p_stage_context->boss_sp_slot, 24 + (pObj->anim_index * 12), 0x90, 12);

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// Xg `
//=============================================================================
void esp_draw_last(void* pTarget)
{
    ESP* pEnemy = (ESP*)pTarget;
    CHROBJ* pObj = &(pEnemy->obj);
    OBJPOS* pPos = &(pObj->pos);
    SP_UNIT* sp;
    int hx, hy;
    int px, py;
    int y, x;
    int ox, oy, oi;
    int allocsp = 0;
    int pal = 12;

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // -----< {̂` >-----
    //
    sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
    allocsp = sp_alloc_index(12);	// SP12g
    if (allocsp < 12) {
        // mۂłȂ`߂
        return;
    }

    ox = 0;
    oy = 0;
    oi = 0;
    for (y = 0; y < 4; y++) {
        for (x = 0; x < 3; x++) {
            // }bvobt@Ƀf[^i[
            SP_SET(sp, px - 8 + ox, py - 24 + oy + 4, 0x90 + oi, 12, 0, 0, 3);
            // 
            sp++;
            ox += 16;
            oi++;
        }
        ox = 0;
        oy += 16;
    }

    // I
    return;
}

//=============================================================================
// KX̔j ړ
//=============================================================================
void esp_move_glass(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);

    // ʏړ
    pObj->pos.ay = MOVE_GRAVITY >> 1;
    move_obj(&(pObj->pos));

    // NbsOOꂽ
    if (pObj->pos.py > p_stage_context->stage_clipping_area.y1) {
        dispose_esp(pTarget);
    }

    // I
    pObj->frame_count += 1;
    return;
}

//=============================================================================
// KX̔j `
//=============================================================================
void esp_draw_glass(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    SP_UNIT* sp;
    int hx, hy;
    int px, py;
    int allocsp = 0;
    int pal = 12;
    int pattern = pESP->opt[0];

    // LN^̃XN[W
    hx = (pPos->hx - p_stage_context->bgview_hx);
    hy = (pPos->hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // -----< {̂` >-----
    //
    sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
    allocsp = sp_alloc_index(1);	// SP12g
    if (allocsp < 1) {
        // mۂłȂ`߂
        return;
    }

    // }bvobt@Ƀf[^i[
    SP_SET(sp, px + 8, py + 8, 0xB0 + pattern, 12, 0, 0, 3);
    sp++;

    // I
    return;
}

//=============================================================================
// XĝȂ ړ
//=============================================================================
void esp_move_lastoinari(void* pTarget)
{
    ESP* pESP = (ESP*)pTarget;
    CHROBJ* pObj = &(pESP->obj);
    OBJPOS* pPos = &(pObj->pos);
    int vel = 1280;

    // ʏړ
    move_common(pObj, 0, MOVE_GRAVITY);

    // n獶EɈړ
    if (pObj->gcol.bottom != 0) {
        // n烉_ŃWv
        if ((vrand() & 63) == 0) {
			pPos->vy = -((1 + (vrand() & 3)) << 8);
        }
    }

    // I
    pObj->anim_index = (pObj->frame_count >> 2) & 1;
    return;
}
