#define __ENESHOT_C__

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "kon_util.h"
#include "eneshot.h"

// -----< vg^Cv錾 >-----
//
// <<<<< ʏe >>>>>
void init_eneshot_normal(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_normal(void* pTarget);
void draw_eneshot_normal(void* pTarget);

// <<<<< ʏeij >>>>>
void init_eneshot_big(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void draw_eneshot_big(void* pTarget);

// <<<<< Ռge >>>>>
void init_eneshot_wave(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void draw_eneshot_wave(void* pTarget);

// <<<<< e >>>>>
void init_eneshot_gravity(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_gravity(void* pTarget);
void draw_eneshot_gravity(void* pTarget);

// <<<<< eij >>>>>
void init_eneshot_grav_spd(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_grav_spd(void* pTarget);
void draw_eneshot_grav_spd(void* pTarget);

// <<<<<  >>>>>
void init_eneshot_axe(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_axe(void* pTarget);
void draw_eneshot_axe(void* pTarget);

// <<<<<  >>>>>
void init_eneshot_fire(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void draw_eneshot_fire(void* pTarget);

// <<<<<  >>>>>
void init_eneshot_flame(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void draw_eneshot_flame(void* pTarget);

// <<<<< [U[ >>>>>
void init_eneshot_laser(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void draw_eneshot_laser(void* pTarget);

// <<<<< \[T[̉ >>>>>
void init_eneshot_sor(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_sor(void* pTarget);
void draw_eneshot_sor(void* pTarget);

// <<<<< z[~Oe >>>>>
void init_eneshot_horming(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_horming(void* pTarget);

// <<<<< LastOinari >>>>>
void init_eneshot_lastoinari(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_eneshot_lastoinari(void* pTarget);
void draw_eneshot_lastoinari(void* pTarget);

// ǐڐG`FbN
int check_wall(OBJPOS* pPos);

//--------------------------------------------------------------------
//	[  ]
//		ENESHOT* appear_eneshot(EneShotType type, int hx, int hy, int vel)
//
//	[  ]
//		EneShotType type	oGe̎
//		int hx				oʒui256{Wnj
//		int hy				oʒui256{Wnj
//		int vx				xi256{Wnj
//		int vy				xi256{Wnj
//
//	[ ߂l ]
//		oGeւ̃|C^BoȂƂNULLԂB
//
//	[  ]
//		
//--------------------------------------------------------------------
ENESHOT* appear_eneshot(EneShotType type, int hx, int hy, int vx, int vy)
{
	int absent_index;
	ENESHOT* pEneShot;

	// X^bN^[Qbg̃CfbNX𓾂
	absent_index = POP_IDSTACK_ENESHOT;
	if (absent_index < 0) {
		// oE
		return NULL;
	}

	// o
	pEneShot = &(p_stage_objects->eneshot[absent_index]);
	memset(pEneShot, 0, sizeof(ENESHOT));

	switch (type) {
	case eneshottype_normal:
		// ʏe
		init_eneshot_normal(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_big:
		// ʏeij
		init_eneshot_big(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_wave:
		// Ռg
		init_eneshot_wave(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_gravity:
		// e
		init_eneshot_gravity(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_grav_spd:
		// e
		init_eneshot_grav_spd(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_axe:
		// 
		init_eneshot_axe(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_fire:
		// 
		init_eneshot_fire(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_flame:
		// 
		init_eneshot_flame(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_laser:
		// [U[
		init_eneshot_laser(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_sor:
		// \[T[̉
		init_eneshot_sor(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_horming:
		// z[~Oe
		init_eneshot_horming(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_lastoinari:
		// z[~Oe
		init_eneshot_lastoinari(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	default:
		// sȃ^Cv̂ƂɂIDԂĖ
		kon_log_single(ERROR_INVALID_ENESHOT_TYPE, "Ge̎ʂsłBtype=%d\n", type);
		PUSH_IDSTACK_ENESHOT(absent_index);
		break;
	}

	// I
	return pEneShot;
}


//=============================================================================
// GeɃ_[W^
//=============================================================================
void on_hit_eneshot(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ENESHOT* pEneShot = pTarget;

	{
		// 
		pEneShot->obj.status = status_absent;

		// X^bNIDԂ
		dispose_eneshot(pEneShot);
	}
}


//=============================================================================
// ʏe
//=============================================================================
void init_eneshot_normal(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_normal;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;			// ړ֐
	pObj->draw = draw_eneshot_normal;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ʏëړ
//=============================================================================
void move_eneshot_normal(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if ((pObj->out_of_screen) || (check_wall(pPos))) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//=============================================================================
// ʏe̕`揈
//=============================================================================
void draw_eneshot_normal(void* pTarget)
{
	int offset[4] = {0, 1, 2, 1};	// Aj[VItZbg
	int vrevoffset[4] = { 0, 0, 0, 1 };
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int vrev = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x4E;

	// Aj[ṼCfbNXԍ
	anim = offset[(pObj->frame_count >> 4) & 1];

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + anim, 7, 0, 0, 3);
	// 
	sp++;

	return;
}


//=============================================================================
// ʏeij
//=============================================================================
void init_eneshot_big(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_big;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;		// ړ֐
	pObj->draw = draw_eneshot_big;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ʏeij̕`揈
//=============================================================================
void draw_eneshot_big(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 3;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 5 + anim, 7, 0, 0, 3);
	sp++;

	// I
	return;
}


//=============================================================================
// Ռge
//=============================================================================
void init_eneshot_wave(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -2;
	pObj->hit_bbox.x1 = +2;
	pObj->hit_bbox.y0 = -15;
	pObj->hit_bbox.y1 = +15;

	// ^Cvݒ
	pEneShot->type = eneshottype_wave;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;			// ړ֐
	pObj->draw = draw_eneshot_wave;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// Ռg̕`揈
//=============================================================================
void draw_eneshot_wave(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int hrev = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP1g
	if (allocsp < 2) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	hrev = (pPos->vx < 0 ? 0 : 1);
	SP_SET(sp, px + 8, py + 0, sp_code_top + 3 + anim, 7, hrev, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 16, sp_code_top + 3 + anim, 7, hrev, 1, 3);
	sp++;

	return;
}

//=============================================================================
// e
//=============================================================================
void init_eneshot_gravity(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_gravity;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_gravity;			// ړ֐
	pObj->draw = draw_eneshot_gravity;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ëړ
//=============================================================================
void move_eneshot_gravity(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	pPos->ay = MOVE_GRAVITY >> 5;	// d͉x
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if ((pObj->out_of_screen) || (check_wall(pPos))) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//=============================================================================
// e̕`揈
//=============================================================================
void draw_eneshot_gravity(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 9 + anim, 6, 0, 0, 3);
	// 
	sp++;

	return;
}

//=============================================================================
// eij
//=============================================================================
void init_eneshot_grav_spd(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_grav_spd;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_grav_spd;			// ړ֐
	pObj->draw = draw_eneshot_grav_spd;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// eij̈ړ
//=============================================================================
void move_eneshot_grav_spd(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	pPos->ay = MOVE_GRAVITY >> 1;	// d͉x
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if ((pObj->out_of_screen) || (check_wall(pPos))) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//=============================================================================
// eij̕`揈
//=============================================================================
void draw_eneshot_grav_spd(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 9 + anim, 7, 0, 0, 3);
	// 
	sp++;

	return;
}

//=============================================================================
// ̒e
//=============================================================================
void init_eneshot_axe(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_axe;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_axe;			// ړ֐
	pObj->draw = draw_eneshot_axe;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ̒ëړ
//=============================================================================
void move_eneshot_axe(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	pPos->ay = MOVE_GRAVITY >> 2;	// d͉x
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if ((pObj->out_of_screen) || (check_wall(pPos))) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//=============================================================================
// ̒e̕`揈
//=============================================================================
void draw_eneshot_axe(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 1) & 3;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 5 + anim, 7, 0, 0, 3);
	// 
	sp++;

	return;
}

//=============================================================================
// ΂
//=============================================================================
void init_eneshot_fire(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -8;
	pObj->hit_bbox.x1 = +8;
	pObj->hit_bbox.y0 = -8;
	pObj->hit_bbox.y1 = +8;

	// ^Cvݒ
	pEneShot->type = eneshottype_fire;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;		// ړ֐
	pObj->draw = draw_eneshot_fire;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ΂̕`揈
//=============================================================================
void draw_eneshot_fire(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int hrev = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 1;	// 0000 1111 0000 1111 ...
	hrev = (pObj->frame_count >> 3) & 1;	// 0000 0000 1111 1111 ...

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP1g
	if (allocsp < 2) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pPos->vx >= 0) {
		// E
		SP_SET(sp, px + 8, py + 8, sp_code_top + 0x27 + (anim << 1), 6, hrev, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8 - 16, sp_code_top + 0x26 + (anim << 1), 6, hrev, 0, 3);
		sp++;
	}
	else {
		// 
		SP_SET(sp, px + 8, py + 8, sp_code_top + 0x27 + (anim << 1), 6, hrev, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8 - 16, sp_code_top + 0x26 + (anim << 1), 6, hrev, 0, 3);
		sp++;
	}

	return;
}

//=============================================================================
// 
//=============================================================================
void init_eneshot_flame(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -2;
	pObj->hit_bbox.x1 = +2;
	pObj->hit_bbox.y0 = -2;
	pObj->hit_bbox.y1 = +2;

	// ^Cvݒ
	pEneShot->type = eneshottype_flame;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;		// ړ֐
	pObj->draw = draw_eneshot_flame;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ̕`揈
//=============================================================================
void draw_eneshot_flame(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int hrev = 0;
	int allocsp = 0;
	int sptop = p_stage_context->cmn_sp_top + 0x24;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 1;	// 0000 1111 0000 1111 ...
	hrev = (pObj->frame_count >> 3) & 1;	// 0000 0000 1111 1111 ...

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pPos->vx >= 0) {
		// E
		SP_SET(sp, px + 8, py + 8, sptop + anim, 7, hrev, 0, 3);
		sp++;
	}
	else {
		// 
		SP_SET(sp, px + 8, py + 8, sptop + anim, 7, hrev, 0, 3);
		sp++;
	}

	return;
}

//=============================================================================
// [U[
//=============================================================================
void init_eneshot_laser(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -4;
	pObj->hit_bbox.x1 = +4;
	pObj->hit_bbox.y0 = -4;
	pObj->hit_bbox.y1 = +4;

	// ^Cvݒ
	pEneShot->type = eneshottype_laser;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_normal;		// ړ֐
	pObj->draw = draw_eneshot_laser;		// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// [U[̕`揈
//=============================================================================
void draw_eneshot_laser(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 3;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP2g
	if (allocsp < 2) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	switch (pObj->direction) {
	case dir_left:
	case dir_right:
		SP_SET(sp, px + 0 + 2, py + 8, sp_code_top + 2, 6, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16 - 2, py + 8, sp_code_top + 2, 6, 0, 0, 3);
		sp++;
		break;

	case dir_ld:
	case dir_ru:
		SP_SET(sp, px + 16 - 4, py + 0 + 4, sp_code_top + 1, 6, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 0 + 4, py + 16 - 4, sp_code_top + 1, 6, 0, 0, 3);
		sp++;
		break;

	case dir_up:
	case dir_down:
		SP_SET(sp, px + 8, py + 0 + 2, sp_code_top, 6, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 16 - 2, sp_code_top, 6, 0, 0, 3);
		sp++;
		break;

	case dir_lu:
	case dir_rd:
		SP_SET(sp, px + 0 + 4, py + 0 + 4, sp_code_top + 1, 6, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16 - 4, py + 16 - 4, sp_code_top + 1, 6, 1, 0, 3);
		sp++;
		break;

	default:
		SP_SET(sp, px + 0 + 2, py + 8, sp_code_top + 2, 6, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16 - 2, py + 8, sp_code_top + 2, 6, 0, 0, 3);
		sp++;
		break;
	}

	// I
	return;
}

//=============================================================================
// \[T[̉
//=============================================================================
void init_eneshot_sor(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -6;
	pObj->hit_bbox.x1 = +6;
	pObj->hit_bbox.y0 = -6;
	pObj->hit_bbox.y1 = +6;

	// ^Cvݒ
	pEneShot->type = eneshottype_sor;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_sor;			// ړ֐
	pObj->draw = draw_eneshot_sor;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// \[T[̉̈ړ
//=============================================================================
void move_eneshot_sor(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	int explode_frame = 30;

	// ړ
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// 64t[Ŕ
	if (pObj->frame_count == explode_frame) {
		int dir = 0;
		for (dir = 0; dir < 512; dir += 64) {
			appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[dir] << 1, vsin[dir] << 1);
		}
	}

	// t[ŏ
	//if ((pObj->out_of_screen) || (pObj->frame_count == 64)) {
	if (pObj->frame_count == explode_frame) {
			// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//=============================================================================
// \[T[̉̕`揈
//=============================================================================
void draw_eneshot_sor(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int hrev = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 1;	// 0000 1111 0000 1111 ...
	hrev = (pObj->frame_count >> 3) & 1;	// 0000 0000 1111 1111 ...

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP1g
	if (allocsp < 2) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pPos->vx >= 0) {
		// E
		SP_SET(sp, px + 8, py + 8, sp_code_top + 0x27 + (anim << 1), 7, hrev, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8 - 16, sp_code_top + 0x26 + (anim << 1), 7, hrev, 0, 3);
		sp++;
	}
	else {
		// 
		SP_SET(sp, px + 8, py + 8, sp_code_top + 0x27 + (anim << 1), 7, hrev, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8 - 16, sp_code_top + 0x26 + (anim << 1), 7, hrev, 0, 3);
		sp++;
	}

	return;
}

//=============================================================================
// z[~Oe
//=============================================================================
void init_eneshot_horming(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -2;
	pObj->hit_bbox.x1 = +2;
	pObj->hit_bbox.y0 = -2;
	pObj->hit_bbox.y1 = +2;

	// ^Cvݒ
	pEneShot->type = eneshottype_horming;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_horming;			// ړ֐
	pObj->draw = draw_eneshot_big;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_eneshot;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// z[~Oëړ
//=============================================================================
void move_eneshot_horming(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	int diff_x, diff_y, acc, vmax;

	// @ɊĂ
	diff_x = p_stage_objects->jiki.obj.pos.hx - pPos->hx;
	diff_y = p_stage_objects->jiki.obj.pos.hy - pPos->hy;
	acc = 6;
	vmax = 8 << 8;
	if (pObj->frame_count < 90) {
		// t[𒴂瑬xŒ
		if (diff_x > 0) { pPos->vx += acc; }
		else { pPos->vx -= acc; }
		if (diff_y > 0) { pPos->vy += acc; }
		else { pPos->vy -= acc; }
		if (pPos->vx > vmax) { pPos->vx = vmax; }
		if (pPos->vx < -vmax) { pPos->vx = -vmax; }
		if (pPos->vy > vmax) { pPos->vy = vmax; }
		if (pPos->vy < -vmax) { pPos->vy = -vmax; }
	}

	// ړ
	move_obj(pPos);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂB莞Ԃ͏ȂB
	if (((pObj->out_of_screen) && (pObj->frame_count > 120)) || (check_wall(pPos))) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}


//=============================================================================
// ESP LastOinari
//=============================================================================
void init_eneshot_lastoinari(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->grd_bbox.x0 = -8;
	pObj->grd_bbox.x1 = +8;
	pObj->grd_bbox.y0 = -8;
	pObj->grd_bbox.y1 = +8;

	// ^Cvݒ
	pEneShot->type = eneshottype_lastoinari;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;
	//
	pObj->prev_pos = *pPos;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_eneshot_lastoinari;	// ړ֐
	pObj->draw = draw_eneshot_lastoinari;	// `֐
	pObj->grounding = move_grounding_bottom_single;	// ڒn֐
	pObj->on_hit = NULL;	// Gj󎞂̋ʏ

	return;
}

//=============================================================================
// ESP LastOinarïړ
//=============================================================================
void move_eneshot_lastoinari(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	int vel = 1280;

	// ʏړ
	move_common(pObj, 0, MOVE_GRAVITY);

	// n獶EɈړ
	if (pObj->gcol.bottom != 0) {
		// n烉_ŃWv
		if ((vrand() & 63) == 0) {
			pPos->vy = -((1 + (vrand() & 3)) << 8);
		}
	}

	// I
	pObj->anim_index = (pObj->frame_count >> 2) & 1;
	return;
}

//=============================================================================
// ESP LastOinari̕`揈
//=============================================================================
void draw_eneshot_lastoinari(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	int hx, hy, px, py;
	SP_UNIT* sp;
	int sp_index;
	int allocsp;

	// SP̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	hx = pPos->hx - p_stage_context->bgview_hx;
	hy = pPos->hy - p_stage_context->bgview_hy;
	px = hx >> 8;
	py = hy >> 8;

	// SPm
	sp_index = p_stage_objects->sp_index_seq;
	allocsp = sp_alloc_index(1);
	if (allocsp < 1) { return; }  // SPindexmۂłȂ`掩̂߂
	sp = p_memory_map_buffer->sp_unit + sp_index; // sp_unit[sp_index]

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 0x41 + pObj->anim_index, 7, (pObj->direction == dir_right), 0, 3);
	sp++;

	// I
	return;
}

//=============================================================================
// ẅʒuǂƐڐGĂꍇ1Ԃ
//=============================================================================
int check_wall(OBJPOS* pPos) {
	int bg_code;

	// BGGAO
	if (pPos->px < 0) { return 1; }
	if (pPos->py < 0) { return 1; }
	if ((pPos->px >> 3) >= p_stage_context->bgmap_width) { return 1; }
	if ((pPos->py >> 3) >= p_stage_context->bgmap_height) { return 1; }

	// ڐG
	bg_code = GET_BG_ATTRIBUTE(p_stage_context->pworld_page, (pPos->px >> 3), (pPos->py >> 3));
	if (BG_WALL_CONDITION(bg_code)) {
		return 1;
	}
	return 0;
}
