#ifndef __ENEMY_H__
#define __ENEMY_H__
#include "constants.h"

//========================================================
// vg^Cv錾
//========================================================
#ifdef __ENEMY_C__
#define EXTERN 
#else
#define EXTERN extern
#endif

// <<< vg^Cv錾 >>>
//
// Go
EXTERN void appear_enemy(int desc_line);
EXTERN void build_enemy(int absent_index, int ene_type, int param, int desc_line);
EXTERN void on_hit_enemy(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
EXTERN void on_hit_enemy_magic_only(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
EXTERN void on_hit_enemy_blade_only(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
EXTERN void on_hit_enemy_has_shield(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
EXTERN void enemy_appear_positioning(ENEMY* pEnemy, int width, int top, int bottom);	// G̏ʒuݒ
EXTERN void enemy_appear_positioning_center(ENEMY* pEnemy, int width, int height);		// G̏ʒuݒ
EXTERN void on_hit_boss(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
EXTERN void regist_eneshot_delay(ENEMY* pEnemy, int offset_hx, int offset_hy);
EXTERN void process_eneshot_delay(ENEMY* pEnemy);
EXTERN void enemy_clip_section(ENEMY* pEnemy);
// {X֘Aʊ֐
EXTERN void enemy_transsp_boss_gauge(ENEMY* pEnemy, int gauge_def_top, int target_top);
EXTERN void enemy_draw_boss_gauge(ENEMY* pEnemy, int offset_x, int offset_y, int sp_top);

// ʊO ȈՔňړ
EXTERN void enemy_move_simple_grounding(void* pTarget);

//#define __ENEMY_C__
#ifndef __ENEMY_C__
// SCORE` : [G][{(log2X)][w茅, index, l]
extern int enemy_score_def[enetype_count][6][(SCORE_DIGITS * 2) + 1];
extern int enemy_hp_def[game_level_count][enetype_count];
extern int enemy_item_count[enetype_count];
extern int eneshot_rate[3][enetype_count];
extern int boss_jewel_sptop[MAX_STAGE];
#else
int enemy_score_def[enetype_count][6][(SCORE_DIGITS * 2) + 1] = {
	// dummy
	{
		 { 0 }	// x 1 : 0
		,{ 0 }	// x 2 : 0
		,{ 0 }	// x 4 : 0
		,{ 0 }	// x 8 : 0
		,{ 0 }	// x16 : 0
		,{ 0 }	// x32 : 0
	}
	// <<< G >>>
	// enetype_slime
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_she_slime
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_mummy
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_mummy_big
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_bat
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_ghost
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_goblin
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_sorcerer
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_skel
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_eye
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// enetype_knight
	, {
		 { 1, 2, 6 }				// x 1 :   600
		,{ 2, 3, 1, 2, 2 }			// x 2 :  1200
		,{ 2, 3, 2, 2, 4 }			// x 4 :  2400
		,{ 2, 3, 4, 2, 8 }			// x 8 :  4800
		,{ 2, 3, 9, 2, 6 }			// x16 :  9600
		,{ 3, 4, 1, 3, 9, 2, 2 }	// x32 : 19200
	}
	// enetype_robo
	, {
		 { 1, 2, 3 }		// x 1 :  300
		,{ 1, 2, 6 }		// x 2 :  600
		,{ 2, 3, 1, 2, 2 }	// x 4 : 1200
		,{ 2, 3, 2, 2, 4 }	// x 8 : 2400
		,{ 2, 3, 4, 2, 8 }	// x16 : 4800
		,{ 2, 3, 9, 2, 6 }	// x32 : 9600
	}
	// <<<  >>>
	// enetype_mid_mecha
	, {
		 { 1, 2, 5 }		// x 1 :   500
		,{ 1, 3, 1 }		// x 2 :  1000
		,{ 1, 3, 2 }		// x 4 :  2000
		,{ 1, 3, 4 }		// x 8 :  4000
		,{ 1, 3, 8 }		// x16 :  8000
		,{ 2, 4, 1, 3, 6 }	// x32 : 16000
	}
	// enetype_mid_cloud
	, {
		 { 1, 2, 5 }		// x 1 :   500
		,{ 1, 3, 1 }		// x 2 :  1000
		,{ 1, 3, 2 }		// x 4 :  2000
		,{ 1, 3, 4 }		// x 8 :  4000
		,{ 1, 3, 8 }		// x16 :  8000
		,{ 2, 4, 1, 3, 6 }	// x32 : 16000
	}
	// enetype_mid_barrel
	, {
		 { 1, 2, 5 }		// x 1 :   500
		,{ 1, 3, 1 }		// x 2 :  1000
		,{ 1, 3, 2 }		// x 4 :  2000
		,{ 1, 3, 4 }		// x 8 :  4000
		,{ 1, 3, 8 }		// x16 :  8000
		,{ 2, 4, 1, 3, 6 }	// x32 : 16000
	}
	// enetype_mid_madman
	, {
		 { 1, 2, 5 }		// x 1 :   500
		,{ 1, 3, 1 }		// x 2 :  1000
		,{ 1, 3, 2 }		// x 4 :  2000
		,{ 1, 3, 4 }		// x 8 :  4000
		,{ 1, 3, 8 }		// x16 :  8000
		,{ 2, 4, 1, 3, 6 }	// x32 : 16000
	}
	// <<< {X >>>
	// BOSS1
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
	// BOSS2
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
	// BOSS3
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
	// BOSS4
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
	// BOSS5
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
	// BOSS5IvV
	, {
		 { 1, 1, 0 }		// x 1 : 0
		,{ 1, 1, 0 }		// x 2 : 0
		,{ 1, 1, 0 }		// x 4 : 0
		,{ 1, 1, 0 }		// x 8 : 0
		,{ 1, 1, 0 }		// x16 : 0
		,{ 1, 1, 0 }		// x32 : 0
	}
	// BOSS6
	, {
		 { 1, 4, 4 }		// x 1 : 40000
		,{ 1, 4, 4 }		// x 2 : 40000
		,{ 1, 4, 4 }		// x 4 : 40000
		,{ 1, 4, 4 }		// x 8 : 40000
		,{ 1, 4, 4 }		// x16 : 40000
		,{ 1, 4, 4 }		// x32 : 40000
	}
};

// HP
int enemy_hp_def[game_level_count][enetype_count] =
{
	{	// EASY
		0,			// DUMMY
		// G
		1250,		// enetype_slime
		2000,		// enetype_she_slime
		8000,		// enetype_mummy
		40000,		// enetype_mummy_big
		2500,		// enetype_bat
		5000,		// enetype_ghost
		25000,		// enetype_goblin
		5000,		// enetype_sorcerer
		2500,		// enetype_skel
		2500,		// enetype_eye
		2500,		// enetype_knight
		3500,		// enetype_robo
		// 
		7000,		// enetype_mid_mecha
		7000,		// enetype_mid_cloud
		7000,		// enetype_mid_barrel
		(8000 * 4),	// enetype_mid_madman
		// {X
		(int)(125000 * 1.0),	// BOSS1
		(int)(125000 * 1.0),	// BOSS2
		(int)(250000 * 1.0),	// BOSS3
		(int)(125000 * 1.0),	// BOSS4
		(int)(125000 * 1.0),	// BOSS5
		(999999),				// BOSS5IvV
		(int)(100000)			// BOSS6
	},
	{	// NOVICE
		0,			// DUMMY
		// G
		1250,		// enetype_slime
		2000,		// enetype_she_slime
		8000,		// enetype_mummy
		40000,		// enetype_mummy_big
		2500,		// enetype_bat
		5000,		// enetype_ghost
		25000,		// enetype_goblin
		5000,		// enetype_sorcerer
		2500,		// enetype_skel
		2500,		// enetype_eye
		2500,		// enetype_knight
		3500,		// enetype_robo
		// 
		7000,		// enetype_mid_mecha
		7000,		// enetype_mid_cloud
		7000,		// enetype_mid_barrel
		(8000 * 4),	// enetype_mid_madman
		// {X
		(int)(125000 * 1.2),	// BOSS1
		(int)(125000 * 1.5),		// BOSS2
		(int)(250000 * 1.2),	// BOSS3
		(int)(125000 * 1.5),		// BOSS4
		(int)(125000 * 1.5),		// BOSS5
		(999999),				// BOSS5IvV
		(int)(100000)			// BOSS6
	},
	{	// NORMAL
		0,			// DUMMY
		// G
		1250,		// enetype_slime
		2000,		// enetype_she_slime
		8000,		// enetype_mummy
		40000,		// enetype_mummy_big
		2500,		// enetype_bat
		5000,		// enetype_ghost
		25000,		// enetype_goblin
		5000,		// enetype_sorcerer
		2500,		// enetype_skel
		2500,		// enetype_eye
		2500,		// enetype_knight
		3500,		// enetype_robo
		// 
		7000,		// enetype_mid_mecha
		7000,		// enetype_mid_cloud
		7000,		// enetype_mid_barrel
		(8000 * 4),	// enetype_mid_madman
		// {X
		(int)(125000 * 1.5),	// BOSS1
		(int)(125000 * 2),		// BOSS2
		(int)(250000 * 1.5),	// BOSS3
		(int)(125000 * 2),		// BOSS4
		(int)(125000 * 2),		// BOSS5
		(999999),				// BOSS5IvV
		(int)(100000)			// BOSS6
	},
	{	// HARD
		0,			// DUMMY
		// G
		1250,		// enetype_slime
		2000,		// enetype_she_slime
		8000,		// enetype_mummy
		40000,		// enetype_mummy_big
		2500,		// enetype_bat
		5000,		// enetype_ghost
		25000,		// enetype_goblin
		15000,		// enetype_sorcerer
		2500,		// enetype_skel
		2500,		// enetype_eye
		2500,		// enetype_knight
		3500,		// enetype_robo
		// 
		7000,		// enetype_mid_mecha
		7000,		// enetype_mid_cloud
		7000,		// enetype_mid_barrel
		(8000 * 4),	// enetype_mid_madman
		// {X
		(int)(125000 * 1.5),	// BOSS1
		(int)(125000 * 2),		// BOSS2
		(int)(250000 * 1.5),	// BOSS3
		(int)(125000 * 2),		// BOSS4
		(int)(125000 * 2),		// BOSS5
		(999999),				// BOSS5IvV
		(int)(100000)			// BOSS6
	},
};

// j̏oACe
int enemy_item_count[enetype_count] =
{
	0,			// DUMMY
	// G
	3,		// enetype_slime
	3,		// enetype_she_slime
	3,		// enetype_mummy
	3,		// enetype_mummy_big
	3,		// enetype_bat
	3,		// enetype_ghost
	3,		// enetype_goblin
	3,		// enetype_sorcerer
	3,		// enetype_skel
	3,		// enetype_eye
	3,		// enetype_knight
	3,		// enetype_robo
	// 
	5,		// enetype_mid_mecha
	5,		// enetype_mid_cloud
	5,		// enetype_mid_barrel
	5,		// enetype_mid_madman
	// {X
	16,		// BOSS1
	16,		// BOSS2
	16,		// BOSS3
	16,		// BOSS4
	16,		// BOSS5
	0,		// BOSS5IvV
	0		// BOSS6
};

// Ge˃[g
int eneshot_rate[game_level_count][enetype_count] =
{
	// EASY
	{
		0,			// DUMMY
		// G
		1,		// enetype_slime
		127,		// enetype_she_slime
		63,		// enetype_mummy
		63,		// enetype_mummy_big
		127,			// enetype_bat
		127,		// enetype_ghost
		31,		// enetype_goblin
		127,		// enetype_sorcerer
		1,		// enetype_skel
		63,		// enetype_eye
		1,		// enetype_knight
		63,		// enetype_robo
		// 
		255,		// enetype_mid_mecha
		255,		// enetype_mid_cloud
		127,		// enetype_mid_barrel
		255,		// enetype_mid_madman
		// {X
		1,		// BOSS1
		1,		// BOSS2
		1,		// BOSS3
		1,		// BOSS4
		1,		// BOSS5
		999999,		// BOSS5IvV
		1		// BOSS6
	}
	,
	// NOVICE
	{
		0,			// DUMMY
		// G
		1,		// enetype_slime
		63,		// enetype_she_slime
		31,		// enetype_mummy
		31,		// enetype_mummy_big
		63,			// enetype_bat
		63,		// enetype_ghost
		15,		// enetype_goblin
		63,		// enetype_sorcerer
		1,		// enetype_skel
		31,		// enetype_eye
		1,		// enetype_knight
		31,		// enetype_robo
		// 
		127,		// enetype_mid_mecha
		127,		// enetype_mid_cloud
		63,		// enetype_mid_barrel
		127,		// enetype_mid_madman
		// {X
		1,		// BOSS1
		1,		// BOSS2
		1,		// BOSS3
		1,		// BOSS4
		1,		// BOSS5
		999999,		// BOSS5IvV
		1		// BOSS6
	}
	,
	// NORMAL
	{
		0,			// DUMMY
		// G
		1,		// enetype_slime
		63,		// enetype_she_slime
		31,		// enetype_mummy
		31,		// enetype_mummy_big
		63,			// enetype_bat
		63,		// enetype_ghost
		15,		// enetype_goblin
		63,		// enetype_sorcerer
		1,		// enetype_skel
		31,		// enetype_eye
		1,		// enetype_knight
		31,		// enetype_robo
		// 
		127,		// enetype_mid_mecha
		127,		// enetype_mid_cloud
		63,		// enetype_mid_barrel
		127,		// enetype_mid_madman
		// {X
		1,		// BOSS1
		1,		// BOSS2
		1,		// BOSS3
		1,		// BOSS4
		1,		// BOSS5
		999999,		// BOSS5IvV
		1		// BOSS6
	}
	,
	// HARD
	{
		0,			// DUMMY
		// G
		1,		// enetype_slime
		15,		// enetype_she_slime
		15,		// enetype_mummy
		15,		// enetype_mummy_big
		31,			// enetype_bat
		31,		// enetype_ghost
		7,		// enetype_goblin
		31,		// enetype_sorcerer
		1,		// enetype_skel
		15,		// enetype_eye
		1,		// enetype_knight
		15,		// enetype_robo
		// 
		63,		// enetype_mid_mecha
		63,		// enetype_mid_cloud
		31,		// enetype_mid_barrel
		63,		// enetype_mid_madman
		// {X
		1,		// BOSS1
		1,		// BOSS2
		1,		// BOSS3
		1,		// BOSS4
		1,		// BOSS5
		999999,		// BOSS5IvV
		1		// BOSS6
	}
};

int boss_jewel_sptop[MAX_STAGE] = {
	0x52
	,0xFA
	,0xB2
	,0xAA
	,0xD2
	,0x92
};

#endif

#undef EXTERN
#endif
