#define __ENEMY_C__

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "item.h"
#include "esp.h"

#include "ene_slime.h"
#include "ene_mummy.h"
#include "ene_mummy_big.h"
#include "ene_bat.h"
#include "ene_goblin.h"
#include "ene_ghost.h"
#include "ene_skel.h"
#include "ene_sorcerer.h"
#include "ene_eye.h"
#include "ene_knight.h"
#include "ene_robo.h"

#include "ene_mid_mecha.h"
#include "ene_mid_cloud.h"
#include "ene_mid_barrel.h"
#include "ene_mid_madman.h"

#include "ene_boss1.h"
#include "ene_boss2.h"
#include "ene_boss3.h"
#include "ene_boss4.h"
#include "ene_boss5.h"
#include "ene_boss5opt.h"
#include "ene_boss6.h"

// -----< 萔` >-----
//
// j̃|Cg`
int pt_at_defeat[6][(POINT_DIGITS * 2) + 1] = PT_AT_DEFEAT;

// -----< vg^Cv錾 >-----
//
void get_appear_pos(OBJCRD* pCoord, BBOX* enemy_bbox);	// G̏oʒu肷

//--------------------------------------------------------------------
//	[  ]
//		void appear_enemy(int desc_line)
//
//	[  ]
//		int desc_line	Xe[WLq̃Cԍ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		
//--------------------------------------------------------------------
void appear_enemy(int desc_line)
{
	int i;
	int existing = 0;
	int absent_index = -1;
	int typecount = 0;
	int typelist[enetype_count];
	int apptype_index = -1;
	int appenemy_type = enetype_dummy;
	STAGE_DESC* pStageDesc;
	int ene_type, param;

	// <<< oۏmF >>>
	//
	// Xe[WLq擾
	pStageDesc = &(p_stage_context->stage_desc[desc_line]);

	// cȂΕԂ
	if (pStageDesc->enemy_remain <= 0) {
		return;
	}

	// Goő吔ɂȂĂԂ
	// X^bN|C^̈ʒuoołB
	existing = p_stage_objects->enemy_existing[desc_line];
	if (existing >= pStageDesc->enemy_max) {
		return;
	}

	// <<< oG̎ނI >>>
	//
	// o҂cĂGLq̃CfbNXԍꗗ
	for (i = 0; i < enetype_count; i++) {
		if (pStageDesc->stage_enemy_desc[i].remains > 0) {
			typelist[typecount] = i;
			typecount++;
		}
	}
	// oG_őI
	apptype_index = vrand() % typecount;
	ene_type = pStageDesc->stage_enemy_desc[typelist[apptype_index]].type;
	param = pStageDesc->stage_enemy_desc[typelist[apptype_index]].param;
	pStageDesc->stage_enemy_desc[typelist[apptype_index]].remains -= 1;
	pStageDesc->enemy_remain -= 1;

	// <<< Go >>>
	// X^bN^[Qbg̃CfbNX𓾂
	absent_index = POP_IDSTACK_ENEMY;
	if (absent_index < 0) {
		return;
	}
	// IuWFNg\z
	build_enemy(absent_index, ene_type, param, desc_line);
}


//--------------------------------------------------------------------
//	[  ]
//		void build_enemy(int absent_index, int ene_type, int param, int desc_line)
//
//	[  ]
//		int absent_index	enemyz̃CfbNXԍ
//		int ene_type		G̎ʁiEneType̒lj
//		int param			õIvVp[^
//		int desc_line		GoLq̃CԍB-1̏ꍇ͊ǗOB
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G̃CfbNXԍ absent_index ɂāA
//--------------------------------------------------------------------
void build_enemy(int absent_index, int ene_type, int param, int desc_line)
{
	int i;
	ENEMY* pEnemy = &(p_stage_objects->enemy[absent_index]);
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ɏoςȂ牽Ȃ
	if (pObj->status != status_absent) {
		return;
	}

	// <<< GIuWFNg >>>
	//
	memset(pEnemy, 0, sizeof(ENEMY));
	pEnemy->obj.array_index = absent_index;	// z̃CfbNXlۑ
	pPos = &(pEnemy->obj.pos);

	// zEXg
	// NXg̐擪ɍ
	if (p_stage_objects->enemy_top != NULL) {
		p_stage_objects->enemy_top->p_prev = pEnemy;
	}
	pEnemy->p_next = p_stage_objects->enemy_top;
	p_stage_objects->enemy_top = pEnemy;

	// oJEgAbv
	if (desc_line >= 0) {
		p_stage_objects->enemy_existing[desc_line] += 1;
	}


	// <<< G̎ʂƂ̏ݒ肷 >>>
	//
	pEnemy->desc_line	= desc_line;
	pEnemy->type		= ene_type;
	pEnemy->param		= param;
	pEnemy->hp			= enemy_hp_def[p_game_properties->game_level][ene_type];
	pEnemy->hp_max		= enemy_hp_def[p_game_properties->game_level][ene_type];
	if (p_game_properties->game_level <= game_level_easy) {
		// EASYȂHP
		pEnemy->hp >>= 1;
		pEnemy->hp_max >>= 1;
		if (pEnemy->hp == 0) {
			pEnemy->hp = 1;
			pEnemy->hp_max = 1;
		}
	}
	switch (ene_type) {
	case enetype_slime:
		// XC
		if (p_game_properties->game_level < game_level_hard) {
			init_slime(absent_index);
		}
		else {
			// HARD[h̏ꍇ́ASXCxXɂ
			init_she_slime(absent_index);
		}
		break;

	case enetype_she_slime:
		// XCxX
		init_she_slime(absent_index);
		break;

	case enetype_mummy:
		// ~Cj
		init_mummy(absent_index);
		break;

	case enetype_mummy_big:
		// ~Cj
		init_mummy_big(absent_index);
		break;

	case enetype_bat:
		// RE
		init_bat(absent_index);
		break;

	case enetype_goblin:
		// Su
		init_goblin(absent_index);
		break;

	case enetype_ghost:
		// ΂
		init_ghost(absent_index);
		break;

	case enetype_sorcerer:
		// \[T[
		init_sorcerer(absent_index);
		break;

	case enetype_skel:
		// KCRc
		init_skel(absent_index);
		break;

	case enetype_eye:
		// ڋ
		init_eye(absent_index);
		break;

	case enetype_knight:
		// Rm
		init_knight(absent_index);
		break;

	case enetype_robo:
		// {
		init_robo(absent_index);
		break;

	case enetype_mid_mecha:
		// J
		init_mid_mecha(absent_index);
		break;

	case enetype_mid_cloud:
		// _
		init_mid_cloud(absent_index);
		break;

	case enetype_mid_barrel:
		// C
		init_mid_barrel(absent_index);
		break;

	case enetype_mid_madman:
		// }bh}
		init_mid_madman(absent_index);
		break;

	case enetype_boss1:
		// XC
		init_boss1(absent_index);
		break;

	case enetype_boss2:
		// XC
		init_boss2(absent_index);
		break;

	case enetype_boss3:
		// XC
		init_boss3(absent_index);
		break;

	case enetype_boss4:
		// XC
		init_boss4(absent_index);
		break;

	case enetype_boss5:
		// XC
		init_boss5(absent_index);
		break;

	case enetype_boss5opt:
		// 5{XpIvV
		init_boss5opt(absent_index);
		break;

	case enetype_boss6:
		// XC
		init_boss6(absent_index);
		break;

	default:
		// s
		kon_log("appear_enemy : sȓGʂw肳܂Btype = %d\n", ene_type);
		dispose_enemy(pEnemy);
		return;
		break;
	}

	// <<< G̏oGtFNg >>>
	switch (ene_type) {
	case enetype_boss2:
	case enetype_boss4:
		// {X̏ꍇ̏oGtFNg
		for (i = 0; i < 4; i++) {
			appear_esp_rnd(esptype_bigsmoke, pPos->hx, pPos->hy, 2 << 8);
		}
		for (i = 0; i < 8; i++) {
			appear_esp_vec(esptype_bossstar, pPos->hx, pPos->hy, vcos[i << 6] << 1, vsin[i << 6] << 1);
		}
		break;

	case enetype_boss1:
	case enetype_boss3:
	case enetype_boss5:
	case enetype_boss5opt:
	case enetype_boss6:
		// oGtFNgoȂ
		break;

	default:
		// ʏ̏oGtFNg
		appear_esp_vec(esptype_bigsmoke, pPos->hx, pPos->hy, 0, 0);
		break;
	}

	// <<< I >>>
	//
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void get_appear_pos(OBJCRD* pPos, BBOX* bbox)
//
//	[  ]
//      OBJCRD* pPos		ʊi[ւ̃|C^
//		BBOX*   enemy_bbox	IuWFNgSW猩oEfBO{bNX
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		GLN^̏oʒu肵pCoordɐݒ肵܂B
//--------------------------------------------------------------------
void get_appear_pos(OBJCRD* pCoord, BBOX* enemy_bbox)
{
	BBOX* pStageArea;		// Xe[W̃NbsOGA
	int ene_width, ene_height;
	int length, height;
	int ene_px, ene_py;
	int bx0, by0, bx1, by1;
	int stage_index = p_stage_context->stage - 1;
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

	// G̕ƍ𓱏o
	ene_width = enemy_bbox->x1 - enemy_bbox->x0 + 1;
	ene_height = enemy_bbox->y1 - enemy_bbox->y0 + 1;

	// Go\ȃGA̕E𓱏oBZNVGA1LB
	pStageArea = &(p_stage_context->enemy_appear_area);
	length = pStageArea->x1 - pStageArea->x0 - ene_width;	// L肫͈
	height = pStageArea->y1 - pStageArea->y0 - ene_height;	// L肫͈
	// ŏtB[ḧԉɗ܂̂
	if (height > 256) { height -= 140; }
	
	while (1) {
		int x, y, collision;

		// ʒu_Ō߂
		ene_px = (vrand() % length) + pStageArea->x0 - enemy_bbox->x0;	// x0͒ʏ핉̒l
		ene_py = (vrand() % height) + pStageArea->y0 - enemy_bbox->y0;	// y0͒ʏ핉̒l

		// LƂ̈ʒuX̍AL{GL{ȓ̂Ƃ͂Ȃ
		if (abs(pJikiPos->px - ene_px) < (32 + ene_width)) {
			continue;
		}

		// OǂɐڐGꍇ͂Ȃ
		bx0 = (ene_px + enemy_bbox->x0) >> 3;
		by0 = (ene_py + enemy_bbox->y0) >> 3;
		bx1 = (ene_px + enemy_bbox->x1) >> 3;
		by1 = (ene_py + enemy_bbox->y1) >> 3;
		// bx0, by0, bx1, by1̃NbsO
		bx0 = (bx0 < 0) ? 0 : bx0;	// bx00ȏ
		by0 = (by0 < 0) ? 0 : by0;	// by00ȏ
		bx1 = (bx1 >= def_stage_bg_size[stage_index][0]) ? def_stage_bg_size[stage_index][0] - 1 : bx1;
		by1 = (by1 >= def_stage_bg_size[stage_index][1]) ? def_stage_bg_size[stage_index][1] - 1 : by1;
		// OǐڐG
		collision = 0;
		for (x = bx0; x <= bx1; x++) {
			for (y = by0; y <= by1; y++) {
				unsigned char att = GET_BG_ATTRIBUTE(0, x, y);
				if (BG_WALL_CONDITION(att)) {
					// ǂƐڐGʒuȂȂ
					collision = 1;
					break;
				}
			}
			if (collision == 1) { break; }
		}
		if (collision == 1) { continue; }

		// ܂ŗNA
		break;
	}

	// ʂݒ肵ďI
	pCoord->x = ene_px;
	pCoord->y = ene_py;
}


//--------------------------------------------------------------------
//	[  ]
//		void enemy_appear_positioning_center(ENEMY* pEnemy, int width, int height)
//
//	[  ]
//      ENEMY* pEnemy		oIuWFNgւ̃|C^
//		int width			G̓蔻蕝
//		int heght			G̓蔻荂
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		GLN^̏oʒu肵āAIuWFNgɐݒ肵܂B
//--------------------------------------------------------------------
void enemy_appear_positioning_center(ENEMY* pEnemy, int width, int height)
{
	OBJCRD appear_pos;
	int ene_px, ene_py;
	CHROBJ* pEneObj = &(pEnemy->obj);

	// G̒n`̓蔻͈͂ݒ
	pEneObj->grd_bbox.x0 = -(width >> 1);
	pEneObj->grd_bbox.x1 = +(width >> 1) - 1;
	pEneObj->grd_bbox.y0 = -(height >> 1);
	pEneObj->grd_bbox.y1 = +(height >> 1) - 1;

	// G̍UE_[W蔻͈͂ݒ
	pEneObj->hit_bbox.x0 = -(width >> 1);
	pEneObj->hit_bbox.x1 = +(width >> 1) - 1;
	pEneObj->hit_bbox.y0 = -(height >> 1);
	pEneObj->hit_bbox.y1 = +(height >> 1) - 1;

	// oʒu肷
	get_appear_pos(&appear_pos, &(pEneObj->grd_bbox));
	ene_px = appear_pos.x;
	ene_py = appear_pos.y;

	// ʒuݒ
	pEneObj->pos.px = ene_px;	// ʒu
	pEneObj->pos.py = ene_py;
	pEneObj->pos.hx = ene_px << 8;	// ʒuiŒ菬_j
	pEneObj->pos.hy = ene_py << 8;
	pEneObj->prev_pos = pEneObj->pos;	// Ot[ʒut[ʒu

	// Ԃݒ肷
	pEneObj->status = status_normal;	// ʏԂ
}



//--------------------------------------------------------------------
//	[  ]
//		void enemy_appear_positioning(ENEMY* pEnemy, int width, int y0, int y1)
//
//	[  ]
//      ENEMY* pEnemy		oIuWFNgւ̃|C^
//		int width			G̓蔻蕝
//		int y0				G̓蔻́AZ^[猩gbv̈ʒuiʏ͕̒lj
//		int y1				G̓蔻́AZ^[猩{g̈ʒuiʏ͐̒lj
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		GLN^̏oʒu肵āAIuWFNgɐݒ肵܂B
//--------------------------------------------------------------------
void enemy_appear_positioning(ENEMY* pEnemy, int width, int top, int bottom)
{
	OBJCRD appear_pos;
	int ene_px, ene_py;
	CHROBJ* pEneObj = &(pEnemy->obj);

	// G̒n`̓蔻͈͂ݒ
	pEneObj->grd_bbox.x0 = -(width >> 1);
	pEneObj->grd_bbox.x1 = +(width >> 1) - 1;
	pEneObj->grd_bbox.y0 = top;
	pEneObj->grd_bbox.y1 = bottom;

	// G̍UE_[W蔻͈͂ݒ
	pEneObj->hit_bbox.x0 = -(width >> 1);
	pEneObj->hit_bbox.x1 = +(width >> 1) - 1;
	pEneObj->hit_bbox.y0 = top;
	pEneObj->hit_bbox.y1 = bottom;

	// oʒu肷
	get_appear_pos(&appear_pos, &(pEneObj->grd_bbox));
	ene_px = appear_pos.x;
	ene_py = appear_pos.y;

	// ʒuݒ
	pEneObj->pos.px = ene_px;	// ʒu
	pEneObj->pos.py = ene_py;
	pEneObj->pos.hx = ene_px << 8;	// ʒuiŒ菬_j
	pEneObj->pos.hy = ene_py << 8;
	pEneObj->prev_pos = pEneObj->pos;	// Ot[ʒut[ʒu

	// Ԃݒ肷
	pEneObj->status = status_normal;	// ʏԂ
}


//=============================================================================
// Gړ ʊOȈՔ Eړ̂
//=============================================================================
void enemy_move_simple_grounding(void* pTarget)
{
	GROUNDING_COLLISION* collision;
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	collision = &(pObj->gcol);

	// nĂ牽Ȃ
	if (collision->bottom != 0) {
		return;
	}

	// Ō떂
	pPos->vx = 0;
	pPos->vy = 512;
	pPos->hy += pPos->vy;
	pPos->py = pPos->hy >> 8;

	// GROUNDING
	if (pObj->grounding != NULL) {
		// ڒn֐̎w肪AĂяo
		pObj->grounding(pObj, 0, collision);
	}

	// uO̒lvXV
	pObj->prev_pos = *pPos;

	// t[JEg
	pObj->frame_count += 1;
}


//=============================================================================
// GɃ_[W^
//=============================================================================
void on_hit_enemy(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	int i, c;
	ENEMY* pEnemy = pTarget;
	OBJPOS* pPos = &(pEnemy->obj.pos);
	int theta;
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	pEnemy->hp -= ap;
	pEnemy->on_damage = 1;
	if (pEnemy->hp < 0) {
		int item_count = enemy_item_count[pEnemy->type];

		// G
		pEnemy->obj.status = status_absent;

		// XRAZ
		add_digit_def(p_application_context->score, SCORE_DIGITS, enemy_score_def[pEnemy->type][p_stage_objects->combo_lv]);

		// X^bNIDԂ
		dispose_enemy(pEnemy);

		// o
		//for (c = 0; c < 4; c++) {
		appear_exp(exptype_big, pPos->hx, pPos->hy, 1 << 8);
		//}
		if (startup_param.XVI) {
			for (c = 0; c < 8; c++) {
				appear_exp(exptype_small, pPos->hx, pPos->hy, 6 << 8);
			}
		}

		// n[go
		for (c = 0; c <= p_stage_objects->combo_lv; c++) {
			appear_esp_vec(esptype_heart, pPos->hx, pPos->hy, (vrand() & 0x3FF) - 512, -512 - (vrand() & 0xFF));
		}
		// |CgZ
		add_digit_def(p_application_context->point, POINT_DIGITS, pt_at_defeat[p_stage_objects->combo_lv]);

		// Ȃo
		appear_esp_vec(esptype_oinari, pPos->hx, pPos->hy, 0, -2048);

		// ACeo
		for (c = 0; c < item_count; c++) {
			theta = 320 + (vrand() & 127);
			appear_item(itemtype_dia, pPos->hx, pPos->hy, vcos[theta] << 2, (vsin[theta] << 2) + vsin[theta]);
		}

//		/* R{x esp_heart ̐ŕ\邱Ƃɂ
		// R{Ȃ\
		if (p_stage_objects->combo_lv > 0) {
			ESP* pESP = appear_esp_vec(esptype_combolv, pPos->hx, pPos->hy, 0, 0);
			if (pESP != NULL) {
				pESP->opt[0] = p_stage_objects->combo_lv;
			}
		}
//		*/

		// {`[W
		p_application_context->bomb_charge += 1;
		if (p_application_context->bomb_charge==(BOMB_CHARGE_MAX)) {
			// Q[W܂ESPo
			for (i = 0; i < 8; i++) {
				appear_esp_vec(esptype_bossstar	// {Xop̐𗬗p
					, pJikiPos->hx
					, pJikiPos->hy
					, vcos[i << 6] << 1
					, vsin[i << 6] << 1
				);
			}
			// ʉ
			play_se(&(p_sound_context->se_item[setype_bombcharge]));
		}
		if (p_application_context->bomb_charge > BOMB_CHARGE_MAX) {
			p_application_context->bomb_charge = BOMB_CHARGE_MAX;
		}

		// R{Jn
		start_combo(pPos);

		// ʉo
		play_se(&(p_sound_context->se_item[setype_enemy_down]));
	}
	else {
		// ʉ
		play_se(&(p_sound_context->se_item[setype_enedamage]));
	}
}


//=============================================================================
// GɃ_[W^ij
//=============================================================================
void on_hit_enemy_magic_only(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	// UłȂ΁Â܂ܒʂ
	if ((hittype != hittype_blade) && (hittype != hittype_charge)) {
		// ʏ̃qbg
		on_hit_enemy(hittype, pTarget, pObject, ap);
		return;
	}

	// GtFNgԊu
	if (pObject->effect_span != 0) {
		// GtFNgs̃^C~Oł͂Ȃ̂ŃXLbv
		return;
	}
	pObject->effect_span = 2;	// 3t[Ƃ1

	// ESPo
	appear_esp_rnd(esptype_spark, pObject->pos.hx, pObject->pos.hy, 256);

	// ʉ
	play_se(&(p_sound_context->se_item[setype_dashhit]));
}


//=============================================================================
// GɃ_[W^iu[ĥ݁j
//=============================================================================
void on_hit_enemy_blade_only(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ENEMY* pEnemy = pTarget;
	CHROBJ* pObjTarget = &(pEnemy->obj);
	OBJPOS* pTargetPos = &(pObjTarget->pos);

	// Û݁Â܂ܒʂ
	if ((hittype == hittype_blade) || (hittype == hittype_bomb)) {
		// ʏ̃qbg
		on_hit_enemy(hittype, pTarget, pObject, ap);
		return;
	}

	// GtFNgԊu
	if (pObject->effect_span != 0) {
		// GtFNgs̃^C~Oł͂Ȃ̂ŃXLbv
		return;
	}
	pObject->effect_span = 2;	// 3t[Ƃ1

	// ESPo
	appear_esp_rnd(esptype_spark, pTargetPos->hx, pTargetPos->hy, 768);
	appear_esp_rnd(esptype_spark, pTargetPos->hx, pTargetPos->hy, 768);
	appear_esp_rnd(esptype_spark, pTargetPos->hx, pTargetPos->hy, 768);

	// ʉ
	play_se(&(p_sound_context->se_item[setype_dashhit]));	// 
}


//=============================================================================
// GɃ_[W^iV[hj
//=============================================================================
void on_hit_enemy_has_shield(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	int eneDir = pEnemy->obj.direction;
	int shotDir = pObject->direction;

	// Ăꍇ̕Uƃ`[WyȊOz̏ꍇ̓_[Wʂ
	if (
		(hittype != hittype_charge)
		&& !(((hittype == hittype_blade) || (hittype == hittype_dash)) && (eneDir != shotDir))
		) {
		// ʏ̃qbg
		on_hit_enemy(hittype, pTarget, pObject, ap);
		return;
	}

	// GtFNgԊu
	if (pObject->effect_span != 0) {
		// GtFNgs̃^C~Oł͂Ȃ̂ŃXLbv
		return;
	}
	pObject->effect_span = 2;	// 3t[Ƃ1

	// ESPo
	appear_esp_rnd(esptype_spark, pObject->pos.hx, pObject->pos.hy, 256);

	// ʉ
	play_se(&(p_sound_context->se_item[setype_dashhit]));
}


//=============================================================================
// {XɃ_[W^
//=============================================================================
void on_hit_boss(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	int c;
	ENEMY* pEnemy = pTarget;
	OBJPOS* pPos = &(pEnemy->obj.pos);
	int theta;

	// ʏԂłȂ΃qbgȂ
	if (pEnemy->obj.status == status_on_down) {
		return;
	}

	pEnemy->hp -= ap;
	pEnemy->on_damage = 1;
	if (pEnemy->hp < 0) {
		int item_count = enemy_item_count[pEnemy->type];
		if (p_game_properties->game_level <= game_level_novice) {
			// C[W[Em[rX̏ꍇ́Aő̃ACeo
			if (item_count > 0) {
				item_count = MAX_ITEM;
			}
		}

		// _EɑJ
		pEnemy->obj.status = status_on_down;
		pEnemy->obj.frame_count = 0;

		// XRAZ
		add_digit_def(p_application_context->score, SCORE_DIGITS, enemy_score_def[pEnemy->type][p_stage_objects->combo_lv]);

		//// R{Ȃ\
		//if (p_stage_objects->combo_lv > 0) {
		//	ESP* pESP = appear_esp_vec(esptype_combolv, pPos->hx, pPos->hy, 0, -256);
		//	if (pESP != NULL) {
		//		pESP->opt[0] = p_stage_objects->combo_lv;
		//	}
		//}

		// R{Jn
		start_combo(pPos);

		// ACeoOɕ΂̉摜ł
		stack_transfer_sp(
			p_stage_context->boss_sp_slot
			, boss_jewel_sptop[p_stage_context->stage - 1]
			, p_stage_context->cmn_sp_top + 0x3F
			, 2
		);

		// ACeo
		for (c = 0; c < item_count; c++) {
			theta = 320 + (vrand() & 127);
			appear_item(
				itemtype_boss_dia
				, pPos->hx
				, pPos->hy
				, vcos[theta] << 2
				, (vsin[theta] << 2)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)	// Y_vf
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
				+ ((vrand() & 1) == 1 ? vsin[theta] : 0)
			);
		}

		// L𖳓GԂɂ
		p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
		p_stage_objects->jiki.invincible_no_blink = 1;
	}
	else {
		// ʉ
		play_se(&(p_sound_context->se_item[setype_enedamage]));
	}
}

//=============================================================================
// Ge˃fBCo^
//=============================================================================
void regist_eneshot_delay(ENEMY* pEnemy, int offset_hx, int offset_hy) {
	OBJPOS* pPos = &(pEnemy->obj.pos);

	// fBCo^
	pEnemy->eneshot_delay[pEnemy->eneshot_delay_regist++] = 60;
	pEnemy->eneshot_delay_regist &= 63;

	// ESPo
	appear_esp_vec(esptype_eneshotmark, pPos->hx + offset_hx, pPos->hy + offset_hy, 0, 0);
}

//=============================================================================
// Ge˃fBC
//=============================================================================
void process_eneshot_delay(ENEMY* pEnemy) {
	int i;

	// OmF
	if ((pEnemy == NULL)	//
		|| (pEnemy->obj.status==status_absent)	//
		|| (pEnemy->do_eneshot == NULL)) {
		return;
	}
	if (pEnemy->eneshot_delay[pEnemy->eneshot_delay_control] <= 0) {
		// o^Ȃ΂̂܂܏I
		return;
	}

	// fBCio^ꍇׂ͂ăJEg_Ej
	for (i = 0; i < 64; i++) {
		// XLĂ0炻܂
		int index = (pEnemy->eneshot_delay_control + i) & 63;
		if (pEnemy->eneshot_delay[index] == 0) { break; }

		// JEg炷
		pEnemy->eneshot_delay[index] -= 1;
	}

	// JEg[Ŕ
	if (pEnemy->eneshot_delay[pEnemy->eneshot_delay_control] == 0) {
		// fBCJEg[ɂȂCfbNXɐi߂
		pEnemy->eneshot_delay_control++;
		pEnemy->eneshot_delay_control &= 63;

		// ˏs
		pEnemy->do_eneshot(pEnemy);

		// ʉ
		play_se(&(p_sound_context->se_item[setype_eneshot]));
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void enemy_clip_section(ENEMY* pEnemy)
//
//	[  ]
//		ENEMY* pEnemy	Gւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G̈ʒuZNVɃNbsO
//		ʊOɏoȂ悤ɂ
//--------------------------------------------------------------------
void enemy_clip_section(ENEMY* pEnemy)
{
	// Wl
	OBJPOS* pPos = &(pEnemy->obj.pos);

	// NbsO͈̔͂𓾂
	int* box = def_stage_section_area[p_stage_context->stage - 1][p_stage_context->section - 1][0];

	// NbsO
	// top
	if (pPos->py < box[1]) {
		pPos->py = box[1];
		pPos->hy = pPos->py << 8;
	}
//	// bottom
//	if (pPos->py > box[3]) {
//		pPos->py = box[3];
//		pPos->hy = pPos->py << 8;
//	}
	// left
	if (pPos->px < box[0]) {
		pPos->px = box[0];
		pPos->hx = pPos->px << 8;
	}
	// right
	if (pPos->px > box[2]) {
		pPos->px = box[2];
		pPos->hx = pPos->px << 8;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void enemy_transsp_boss_gauge(ENEMY* pEnemy, int gauge_def_top, int target_top)
//
//	[  ]
//		ENEMY* pEnemy		Gւ̃|C^
//		int gauge_def_top	]̃Q[Wp^[̐擪CfbNX
//		int target_top		]SP`CfbNX
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SP̃p^[p̗̈悩ASP`̈HPQ[W
//		p^[]܂B
//--------------------------------------------------------------------
void enemy_transsp_boss_gauge(ENEMY* pEnemy, int gauge_def_top, int target_top)
{
	int gauge, gauge0, gauge1;

	// SP`iQ[Wj
	//gauge = (((pEnemy->hp << 8) * 31) / (pEnemy->hp_max)) >> 8;	// 0`31
	gauge = (((pEnemy->hp << 6) * 31) / (pEnemy->hp_max)) >> 6;	// 0`31  8bitVtgƌꂷ
	if (gauge < 16) {
		gauge0 = gauge_def_top + 1 + (gauge & 0xF);
		gauge1 = gauge_def_top + 1;
	}
	else {
		gauge0 = gauge_def_top + 17;
		gauge1 = gauge_def_top + 1 + ((gauge - 16) & 0xF);
	}
	stack_transfer_sp(p_stage_context->boss_sp_slot, gauge_def_top, target_top, 1);
	stack_transfer_sp(p_stage_context->boss_sp_slot, gauge0, target_top + 1, 1);
	stack_transfer_sp(p_stage_context->boss_sp_slot, gauge1, target_top + 2, 1);
}


//--------------------------------------------------------------------
//	[  ]
//		void enemy_draw_boss_gauge(ENEMY* pEnemy, int offset_x, int offset_y)
//
//	[  ]
//		ENEMY* pEnemy		Gւ̃|C^
//		int offset_x		G̒S̃ItZbgʒuX
//		int offset_y		G̒S̃ItZbgʒuY
//		int sp_top			Q[WSP̃gbv
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		{XHPQ[W`悵܂
//--------------------------------------------------------------------
void enemy_draw_boss_gauge(ENEMY* pEnemy, int offset_x, int offset_y, int sp_top)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int allocsp = 0;
	int hx, hy;
	int px, py;
	int ox, oy;
	int x;

	// ʏԂłȂΕ`sv
	if (pEnemy->obj.status == status_on_down) {
		return;
	}

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP32g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// SItZbgړ
	ox = px + offset_x;
	oy = py + offset_y;
	// [
	SP_SET(sp, ox, oy, sp_top, 7, 0, 0, 3);
	sp++;
	// E[
	SP_SET(sp, ox + 47, oy, sp_top, 7, 1, 0, 3);
	sp++;

	// 2
	ox += 16;
	for (x = 0; x < 2; x++) {
		SP_SET(sp, ox, oy, sp_top + 1 + x, 7, 0, 0, 3);
		sp++;
		ox += 16;
	}
}
