#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_sorcerer.h"

// vg^Cv錾
void move_sorcerer_normal(void* pEnemy);
void move_sorcerer_simple(void* pEnemy);
void eneshot_sorcerer(void* pEnemy);

// 萔`
int sorcerer_sptop[6] = { 0x98, 0x98 , 0xA8 , 0x98 , 0xA8 , 0x9C };

//=============================================================================
// o
//=============================================================================
void init_sorcerer(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 14;
	int ene_top = -14;
	int ene_bottom = 15;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_sorcerer;			// ړ֐
	pEnemy->obj.draw = draw_sorcerer;			// `֐
	pEnemy->do_eneshot = eneshot_sorcerer;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ
	// Option[0] : ړx
	pEnemy->option_param[0] = (p_game_properties->game_level < game_level_hard ? 400 : 500);

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_sorcerer(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_sorcerer_normal(pTarget);
	}
	else {
		move_sorcerer_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_sorcerer_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	JIKI* pJiki = (JIKI*)(&(p_stage_objects->jiki));
	OBJPOS* pJikiPos = &(pJiki->obj.pos);
	int diff_x, diff_y;
	int speed = pEnemy->option_param[0];

	// LƂ̍擾
	diff_x = pPos->hx - pJikiPos->hx;
	diff_y = pPos->hy - pJikiPos->hy;

	if (diff_x < 0) { pPos->vx = speed; }
	if (diff_x > 0) { pPos->vx = -speed; }
	if (diff_y < 0) { pPos->vy = speed; }
	if (diff_y > 0) { pPos->vy = -speed; }
	if ((abs(diff_x) >> 8) < 4) { pPos->vx = 0; }
	if ((abs(diff_y) >> 8) < 4) { pPos->vy = 0; }

	// 
	if (diff_x > 0) {
		pObj->direction = dir_left;
	} else {
		pObj->direction = dir_right;
	}
	if (pJiki->obj.direction != pObj->direction) {
		pPos->vx = pPos->vx >> 2;
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Ge
	//if ((vrand() & 255) == 0) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_sorcerer]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiʊOȑfj
//=============================================================================
void move_sorcerer_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_sorcerer(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	JIKI* pJiki = (JIKI*)(&(p_stage_objects->jiki));
	OBJPOS* pJikiPos = &(pJiki->obj.pos);
	int diff_x, diff_y;
	int vx, vy;

	// LƂ̍擾
	diff_x = pPos->hx - pJikiPos->hx;
	diff_y = pPos->hy - pJikiPos->hy;

	// LƂ̋߂B2b炢œ鑬x
	vx = -(diff_x >> 7);
	vy = -(diff_y >> 7);
	appear_eneshot(eneshottype_sor, pPos->hx, pPos->hy, vx, vy);

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_sorcerer(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 14 : 15;
	int sptop = sorcerer_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py, sptop + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py, sptop + 1 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 2 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 3 + (anim << 2), pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py, sptop + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py, sptop + 1 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 2 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 3 + (anim << 2), pal, 1, 0, 3);
		sp++;
	}

	return;
}
