#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "enemy.h"
#include "ene_slime.h"
#include "stage.h"

// <<< 萔` >>>
int slime_sptop[6] = { 0x90, 0x90 , 0x3C , 0x80 , 0x90 , 0x90 };

// <<< vg^Cv錾 >>>
// slime
void move_slime_normal(void* pEnemy);		// ړiʏj
void move_slime(void* pEnemy);				// ړ
void draw_slime(void* pEnemy);				// `揈
// she-slime
void move_she_slime_normal(void* pEnemy);	// ړiʏj
void move_she_slime(void* pEnemy);			// ړ
void eneshot_she_slime(void* pEnemy);		// Ge
void draw_she_slime(void* pEnemy);			// `揈

//=============================================================================
// o
//=============================================================================
void init_slime(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 16;
	int ene_height = 24;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// ݒ
	pEnemy->obj.move = move_slime;			// ړ֐
	pEnemy->obj.draw = draw_slime;			// `֐
	if (((p_stage_context->stage < 4))) {
		pEnemy->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	}
	else {
		pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	}
	pEnemy->do_eneshot = NULL;	// Geˊ֐Ȃ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	// I
	return;
}


//=============================================================================
// ړ
//============================================================================
void move_slime(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_slime_normal(pTarget);
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_slime_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// nĂWv
	if (pObj->gcol.bottom != 0) {
		pPos->vy = -(2 << 8);
	}

	// Eړ
	if( (pObj->frame_count&63)==0 ) {
		int rnd = vrand();
		pPos->vx = 0;
		if ((rnd & 0xFF) < 64) {
			if (rnd & 1) {
				pPos->vx = 128;
			}
			else {
				pPos->vx = -128;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// UȂ

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_slime(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int iy;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;

	// SPR[h̐擪I
	int sp_code_top = slime_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP2g
	if (allocsp < 2) {
		// mۂłȂ`߂
		return;
	}
	for (iy = 0; iy < allocsp; iy++) {
		// }bvobt@Ƀf[^i[
		SP_SET(sp, px + 8, py + (iy << 4 ), sp_code_top + iy + (anim << 1), pal, 0, 0, 3);
		// 
		sp++;
	}

	return;
}

//=============================================================================
// She-slimeo
//=============================================================================
void init_she_slime(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 16;
	int ene_height = 24;

	// o̍\̂𓾂
	pEnemy = &(p_stage_context->stage_objects.enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// ݒ
	pEnemy->obj.move = move_she_slime;			// ړ֐
	pEnemy->obj.draw = draw_she_slime;		// `֐
	if (((p_stage_context->stage < 4))) {
		pEnemy->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	}
	else {
		pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	}
	pEnemy->do_eneshot = eneshot_she_slime;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	// I
	return;
}


//=============================================================================
// ړ
//============================================================================
void move_she_slime(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen == 0) {
		move_she_slime_normal(pTarget);
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// She-slimeړiʏj
//=============================================================================
void move_she_slime_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// nĂWv
	if (pObj->gcol.bottom != 0) {
		pPos->vy = -(2 << 8);
	}

	// Eړ
	if ((pObj->frame_count & 63) == 0) {
		int rnd = vrand();
		pPos->vx = 0;
		if ((rnd & 0xFF) < 64) {
			if (rnd & 1) {
				pPos->vx = 128;
			}
			else {
				pPos->vx = -128;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// Ge
	//if ((vrand() & 255) == 0) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_she_slime]) == 0) {
			regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// She-slimeGeˏ
//=============================================================================
void eneshot_she_slime(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// Ge
	int idx;
	int dif = -((vrand() & 31) + (vrand() & 15));
	if ((p_stage_objects->jiki.obj.pos.px - pPos->px) > 0) {
		// LE
		idx = dif;
	}
	else {
		// L
		idx = 255 - dif;
	}

	idx = idx & 511;
	appear_eneshot(eneshottype_normal, pPos->hx, pPos->hy, vcos[idx] + (vcos[idx] >> 1), vsin[idx] + (vsin[idx] >> 1));
	idx = (idx + 64) & 511;
	appear_eneshot(eneshottype_normal, pPos->hx, pPos->hy, vcos[idx] + (vcos[idx] >> 1), vsin[idx] + (vsin[idx] >> 1));
	idx = (idx - 128) & 511;
	appear_eneshot(eneshottype_normal, pPos->hx, pPos->hy, vcos[idx] + (vcos[idx] >> 1), vsin[idx] + (vsin[idx] >> 1));

	// I
	return;
}

//=============================================================================
// She-slime `揈
//=============================================================================
void draw_she_slime(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int iy;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 13 : 15;

	// SPR[h̐擪I
	int sp_code_top = slime_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP2g
	if (allocsp < 2) {
		// mۂłȂ`߂
		return;
	}
	for (iy = 0; iy < allocsp; iy++) {
		// }bvobt@Ƀf[^i[
		SP_SET(sp, px + 8, py + (iy << 4), sp_code_top + iy + (anim << 1), pal, 0, 0, 3);
		// 
		sp++;
	}

	return;
}
