#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_skel.h"

// vg^Cv錾
void move_skel_normal(void* pEnemy);
void move_skel_charge(void* pEnemy);
void move_skel_dash(void* pEnemy);
void move_skel_simple(void* pEnemy);

// 萔`
int skel_sptop[6] = { 0x90, 0x90 , 0x90 , 0x84 , 0x94 , 0xA4 };

//=============================================================================
// o
//=============================================================================
void init_skel(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 26;
	int ene_top = -20;
	int ene_bottom = 23;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_skel;			// ړ֐
	pEnemy->obj.draw = draw_skel;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->do_eneshot = NULL;	// Geˏ
	if (p_game_properties->game_level <= game_level_easy) {
		// C[W[̏ꍇׂ͂Ă̍U󂯕t
		pEnemy->obj.on_hit = on_hit_enemy;
	}
	else {
		// C[W[łȂꍇ͔wォ̍U󂯕t
		pEnemy->obj.on_hit = on_hit_enemy_has_shield;
	}

	// Ԓlݒ
	pEnemy->obj.status = status_normal;

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_skel(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		if (pObj->status == status_charge) {
			// `[W
			move_skel_charge(pTarget);
		}
		else if (pObj->status == status_dash) {
			// _bV
			move_skel_dash(pTarget);
		}
		else {
			// ʏԂ̈ړ
			move_skel_normal(pTarget);
		}

		// Yx
		if (BG_STEP_CONDITION(pObj->gcol.bottom)) {
			// ڒnĂYړ~߂
			// Ƃ߂ĂȂƁAŏIXe[WŔɈ͂܂ꂽӏ
			// V܂ňグĂ܂
			pObj->pos.vy = 0;
		}
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_skel_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	CHROBJ* pJikiObj = &(p_stage_objects->jiki.obj);
	OBJPOS* pJikiPos = &(pJikiObj->pos);
	int same_line = 0;

	// nʂ𒲂ׂ
	if (pObj->gcol.bottom != BG_ATTRIBUTE_NOP) {
		int nx, ny;
		int ground_code;

		if (pObj->direction == dir_left) {
			nx = (((pPos->hx + pPos->vx) >> 8) - 4) >> 3;	// ړ4sNZ炢
		}
		else {
			nx = (((pPos->hx + pPos->vx) >> 8) + 4) >> 3;	// ړ4sNZ炢
		}
		ny = (pPos->py + pObj->grd_bbox.y1 + 4) >> 3;	// [+4px炢

		// nʒ̃NbsO
		if (nx < 0) { nx = 0; }
		if (ny < 0) { ny = 0; }
		if (nx >= p_stage_context->bgmap_width) {
			nx = p_stage_context->bgmap_width - 1;
		}
		if (ny >= p_stage_context->bgmap_height) {
			ny = p_stage_context->bgmap_height - 1;
		}

		// R[h
		ground_code = GET_BG_ATTRIBUTE(0, nx, ny);
		if (!BG_STEP_CONDITION(ground_code)) {
			// ȂƂ͔]
			if (pObj->direction == dir_left) { pObj->direction = dir_right; }
			else { pObj->direction = dir_left; }
		}
	}

	// ꃉC𔻒肷iɗj
	same_line = 0;
	if ((pPos->py + pObj->grd_bbox.y1) == (pJikiPos->py + pJikiObj->grd_bbox.y1)) {
		same_line = 1;
	}
	// ꃉCʒuiɗj
	if (same_line) {
		int dx = pPos->px - pJikiPos->px;

		// HARD̏ꍇ͌
		if (p_game_properties->game_level >= game_level_hard) {
			if (dx > 0) {
				// LEɂꍇ͍
				pObj->direction = dir_left;
			}
			else {
				// Lƈvɂꍇ͉E
				pObj->direction = dir_right;
			}
		}

		// GLĂȂ甭
		if (   (dx > 0) && (pObj->direction == dir_left )	//
			|| (dx < 0) && (pObj->direction == dir_right)
		) {
			pObj->status = status_charge;
			pObj->frame_count = 0;
			appear_esp_vec(esptype_eneshotmark, pPos->hx, pPos->hy, 0, 0);
		}
	}

	// Eړ
	if (pObj->direction == dir_left) {pPos->vx = -(1 << 7);}
	else { pPos->vx = (1 << 7); }
	if (	//
		((pPos->hx < (p_stage_context->stage_clipping_area.x0 - pObj->grd_bbox.x0) << 8) && (pObj->direction == dir_left))	//
		|| ((pPos->hx > (p_stage_context->stage_clipping_area.x1 - pObj->grd_bbox.x1) << 8) && (pObj->direction == dir_right))
		) {
		// ʒ[Ŕ]
		pPos->vx *= -1;
		pObj->direction = (pObj->direction == dir_left ? dir_right : dir_left);
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// I
	return;
}

//=============================================================================
// ړi`[Wj
//=============================================================================
void move_skel_charge(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// ԑJڐ
	if (pObj->frame_count > 60) {
		pObj->frame_count = 0;
		pObj->status = status_dash;
		if (pObj->direction == dir_left) {
			pPos->vx = -(16 << 8);
			appear_eneshot(eneshottype_wave, pPos->hx, pPos->hy, -1024, 0);
		}
		else {
			pPos->vx = (16 << 8);
			appear_eneshot(eneshottype_wave, pPos->hx, pPos->hy, 1024, 0);
		}
	}

	// I
	return;
}

//=============================================================================
// ړi_bVj
//=============================================================================
void move_skel_dash(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// x𗎂Ƃ
	pPos->vx = (pPos->vx >> 1) + (pPos->vx >> 2);

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// ~ԂƂɖ߂
	if (abs(pPos->vx) < (1 << 7)) {
		// ~ԂƂɖ߂
		pPos->vx = 0;
		pObj->status = status_normal;
	}

	// I
	return;
}


//=============================================================================
// ړiȑfj
//=============================================================================
void move_skel_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_skel(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int raindex = 0;
	int allocsp = 0;
	int pal = 5;
	int sptop = skel_sptop[p_stage_context->stage - 1];
	if (pObj->status != status_charge) {
		// ʏ
		pal = pEnemy->on_damage == 0 ? 12 : 15;
	}
	else {
		// `[W
		pal = pEnemy->on_damage == 0 ? 12 : 15;
	}
	

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;
	raindex = ((p_stage_objects->frame_count >> 3) << 3) & 0x1FF;	// 8t[Ƃ8CfbNXԍ

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(8);	// SP8g
	if (allocsp < 8) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		// Shield
		SP_SET(sp, px + 16 + (vrandom[raindex] & 3), py + 20 + (vrandom[raindex + 1] & 3), sptop + 11, pal, 0, 0, 3);
		sp++;
		// Body
		SP_SET(sp, px + 8 + (vrandom[raindex + 4] & 1), py + 24 + (vrandom[raindex + 5] & 1), sptop + 10, pal, 0, 0, 3);
		sp++;
		// Head
		SP_SET(sp, px - 2, py - 1 - (anim << 1), sptop + 4, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 14, py - 1 - (anim << 1), sptop + 5, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px - 2, py + 15 - (anim << 1), sptop + 6 + (anim << 1), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 14, py + 15 - (anim << 1), sptop + 7 + (anim << 1), pal, 0, 0, 3);
		sp++;
		// Blade
		switch (pObj->status) {
		case status_charge:
			// `[W
			SP_SET(sp, px, py - 14, sptop + 2, pal, 0, 0, 3);
			sp++;
			SP_SET(sp, px + 16, py - 14, sptop + 3, pal, 0, 0, 3);
			sp++;
			break;
		case status_dash:
			// U肨낵
			SP_SET(sp, px + 1, py + 24, sptop + 2, pal, 1, 1, 3);
			sp++;
			SP_SET(sp, px - 15, py + 24, sptop + 3, pal, 1, 1, 3);
			sp++;
			break;
		default:
			// ʏ
			SP_SET(sp, px -6 + (vrandom[raindex + 2] & 1), py - 4 + (vrandom[raindex + 3] & 1), sptop + 0, pal, 0, 0, 3);
			sp++;
			SP_SET(sp, px -6 + (vrandom[raindex + 2] & 1), py + 12 + (vrandom[raindex + 3] & 1), sptop + 1, pal, 0, 0, 3);
			sp++;
			break;
		}
	}
	else {
		// Shield
		SP_SET(sp, px + (vrandom[raindex + 0] & 1), py + 20 + (vrandom[raindex + 1] & 1), sptop + 11, pal, 1, 0, 3);
		sp++;
		// Body
		SP_SET(sp, px + 8 + (vrandom[raindex + 4] & 1), py + 24 + (vrandom[raindex + 5] & 1), sptop + 10, pal, 1, 0, 3);
		sp++;
		// Head
		SP_SET(sp, px + 18, py - 1 - (anim << 1), sptop + 4, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 2, py - 1 - (anim << 1), sptop + 5, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 18, py + 15 - (anim << 1), sptop + 6 + (anim << 1), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 2, py + 15 - (anim << 1), sptop + 7 + (anim << 1), pal, 1, 0, 3);
		sp++;
		// Blade
		switch (pObj->status) {
		case status_charge:
			// `[W
			SP_SET(sp, px + 16, py - 14, sptop + 2, pal, 1, 0, 3);
			sp++;
			SP_SET(sp, px, py - 14, sptop + 3, pal, 1, 0, 3);
			sp++;
			break;
		case status_dash:
			// U肨낵
			SP_SET(sp, px + 15, py + 24, sptop + 2, pal, 0, 1, 3);
			sp++;
			SP_SET(sp, px + 31, py + 24, sptop + 3, pal, 0, 1, 3);
			sp++;
			break;
		default:
			// ʏ
			SP_SET(sp, px + 22 + (vrandom[raindex + 2] & 1), py - 4 + (vrandom[raindex + 3] & 1), sptop + 0, pal, 1, 0, 3);
			sp++;
			SP_SET(sp, px + 22 + (vrandom[raindex + 2] & 1), py + 12 + (vrandom[raindex + 3] & 1), sptop + 1, pal, 1, 0, 3);
			sp++;
			break;
		}
	}

	return;
}
