#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_robo.h"

// vg^Cv錾
void move_robo_normal(void* pEnemy);
void move_robo_simple(void* pEnemy);
void eneshot_robo(void* pEnemy);

// 萔`
int robo_sptop[6] = { 0x90, 0x90 , 0x90 , 0x90 , 0xB0 , 0xB0 };

//=============================================================================
// o
//=============================================================================
void init_robo(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 14;
	int ene_top = -14;
	int ene_bottom = 15;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_robo;			// ړ֐
	pEnemy->obj.draw = draw_robo;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->do_eneshot = eneshot_robo;	// Geo
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_robo(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_robo_normal(pTarget);
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_robo_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// Eړ
	if( (pObj->frame_count&127)==0 ) {
		int rnd = vrand();
		if (rnd & 1) {
			pPos->vx = 64;
			pObj->direction = dir_right;
		}
		else {
			pPos->vx = -64;
			pObj->direction = dir_left;
		}
	}


	// ܂ɃWvXebv_E
	if ((pObj->frame_count & 63) == 0) {
		if (pObj->gcol.bottom != BG_ATTRIBUTE_NOP) {
			int type;
			pObj->status = status_normal;

			// WvXebv_EȂ
			type = vrand() & 3;
			if (type == 0) {
				// Wv
				pPos->vy = (-(6 << 8)) - (vrand() & 0xFF);
			}
			else if (type == 1) {
				// Xebv_EiXe[gpj
				pObj->status = status_dash;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, (pObj->status == status_dash), MOVE_GRAVITY >> 1);

	// Ge
	//if ((vrand() & 255) == 0) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_robo]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiȑfj
//=============================================================================
void move_robo_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// I
	return;
}

//=============================================================================
// Geo
//=============================================================================
void eneshot_robo(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	int offset = pObj->frame_count;
	int dir = 0;
	for (dir = 0; dir < 512; dir += 64) {
		int idx = (dir + offset) & 511;
		appear_eneshot(eneshottype_normal, pPos->hx, pPos->hy, vcos[idx] << 1, vsin[idx] << 1);
	}

	// HARD̂Ƃ́Aɒeo
	if (p_game_properties->game_level >= game_level_hard) {
		if (pObj->direction == dir_left) {
			// 
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[256 + 21], vsin[256 + 21] << 1);
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[256 + 57], vsin[256 + 57] << 1);
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[256 + 100], vsin[256 + 100] << 1);
		}
		else {
			// E
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[512 - 21], vsin[512 - 21] << 1);
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[512 - 57], vsin[512 - 57] << 1);
			appear_eneshot(eneshottype_gravity, pPos->hx, pPos->hy, vcos[512 - 100], vsin[512 - 100] << 1);
		}
	}

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_robo(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 14 : 15;
	int sptop = robo_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py, sptop + 0 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py, sptop + 1 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 2 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 3 + (anim << 2), pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py, sptop + 0 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py, sptop + 1 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 2 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 3 + (anim << 2), pal, 1, 0, 3);
		sp++;
	}

	return;
}
