#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_mummy_big.h"

// vg^Cv錾
void move_mummy_big_normal(void* pEnemy);
void eneshot_mummy_big(void* pEnemy);

// 萔`
int mummy_big_sptop[6] = { 0xA0, 0xA0 , 0xA0 , 0x90 , 0x90 , 0x90 };

//=============================================================================
// o
//=============================================================================
void init_mummy_big(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 24;
	int ene_top = -31;
	int ene_bottom = 31;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_mummy_big;			// ړ֐
	pEnemy->obj.draw = draw_mummy_big;			// `֐
	if (((p_stage_context->stage < 4))) {
		pEnemy->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	}
	else {
		pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	}
	pEnemy->do_eneshot = eneshot_mummy_big;
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_mummy_big(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_mummy_big_normal(pTarget);
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_mummy_big_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// EړBɌĂ
	if( (pObj->frame_count&127)==0 ) {
		JIKI* pJiki = &(p_stage_objects->jiki);
		int diff_x = pJiki->obj.pos.hx - pPos->hx;
		if (diff_x >= 0) {
			pPos->vx = 48;
			pObj->direction = dir_right;
		}
		else {
			pPos->vx = -48;
			pObj->direction = dir_left;
		}

		// _ŃWv
		if (((vrand() & 1) == 0) && (pObj->gcol.bottom != 0)) {
			pPos->vy = -(3 << 8);
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 3);

	// Ge
	//if ((vrand() & 127) == 0) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_mummy_big]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_mummy_big(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	if (pObj->direction == dir_left) {
		// 
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[256 + 21] << 1, vsin[256 + 21] << 3);
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[256 + 57] << 1, vsin[256 + 57] << 3);
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[256 + 100] << 1, vsin[256 + 100] << 3);
	}
	else {
		// E
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[512 - 21] << 1, vsin[512 - 21] << 3);
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[512 - 57] << 1, vsin[512 - 57] << 3);
		appear_eneshot(eneshottype_grav_spd, pPos->hx, pPos->hy, vcos[512 - 100] << 1, vsin[512 - 100] << 3);
	}

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_mummy_big(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int sptop = mummy_big_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(8);	// SP2g
	if (allocsp < 8) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		for (y = 0; y < 4; y++) {
			SP_SET(sp, px + 0, py - 16 + (y << 4), sptop + (y << 1) + (anim << 3), pal, 0, 0, 3);
			sp++;
			SP_SET(sp, px + 16, py - 16 + (y << 4), sptop + (y << 1) + 1 + (anim << 3), pal, 0, 0, 3);
			sp++;
		}
	} else {
		for (y = 0; y < 4; y++) {
			SP_SET(sp, px + 16, py - 16 + (y << 4), sptop + (y << 1) + (anim << 3), pal, 1, 0, 3);
			sp++;
			SP_SET(sp, px + 0, py - 16 + (y << 4), sptop + (y << 1) + 1 + (anim << 3), pal, 1, 0, 3);
			sp++;
		}
	}

	return;
}
