#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_mid_madman.h"

// vg^Cv錾
void move_mid_madman_normal(void* pEnemy);
void move_mid_madman_simple(void* pEnemy);
void eneshot_mid_madman(void* pEnemy);

// 萔`
int mid_madman_sptop[6] = { 0xB9, 0xB9 , 0x99 , 0xB9 , 0x90 , 0xB0 };

//=============================================================================
// o
//=============================================================================
void init_mid_madman(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 22;
	int ene_top = -22;
	int ene_bottom = 23;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_mid_madman;			// ړ֐
	pEnemy->obj.draw = draw_mid_madman;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->do_eneshot = eneshot_mid_madman;
	if (p_game_properties->game_level <= game_level_easy) {
		// C[W[̏ꍇׂ͂Ă̍U󂯕t
		pEnemy->obj.on_hit = on_hit_enemy;
	}
	else {
		// C[W[łȂꍇ̓u[h󂯕t
		pEnemy->obj.on_hit = on_hit_enemy_blade_only;
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_mid_madman(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_mid_madman_normal(pTarget);
	}
	else {
		move_mid_madman_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_mid_madman_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	move_mid_madman_simple(pTarget);

	// Ge
	//if ((vrand() & 255) < 3) {
	/*
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_mid_madman]) < 2) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}
	*/
	if (	//
		((pObj->frame_count & 7) == 0)	// 8t[
		&& ( ((pObj->frame_count>>3) & 8 )==0 )	// 8PʂŌJԂ
	) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiȈՁj
//=============================================================================
void move_mid_madman_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int index = (pObj->frame_count << 4) & VARY_TABLE_MASK;

	// ړȂ

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY<<2);

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_mid_madman(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int dir = 0;

	// Ge
	if (pObj->direction == dir_left) {
		appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[256] << 2, vsin[256] << 2);
		appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[256 - 6] << 2, vsin[256 - 6] << 2);
		//appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[256 + 6] << 2, vsin[256 + 6] << 2);
	}
	else {
		appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[0] << 2, vsin[0] << 2);
		appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[512 - 6] << 2, vsin[512 - 6] << 2);
		//appear_eneshot(eneshottype_flame, pPos->hx, pPos->hy, vcos[6] << 2, vsin[6] << 2);
	}

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_mid_madman(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int spcode;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(9);	// SP9g
	if (allocsp < 9) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	spcode = mid_madman_sptop[p_stage_context->stage - 1];
	if (pObj->direction == dir_left) {
		// L1
		SP_SET(sp, px - 8, py - 8, spcode + 0, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py - 8, spcode + 1, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 24, py - 8, spcode + 2, pal, 0, 0, 3);
		sp++;
		// L2
		SP_SET(sp, px - 8, py + 8, spcode + 3, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8, spcode + 4, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 24, py + 8, spcode + 5, pal, 0, 0, 3);
		sp++;
		// L3
		SP_SET(sp, px - 8, py + 24, spcode + 6, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 24, spcode + 7, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 24, py + 24, spcode + 8, pal, 0, 0, 3);
		sp++;
	}
	else {
		// L1
		SP_SET(sp, px + 24, py - 8, spcode + 0, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py - 8, spcode + 1, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px - 8, py - 8, spcode + 2, pal, 1, 0, 3);
		sp++;
		// L2
		SP_SET(sp, px + 24, py + 8, spcode + 3, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 8, spcode + 4, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px - 8, py + 8, spcode + 5, pal, 1, 0, 3);
		sp++;
		// L3
		SP_SET(sp, px + 24, py + 24, spcode + 6, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 8, py + 24, spcode + 7, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px - 8, py + 24, spcode + 8, pal, 1, 0, 3);
		sp++;
	}

	return;
}
