#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_mid_cloud.h"

// vg^Cv錾
void move_mid_cloud_normal(void* pEnemy);
void move_mid_cloud_simple(void* pEnemy);
void eneshot_mid_cloud_st3(void* pEnemy);
void eneshot_mid_cloud(void* pEnemy);

// 萔`
int mid_cloud_sptop[6] = { 0xB9, 0xB9 , 0x99 , 0xB9 , 0xB9 , 0xB9 };
void* mid_cloud_eneshot[6] = {
	eneshot_mid_cloud
	, eneshot_mid_cloud
	, eneshot_mid_cloud_st3
	, eneshot_mid_cloud
	, eneshot_mid_cloud
	, eneshot_mid_cloud
};

//=============================================================================
// o
//=============================================================================
void init_mid_cloud(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 22;
	int ene_top = -22;
	int ene_bottom = 22;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_mid_cloud;			// ړ֐
	pEnemy->obj.draw = draw_mid_cloud;			// `֐
	pEnemy->obj.grounding = move_grounding_flying_simple;	// ڒn֐
	if (p_game_properties->game_level >= game_level_hard) {
		// HARDȂɗUeo悤ɂ
		pEnemy->do_eneshot = eneshot_mid_cloud;
	}
	else {
		// ʏ̏ꍇ̓Xe[WƂɋς
		pEnemy->do_eneshot = mid_cloud_eneshot[p_stage_context->stage - 1];	// Geˏ
	}
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_mid_cloud(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_mid_cloud_normal(pTarget);
	}
	else {
		move_mid_cloud_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_mid_cloud_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	move_mid_cloud_simple(pTarget);

	// Ge
	//if ((vrand() & 255) < 3) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_mid_cloud]) < 3) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiȈՁj
//=============================================================================
void move_mid_cloud_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int clip_x0 = p_stage_context->stage_clipping_area.x0;
	int clip_x1 = p_stage_context->stage_clipping_area.x1;
	int ay[] = { 16, -16, -16, 16 };	// t[Yx

	// ړxݒ
	pPos->ay = ay[((pObj->frame_count >> 4) & 3)];
	pPos->vx = (pObj->direction == dir_left ? -128 : 128);
	// ʒ[̃NbsO
	if (((pPos->hx + pPos->vx) >> 8) < (clip_x0 + 32)) {
		pObj->direction = dir_right;
		pPos->vx = (pObj->direction == dir_left ? -128 : 128);
	}
	if (((pPos->hx + pPos->vx) >> 8) > (clip_x1 - 32)) {
		pObj->direction = dir_left;
		pPos->vx = (pObj->direction == dir_left ? -128 : 128);
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_mid_cloud(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int index = 128 - 64;
	ENESHOT* pEneShot;

	// Ge
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_rd;

	index += 64;
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_down;

	index += 64;
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_ld;

	// GeˁiUej
	appear_eneshot(eneshottype_horming, pPos->hx, pPos->hy, -256, -256);
	appear_eneshot(eneshottype_horming, pPos->hx, pPos->hy, +256, -256);

	// I
	return;
}

//=============================================================================
// GeˏiXe[W3pFUeȂj
//=============================================================================
void eneshot_mid_cloud_st3(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int index = 128 - 64;
	ENESHOT* pEneShot;

	// Ge
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_rd;

	index += 64;
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_down;

	index += 64;
	pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vcos[index] << 2, vsin[index] << 2);
	if (pEneShot == NULL) { return; }
	pEneShot->obj.direction = dir_ld;

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_mid_cloud(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;
	int spcode;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(9);	// SP9g
	if (allocsp < 9) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	spcode = mid_cloud_sptop[p_stage_context->stage - 1];

	// L1
	SP_SET(sp, px - 8, py - 8, spcode + 0, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py - 8, spcode + 1, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py - 8, spcode + 0, pal, 1, 0, 3);
	sp++;
	// L2
	SP_SET(sp, px - 8, py + 8, spcode + 2, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 8, spcode + 3, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py + 8, spcode + 2, pal, 1, 0, 3);
	sp++;
	// L3
	SP_SET(sp, px - 8, py + 24, spcode + 4 + (anim << 1), pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 24, spcode + 5, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py + 24, spcode + 4 + (anim << 1), pal, 1, 0, 3);
	sp++;

	return;
}
