#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_mid_barrel.h"

// vg^Cv錾
void move_mid_barrel_normal(void* pEnemy);
void move_mid_barrel_simple(void* pEnemy);
void eneshot_mid_barrel(void* pEnemy);

// 萔`
int mid_barrel_sptop[6] = { 0xB9, 0xB9 , 0x99 , 0xB9 , 0xB9 , 0xB9 };

//=============================================================================
// o
//=============================================================================
void init_mid_barrel(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 22;
	int ene_top = -22;
	int ene_bottom = 22;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_mid_barrel;			// ړ֐
	pEnemy->obj.draw = draw_mid_barrel;			// `֐
	pEnemy->obj.grounding = move_grounding_flying_simple;	// ڒn֐
	pEnemy->do_eneshot = eneshot_mid_barrel;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_mid_barrel(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_mid_barrel_normal(pTarget);
	}
	else {
		move_mid_barrel_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_mid_barrel_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	move_mid_barrel_simple(pTarget);

	// Ge
	//if ((vrand() & 255) < 3) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_mid_barrel]) < 3) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiȈՁj
//=============================================================================
void move_mid_barrel_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int index = (pObj->frame_count << 3) & VARY_TABLE_MASK;

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = vsin[index];

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_mid_barrel(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);
	int diff_x, diff_y;
	int vx, vy;

	// L
	diff_x = pJikiPos->hx - pPos->hx;
	diff_y = pJikiPos->hy - pPos->hy;

	// 
	vx = diff_x >> 7;
	vy = diff_y >> 7;
	appear_eneshot(eneshottype_big, pPos->hx, pPos->hy, vx, vy);
	appear_eneshot(eneshottype_big, pPos->hx, pPos->hy	//
		, vx + ((vrand() & 511) - (vrand() & 511))	//
		, vy + ((vrand() & 511) - (vrand() & 511))	//
	);
	appear_eneshot(eneshottype_big, pPos->hx, pPos->hy	//
		, vx + ((vrand() & 511) - (vrand() & 511))	//
		, vy + ((vrand() & 511) - (vrand() & 511))	//
	);

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_mid_barrel(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 10 : 15;
	int spcode;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(9);	// SP9g
	if (allocsp < 9) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	spcode = mid_barrel_sptop[p_stage_context->stage - 1];
	// L1
	SP_SET(sp, px - 8, py - 8, spcode + 0, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py - 8, spcode + 1, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py - 8, spcode + 0, pal, 1, 0, 3);
	sp++;
	// L2
	SP_SET(sp, px - 8, py + 8, spcode + 2, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 8, spcode + 3, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py + 8, spcode + 2, pal, 1, 0, 3);
	sp++;
	// L3
	SP_SET(sp, px - 8, py + 24, spcode + 4 + (anim << 1), pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 24, spcode + 5, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 24, py + 24, spcode + 4 + (anim << 1), pal, 1, 0, 3);
	sp++;

	return;
}
