#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_knight.h"

// vg^Cv錾
void move_knight_normal(void* pEnemy);
void move_knight_simple(void* pEnemy);

// 萔`
int knite_sptop[6] = { 0xA0, 0xA0 , 0xA0 , 0x90 , 0xA0 , 0xA0 };

//=============================================================================
// o
//=============================================================================
void init_knight(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 14;
	int ene_top = -14;
	int ene_bottom = 15;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_knight;			// ړ֐
	pEnemy->obj.draw = draw_knight;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->do_eneshot = NULL;	// Geˏ
	if (p_game_properties->game_level <= game_level_easy) {
		// C[W[̏ꍇׂ͂Ă̍U󂯕t
		pEnemy->obj.on_hit = on_hit_enemy;
	}
	else {
		// C[W[łȂꍇMPU󂯕t
		pEnemy->obj.on_hit = on_hit_enemy_magic_only;
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_knight(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);
	int diff_x, diff_y, simple;

	// U𒵂˕Ԃۂ̃GtFNgԊu̐
	if (pObj->effect_span > 0) {
		pObj->effect_span -= 1;
	}

	// 𑪂
	simple = 0;
	diff_x = abs(pPos->px - pJikiPos->px);
	diff_y = abs(pPos->py - pJikiPos->py);
	if ((diff_x > 256) || (diff_y > 256)) {
		simple = 1;
	}

	// ʊOȂȈՈړ
	if (simple == 0) {
		move_knight_normal(pTarget);
	}
	else {
		move_knight_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_knight_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	JIKI* pJiki = (JIKI*)(&(p_stage_objects->jiki));
	CHROBJ* pJikiObj = &(pJiki->obj);
	OBJPOS* pJikiPos = &(pJikiObj->pos);
	int diff_x, diff_y;
	int speed = 768;

	// ړ
	diff_x = abs(pPos->px - pJikiPos->px);
	diff_y = abs(pPos->py - pJikiPos->py);

	// ^C~Oi32t[1j
	if ((p_stage_objects->frame_count & 0x1F) == 0) {
		// Xړ
		if (pJikiPos->px - pPos->px < 0) {
			// 
			pObj->direction = dir_left;
			pPos->vx = -(speed - (vrand() & 0xFF));
		}
		else {
			// E
			pObj->direction = dir_right;
			pPos->vx = (speed - (vrand() & 0xFF));
		}

		// WvXebv_E
		if (pObj->gcol.bottom != BG_ATTRIBUTE_NOP) {
			// ڒnĂ
			int jikiBottomY, eneBottomY;
			pObj->status = status_normal;

			// Wv or Xebv_E
			jikiBottomY = pJikiPos->py + pJikiObj->grd_bbox.y1;
			eneBottomY = pPos->py + pObj->grd_bbox.y1;
			if ((eneBottomY - jikiBottomY) > 0) {
				// Wv
				pPos->vy = (-(6 << 8)) - (vrand() & 0xFF);
			}
			else if ((eneBottomY - jikiBottomY) < 0) {
				// Xebv_EiXe[gpj
				pObj->status = status_dash;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, (pObj->status == status_dash), MOVE_GRAVITY >> 1);

	// I
	return;
}

//=============================================================================
// ړiȑfj
//=============================================================================
void move_knight_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_knight(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int sptop = knite_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py, sptop + 0 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py, sptop + 1 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 2 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 3 + (anim << 2), pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py, sptop + 0 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py, sptop + 1 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 2 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 3 + (anim << 2), pal, 1, 0, 3);
		sp++;
	}

	return;
}
