#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "kon_util.h"
#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_goblin.h"

// vg^Cv錾
void move_goblin_far(void* pEnemy);
void move_goblin_near(void* pEnemy);
void eneshot_goblin(void* pEnemy);

// 萔`
int goblin_sptop[2][6] = {
	{ 0xA0, 0xA0 , 0xB0 , 0x90 , 0x90 , 0x90 }
	, { 0xA0, 0xA0 , 0xB0 , 0x90 , 0x90 , 0x90 }
};

//=============================================================================
// o
//=============================================================================
void init_goblin(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 26;
	int ene_top = -20;
	int ene_bottom = 23;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// Ԓlݒ
	pEnemy->obj.status = status_normal;

	// ݒ
	pEnemy->obj.move = move_goblin;			// ړ֐
	pEnemy->obj.draw = draw_goblin;			// `֐
	if (((p_stage_context->stage < 4))) {
		pEnemy->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	}
	else {
		pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	}
	pEnemy->do_eneshot = eneshot_goblin;
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	// Q[xƂ̈ړx␳l
	pEnemy->option_param[0] = (p_game_properties->game_level>=game_level_hard ? 128 : 0);

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_goblin(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		// LƂ̋𑪂
		int dx, dy;
		dx = abs(pJikiPos->hx - pPos->hx);
		dy = abs(pJikiPos->hy - pPos->hy);
		if ((dx < ENE_NEAR_TX) && (dy < ENE_NEAR_TY)) {
			// ߂
			move_goblin_near(pTarget);
		}
		else {
			// 
			move_goblin_far(pTarget);
		}
	}
	else {
		enemy_move_simple_grounding(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړij
//=============================================================================
void move_goblin_far(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// Eړ
	if( (pObj->frame_count & 0x3F)==0 ) {
		int vx = 1 << 8;
		int dir_type = vrand() & 3;
		switch (dir_type) {
		case 0:
			// 
			pObj->direction = dir_left;
			pPos->vx = -vx;
			break;
		case 1:
			// j[g
			pObj->direction = dir_left;
			pPos->vx = 0;
			break;
		case 2:
			// j[g
			pObj->direction = dir_right;
			pPos->vx = 0;
			break;
		case 3:
			// E
			pObj->direction = dir_right;
			pPos->vx = vx;
			break;
		default:
			// zO
			kon_log("GOBLIN̕wŕsȃR[ho܂B\n");
			break;
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// Ge
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_goblin]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړi߂j
//=============================================================================
void move_goblin_near(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int dx, dy;
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// LƂ̋Ƃ
	dx = pPos->hx - pJikiPos->hx;
	dy = pPos->hy - pJikiPos->hy;

	// ^C~O
	if ((pObj->frame_count & 0x1F) == 0) {
		// Eړ
		int vx = (256 + 64) + (pEnemy->option_param[0]);	// {x{x␳
		int dir = dir_right;
		if (dx > 0) {
			vx = -vx;
			dir = dir_left;
		}
		pPos->vx = vx;
		pObj->direction = dir;

		// WvE~
		if ((dy > (16 << 8)) && (pObj->gcol.bottom != 0)) {
			// Wv
			pPos->vy = -(5 << 8);
		}
		if (dy < -(16 << 8)) {
			// ~
			pObj->status = status_dash;
		}
		else {
			pObj->status = status_normal;
		}
	}

	// ړʏ
	//
	move_common(pObj, (pObj->status == status_dash), MOVE_GRAVITY >> 2);

	// Ge
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_goblin]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_goblin(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	if (pObj->direction == dir_left) {
		appear_eneshot(eneshottype_axe, pPos->hx, pPos->hy, (vcos[256 + 42] << 1) + vcos[256 + 42], vsin[256 + 42] << 2);
		appear_eneshot(eneshottype_axe, pPos->hx, pPos->hy, (vcos[256 + 64] << 1) + vcos[256 + 64], vsin[256 + 64] << 2);
	}
	else {
		appear_eneshot(eneshottype_axe, pPos->hx, pPos->hy, (vcos[512 - 42] << 1) + vcos[512 - 42], vsin[512 - 42] << 2);
		appear_eneshot(eneshottype_axe, pPos->hx, pPos->hy, (vcos[512 - 64] << 1) + vcos[512 - 64], vsin[512 - 64] << 2);
	}

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_goblin(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int anim_index = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int sptop = goblin_sptop[pEnemy->param][p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;
	anim_index = (anim == 0 ? 0 : 6);

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(6);	// SP2g
	if (allocsp < 6) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py - 8, sptop + anim_index + 0, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py - 8, sptop + anim_index + 1, pal, 0, 0, 3);
		sp++;

		SP_SET(sp, px, py + 8, sptop + anim_index + 2, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 8, sptop + anim_index + 3, pal, 0, 0, 3);
		sp++;

		SP_SET(sp, px, py + 24, sptop + anim_index + 4, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 24, sptop + anim_index + 5, pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py - 8, sptop + anim_index + 0, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py - 8, sptop + anim_index + 1, pal, 1, 0, 3);
		sp++;

		SP_SET(sp, px + 16, py + 8, sptop + anim_index + 2, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 8, sptop + anim_index + 3, pal, 1, 0, 3);
		sp++;

		SP_SET(sp, px + 16, py + 24, sptop + anim_index + 4, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 24, sptop + anim_index + 5, pal, 1, 0, 3);
		sp++;
	}

	return;
}
